/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding.proposal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.php.internal.core.ast.binding.proposal.ResolvedVariable;
import org.eclipse.php.internal.core.ast.binding.proposal.VariableResolver;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableResolver
implements VariableResolver {
    private static final HashSet<String> _supers = new HashSet();
    private final HashSet<String> _globals;
    private final HashSet<String> _undetermined;
    private final boolean _indeterminate;

    public LocalVariableResolver() {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"_GET", "_POST", "_FILES", "_COOKIE", "_REQUEST", "_SESSION", "_SERVER", "_ENV", "GLOBALS"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            _supers.add(string);
            ++n2;
        }
        this._globals = new HashSet();
        this._undetermined = new HashSet();
        this._indeterminate = false;
    }

    public LocalVariableResolver(Collection<String> collection) {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"_GET", "_POST", "_FILES", "_COOKIE", "_REQUEST", "_SESSION", "_SERVER", "_ENV", "GLOBALS"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            _supers.add(string);
            ++n2;
        }
        this._globals = new HashSet<String>(collection);
        this._undetermined = new HashSet();
        this._indeterminate = false;
    }

    public LocalVariableResolver(LocalVariableResolver localVariableResolver, LocalVariableResolver localVariableResolver2) {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"_GET", "_POST", "_FILES", "_COOKIE", "_REQUEST", "_SESSION", "_SERVER", "_ENV", "GLOBALS"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            _supers.add(string);
            ++n2;
        }
        boolean bl = this._indeterminate = localVariableResolver._indeterminate || localVariableResolver2._indeterminate;
        if (this._indeterminate) {
            this._globals = new HashSet<String>(localVariableResolver._globals);
            this._globals.retainAll(localVariableResolver2._globals);
            this._undetermined = new HashSet();
        } else {
            this._globals = new HashSet<String>(localVariableResolver._globals);
            this._globals.retainAll(localVariableResolver2._globals);
            this._undetermined = new HashSet<String>(localVariableResolver._globals);
            this._undetermined.addAll(localVariableResolver2._globals);
            this._undetermined.removeAll(this._globals);
            this._undetermined.addAll(localVariableResolver._undetermined);
            this._undetermined.addAll(localVariableResolver2._undetermined);
        }
    }

    public LocalVariableResolver(LocalVariableResolver localVariableResolver, String[] stringArray) {
        String string;
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = new String[]{"_GET", "_POST", "_FILES", "_COOKIE", "_REQUEST", "_SESSION", "_SERVER", "_ENV", "GLOBALS"};
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray3[n2];
            _supers.add(string);
            ++n2;
        }
        this._globals = new HashSet<String>(localVariableResolver._globals);
        this._undetermined = new HashSet<String>(localVariableResolver._undetermined);
        boolean bl = localVariableResolver._indeterminate;
        stringArray3 = stringArray;
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray3[n2];
            if (string == null) {
                bl = true;
            } else {
                this._globals.add(string);
                this._undetermined.remove(string);
            }
            ++n2;
        }
        this._indeterminate = bl;
        if (this._indeterminate) {
            this._undetermined.clear();
        }
    }

    @Override
    public ResolvedVariable resolveName(Variable variable) {
        Expression expression = variable.getVariableName();
        if (variable.isDollared() && expression instanceof Identifier) {
            return this.resolveName(((Identifier)expression).getName());
        }
        return ResolvedVariable.UNKNOWN;
    }

    @Override
    public VariableResolver addGlobalNames(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (!this._globals.contains(string)) {
                vector.add(string);
            }
            ++n2;
        }
        if (vector.isEmpty()) {
            return this;
        }
        return new LocalVariableResolver(this, vector.toArray(new String[vector.size()]));
    }

    @Override
    public VariableResolver addGlobalNames(Variable[] variableArray) {
        String[] stringArray = new String[variableArray.length];
        int n = 0;
        while (n < variableArray.length) {
            Variable variable = variableArray[n];
            Expression expression = variable.getVariableName();
            stringArray[n] = variable.isDollared() && expression instanceof Identifier ? ((Identifier)expression).getName() : null;
            ++n;
        }
        return this.addGlobalNames(stringArray);
    }

    @Override
    public ResolvedVariable resolveName(String string) {
        if (string == null) {
            return ResolvedVariable.UNKNOWN;
        }
        if (_supers.contains(string) || this._globals.contains(string)) {
            return ResolvedVariable.getBinding(ResolvedVariable.ScopeKind.GLOBAL, string);
        }
        if (this._indeterminate || this._undetermined.contains(string)) {
            return ResolvedVariable.getBinding(ResolvedVariable.ScopeKind.UNDETERMINED, string);
        }
        return ResolvedVariable.getBinding(ResolvedVariable.ScopeKind.LOCAL, string);
    }

    public String toString() {
        String string = "LocalVariableResolver: " + super.toString() + " " + (this._indeterminate ? "INDETERMINATE" : "determinate") + " ";
        string = String.valueOf(string) + "Globals(";
        for (String string2 : this._globals) {
            string = String.valueOf(string) + string2 + ",";
        }
        string = String.valueOf(string) + ") Undetermined (";
        for (String string2 : this._undetermined) {
            string = String.valueOf(string) + string2 + ",";
        }
        return String.valueOf(string) + ")";
    }
}

