/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class UnaryOperation
extends Expression {
    public static final int OP_PLUS = 0;
    public static final int OP_MINUS = 1;
    public static final int OP_NOT = 2;
    public static final int OP_TILDA = 3;
    private final Expression expr;
    private final int operator;

    public UnaryOperation(int n, int n2, Expression expression, int n3) {
        super(n, n2);
        assert (expression != null);
        this.expr = expression;
        this.operator = n3;
        expression.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expr.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expr.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expr.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<UnaryOperation");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" operator='").append(UnaryOperation.getOperator(this.operator)).append("'>\n");
        this.expr.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n").append(string).append("</UnaryOperation>");
    }

    public static String getOperator(int n) {
        switch (n) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 2: {
                return "!";
            }
            case 3: {
                return "~";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getType() {
        return 59;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public int getOperator() {
        return this.operator;
    }
}

