/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.phpElementData;

import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;

public abstract class AbstractCodeData
implements CodeData {
    protected String name;
    private String description;
    private boolean isUserCode;
    protected UserData userData;

    public AbstractCodeData(String string, String string2) {
        this(string, string2, null);
    }

    public AbstractCodeData(String string, String string2, UserData userData) {
        this.name = string;
        this.description = string2;
        this.userData = userData;
        this.isUserCode = userData != null;
    }

    public final String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public final boolean isUserCode() {
        return this.isUserCode;
    }

    public final UserData getUserData() {
        return this.userData;
    }

    public int compareTo(Object object) {
        if (!(object instanceof CodeData)) {
            return -1;
        }
        CodeData codeData = (CodeData)object;
        int n = this.name.compareToIgnoreCase(codeData.getName());
        if (n != 0) {
            return n;
        }
        boolean bl = codeData.isUserCode();
        if (!this.isUserCode) {
            if (!bl) {
                return 0;
            }
            return -1;
        }
        if (!bl) {
            return 1;
        }
        return this.userData.getFileName().compareTo(codeData.getUserData().getFileName());
    }

    public String toString() {
        if (this.getUserData() == null) {
            return this.name;
        }
        return String.valueOf(this.name) + " (in " + this.getUserData().getFileName() + ")";
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }
}

