/*
 * Decompiled with CFR 0.152.
 */
package mx4j.loading;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import javax.management.MBeanServerFactory;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private ClassLoader m_classLoader;

    public ClassLoaderObjectInputStream(InputStream stream) throws IOException, StreamCorruptedException {
        super(stream);
    }

    public ClassLoaderObjectInputStream(InputStream stream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(stream);
        this.m_classLoader = classLoader;
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String name = osc.getName();
        return this.loadClass(name);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] classes = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            classes[i] = this.loadClass(interfaces[i]);
            ++i;
        }
        if (this.m_classLoader != null) {
            return Proxy.getProxyClass(this.m_classLoader, classes);
        }
        return Proxy.getProxyClass(Thread.currentThread().getContextClassLoader(), classes);
    }

    private Class loadClass(String name) throws ClassNotFoundException {
        if (this.m_classLoader != null) {
            return this.m_classLoader.loadClass(name);
        }
        return MBeanServerFactory.getClassLoaderRepository(null).loadClass(name);
    }
}

