/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.util.CollectionUtils;
import org.eclipse.php.internal.ui.util.ParentChecker;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;
    private Text fSelectedText;

    public PasteAction(IWorkbenchSite iWorkbenchSite, Clipboard clipboard) {
        super(iWorkbenchSite);
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.setText(PHPUIMessages.PasteAction_text);
        this.setDescription(PHPUIMessages.PasteAction_desc);
        ISharedImages iSharedImages = PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.paste_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        boolean bl = true;
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof PHPCodeData && !(objectArray[n] instanceof PHPFileData)) {
                bl = false;
            }
            ++n;
        }
        this.setEnabled(bl);
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] objectArray = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                objectArray[0] = clipboard.getContents(transfer);
            }
        });
        return objectArray[0];
    }

    private static boolean isAvailable(Transfer transfer, TransferData[] transferDataArray) {
        int n = 0;
        while (n < transferDataArray.length) {
            if (transfer.isSupportedType(transferDataArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            TransferData[] transferDataArray = this.fClipboard.getAvailableTypes();
            List list = iStructuredSelection.toList();
            IResource[] iResourceArray = ActionUtils.getResources(list, true);
            Object[] objectArray = ActionUtils.getPHPElements(list, true);
            Paster[] pasterArray = this.createEnabledPasters(transferDataArray);
            int n = 0;
            while (n < pasterArray.length) {
                if (pasterArray[n].canPasteOn(objectArray, iResourceArray)) {
                    pasterArray[n].paste(objectArray, iResourceArray, transferDataArray);
                    return;
                }
                ++n;
            }
            MessageDialog.openError((Shell)PHPUiPlugin.getActiveWorkbenchShell(), (String)PHPUIMessages.RefactoringAction_refactoring, (String)PHPUIMessages.RefactoringAction_disabled);
        }
        catch (CoreException coreException) {
            PHPUiPlugin.log(coreException);
        }
        catch (InvocationTargetException invocationTargetException) {
            PHPUiPlugin.log(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {}
    }

    private Paster[] createEnabledPasters(TransferData[] transferDataArray) throws CoreException {
        Shell shell = this.getShell();
        ArrayList<Paster> arrayList = new ArrayList<Paster>(2);
        Paster paster = new ProjectPaster(shell, this.fClipboard);
        if (paster.canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        if ((paster = new PHPElementAndResourcePaster(shell, this.fClipboard)).canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        if ((paster = new FilePaster(shell, this.fClipboard)).canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        if (this.fSelectedText != null && (paster = new ResourceNameTextPaster(shell, this.fClipboard, this.fSelectedText)).canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        return arrayList.toArray(new Paster[arrayList.size()]);
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof Text) {
            Text text;
            this.fSelectedText = text = (Text)event.widget;
        }
        this.run();
    }

    private static class FilePaster
    extends Paster {
        protected FilePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(Object[] objectArray, IResource[] iResourceArray, TransferData[] transferDataArray) throws CoreException {
            String[] stringArray = this.getClipboardFiles(transferDataArray);
            if (stringArray == null) {
                return;
            }
            IContainer iContainer = this.getAsContainer(this.getTarget(objectArray, iResourceArray));
            if (iContainer == null) {
                return;
            }
            new CopyFilesAndFoldersOperation(this.getShell()).copyFiles(stringArray, iContainer);
        }

        private Object getTarget(Object[] objectArray, IResource[] iResourceArray) {
            if (objectArray.length + iResourceArray.length == 1) {
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return iResourceArray[0];
            }
            return this.getCommonParent(objectArray, iResourceArray);
        }

        public boolean canPasteOn(Object[] objectArray, IResource[] iResourceArray) throws CoreException {
            Object object = this.getTarget(objectArray, iResourceArray);
            return object != null && this.canPasteFilesOn(this.getAsContainer(object));
        }

        public boolean canEnable(TransferData[] transferDataArray) throws CoreException {
            return PasteAction.isAvailable((Transfer)FileTransfer.getInstance(), transferDataArray);
        }

        private boolean canPasteFilesOn(Object object) {
            return object instanceof IContainer;
        }

        private IContainer getAsContainer(Object object) throws CoreException {
            if (object == null) {
                return null;
            }
            if (object instanceof IContainer) {
                return (IContainer)object;
            }
            if (object instanceof IFile) {
                return ((IFile)object).getParent();
            }
            return null;
        }

        private String[] getClipboardFiles(TransferData[] transferDataArray) {
            FileTransfer fileTransfer = FileTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)fileTransfer, transferDataArray)) {
                return (String[])PasteAction.getContents(this.getClipboard(), (Transfer)fileTransfer, this.getShell());
            }
            return null;
        }

        private Object getCommonParent(Object[] objectArray, IResource[] iResourceArray) {
            return new ParentChecker(iResourceArray, (PHPCodeData[])objectArray).getCommonParent();
        }
    }

    private static class PHPElementAndResourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected PHPElementAndResourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(Object[] objectArray, IResource[] iResourceArray, TransferData[] transferDataArray) throws CoreException, InterruptedException, InvocationTargetException {
            Object object;
            Object[] objectArray2;
            IResource[] iResourceArray2 = this.getClipboardResources(transferDataArray);
            if (iResourceArray2 == null) {
                iResourceArray2 = new IResource[]{};
            }
            if ((objectArray2 = this.getClipboardPHPElements(transferDataArray)) == null) {
                objectArray2 = new Object[]{};
            }
            if ((object = this.getTarget(objectArray, iResourceArray)) instanceof PHPCodeData) {
                this.pasteToPHP(objectArray2, iResourceArray2, (PHPCodeData)object);
            } else if (object instanceof IResource) {
                this.pasteToResource(objectArray2, iResourceArray2, (IResource)object);
            }
        }

        private void pasteToResource(Object[] objectArray, IResource[] iResourceArray, IResource iResource) {
            new CopyFilesAndFoldersOperation(this.getShell()).copyResources(iResourceArray, (IContainer)iResource);
        }

        private void pasteToPHP(Object[] objectArray, IResource[] iResourceArray, PHPCodeData pHPCodeData) {
        }

        private Object getTarget(Object[] objectArray, IResource[] iResourceArray) {
            if (objectArray.length + iResourceArray.length == 1) {
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return iResourceArray[0];
            }
            return this.getCommonParent(objectArray, iResourceArray);
        }

        private Object getCommonParent(Object[] objectArray, IResource[] iResourceArray) {
            return new ParentChecker(iResourceArray, (PHPCodeData[])objectArray).getCommonParent();
        }

        public boolean canPasteOn(Object[] objectArray, IResource[] iResourceArray) throws CoreException {
            Object object;
            Object[] objectArray2;
            IResource[] iResourceArray2 = this.getClipboardResources(this.fAvailableTypes);
            if (iResourceArray2 == null) {
                iResourceArray2 = new IResource[]{};
            }
            if ((objectArray2 = this.getClipboardPHPElements(this.fAvailableTypes)) == null) {
                objectArray2 = new Object[]{};
            }
            if ((object = this.getTarget(objectArray, iResourceArray)) instanceof PHPCodeData) {
                return this.canPasteElement(objectArray2, iResourceArray2, (PHPCodeData)object);
            }
            if (object instanceof IResource) {
                return this.canPasteResource(objectArray2, iResourceArray2, (IResource)object);
            }
            return false;
        }

        public boolean canPasteResource(Object[] objectArray, IResource[] iResourceArray, IResource iResource) {
            if (!(iResource instanceof IContainer)) {
                return false;
            }
            int n = 0;
            while (n < iResourceArray.length) {
                if (!(iResourceArray[n] instanceof IFile)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private boolean canPasteElement(Object[] objectArray, IResource[] iResourceArray, PHPCodeData pHPCodeData) {
            return false;
        }

        public boolean canEnable(TransferData[] transferDataArray) {
            this.fAvailableTypes = transferDataArray;
            return PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), transferDataArray);
        }
    }

    private static abstract class Paster {
        private final Shell fShell;
        private final Clipboard fClipboard2;
        static final PHPCodeData[] EMPTY_PHPELEMENTS = new PHPCodeData[0];

        protected Paster(Shell shell, Clipboard clipboard) {
            this.fShell = shell;
            this.fClipboard2 = clipboard;
        }

        protected final Shell getShell() {
            return this.fShell;
        }

        protected final Clipboard getClipboard() {
            return this.fClipboard2;
        }

        protected final IResource[] getClipboardResources(TransferData[] transferDataArray) {
            ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)resourceTransfer, transferDataArray)) {
                return (IResource[])PasteAction.getContents(this.fClipboard2, (Transfer)resourceTransfer, this.getShell());
            }
            return null;
        }

        protected final PHPCodeData[] getClipboardPHPElements(TransferData[] transferDataArray) {
            return EMPTY_PHPELEMENTS;
        }

        public abstract void paste(Object[] var1, IResource[] var2, TransferData[] var3) throws CoreException, InterruptedException, InvocationTargetException;

        public abstract boolean canEnable(TransferData[] var1) throws CoreException;

        public abstract boolean canPasteOn(Object[] var1, IResource[] var2) throws CoreException;
    }

    private static class ProjectPaster
    extends Paster {
        protected ProjectPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] transferDataArray) {
            boolean bl = PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), transferDataArray);
            boolean bl2 = false;
            if (!bl2) {
                return this.canPasteSimpleProjects(transferDataArray);
            }
            if (!bl) {
                return false;
            }
            return this.canPasteSimpleProjects(transferDataArray);
        }

        public void paste(Object[] objectArray, IResource[] iResourceArray, TransferData[] transferDataArray) {
            this.pasteProjects(transferDataArray);
        }

        private void pasteProjects(TransferData[] transferDataArray) {
            this.pasteProjects(this.getProjectsToPaste(transferDataArray));
        }

        private void pasteProjects(IProject[] iProjectArray) {
            Shell shell = this.getShell();
            int n = 0;
            while (n < iProjectArray.length) {
                new CopyProjectOperation(shell).copyProject(iProjectArray[n]);
                ++n;
            }
        }

        private IProject[] getProjectsToPaste(TransferData[] transferDataArray) {
            IResource[] iResourceArray = this.getClipboardResources(transferDataArray);
            PHPCodeData[] pHPCodeDataArray = this.getClipboardPHPElements(transferDataArray);
            HashSet hashSet = new HashSet();
            if (iResourceArray != null) {
                hashSet.addAll(Arrays.asList(iResourceArray));
            }
            if (pHPCodeDataArray != null) {
                hashSet.addAll(Arrays.asList(CollectionUtils.getNotNulls(CollectionUtils.getResources(pHPCodeDataArray))));
            }
            Assert.isTrue((hashSet.size() > 0 ? 1 : 0) != 0);
            return hashSet.toArray(new IProject[hashSet.size()]);
        }

        public boolean canPasteOn(Object[] objectArray, IResource[] iResourceArray) {
            return true;
        }

        private boolean canPasteSimpleProjects(TransferData[] transferDataArray) {
            IResource[] iResourceArray = this.getClipboardResources(transferDataArray);
            if (iResourceArray == null || iResourceArray.length == 0) {
                return false;
            }
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].getType() != 4 || !((IProject)iResourceArray[n]).isOpen()) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    private static class ResourceNameTextPaster
    extends Paster {
        private final Text textWidget;

        protected ResourceNameTextPaster(Shell shell, Clipboard clipboard, Text text) {
            super(shell, clipboard);
            this.textWidget = text;
        }

        public void paste(Object[] objectArray, IResource[] iResourceArray, TransferData[] transferDataArray) throws CoreException {
            this.textWidget.paste();
        }

        public boolean canPasteOn(Object[] objectArray, IResource[] iResourceArray) throws CoreException {
            return true;
        }

        public boolean canEnable(TransferData[] transferDataArray) throws CoreException {
            return PasteAction.isAvailable((Transfer)TextTransfer.getInstance(), transferDataArray);
        }
    }
}

