/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.php.internal.ui.editor.util.PHPDocBlockSerialezer;
import org.eclipse.php.internal.ui.editor.util.PHPDocTool;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class DocBlockAutoEditStrategy
implements IAutoEditStrategy {
    private static final String lineStart = "* ";
    private static final IPreferenceStore store = PHPCorePlugin.getDefault().getPreferenceStore();
    private static final PreferencesSupport preferencesSupport = new PreferencesSupport("org.eclipse.php.core", store);

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (TypingPreferences.closePhpdoc && documentCommand.text != null && TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) != -1) {
            this.autoEditAfterNewLine((IStructuredDocument)iDocument, documentCommand);
        }
    }

    private void autoEditAfterNewLine(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        try {
            Matcher matcher;
            IRegion iRegion = iStructuredDocument.getLineInformationOfOffset(documentCommand.offset);
            int n = iRegion.getOffset();
            String string = iStructuredDocument.get(n, iRegion.getLength());
            String string2 = this.getBlanks(string);
            String string3 = string.trim();
            boolean bl = false;
            boolean bl2 = true;
            int n2 = string3.indexOf("/*");
            if (n2 != -1) {
                if (documentCommand.offset + documentCommand.length < n + n2 + 2) {
                    return;
                }
                bl = true;
                if (string3.indexOf("/**") != n2) {
                    bl2 = false;
                }
            }
            if ((matcher = Pattern.compile("/\\*.*\\*/").matcher(string3)).find()) {
                return;
            }
            if (bl) {
                int n3;
                string2 = String.valueOf(string2) + ' ';
                documentCommand.text = String.valueOf(documentCommand.text) + string2;
                int n4 = string.indexOf("/*");
                String string4 = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)(n + n4 - 1));
                if ((string4 == "org.eclipse.php.PHP_DEFAULT" || string4 == "org.eclipse.php.PHP_DOC" || string4 == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") && (n3 = this.handleDocBlockStart(iStructuredDocument, documentCommand, string2, bl2)) != -1) {
                    iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                    documentCommand.offset = n3;
                    documentCommand.length = 0;
                    documentCommand.text = "";
                    iStructuredDocument.getUndoManager().disableUndoManagement();
                    iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                    iStructuredDocument.getUndoManager().enableUndoManagement();
                }
                return;
            }
            boolean bl3 = iStructuredDocument.get(n, documentCommand.offset - n).endsWith("*/");
            if (!bl3 && string3.length() > 0 && string3.charAt(0) == '*') {
                documentCommand.text = String.valueOf(documentCommand.text) + string2 + lineStart;
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    private String getBlanks(String string) {
        int n = string.indexOf("/*");
        if (n < 0) {
            n = string.indexOf("*");
        }
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                if (string.charAt(n2) == '\t') {
                    stringBuffer.append('\t');
                } else {
                    stringBuffer.append(' ');
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        return " ";
    }

    /*
     * Unable to fully structure code
     */
    private int handleDocBlockStart(IStructuredDocument var1_1, DocumentCommand var2_2, String var3_3, boolean var4_4) {
        block13: {
            block12: {
                block14: {
                    block11: {
                        var5_5 = 0;
                        var6_6 = var1_1.getLineInformationOfOffset(var2_2.offset);
                        var7_8 = var6_6.getOffset();
                        var8_9 = var1_1.get(var7_8, var2_2.offset - var7_8);
                        var9_10 = Pattern.compile("\\/\\*+").matcher(var8_9);
                        var9_10.find();
                        var10_11 = var8_9.substring(var9_10.start(), var9_10.end());
                        var11_12 = var10_11.length();
                        var2_2.text = String.valueOf(var2_2.text) + "* ";
                        var5_5 = var2_2.offset + var2_2.text.length();
                        var12_13 = var2_2.offset + var2_2.length;
                        if (!this.isInsideExistingDocBlock(var1_1, var12_13)) break block11;
lbl15:
                        // 3 sources

                        while (true) {
                            var1_1.getUndoManager().enableUndoManagement();
                            return -1;
                        }
                    }
                    var13_14 = var8_9.substring(var8_9.indexOf(var10_11) + var11_12).trim();
                    var5_5 = (var7_8 += var8_9.indexOf(var10_11)) + var11_12 + var2_2.text.length();
                    var14_15 = var12_13;
                    if (var12_13 < var6_6.getOffset() + var6_6.getLength()) {
                        var6_6 = var1_1.getLineInformationOfOffset(var12_13);
                    }
                    if (!var4_4 || !TypingPreferences.addDocTags) break block12;
                    var1_1.replace(var7_8 + 3, var14_15 - var7_8 - 3, "");
                    var2_2.offset = var14_15 = var7_8 + 3;
                    if (var13_14.equals("")) {
                        var13_14 = null;
                    }
                    var15_16 = (DOMModelForPHP)StructuredModelManager.getModelManager().getModelForRead(var1_1);
                    var16_17 = var15_16.getFileData();
                    var15_16.releaseFromRead();
                    var16_17 = this.updateFileData(var1_1, var7_8, var14_15, var16_17);
                    var17_18 = this.getDocBlockStub(var16_17, var1_1, var7_8, var13_14, var14_15);
                    if (var17_18 == null) ** GOTO lbl59
                    var2_2.text = var17_18.substring(3);
                    if (var13_14 != null) break block14;
                    var18_19 = var16_17.getName();
                    var19_20 = PHPUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(var18_19));
                    try {
                        var20_21 = EditorUtility.openInEditor(var19_20, true);
                    }
                    catch (PartInitException var21_22) {
                        Logger.logException(var21_22);
                        var2_2.text = String.valueOf(var10_11) + var2_2.text;
                        ** GOTO lbl15
                    }
                    var21_23 = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)var20_21);
                    Display.getDefault().asyncExec((Runnable)new SelectText(var2_2.offset + var2_2.text.indexOf("E"), 25, (ITextEditor)var21_23));
                    ** continue;
                }
                var23_24 = var5_5 + var13_14.length();
                var1_1.getUndoManager().enableUndoManagement();
                return var23_24;
            }
            try {
                try {
                    var2_2.length += var2_2.offset - var7_8 - var11_12;
                    var2_2.offset = var7_8 + var11_12;
lbl59:
                    // 2 sources

                    var7_8 += var11_12;
                    if (var13_14 == null || var13_14.equals("")) break block13;
                    var2_2.text = String.valueOf(var2_2.text) + var13_14;
                    var5_5 = var7_8 + var2_2.text.length();
                }
                catch (BadLocationException var6_7) {
                    Logger.logException(var6_7);
                    var1_1.getUndoManager().enableUndoManagement();
                }
            }
            catch (Throwable var22_25) {
                var1_1.getUndoManager().enableUndoManagement();
                throw var22_25;
            }
        }
        var1_1.getUndoManager().enableUndoManagement();
        var2_2.text = String.valueOf(var2_2.text) + var1_1.getLineDelimiter() + var3_3 + "*/";
        return var5_5;
    }

    private PHPFileData updateFileData(IStructuredDocument iStructuredDocument, int n, int n2, PHPFileData pHPFileData) {
        String string = pHPFileData.getName();
        Pattern[] patternArray = new Pattern[]{};
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
        IProject iProject = null;
        if (iFile != null) {
            iProject = iFile.getProject();
            patternArray = TaskPatternsProvider.getInstance().getPatternsForProject(iProject);
        }
        boolean bl = UseAspTagsHandler.useAspTagsAsPhp(iProject);
        String string2 = preferencesSupport.getPreferencesValue("phpVersion", "php5", iProject);
        pHPFileData = PHPFileDataUtilities.getFileData((Reader)new SkippedTextDocumentReader((IDocument)iStructuredDocument, n, n2 - n), (String)pHPFileData.getName(), (long)0L, (String)string2, (Pattern[])patternArray, (boolean)bl);
        return pHPFileData;
    }

    private boolean isInsideExistingDocBlock(IStructuredDocument iStructuredDocument, int n) {
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        boolean bl = true;
        while (iStructuredDocumentRegion != null) {
            int n2;
            String string = iStructuredDocumentRegion.getText();
            if (bl) {
                bl = false;
                string = string.substring(n - iStructuredDocumentRegion.getStartOffset());
            }
            if ((n2 = string.length()) == 0) {
                iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
                continue;
            }
            char c = string.charAt(0);
            int n3 = 1;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                if (c == '*' && c2 == '/') {
                    return true;
                }
                if (c == '/' && c2 == '*') {
                    return false;
                }
                c = c2;
                ++n3;
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        return false;
    }

    private String getDocBlockStub(PHPFileData pHPFileData, IStructuredDocument iStructuredDocument, int n, String string, int n2) {
        if (pHPFileData == null) {
            return null;
        }
        PHPCodeData pHPCodeData = this.getClosestCodeData(iStructuredDocument, pHPFileData, n, n2);
        if (pHPCodeData == null) {
            return null;
        }
        PHPDocBlock pHPDocBlock = PHPDocTool.createPhpDoc((CodeData)pHPCodeData, string, (IDocument)iStructuredDocument);
        return PHPDocBlockSerialezer.instance().createDocBlockText(iStructuredDocument, pHPDocBlock, n, false);
    }

    private PHPCodeData getClosestCodeData(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n, int n2) {
        int n3;
        int n4;
        int n5;
        PHPClassData pHPClassData = null;
        int n6 = iStructuredDocument.getLength();
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n7 = 0;
        while (n7 < pHPClassDataArray.length) {
            PHPClassData pHPClassData2 = pHPClassDataArray[n7];
            n5 = pHPClassData2.getUserData().getStartPosition();
            if (n5 < n) {
                n4 = pHPClassData2.getUserData().getEndPosition();
                if (n4 > n) {
                    return this.getClosestCodeDataFromClass(iStructuredDocument, pHPClassData2, n, n2);
                }
            } else if (n5 < n6) {
                n6 = n5;
                pHPClassData = pHPClassData2;
            }
            ++n7;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        int n8 = 0;
        while (n8 < pHPFunctionDataArray.length) {
            PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n8];
            n4 = pHPFunctionData.getUserData().getStartPosition();
            if (n4 < n) {
                n3 = pHPFunctionData.getUserData().getEndPosition();
                if (n3 > n) {
                    return null;
                }
            } else if (n4 < n6) {
                n6 = n4;
                pHPClassData = pHPFunctionData;
            }
            ++n8;
        }
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        n5 = 0;
        while (n5 < pHPConstantDataArray.length) {
            PHPConstantData pHPConstantData = pHPConstantDataArray[n5];
            n3 = pHPConstantData.getUserData().getStartPosition();
            if (n3 < n) {
                int n9 = pHPConstantData.getUserData().getEndPosition();
                if (n9 > n) {
                    return null;
                }
            } else if (n3 < n6) {
                n6 = n3;
                pHPClassData = pHPConstantData;
            }
            ++n5;
        }
        if (pHPClassData != null && this.isNoCodeBetween(iStructuredDocument, n2, n6)) {
            return pHPClassData;
        }
        return null;
    }

    private PHPCodeData getClosestCodeDataFromClass(IStructuredDocument iStructuredDocument, PHPClassData pHPClassData, int n, int n2) {
        int n3;
        int n4;
        int n5;
        PHPFunctionData pHPFunctionData = null;
        int n6 = iStructuredDocument.getLength();
        PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
        int n7 = 0;
        while (n7 < pHPFunctionDataArray.length) {
            PHPFunctionData pHPFunctionData2 = pHPFunctionDataArray[n7];
            n5 = pHPFunctionData2.getUserData().getStartPosition();
            if (n5 < n) {
                n4 = pHPFunctionData2.getUserData().getEndPosition();
                if (n4 > n) {
                    return null;
                }
            } else if (n5 < n6) {
                n6 = n5;
                pHPFunctionData = pHPFunctionData2;
            }
            ++n7;
        }
        PHPClassConstData[] pHPClassConstDataArray = pHPClassData.getConsts();
        int n8 = 0;
        while (n8 < pHPClassConstDataArray.length) {
            PHPClassConstData pHPClassConstData = pHPClassConstDataArray[n8];
            n4 = pHPClassConstData.getUserData().getStartPosition();
            if (n4 < n) {
                n3 = pHPClassConstData.getUserData().getEndPosition();
                if (n3 > n) {
                    return null;
                }
            } else if (n4 < n6) {
                n6 = n4;
                pHPFunctionData = pHPClassConstData;
            }
            ++n8;
        }
        PHPClassVarData[] pHPClassVarDataArray = pHPClassData.getVars();
        n5 = 0;
        while (n5 < pHPClassVarDataArray.length) {
            PHPClassVarData pHPClassVarData = pHPClassVarDataArray[n5];
            n3 = pHPClassVarData.getUserData().getStartPosition();
            if (n3 < n) {
                int n9 = pHPClassVarData.getUserData().getEndPosition();
                if (n9 > n) {
                    return null;
                }
            } else if (n3 < n6) {
                n6 = n3;
                pHPFunctionData = pHPClassVarData;
            }
            ++n5;
        }
        if (pHPFunctionData != null && this.isNoCodeBetween(iStructuredDocument, n2, n6)) {
            return pHPFunctionData;
        }
        return null;
    }

    private boolean isNoCodeBetween(IStructuredDocument iStructuredDocument, int n, int n2) {
        char[] cArray = null;
        try {
            cArray = iStructuredDocument.get(n, n2 - n).toCharArray();
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
        if (cArray == null) {
            return true;
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (bl) {
                if (c == '\n' || c == '\r') {
                    bl = false;
                }
            } else if (!Character.isWhitespace(c)) {
                if (c == '/' && n3 + 1 < cArray.length && cArray[n3 + 1] == '/') {
                    bl = true;
                } else {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    private class SelectText
    implements Runnable {
        int offset;
        int length;
        ITextEditor textEditor;

        public SelectText(int n, int n2, ITextEditor iTextEditor) {
            this.offset = n;
            this.length = n2;
            this.textEditor = iTextEditor;
        }

        public void run() {
            EditorUtility.revealInEditor((IEditorPart)this.textEditor, this.offset, this.length);
        }
    }

    private class SkippedTextDocumentReader
    extends Reader {
        private IDocument document = null;
        private int mark = 0;
        private int position = 0;
        private int skippedPosition;
        private int skippedLength;

        public SkippedTextDocumentReader(IDocument iDocument, int n, int n2) {
            this.document = iDocument;
            this.skippedPosition = n;
            this.skippedLength = n2;
        }

        public void close() throws IOException {
            this.document = null;
        }

        public void mark(int n) throws IOException {
            this.mark = this.position;
        }

        public boolean markSupported() {
            return true;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            char[] cArray2;
            block9: {
                if (this.document == null) {
                    return -1;
                }
                cArray2 = null;
                try {
                    if (this.position < this.document.getLength()) break block9;
                    return -1;
                }
                catch (Exception exception) {
                    throw new IOException("Exception while reading from IDocument: " + exception);
                }
            }
            if (this.position < this.skippedPosition) {
                if (this.position + n2 >= this.skippedPosition) {
                    String string = this.document.get(this.position, this.skippedPosition - this.position);
                    String string2 = this.document.get(this.skippedPosition + this.skippedLength, n2 - (this.skippedPosition - this.position));
                    cArray2 = (String.valueOf(string) + string2).toCharArray();
                }
            } else if (this.position <= this.skippedPosition + this.skippedLength) {
                this.position = this.skippedPosition + this.skippedLength;
            }
            if (cArray2 == null) {
                cArray2 = this.position + n2 > this.document.getLength() ? this.document.get(this.position, this.document.getLength() - this.position).toCharArray() : this.document.get(this.position, n2).toCharArray();
            }
            System.arraycopy(cArray2, 0, cArray, n, cArray2.length);
            this.position += cArray2.length;
            return cArray2.length;
        }

        public void reset() throws IOException {
            this.position = this.mark;
        }

        public void reset(int n) throws IOException {
            this.position = n;
        }

        public long skip(long l) throws IOException {
            if (this.document == null) {
                return 0L;
            }
            long l2 = l;
            if ((long)this.position + l > (long)this.document.getLength()) {
                l2 = this.document.getLength() - this.position;
                this.position = this.document.getLength();
            } else {
                this.position = (int)((long)this.position + l);
            }
            return l2;
        }
    }
}

