/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.util.CodeDataResolver;
import org.eclipse.php.internal.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.php.internal.ui.util.PHPCodeDataHTMLDescriptionUtilities;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class PHPAnnotationTextHover
extends AbstractPHPTextHover {
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        IDocument iDocument = iTextViewer.getDocument();
        if (iDocument instanceof IStructuredDocument) {
            IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
            IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(iDocument);
            try {
                if (iStructuredModel instanceof DOMModelForPHP) {
                    DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                    CodeData[] codeDataArray = CodeDataResolver.getInstance().resolve(iStructuredDocument, iRegion.getOffset(), dOMModelForPHP);
                    if (codeDataArray.length != 0) {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = 0;
                        while (n < codeDataArray.length) {
                            CodeData codeData = codeDataArray[n];
                            PHPProjectModel pHPProjectModel = dOMModelForPHP.getProjectModel();
                            stringBuffer.append(PHPCodeDataHTMLDescriptionUtilities.getHTMLHyperlinkDescriptionText(codeData, pHPProjectModel));
                            if (n + 1 != codeDataArray.length) {
                                stringBuffer.append("\n");
                            }
                            ++n;
                        }
                        String string = stringBuffer.toString();
                        return string;
                    }
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        return null;
    }
}

