/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SWTUtil {
    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Caret) {
            return ((Caret)widget).getParent().getShell();
        }
        if (widget instanceof DragSource) {
            return ((DragSource)widget).getControl().getShell();
        }
        if (widget instanceof DropTarget) {
            return ((DropTarget)widget).getControl().getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        return null;
    }

    public static int getTableHeightHint(Table table, int n) {
        if (table.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            table.setFont(JFaceResources.getDialogFont());
        }
        int n2 = table.getItemHeight() * n + table.getHeaderHeight();
        if (table.getLinesVisible()) {
            n2 += table.getGridLineWidth() * (n - 1);
        }
        return n2;
    }

    public static CTabFolder createTabFolder(Composite composite) {
        Display display = SWTUtil.getStandardDisplay();
        Color color = display.getSystemColor(31);
        Color color2 = display.getSystemColor(32);
        CTabFolder cTabFolder = new CTabFolder(composite, 0x900008);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        cTabFolder.setSelectionBackground(new Color[]{color, color2}, new int[]{100}, true);
        cTabFolder.setSelectionForeground(SWTUtil.getStandardDisplay().getSystemColor(30));
        cTabFolder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        cTabFolder.setLayoutData((Object)gridData);
        cTabFolder.setBorderVisible(true);
        cTabFolder.setFont(composite.getFont());
        return cTabFolder;
    }

    public static void showPreferencePage(String string, IPreferencePage iPreferencePage) {
        PreferenceNode preferenceNode = new PreferenceNode(string, iPreferencePage);
        PreferenceManager preferenceManager = new PreferenceManager();
        preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
        final PreferenceDialog preferenceDialog = new PreferenceDialog(DebugUIPlugin.getShell(), preferenceManager);
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)new Runnable((IPreferenceNode)preferenceNode){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = iPreferenceNode;
            }

            public void run() {
                preferenceDialog.create();
                preferenceDialog.setMessage(this.val$targetNode.getLabelText());
                preferenceDialog.open();
            }
        });
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter pixelConverter = new PixelConverter((Control)button);
        int n = pixelConverter.convertHorizontalDLUsToPixels(61);
        return Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object object = button.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).widthHint = SWTUtil.getButtonWidthHint(button);
            ((GridData)object).horizontalAlignment = 4;
        }
    }

    public static Button createPushButton(Composite composite, String string, Image image) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (string != null) {
            button.setText(string);
        }
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    public static Button createRadioButton(Composite composite, String string) {
        Button button = new Button(composite, 16);
        button.setFont(composite.getFont());
        if (string != null) {
            button.setText(string);
        }
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    public static Label createLabel(Composite composite, String string, int n) {
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(string);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Text createSingleText(Composite composite, int n) {
        Text text = new Text(composite, 2052);
        text.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static Group createGroup(Composite composite, String string, int n, int n2, int n3) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(n, false));
        group.setText(string);
        group.setFont(composite.getFont());
        GridData gridData = new GridData(n3);
        gridData.horizontalSpan = n2;
        group.setLayoutData((Object)gridData);
        return group;
    }
}

