/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.resources.ExternalFileDecorator;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPExecutableLaunchDelegate;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.ui.editor.UntitledPHPEditor;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PHPExeLaunchShortcut
implements ILaunchShortcut {
    private static final String DEBUG_UI = "org.eclipse.debug.ui";
    private static final IStatus promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    private static final String DEBUG_CORE = "org.eclipse.debug.core";
    private static final IStatus saveScopedDirtyEditors = new Status(1, "org.eclipse.debug.core", 222, "", null);

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            PHPExeLaunchShortcut.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string, this.getPHPExeLaunchConfigType());
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile == null) {
            IPath iPath = null;
            if (iEditorInput instanceof IStorageEditorInput) {
                IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)iEditorInput;
                try {
                    LocalFileStorage localFileStorage = (LocalFileStorage)iStorageEditorInput.getStorage();
                    iPath = localFileStorage.getFullPath();
                }
                catch (CoreException coreException) {
                    Logger.logException(coreException);
                }
            } else if (iEditorInput instanceof IURIEditorInput) {
                iPath = URIUtil.toPath((URI)((IURIEditorInput)iEditorInput).getURI());
            } else if (iEditorInput instanceof NonExistingPHPFileEditorInput) {
                IPath iPath2 = ((NonExistingPHPFileEditorInput)iEditorInput).getPath();
                IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                if (iStatusHandler != null) {
                    try {
                        int[] nArray = this.getBreakpointLines(iPath2);
                        if (!((Boolean)iStatusHandler.handleStatus(saveScopedDirtyEditors, (Object)new Object[0])).booleanValue()) {
                            return;
                        }
                        iPath = (IPath)UntitledPHPEditor.latestSavedUntitled.get(iPath2);
                        UntitledPHPEditor.latestSavedUntitled.remove(iPath2);
                        if (iPath != null) {
                            this.copyBreakPoints(iPath, nArray);
                        }
                    }
                    catch (Exception exception) {
                        Logger.logException(exception);
                        return;
                    }
                }
            }
            if (iPath != null) {
                iFile = ExternalFilesRegistry.getInstance().isEntryExist(iPath.toString()) ? ExternalFilesRegistry.getInstance().getFileEntry(iPath.toString()) : ExternalFileDecorator.createFile((String)iPath.toString());
            }
        }
        if (iFile != null) {
            PHPExeLaunchShortcut.searchAndLaunch(new Object[]{iFile}, string, this.getPHPExeLaunchConfigType());
        }
    }

    private void copyBreakPoints(IPath iPath, int[] nArray) throws CoreException {
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
        int n = 0;
        while (n < nArray.length) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint(PHPDebugTarget.createBreakpoint((IResource)iFile, (int)nArray[n]));
            ++n;
        }
    }

    private int[] getBreakpointLines(IPath iPath) throws CoreException {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.php.debug.core");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < iBreakpointArray.length) {
            PHPConditionalBreakpoint pHPConditionalBreakpoint = (PHPConditionalBreakpoint)iBreakpointArray[n];
            if (pHPConditionalBreakpoint.getRuntimeBreakpoint().getFileName().equals(iPath.toString())) {
                arrayList.add(pHPConditionalBreakpoint.getLineNumber());
            }
            ++n;
        }
        int[] nArray = new int[arrayList.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (Integer)arrayList.get(n2);
            ++n2;
        }
        return nArray;
    }

    protected ILaunchConfigurationType getPHPExeLaunchConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        return iLaunchManager.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
    }

    public static void searchAndLaunch(Object[] objectArray, String string, ILaunchConfigurationType iLaunchConfigurationType) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Object object;
                try {
                    String string2;
                    PHPexes pHPexes;
                    Object object2;
                    String string3 = null;
                    object = null;
                    IProject iProject = null;
                    Object object3 = objectArray[n2];
                    if (object3 instanceof PHPCodeData) {
                        object3 = PHPModelUtil.getResource((Object)object3);
                    }
                    if (object3 instanceof IFile) {
                        object2 = (IFile)object3;
                        iProject = object2.getProject();
                        pHPexes = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                        if (pHPexes.isAssociatedWith(object2.getName())) {
                            string3 = object2.getFullPath().toString();
                            object = object2.getLocation().toString();
                        }
                    }
                    if (string3 == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                    }
                    object2 = PHPExeLaunchShortcut.getDefaultPHPExe(iProject);
                    pHPexes = new PHPexes();
                    pHPexes.load(PHPProjectPreferences.getModelPreferences());
                    PHPexeItem pHPexeItem = pHPexes.getItem((String)object2);
                    if (pHPexeItem == null) {
                        pHPexeItem = pHPexes.getDefaultItem();
                    }
                    String string4 = string2 = pHPexeItem != null ? pHPexeItem.getPhpEXE().getAbsolutePath().toString() : null;
                    if (string2 == null) {
                        MessageDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_noexe_msg_title, (String)PHPDebugUIMessages.launch_noexe_msg_text);
                        PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)"org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage", null, null).open();
                        return;
                    }
                    ILaunchConfiguration iLaunchConfiguration = PHPExeLaunchShortcut.findLaunchConfiguration(iProject.getName(), string3, (String)object, string2, string, iLaunchConfigurationType);
                    if (iLaunchConfiguration != null) {
                        DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
                        break block10;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_config, null));
                }
                catch (CoreException coreException) {
                    object = coreException.getStatus();
                    Display.getDefault().asyncExec(new Runnable((IStatus)object){
                        private final /* synthetic */ IStatus val$stat;
                        {
                            this.val$stat = iStatus;
                        }

                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_exec_msg_text, (IStatus)this.val$stat);
                        }
                    });
                }
            }
            ++n2;
        }
    }

    private static String getDefaultPHPExe(IProject iProject) {
        IEclipsePreferences iEclipsePreferences;
        IScopeContext[] iScopeContextArray;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        String string = preferences.getString(PHPDebugCorePreferenceNames.DEFAULT_PHP);
        if (iProject != null && (iScopeContextArray = PHPExeLaunchShortcut.createPreferenceScopes(iProject))[0] instanceof ProjectScope && (iEclipsePreferences = iScopeContextArray[0].getNode(PHPProjectPreferences.getPreferenceNodeQualifier())) != null) {
            string = iEclipsePreferences.get(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
        }
        return string;
    }

    private static IScopeContext[] createPreferenceScopes(IProject iProject) {
        if (iProject != null) {
            return new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    protected static ILaunchConfiguration findLaunchConfiguration(String string, String string2, String string3, String string4, String string5, ILaunchConfigurationType iLaunchConfigurationType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            int n = iLaunchConfigurationArray == null ? 0 : iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string6 = iLaunchConfigurationArray[n2].getAttribute("ATTR_FILE", null);
                String string7 = iLaunchConfigurationArray[n2].getAttribute("ATTR_LOCATION", null);
                if (string2.equals(string6) && string7.equals(string4)) {
                    iLaunchConfiguration = iLaunchConfigurationArray[n2].getWorkingCopy();
                    break;
                }
                ++n2;
            }
            if (iLaunchConfiguration == null) {
                iLaunchConfiguration = PHPExeLaunchShortcut.createConfiguration(string, string2, string3, string4, iLaunchConfigurationType);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    protected static ILaunchConfiguration createConfiguration(String string, String string2, String string3, String string4, ILaunchConfigurationType iLaunchConfigurationType) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = null;
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, PHPExeLaunchShortcut.getNewConfigurationName(string2));
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, PHPExecutableLaunchDelegate.class.getName());
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE_FULL_PATH", string3);
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string4);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        return iLaunchConfiguration;
    }

    protected static String getNewConfigurationName(String string) {
        String string2 = "New_configuration";
        try {
            IPath iPath = Path.fromOSString((String)string);
            String string3 = iPath.getFileExtension();
            String string4 = iPath.lastSegment();
            if (string4 != null) {
                if (string3 != null) {
                    string4 = string4.replaceFirst("." + string3, "");
                }
                string2 = string4;
            }
        }
        catch (Exception exception) {
            Logger.log(202, "Could not generate configuration name for " + string + ".\nThe default name will be used.", exception);
        }
        return DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(string2);
    }
}

