/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.preferences.AbstractPreferencesPropagator;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.ProjectPreferencesPropagator;
import org.osgi.service.prefs.Preferences;

public class PreferencesPropagator
extends AbstractPreferencesPropagator {
    private HashMap projectToPropagator;
    private HashMap projectToScope;
    private HashMap projectToNodeListener;
    private HashMap preferenceChangeListeners;
    private String nodeQualifier;
    private IPropertyChangeListener propertyChangeListener;
    private IPreferenceStore preferenceStore;

    protected PreferencesPropagator(String string, IPreferenceStore iPreferenceStore) {
        this.nodeQualifier = string;
        this.preferenceStore = iPreferenceStore;
        this.install();
    }

    public void addPropagatorListener(IPreferencesPropagatorListener iPreferencesPropagatorListener, String string) {
        this.addNodeListener(iPreferencesPropagatorListener.getProject(), this.getProjectScope(iPreferencesPropagatorListener.getProject()));
        if (this.isProjectSpecific(iPreferencesPropagatorListener.getProject(), string)) {
            this.addToProjectPropagator(iPreferencesPropagatorListener, string);
        } else {
            super.addPropagatorListener(iPreferencesPropagatorListener, string);
        }
    }

    public void removePropagatorListener(IPreferencesPropagatorListener iPreferencesPropagatorListener, String string) {
        if (this.isProjectSpecific(iPreferencesPropagatorListener.getProject(), string)) {
            this.removeFromProjectPropagator(iPreferencesPropagatorListener, string);
        } else {
            super.removePropagatorListener(iPreferencesPropagatorListener, string);
        }
    }

    public void setPropagatorListeners(List list, String string) {
        super.setPropagatorListeners(list, string);
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.projectToPropagator = new HashMap();
        this.projectToScope = new HashMap();
        this.projectToNodeListener = new HashMap();
        this.preferenceChangeListeners = new HashMap();
        this.propertyChangeListener = new InnerPropertyChangeListener();
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        super.install();
    }

    protected synchronized void uninstall() {
        Object object;
        if (!this.isInstalled) {
            return;
        }
        Iterator iterator = this.projectToNodeListener.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                object = iterator.next();
                ProjectScope projectScope = (ProjectScope)this.projectToScope.get(object);
                IEclipsePreferences iEclipsePreferences = projectScope.getNode(this.nodeQualifier);
                if (iEclipsePreferences == null) continue;
                iEclipsePreferences.removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this.projectToNodeListener.get(object));
            }
        }
        catch (Exception exception) {}
        object = this.projectToPropagator.values().iterator();
        while (object.hasNext()) {
            ((ProjectPreferencesPropagator)object.next()).uninstall();
        }
        this.preferenceChangeListeners = null;
        this.projectToScope = null;
        this.projectToPropagator = null;
        this.projectToNodeListener = null;
        super.uninstall();
    }

    private void addToProjectPropagator(IPreferencesPropagatorListener iPreferencesPropagatorListener, String string) {
        ProjectPreferencesPropagator projectPreferencesPropagator = (ProjectPreferencesPropagator)this.projectToPropagator.get(iPreferencesPropagatorListener.getProject());
        if (projectPreferencesPropagator == null) {
            projectPreferencesPropagator = new ProjectPreferencesPropagator(iPreferencesPropagatorListener.getProject(), this.nodeQualifier);
            this.projectToPropagator.put(iPreferencesPropagatorListener.getProject(), projectPreferencesPropagator);
        }
        projectPreferencesPropagator.addPropagatorListener(iPreferencesPropagatorListener, string);
    }

    private void removeFromProjectPropagator(IPreferencesPropagatorListener iPreferencesPropagatorListener, String string) {
        ProjectPreferencesPropagator projectPreferencesPropagator = (ProjectPreferencesPropagator)this.projectToPropagator.get(iPreferencesPropagatorListener.getProject());
        if (projectPreferencesPropagator != null) {
            projectPreferencesPropagator.removePropagatorListener(iPreferencesPropagatorListener, string);
        }
    }

    private boolean isProjectSpecific(IProject iProject, String string) {
        ProjectScope projectScope = this.getProjectScope(iProject);
        return projectScope.getNode(this.nodeQualifier).get(string, null) != null;
    }

    private ProjectScope getProjectScope(IProject iProject) {
        ProjectScope projectScope = (ProjectScope)this.projectToScope.get(iProject);
        if (projectScope == null) {
            projectScope = new ProjectScope(iProject);
            this.projectToScope.put(iProject, projectScope);
        }
        return projectScope;
    }

    private void addNodeListener(IProject iProject, ProjectScope projectScope) {
        if (this.projectToNodeListener.get(iProject) != null) {
            return;
        }
        IEclipsePreferences iEclipsePreferences = projectScope.getNode(this.nodeQualifier);
        if (iEclipsePreferences != null) {
            InnerNodeChangeListener innerNodeChangeListener = new InnerNodeChangeListener(iProject);
            ((IEclipsePreferences)iEclipsePreferences.parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)innerNodeChangeListener);
            this.projectToNodeListener.put(iProject, innerNodeChangeListener);
            if (!this.preferenceChangeListeners.containsValue(iEclipsePreferences)) {
                NodePreferenceChangeListener nodePreferenceChangeListener = new NodePreferenceChangeListener(iProject);
                iEclipsePreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)nodePreferenceChangeListener);
                this.preferenceChangeListeners.put(nodePreferenceChangeListener, iEclipsePreferences);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(PreferencesPropagatorEvent preferencesPropagatorEvent, String string, IProject iProject) {
        Object object = this.lock;
        synchronized (object) {
            if (iProject != null) {
                ProjectPreferencesPropagator projectPreferencesPropagator = (ProjectPreferencesPropagator)this.projectToPropagator.get(iProject);
                if (projectPreferencesPropagator == null) {
                    projectPreferencesPropagator = new ProjectPreferencesPropagator(iProject, this.nodeQualifier);
                    this.projectToPropagator.put(iProject, projectPreferencesPropagator);
                }
                projectPreferencesPropagator.notifyPropagatorEvent(preferencesPropagatorEvent);
            } else {
                List list = this.getPropagatorListeners(string);
                if (list == null) {
                    return;
                }
                IPreferencesPropagatorListener[] iPreferencesPropagatorListenerArray = new IPreferencesPropagatorListener[list.size()];
                list.toArray(iPreferencesPropagatorListenerArray);
                int n = 0;
                while (n < iPreferencesPropagatorListenerArray.length) {
                    iPreferencesPropagatorListenerArray[n].preferencesEventOccured(preferencesPropagatorEvent);
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToProjectPropagator(String string, IProject iProject) {
        List list = null;
        IPreferencesPropagatorListener[] iPreferencesPropagatorListenerArray = null;
        Object object = this.lock;
        synchronized (object) {
            list = this.getPropagatorListeners(string);
            if (list == null) {
                return;
            }
            iPreferencesPropagatorListenerArray = new IPreferencesPropagatorListener[list.size()];
            list.toArray(iPreferencesPropagatorListenerArray);
        }
        int n = 0;
        while (n < iPreferencesPropagatorListenerArray.length) {
            IPreferencesPropagatorListener iPreferencesPropagatorListener = iPreferencesPropagatorListenerArray[n];
            if (iProject.equals((Object)iPreferencesPropagatorListener.getProject())) {
                super.removePropagatorListener(iPreferencesPropagatorListener, string);
                this.addToProjectPropagator(iPreferencesPropagatorListener, string);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromProjectPropagator(String string, IProject iProject) {
        Object object = this.lock;
        synchronized (object) {
            List list;
            ProjectPreferencesPropagator projectPreferencesPropagator = (ProjectPreferencesPropagator)this.projectToPropagator.get(iProject);
            if (projectPreferencesPropagator != null && (list = projectPreferencesPropagator.removePropagatorListeners(string)) != null && list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.addPropagatorListener((IPreferencesPropagatorListener)iterator.next(), string);
                }
            }
        }
    }

    private class InnerNodeChangeListener
    implements IEclipsePreferences.INodeChangeListener {
        private IProject project;

        public InnerNodeChangeListener(IProject iProject) {
            this.project = iProject;
        }

        public void added(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
            IEclipsePreferences iEclipsePreferences = null;
            if (!(nodeChangeEvent.getChild() instanceof IEclipsePreferences)) {
                return;
            }
            iEclipsePreferences = (IEclipsePreferences)nodeChangeEvent.getChild();
            if (!PreferencesPropagator.this.preferenceChangeListeners.containsValue(iEclipsePreferences)) {
                NodePreferenceChangeListener nodePreferenceChangeListener = new NodePreferenceChangeListener(this.project);
                iEclipsePreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)nodePreferenceChangeListener);
                PreferencesPropagator.this.preferenceChangeListeners.put(nodePreferenceChangeListener, iEclipsePreferences);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
            Preferences preferences = nodeChangeEvent.getChild();
            if (PreferencesPropagator.this.preferenceChangeListeners.containsValue(preferences)) {
                for (Object k : PreferencesPropagator.this.preferenceChangeListeners.keySet()) {
                    IEclipsePreferences iEclipsePreferences = (IEclipsePreferences)PreferencesPropagator.this.preferenceChangeListeners.get(k);
                    if (iEclipsePreferences != preferences) continue;
                    PreferencesPropagator.this.preferenceChangeListeners.remove(k);
                    return;
                }
            }
        }
    }

    private class InnerPropertyChangeListener
    implements IPropertyChangeListener {
        private InnerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PreferencesPropagatorEvent preferencesPropagatorEvent = new PreferencesPropagatorEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getProperty());
            PreferencesPropagator.this.notifyEvent(preferencesPropagatorEvent, propertyChangeEvent.getProperty(), null);
        }
    }

    public class NodePreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private IProject project;

        public NodePreferenceChangeListener(IProject iProject) {
            this.project = iProject;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            String string2 = (String)preferenceChangeEvent.getNewValue();
            if (string2 == null) {
                PreferencesPropagator.this.removeFromProjectPropagator(string, this.project);
            } else {
                PreferencesPropagator.this.moveToProjectPropagator(string, this.project);
            }
            PreferencesPropagatorEvent preferencesPropagatorEvent = new PreferencesPropagatorEvent(preferenceChangeEvent.getSource(), preferenceChangeEvent.getOldValue(), preferenceChangeEvent.getNewValue(), preferenceChangeEvent.getKey());
            PreferencesPropagator.this.notifyEvent(preferencesPropagatorEvent, string, string2 == null ? null : this.project);
        }
    }
}

