/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Quote
extends Expression {
    public static final int QT_QUOTE = 0;
    public static final int QT_SINGLE = 1;
    public static final int QT_HEREDOC = 2;
    private final Expression[] expressions;
    private final int quoteType;

    public Quote(int n, int n2, Expression[] expressionArray, int n3) {
        super(n, n2);
        this.expressions = expressionArray;
        this.quoteType = n3;
        int n4 = 0;
        while (n4 < expressionArray.length) {
            expressionArray[n4].setParent(this);
            ++n4;
        }
    }

    public Quote(int n, int n2, List list, int n3) {
        this(n, n2, list == null ? null : list.toArray(new Expression[list.size()]), n3);
    }

    public static String getType(int n) {
        switch (n) {
            case 0: {
                return "quote";
            }
            case 1: {
                return "single";
            }
            case 2: {
                return "heredoc";
            }
        }
        throw new IllegalArgumentException();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int n = 0;
        while (n < this.expressions.length) {
            this.expressions[n].accept(visitor);
            ++n;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int n = 0;
        while (n < this.expressions.length) {
            this.expressions[n].traverseTopDown(visitor);
            ++n;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int n = 0;
        while (n < this.expressions.length) {
            this.expressions[n].traverseBottomUp(visitor);
            ++n;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<Quote");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" type='").append(Quote.getType(this.quoteType)).append("'>\n");
        int n = 0;
        while (n < this.expressions.length) {
            this.expressions[n].toString(stringBuffer, "\t" + string);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append(string).append("</Quote>");
    }

    public int getType() {
        return 47;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    public int getQuoteType() {
        return this.quoteType;
    }
}

