/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.actions.expressions.WatchExpressionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class PHPWatchAction
extends WatchExpressionAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (iSelection instanceof ITextSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            iAction.setEnabled(iTextSelection.getLength() != 0);
        }
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
    }

    public void run(IAction iAction) {
        IStructuredSelection iStructuredSelection = this.getCurrentSelection();
        if (iStructuredSelection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)iStructuredSelection;
            IExpressionManager iExpressionManager = DebugPlugin.getDefault().getExpressionManager();
            IDOMNode iDOMNode = (IDOMNode)iStructuredSelection.getFirstElement();
            try {
                String string = iDOMNode.getFirstStructuredDocumentRegion().getParentDocument().get(textSelection.getOffset(), textSelection.getLength());
                IWatchExpression iWatchExpression = iExpressionManager.newWatchExpression(string.trim());
                iExpressionManager.addExpression((IExpression)iWatchExpression);
                iWatchExpression.setExpressionContext(this.getContext());
            }
            catch (Exception exception) {
                Logger.logException(exception);
            }
        }
    }
}

