/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.ui.editor.contentassist.ContentAssistSupport;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContextInformationValidator;
import org.eclipse.php.internal.ui.text.PHPCodeReader;
import org.eclipse.php.ui.editor.contentassist.IContentAssistProcessorForPHP;
import org.eclipse.php.ui.editor.contentassist.IContentAssistSupport;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PHPContentAssistProcessor
implements IContentAssistProcessorForPHP {
    protected IContentAssistSupport support = new ContentAssistSupport();
    protected PHPContextInformationValidator contextInformationValidator = new PHPContextInformationValidator();
    protected static final char[] contextInformationActivationChars = new char[]{'(', ','};
    private boolean isExplicitRequest = false;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        ICompletionProposal[] iCompletionProposalArray;
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        if (iModelManager == null) {
            return new ICompletionProposal[0];
        }
        IStructuredModel iStructuredModel = null;
        iStructuredModel = iModelManager.getExistingModelForRead(iTextViewer.getDocument());
        if (iStructuredModel == null) {
            return new ICompletionProposal[0];
        }
        try {
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            try {
                iCompletionProposalArray = this.support.getCompletionOption(iTextViewer, dOMModelForPHP, n, this.isExplicitRequest);
            }
            catch (Exception exception) {
                Logger.logException((Throwable)exception);
                ICompletionProposal[] iCompletionProposalArray2 = new ICompletionProposal[]{};
                iStructuredModel.releaseFromRead();
                this.isExplicitRequest = false;
                return iCompletionProposalArray2;
            }
            if (iCompletionProposalArray == null) {
                iCompletionProposalArray = new ICompletionProposal[]{};
            }
        }
        finally {
            iStructuredModel.releaseFromRead();
            this.isExplicitRequest = false;
        }
        return iCompletionProposalArray;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        int n2 = this.guessContextInformationPosition(iTextViewer, n);
        if (n2 == -1) {
            return null;
        }
        ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals(iTextViewer, n2);
        ArrayList<IContextInformation> arrayList = new ArrayList<IContextInformation>();
        int n3 = 0;
        while (n3 < iCompletionProposalArray.length) {
            IContextInformation iContextInformation = iCompletionProposalArray[n3].getContextInformation();
            if (iContextInformation != null) {
                arrayList.add(iContextInformation);
            }
            ++n3;
        }
        return arrayList.toArray(new IContextInformation[arrayList.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.support.getAutoactivationTriggers();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return contextInformationActivationChars;
    }

    public String getErrorMessage() {
        return null;
    }

    public final IContextInformationValidator getContextInformationValidator() {
        if (this.getClass().equals(PHPContentAssistProcessor.class)) {
            return this.contextInformationValidator;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int guessContextInformationPosition(ITextViewer iTextViewer, int n) {
        int n2 = -1;
        IDocument iDocument = iTextViewer.getDocument();
        try {
            PHPCodeReader pHPCodeReader = new PHPCodeReader();
            pHPCodeReader.configureBackwardReader(iDocument, n, true, true);
            int n3 = 0;
            int n4 = pHPCodeReader.read();
            while (true) {
                if (n4 == -1) {
                    return n2;
                }
                if (')' == (char)n4) {
                    ++n3;
                } else if ('(' == (char)n4 && --n3 < 0) {
                    if (!this.looksLikeMethod(pHPCodeReader)) return -1;
                    return pHPCodeReader.getOffset() + 1;
                }
                n4 = pHPCodeReader.read();
            }
        }
        catch (IOException iOException) {}
        return n2;
    }

    private boolean looksLikeMethod(PHPCodeReader pHPCodeReader) throws IOException {
        int n = pHPCodeReader.read();
        while (n != -1 && Character.isWhitespace((char)n)) {
            n = pHPCodeReader.read();
        }
        if (n == -1) {
            return false;
        }
        return Character.isJavaIdentifierPart((char)n) || Character.isJavaIdentifierStart((char)n);
    }

    public void explicitActivationRequest() {
        this.isExplicitRequest = true;
    }
}

