/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.Collection;

public class Breakpoint
implements Cloneable {
    public static final String NAME_CHANGED_PROPERTY = "fileName";
    public static final String LINE_CHANGED_PROPERTY = "lineNumber";
    public static final String ID_CHANGED_PROPERTY = "id";
    public static final String TYPE_CHANGED_PROPERTY = "type";
    public static final String LIFETIME_CHANGED_PROPERTY = "lifetime";
    public static final String EXPRESSION_CHANGED_PROPERTY = "expression";
    public static final String ENABLE_CHANGED_PROPERTY = "enable";
    static final long serialVersionUID = 8217568055748309793L;
    public static final int DEFAULT_ID = -1;
    public static final int ZEND_CONDITIONAL_BREAKPOINT = 2;
    public static final String CONDITIONAL_STRING = "Conditional";
    public static final int ZEND_STATIC_BREAKPOINT = 1;
    public static final String STATIC_STRING = "Static";
    public static final int ZEND_ONETIME_BREAKPOINT = 1;
    public static final String ONETIME_STRING = "One time";
    public static final int ZEND_PERMANENT_BREAKPOINT = 2;
    public static final String PERMANENT_STRING = "Permanent";
    private int id;
    private int type;
    private int lifetime;
    private String expression = "";
    private boolean enable;
    private boolean conditionalFlag = false;
    private boolean staticFlag = true;
    protected String fileName = "";
    protected int lineNumber = -1;
    protected transient Collection listeners;

    public Breakpoint() {
        this("", -1);
    }

    public Breakpoint(String string, int n) {
        this.setFileName(string);
        this.setLineNumber(n);
        this.id = -1;
        this.setStaticFlag(true);
        this.lifetime = 2;
        this.enable = true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setID(int n) {
        if (this.id != n) {
            int n2 = this.id;
            this.id = n;
            this.fireBreakpointChanged(this, ID_CHANGED_PROPERTY, new Integer(n2), new Integer(n));
        }
    }

    public int getID() {
        return this.id;
    }

    public void setFileName(String string) {
        if (this.fileName.equals(string)) {
            return;
        }
        String string2 = this.fileName;
        this.fileName = string;
        this.fireBreakpointChanged(this, NAME_CHANGED_PROPERTY, string2, string);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        if (this.lineNumber == n) {
            return;
        }
        int n2 = this.lineNumber;
        this.lineNumber = n;
        this.fireBreakpointChanged(this, LINE_CHANGED_PROPERTY, new Integer(n2), new Integer(n));
    }

    public void setConditionalFlag(boolean bl) {
        this.conditionalFlag = bl;
    }

    public void setStaticFlag(boolean bl) {
        this.staticFlag = bl;
    }

    public boolean getStaticFlag() {
        return this.staticFlag;
    }

    public boolean getConditionalFlag() {
        return this.conditionalFlag;
    }

    public void setType(int n) {
        if (n < 4 && this.type != n) {
            int n2 = this.type;
            this.type = n;
            this.conditionalFlag = n >= 2;
            this.staticFlag = n == 1 || n == 3;
            this.fireBreakpointChanged(this, TYPE_CHANGED_PROPERTY, new Integer(n2), new Integer(this.id));
        }
    }

    public int getType() {
        int n = this.staticFlag ? 1 : 0;
        int n2 = this.conditionalFlag ? 2 : 0;
        this.type = n + n2;
        return this.type;
    }

    public void setLifeTime(int n) {
        if ((n == 1 || n == 2) && this.lifetime != n) {
            int n2 = n;
            this.lifetime = n;
            this.fireBreakpointChanged(this, LIFETIME_CHANGED_PROPERTY, new Integer(n2), new Integer(this.id));
        }
    }

    public int getLifeTime() {
        return this.lifetime;
    }

    public void setExpression(String string) {
        if (!this.expression.equals(string)) {
            String string2 = this.expression;
            this.expression = string;
            if (!string.equals("")) {
                this.setConditionalFlag(true);
            } else {
                this.setConditionalFlag(false);
            }
            this.fireBreakpointChanged(this, EXPRESSION_CHANGED_PROPERTY, string2, string);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setEnable(boolean bl) {
        if (this.enable != bl) {
            boolean bl2 = this.enable;
            this.enable = bl;
            this.fireBreakpointChanged(this, ENABLE_CHANGED_PROPERTY, new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String toString() {
        return "id: " + this.id + " type: " + this.type + "  file name: " + this.getFileName() + " line: " + this.getLineNumber();
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object == null || !(object instanceof Breakpoint)) {
            return false;
        }
        Breakpoint breakpoint = (Breakpoint)object;
        return this.id == breakpoint.id && this.type == breakpoint.type && this.lifetime == breakpoint.lifetime && this.fileName.equals(breakpoint.getFileName()) && this.lineNumber == breakpoint.getLineNumber();
    }

    protected void fireBreakpointChanged(Breakpoint breakpoint, String string, Object object, Object object2) {
        if (this.listeners != null) {
            for (BreakpointListener breakpointListener : this.listeners) {
                breakpointListener.breakpointChanged(breakpoint, string, object, object2);
            }
        }
    }

    public int compareTo(Object object) {
        if (!(object instanceof Breakpoint)) {
            return -1;
        }
        Breakpoint breakpoint = (Breakpoint)object;
        int n = this.fileName.compareTo(breakpoint.getFileName());
        if (n == 0) {
            n = this.lineNumber - breakpoint.getLineNumber();
        }
        return n;
    }

    public Object clone() {
        try {
            Breakpoint breakpoint = (Breakpoint)super.clone();
            breakpoint.listeners = null;
            return breakpoint;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static interface BreakpointListener {
        public void breakpointChanged(Breakpoint var1, String var2, Object var3, Object var4);
    }
}

