/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.FileEditorInput;

public class PHPProjectBuildJobWrapper {
    private IProject project;

    public PHPProjectBuildJobWrapper(IProject iProject) {
        this.project = iProject;
    }

    public void runJob() {
        WorkspaceJob workspaceJob = new WorkspaceJob("Building after php version changed ..."){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    PHPProjectBuildJobWrapper.this.project.build(15, iProgressMonitor);
                }
                finally {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }

            private void handleEditorReferences(IEditorReference[] iEditorReferenceArray) {
                int n = 0;
                while (n < iEditorReferenceArray.length) {
                    IContentDescription iContentDescription;
                    IEditorReference iEditorReference = iEditorReferenceArray[n];
                    IEditorPart iEditorPart = iEditorReference.getEditor(false);
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (!(iEditorInput instanceof FileEditorInput)) {
                        return;
                    }
                    IFile iFile = ((FileEditorInput)iEditorInput).getFile();
                    try {
                        iContentDescription = iFile.getContentDescription();
                    }
                    catch (CoreException coreException) {
                        Logger.logException(coreException);
                        return;
                    }
                    if (iContentDescription == null) {
                        return;
                    }
                    if (!ContentTypeIdForPHP.ContentTypeID_PHP.equals(iContentDescription.getContentType().getId())) {
                        return;
                    }
                    ++n;
                }
            }
        };
        workspaceJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        workspaceJob.setUser(false);
        workspaceJob.schedule();
    }
}

