/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.functions.PHPFunctionsPart;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.workingset.ViewAction;
import org.eclipse.php.internal.ui.workingset.ViewActionGroup;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class FunctionsViewGroup
extends ViewActionGroup {
    public static final int PHP4 = 1;
    public static final int PHP5 = 2;
    public static final IPhpModel php4Model = PHPLanguageManagerProvider.instance().getPHPLanguageManager("php4").getModel();
    public static final IPhpModel php5Model = PHPLanguageManagerProvider.instance().getPHPLanguageManager("php5").getModel();
    private PHPFunctionsPart fPart;
    private ViewAction showPHP4FunctionsAction;
    private ViewAction showPHP5FunctionsAction;
    private int currentMode;

    public FunctionsViewGroup(PHPFunctionsPart pHPFunctionsPart) {
        this.fPart = pHPFunctionsPart;
        this.fillContextMenu(this.fPart.getViewSite().getActionBars().getMenuManager());
    }

    public void dispose() {
        super.dispose();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.showPHP4FunctionsAction = new ViewAction(this, 1);
        this.showPHP4FunctionsAction.setText("PHP 4");
        this.showPHP5FunctionsAction = new ViewAction(this, 2);
        this.showPHP5FunctionsAction.setText("PHP 5");
        iMenuManager.add((IAction)this.showPHP4FunctionsAction);
        iMenuManager.add((IAction)this.showPHP5FunctionsAction);
    }

    public void setMode(int n) {
        if (n == this.currentMode) {
            return;
        }
        this.fPart.getViewer().setInput((Object)(n == 1 ? php4Model : php5Model));
        this.currentMode = n;
        this.updateActions();
    }

    private void updateActions() {
        if (this.currentMode == 1) {
            this.showPHP4FunctionsAction.setChecked(true);
            this.showPHP5FunctionsAction.setChecked(false);
        } else {
            this.showPHP5FunctionsAction.setChecked(true);
            this.showPHP4FunctionsAction.setChecked(false);
        }
    }

    public void handleUpdateInput(IEditorPart iEditorPart) {
        if (iEditorPart == null) {
            this.setMode(this.getVersion(PhpVersionProjectPropertyHandler.getVersion()));
            return;
        }
        PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)iEditorPart);
        if (pHPStructuredEditor != null) {
            IFile iFile = pHPStructuredEditor.getFile();
            String string = PhpVersionProjectPropertyHandler.getVersion((IProject)iFile.getProject());
            this.setMode(this.getVersion(string));
        }
    }

    private int getVersion(String string) {
        if ("php4".equals(string)) {
            return 1;
        }
        return 2;
    }
}

