/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org.eclipse.php.internal.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;

public class TaskPatternsProvider {
    private static TaskPatternsProvider instance;
    private TaskTagsProvider provider = TaskTagsProvider.getInstance();
    private Pattern[] workspacePatterns;
    private HashMap projectsPatterns = new HashMap();
    private HashMap projectToListener = new HashMap();

    private TaskPatternsProvider() {
        this.initPatternsDB();
    }

    public static TaskPatternsProvider getInstance() {
        if (instance == null) {
            instance = new TaskPatternsProvider();
        }
        return instance;
    }

    public Pattern[] getPatternsForProject(IProject iProject) {
        this.registerProject(iProject);
        Pattern[] patternArray = (Pattern[])this.projectsPatterns.get(iProject);
        if (patternArray != null) {
            return patternArray;
        }
        patternArray = this.workspacePatterns;
        return patternArray;
    }

    public Pattern[] getPetternsForWorkspace() {
        return this.workspacePatterns;
    }

    private void registerProject(IProject iProject) {
        if (this.projectToListener.get(iProject) == null) {
            Object object;
            TaskTag[] taskTagArray = this.provider.getProjectTaskTags(iProject);
            boolean bl = this.provider.getProjectTagsCaseSensitive(iProject);
            if (taskTagArray != null) {
                object = this.createPatterns(taskTagArray, bl);
                this.projectsPatterns.put(iProject, object);
            }
            object = new TaskTagsListener();
            this.provider.addTaskTagsListener((ITaskTagsListener)object, iProject);
            this.projectToListener.put(iProject, object);
        }
    }

    private void initPatternsDB() {
        this.workspacePatterns = this.createPatterns(this.provider.getWorkspaceTaskTags(), this.provider.isWorkspaceTagsCaseSensitive());
        IProject[] iProjectArray = PHPWorkspaceModelManager.getInstance().listProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            this.registerProject(iProject);
            ++n;
        }
    }

    private Pattern[] createPatterns(TaskTag[] taskTagArray, boolean bl) {
        Pattern[] patternArray = new Pattern[taskTagArray.length];
        int n = 0;
        while (n < taskTagArray.length) {
            TaskTag taskTag = taskTagArray[n];
            String string = taskTag.getTag();
            patternArray[n] = bl ? Pattern.compile(string) : Pattern.compile(string, 2);
            ++n;
        }
        return patternArray;
    }

    private void taskTagsChanged(IProject iProject, TaskTag[] taskTagArray, boolean bl) {
        if (iProject == null) {
            this.workspacePatterns = this.createPatterns(taskTagArray, bl);
            return;
        }
        if (taskTagArray == null) {
            this.projectsPatterns.remove(iProject);
            return;
        }
        Pattern[] patternArray = this.createPatterns(taskTagArray, bl);
        this.projectsPatterns.put(iProject, patternArray);
    }

    private class TaskTagsListener
    implements ITaskTagsListener {
        private TaskTagsListener() {
        }

        public void taskTagsChanged(TaskTagsEvent taskTagsEvent) {
            TaskPatternsProvider.this.taskTagsChanged(taskTagsEvent.getProject(), taskTagsEvent.getTaskTags(), taskTagsEvent.isCaseSensitive());
        }

        public void taskPrioritiesChanged(TaskTagsEvent taskTagsEvent) {
        }

        public void taskCaseChanged(TaskTagsEvent taskTagsEvent) {
            TaskPatternsProvider.this.taskTagsChanged(taskTagsEvent.getProject(), taskTagsEvent.getTaskTags(), taskTagsEvent.isCaseSensitive());
        }
    }
}

