/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;

public class IniPreferencesFactory
implements PreferencesFactory {
    public static final String KEY_SYSTEM = "org.ini4j.prefs.system";
    public static final String KEY_USER = "org.ini4j.prefs.user";
    public static final String PROPERTIES = "ini4j.properties";
    private Preferences _system;
    private Preferences _user;

    protected String getIniLocation(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            try {
                Properties properties = new Properties();
                properties.load(this.getClass().getClassLoader().getResourceAsStream(PROPERTIES));
                string2 = properties.getProperty(string);
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    protected URL getResource(String string) throws IllegalArgumentException {
        try {
            URI uRI = new URI(string);
            URL uRL = uRI.getScheme() == null ? this.getClass().getClassLoader().getResource(string) : uRI.toURL();
            return uRL;
        }
        catch (Exception exception) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
        }
    }

    protected InputStream getResourceAsStream(String string) throws IllegalArgumentException {
        try {
            return this.getResource(string).openStream();
        }
        catch (Exception exception) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
        }
    }

    protected Preferences newIniPreferences(String string) {
        Ini ini = new Ini();
        String string2 = this.getIniLocation(string);
        if (string2 != null) {
            try {
                ini.load(this.getResourceAsStream(string2), 0);
            }
            catch (Exception exception) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
            }
        }
        return new IniPreferences(ini);
    }

    public synchronized Preferences systemRoot() {
        if (this._system == null) {
            this._system = this.newIniPreferences(KEY_SYSTEM);
        }
        return this._system;
    }

    public synchronized Preferences userRoot() {
        if (this._user == null) {
            this._user = this.newIniPreferences(KEY_USER);
        }
        return this._user;
    }
}

