/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import com.ibm.icu.text.MessageFormat;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.internal.BufferedCanvas;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.IMergeViewerTestAdapter;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.NavigationEndDialog;
import org.eclipse.compare.internal.OutlineViewerCreator;
import org.eclipse.compare.internal.TokenComparator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.ui.compare.ContentMergeViewer;
import org.eclipse.php.internal.ui.compare.MergeSourceViewer;
import org.eclipse.php.internal.ui.compare.ShowWhitespaceAction;
import org.eclipse.php.internal.ui.compare.TextEditorPropertyAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;

public class TextMergeViewer
extends ContentMergeViewer
implements IAdaptable {
    private static final String COPY_LEFT_TO_RIGHT_INDICATOR = ">";
    private static final String COPY_RIGHT_TO_LEFT_INDICATOR = "<";
    private static final char ANCESTOR_CONTRIBUTOR = 'A';
    private static final char RIGHT_CONTRIBUTOR = 'R';
    private static final char LEFT_CONTRIBUTOR = 'L';
    private static final String DIFF_RANGE_CATEGORY = "org.eclipse.compare.DIFF_RANGE_CATEGORY";
    static final boolean DEBUG = false;
    private static final boolean FIX_47640 = true;
    private static final String[] GLOBAL_ACTIONS = new String[]{ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.DELETE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.SAVE.getId(), ActionFactory.FIND.getId()};
    private static final String[] TEXT_ACTIONS = new String[]{"undo", "redo", "cut", "copy", "paste", "delete", "selectAll", "save", "find"};
    private static final String BUNDLE_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewerResources";
    private static final String INCOMING_COLOR = "INCOMING_COLOR";
    private static final String OUTGOING_COLOR = "OUTGOING_COLOR";
    private static final String CONFLICTING_COLOR = "CONFLICTING_COLOR";
    private static final String RESOLVED_COLOR = "RESOLVED_COLOR";
    private static final int MARGIN_WIDTH = 6;
    private static final int CENTER_WIDTH = 34;
    private static final int BIRDS_EYE_VIEW_WIDTH = 12;
    private static final int BIRDS_EYE_VIEW_INSET = 2;
    private static final int RESOLVE_SIZE = 5;
    private static final boolean APPEND_CONFLICT = true;
    private static final int LW = 1;
    private static final boolean USE_MERGING_TOKEN_DIFF = false;
    private boolean fLeftIsLocal;
    private boolean fShowCurrentOnly = false;
    private boolean fShowCurrentOnly2 = false;
    private int fMarginWidth = 6;
    private int fTopInset;
    private RGB fBackground;
    private RGB fForeground;
    private boolean fPollSystemForeground = true;
    private boolean fPollSystemBackground = true;
    private RGB SELECTED_INCOMING;
    private RGB INCOMING;
    private RGB INCOMING_FILL;
    private RGB INCOMING_TEXT_FILL;
    private RGB SELECTED_CONFLICT;
    private RGB CONFLICT;
    private RGB CONFLICT_FILL;
    private RGB CONFLICT_TEXT_FILL;
    private RGB SELECTED_OUTGOING;
    private RGB OUTGOING;
    private RGB OUTGOING_FILL;
    private RGB OUTGOING_TEXT_FILL;
    private RGB RESOLVED;
    private IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fPreferenceChangeListener;
    private ArrayList fAllDiffs;
    private ArrayList fChangeDiffs;
    private Diff fCurrentDiff;
    private HashMap fNewAncestorRanges = new HashMap();
    private HashMap fNewLeftRanges = new HashMap();
    private HashMap fNewRightRanges = new HashMap();
    private MergeSourceViewer fAncestor;
    private MergeSourceViewer fLeft;
    private MergeSourceViewer fRight;
    private int fLeftLineCount;
    private int fRightLineCount;
    private boolean fInScrolling;
    private int[] fPts = new int[8];
    private int fInheritedDirection;
    private int fTextDirection;
    private ActionContributionItem fIgnoreAncestorItem;
    private boolean fHighlightRanges;
    private boolean fShowPseudoConflicts = false;
    private boolean fUseSplines = true;
    private boolean fUseSingleLine = true;
    private boolean fUseResolveUI = true;
    private boolean fHighlightTokenChanges = false;
    private String fSymbolicFontName;
    private ActionContributionItem fNextDiff;
    private ActionContributionItem fPreviousDiff;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private CompareHandlerService fHandlerService;
    private boolean fSynchronizedScrolling = true;
    private boolean fShowMoreInfo = false;
    private MergeSourceViewer fFocusPart;
    private boolean fSubDoc = true;
    private IPositionUpdater fPositionUpdater;
    private boolean fIsMotif;
    private boolean fIsCarbon;
    private boolean fHasErrors;
    private BufferedCanvas fAncestorCanvas;
    private BufferedCanvas fLeftCanvas;
    private BufferedCanvas fRightCanvas;
    private Canvas fScrollCanvas;
    private ScrollBar fVScrollBar;
    private Canvas fBirdsEyeCanvas;
    private Canvas fSummaryHeader;
    private HeaderPainter fHeaderPainter;
    private Map fColors;
    private Cursor fBirdsEyeCursor;
    private double[] fBasicCenterCurve;
    private Button fCenterButton;
    private Diff fButtonDiff;
    private ContributorInfo fLeftContributor;
    private ContributorInfo fRightContributor;
    private ContributorInfo fAncestorContributor;
    private boolean isRefreshing;
    private int fSynchronziedScrollPosition;
    private ActionContributionItem fNextChange;
    private ActionContributionItem fPreviousChange;
    private ShowWhitespaceAction showWhitespaceAction;
    private InternalOutlineViewerCreator fOutlineViewerCreator;
    private TextEditorPropertyAction toggleLineNumbersAction;
    private IFindReplaceTarget fFindReplaceTarget;
    private ChangePropertyAction fIgnoreWhitespace;

    public TextMergeViewer(Composite composite, CompareConfiguration compareConfiguration) {
        this(composite, 0, compareConfiguration);
    }

    public TextMergeViewer(Composite composite, int n, CompareConfiguration compareConfiguration) {
        super(n, ResourceBundle.getBundle(BUNDLE_NAME), compareConfiguration);
        int n2 = composite.getStyle();
        this.fInheritedDirection = (n2 & 0x2000000) != 0 ? 0x2000000 : ((n2 & 0x4000000) != 0 ? 0x4000000 : 0);
        this.fTextDirection = (n & 0x2000000) != 0 ? 0x2000000 : ((n & 0x4000000) != 0 ? 0x4000000 : 0);
        this.fSymbolicFontName = ((Object)((Object)this)).getClass().getName();
        String string = SWT.getPlatform();
        this.fIsMotif = "motif".equals(string);
        this.fIsCarbon = "carbon".equals(string);
        if (this.fIsMotif) {
            this.fMarginWidth = 0;
        }
        Display display = composite.getDisplay();
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextMergeViewer.this.handlePropertyChangeEvent(propertyChangeEvent);
            }
        };
        this.fPreferenceStore = this.getCompareConfiguration().getPreferenceStore();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
            this.checkForColorUpdate(display);
            this.fLeftIsLocal = Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)"LEFT_IS_LOCAL", (boolean)false);
            this.fSynchronizedScrolling = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.fShowMoreInfo = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowMoreInfo");
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fHighlightTokenChanges = this.fPreferenceStore.getBoolean("org.eclipse.compare.HighlightTokenChanges");
        }
        this.buildControl(composite);
        INavigatable iNavigatable = new INavigatable(){

            public boolean selectChange(int n) {
                if (n == 3 || n == 4) {
                    TextMergeViewer.this.selectFirstDiff(n == 3);
                    return false;
                }
                return TextMergeViewer.this.navigate(n == 1, false, false);
            }

            public Object getInput() {
                return TextMergeViewer.this.getInput();
            }

            public boolean openSelectedChange() {
                return false;
            }

            public boolean hasChange(int n) {
                return TextMergeViewer.this.getNextVisibleDiff(n == 1, false) != null;
            }
        };
        this.fComposite.setData("org.eclipse.compare.internal.Navigator", (Object)iNavigatable);
        this.fBirdsEyeCursor = new Cursor((Device)composite.getDisplay(), 21);
        JFaceResources.getFontRegistry().addListener(this.fPreferenceChangeListener);
        JFaceResources.getColorRegistry().addListener(this.fPreferenceChangeListener);
        this.updateFont();
    }

    private void updateFont() {
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        if (font != null) {
            if (this.fAncestor != null) {
                this.fAncestor.setFont(font);
            }
            if (this.fLeft != null) {
                this.fLeft.setFont(font);
            }
            if (this.fRight != null) {
                this.fRight.setFont(font);
            }
        }
    }

    private void checkForColorUpdate(Display display) {
        RGB rGB;
        if (this.fPollSystemForeground) {
            rGB = display.getSystemColor(24).getRGB();
            if (this.fForeground == null || !rGB.equals((Object)this.fForeground)) {
                this.fForeground = rGB;
                this.updateColors(display);
            }
        }
        if (this.fPollSystemBackground) {
            rGB = display.getSystemColor(25).getRGB();
            if (this.fBackground == null || !rGB.equals((Object)this.fBackground)) {
                this.fBackground = rGB;
                this.updateColors(display);
            }
        }
    }

    public void setBackgroundColor(RGB rGB) {
        this.fPollSystemBackground = rGB == null;
        this.fBackground = rGB;
        this.updateColors(null);
    }

    private RGB getBackground(Display display) {
        if (this.fBackground != null) {
            return this.fBackground;
        }
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        return display.getSystemColor(25).getRGB();
    }

    public void setForegroundColor(RGB rGB) {
        this.fPollSystemForeground = rGB == null;
        this.fForeground = rGB;
        this.updateColors(null);
    }

    private void updateColors(Display display) {
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        Color color = null;
        if (this.fBackground != null) {
            color = this.getColor(display, this.fBackground);
        }
        if (this.fAncestor != null) {
            this.fAncestor.setBackgroundColor(color);
        }
        if (this.fLeft != null) {
            this.fLeft.setBackgroundColor(color);
        }
        if (this.fRight != null) {
            this.fRight.setBackgroundColor(color);
        }
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        RGB rGB = this.getBackground(display);
        this.SELECTED_INCOMING = colorRegistry.getRGB(INCOMING_COLOR);
        if (this.SELECTED_INCOMING == null) {
            this.SELECTED_INCOMING = new RGB(0, 0, 255);
        }
        this.INCOMING = TextMergeViewer.interpolate(this.SELECTED_INCOMING, rGB, 0.6);
        this.INCOMING_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, rGB, 0.97);
        this.INCOMING_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, rGB, 0.85);
        this.SELECTED_OUTGOING = colorRegistry.getRGB(OUTGOING_COLOR);
        if (this.SELECTED_OUTGOING == null) {
            this.SELECTED_OUTGOING = new RGB(0, 0, 0);
        }
        this.OUTGOING = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, rGB, 0.6);
        this.OUTGOING_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, rGB, 0.97);
        this.OUTGOING_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, rGB, 0.85);
        this.SELECTED_CONFLICT = colorRegistry.getRGB(CONFLICTING_COLOR);
        if (this.SELECTED_CONFLICT == null) {
            this.SELECTED_CONFLICT = new RGB(255, 0, 0);
        }
        this.CONFLICT = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, rGB, 0.6);
        this.CONFLICT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, rGB, 0.97);
        this.CONFLICT_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, rGB, 0.85);
        this.RESOLVED = colorRegistry.getRGB(RESOLVED_COLOR);
        if (this.RESOLVED == null) {
            this.RESOLVED = new RGB(0, 255, 0);
        }
        this.updatePresentation(display);
    }

    private void updatePresentation(Display display) {
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        this.refreshBirdsEyeView();
        this.invalidateLines();
        this.updateAllDiffBackgrounds(display);
        this.invalidateTextPresentation();
    }

    public void invalidateTextPresentation() {
        if (this.fAncestor != null) {
            this.fAncestor.invalidateTextPresentation();
        }
        if (this.fLeft != null) {
            this.fLeft.invalidateTextPresentation();
        }
        if (this.fRight != null) {
            this.fRight.invalidateTextPresentation();
        }
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof MergeSourceViewer) {
            SourceViewerConfiguration sourceViewerConfiguration = new SourceViewerConfiguration();
            ((MergeSourceViewer)textViewer).configure(sourceViewerConfiguration);
        }
    }

    protected ITokenComparator createTokenComparator(String string) {
        return new TokenComparator(string);
    }

    protected void setupDocument(IDocument iDocument) {
        String string = this.getDocumentPartitioning();
        if (string == null || !(iDocument instanceof IDocumentExtension3)) {
            IDocumentPartitioner iDocumentPartitioner;
            if (iDocument.getDocumentPartitioner() == null && (iDocumentPartitioner = this.getDocumentPartitioner()) != null) {
                iDocument.setDocumentPartitioner(iDocumentPartitioner);
                iDocumentPartitioner.connect(iDocument);
            }
        } else {
            IDocumentPartitioner iDocumentPartitioner;
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            if (iDocumentExtension3.getDocumentPartitioner(string) == null && (iDocumentPartitioner = this.getDocumentPartitioner()) != null) {
                iDocumentExtension3.setDocumentPartitioner(string, iDocumentPartitioner);
                iDocumentPartitioner.connect(iDocument);
            }
        }
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return null;
    }

    protected String getDocumentPartitioning() {
        return null;
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        Object object = this.getInput();
        this.removeFromDocumentManager('A', object);
        this.removeFromDocumentManager('L', object);
        this.removeFromDocumentManager('R', object);
        if (this.fPreferenceChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fPreferenceChangeListener);
            JFaceResources.getColorRegistry().removeListener(this.fPreferenceChangeListener);
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        this.fLeftCanvas = null;
        this.fRightCanvas = null;
        this.fVScrollBar = null;
        this.fBirdsEyeCanvas = null;
        this.fSummaryHeader = null;
        this.fAncestorContributor.unsetDocument(this.fAncestor);
        this.fLeftContributor.unsetDocument(this.fLeft);
        this.fRightContributor.unsetDocument(this.fRight);
        this.disconnect(this.fLeftContributor);
        this.disconnect(this.fRightContributor);
        this.disconnect(this.fAncestorContributor);
        if (this.fColors != null) {
            for (Color color : this.fColors.values()) {
                if (color.isDisposed()) continue;
                color.dispose();
            }
            this.fColors = null;
        }
        if (this.fBirdsEyeCursor != null) {
            this.fBirdsEyeCursor.dispose();
            this.fBirdsEyeCursor = null;
        }
        if (this.showWhitespaceAction != null) {
            this.showWhitespaceAction.dispose();
        }
        if (this.toggleLineNumbersAction != null) {
            this.toggleLineNumbersAction.dispose();
        }
        if (this.fIgnoreWhitespace != null) {
            this.fIgnoreWhitespace.dispose();
        }
        super.handleDispose(disposeEvent);
    }

    private void disconnect(ContributorInfo contributorInfo) {
        if (contributorInfo != null) {
            contributorInfo.disconnect();
        }
    }

    protected void createControls(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.text_merge_view_context");
        if (this.fMarginWidth > 0) {
            this.fAncestorCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gC) {
                    TextMergeViewer.this.paintSides(gC, TextMergeViewer.this.fAncestor, (Canvas)TextMergeViewer.this.fAncestorCanvas, false);
                }
            };
            this.fAncestorCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides((Canvas)TextMergeViewer.this.fAncestorCanvas, TextMergeViewer.this.fAncestor, mouseEvent.y), false);
                }
            });
        }
        this.fAncestor = this.createPart(composite);
        this.fAncestor.setEditable(false);
        this.fAncestor.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_ancestor, (Object)TextMergeViewer.this.getCompareConfiguration().getAncestorLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fAncestor.addTextPresentationListener(new ChangeHighlighter(this.fAncestor));
        this.fSummaryHeader = new Canvas(composite, 0);
        this.fHeaderPainter = new HeaderPainter();
        this.fSummaryHeader.addPaintListener((PaintListener)this.fHeaderPainter);
        this.updateResolveStatus();
        if (this.fMarginWidth > 0) {
            this.fLeftCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gC) {
                    TextMergeViewer.this.paintSides(gC, TextMergeViewer.this.fLeft, (Canvas)TextMergeViewer.this.fLeftCanvas, false);
                }
            };
            this.fLeftCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides((Canvas)TextMergeViewer.this.fLeftCanvas, TextMergeViewer.this.fLeft, mouseEvent.y), false);
                }
            });
        }
        this.fLeft = this.createPart(composite);
        this.fLeft.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fLeft.addAction("save", this.fLeftSaveAction);
        this.fLeft.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_left, (Object)TextMergeViewer.this.getCompareConfiguration().getLeftLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fLeft.addTextPresentationListener(new ChangeHighlighter(this.fLeft));
        this.fRight = this.createPart(composite);
        this.fRight.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fRight.addAction("save", this.fRightSaveAction);
        this.fRight.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_right, (Object)TextMergeViewer.this.getCompareConfiguration().getRightLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fRight.addTextPresentationListener(new ChangeHighlighter(this.fRight));
        this.hsynchViewport((TextViewer)this.fAncestor, (TextViewer)this.fLeft, (TextViewer)this.fRight);
        this.hsynchViewport((TextViewer)this.fLeft, (TextViewer)this.fAncestor, (TextViewer)this.fRight);
        this.hsynchViewport((TextViewer)this.fRight, (TextViewer)this.fAncestor, (TextViewer)this.fLeft);
        if (this.fMarginWidth > 0) {
            this.fRightCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gC) {
                    TextMergeViewer.this.paintSides(gC, TextMergeViewer.this.fRight, (Canvas)TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fSynchronizedScrolling);
                }
            };
            this.fRightCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides((Canvas)TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fRight, mouseEvent.y), false);
                }
            });
        }
        this.fScrollCanvas = new Canvas(composite, 512);
        Rectangle rectangle = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        this.fTopInset = rectangle.y;
        this.fVScrollBar = this.fScrollCanvas.getVerticalBar();
        this.fVScrollBar.setIncrement(1);
        this.fVScrollBar.setVisible(true);
        this.fVScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = ((ScrollBar)event.widget).getSelection();
                TextMergeViewer.this.synchronizedScrollVertical(n);
            }
        });
        this.fBirdsEyeCanvas = new BufferedCanvas(composite, 0){

            public void doPaint(GC gC) {
                TextMergeViewer.this.paintBirdsEyeView((Canvas)this, gC);
            }
        };
        this.fBirdsEyeCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, mouseEvent.y), true);
            }
        });
        this.fBirdsEyeCanvas.addMouseMoveListener(new MouseMoveListener(){
            private Cursor fLastCursor;

            public void mouseMove(MouseEvent mouseEvent) {
                Cursor cursor = null;
                Diff diff = TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, mouseEvent.y);
                if (diff != null && diff.fDirection != 0) {
                    cursor = TextMergeViewer.this.fBirdsEyeCursor;
                }
                if (this.fLastCursor != cursor) {
                    TextMergeViewer.this.fBirdsEyeCanvas.setCursor(cursor);
                    this.fLastCursor = cursor;
                }
            }
        });
    }

    private void hsynchViewport(TextViewer textViewer, TextViewer textViewer2, TextViewer textViewer3) {
        StyledText styledText = textViewer.getTextWidget();
        final StyledText styledText2 = textViewer2.getTextWidget();
        final StyledText styledText3 = textViewer3.getTextWidget();
        final ScrollBar scrollBar = styledText.getHorizontalBar();
        scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TextMergeViewer.this.fSynchronizedScrolling) {
                    ScrollBar scrollBar2;
                    int n = scrollBar.getMaximum() - scrollBar.getThumb();
                    double d = 0.0;
                    if (n > 0) {
                        d = (float)scrollBar.getSelection() / (float)n;
                    }
                    if (styledText2.isVisible()) {
                        scrollBar2 = styledText2.getHorizontalBar();
                        styledText2.setHorizontalPixel((int)((double)(scrollBar2.getMaximum() - scrollBar2.getThumb()) * d));
                    }
                    if (styledText3.isVisible()) {
                        scrollBar2 = styledText3.getHorizontalBar();
                        styledText3.setHorizontalPixel((int)((double)(scrollBar2.getMaximum() - scrollBar2.getThumb()) * d));
                    }
                    TextMergeViewer.this.workaround65205();
                }
            }
        });
    }

    private void workaround65205() {
        if (this.fIsCarbon && this.fComposite != null && !this.fComposite.isDisposed()) {
            this.fComposite.getDisplay().update();
        }
    }

    private void setCurrentDiff2(Diff diff, boolean bl) {
        if (diff != null && diff.fDirection != 0) {
            this.setCurrentDiff(diff, bl);
        }
    }

    private Diff handleMouseInSides(Canvas canvas, MergeSourceViewer mergeSourceViewer, int n) {
        int n2 = mergeSourceViewer.getTextWidget().getLineHeight();
        int n3 = mergeSourceViewer.getViewportHeight();
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fChangeDiffs != null) {
            int n4 = mergeSourceViewer.getVerticalScrollOffset() + 1;
            Point point = new Point(0, 0);
            for (Diff diff : this.fChangeDiffs) {
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                mergeSourceViewer.getLineRange(diff.getPosition(mergeSourceViewer), point);
                int n5 = point.x * n2 + n4;
                int n6 = point.y * n2;
                if (n5 + n6 < 0) continue;
                if (n5 >= n3) break;
                if (n < n5 || n >= n5 + n6) continue;
                return diff;
            }
        }
        return null;
    }

    private Diff getDiffUnderMouse(Canvas canvas, int n, int n2, Rectangle rectangle) {
        if (!this.fSynchronizedScrolling) {
            return null;
        }
        int n3 = this.fLeft.getTextWidget().getLineHeight();
        int n4 = this.fRight.getViewportHeight();
        Point point = canvas.getSize();
        int n5 = point.x;
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fChangeDiffs != null) {
            int n6 = this.fLeft.getVerticalScrollOffset();
            int n7 = this.fRight.getVerticalScrollOffset();
            Point point2 = new Point(0, 0);
            for (Diff diff : this.fChangeDiffs) {
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.fLeftPos, point2);
                int n8 = point2.x * n3 + n6;
                int n9 = point2.y * n3;
                this.fRight.getLineRange(diff.fRightPos, point2);
                int n10 = point2.x * n3 + n7;
                int n11 = point2.y * n3;
                if (Math.max(n8 + n9, n10 + n11) < 0) continue;
                if (Math.min(n8, n10) >= n4) break;
                int n12 = (n5 - 5) / 2;
                int n13 = (n8 + n9 / 2 + (n10 + n11 / 2) - 5) / 2;
                if (n2 < n13 || n2 >= n13 + 5 || n < n12 || n >= n12 + 5) continue;
                if (rectangle != null) {
                    int n14 = this.fIsCarbon ? 30 : 20;
                    rectangle.x = n12 + (5 - n14) / 2;
                    rectangle.y = n13 + (5 - n14) / 2;
                    rectangle.width = n14;
                    rectangle.height = n14;
                }
                return diff;
            }
        }
        return null;
    }

    private Diff handlemouseInBirdsEyeView(Canvas canvas, int n) {
        int n2;
        Point point = canvas.getSize();
        int n3 = n2 = this.fSynchronizedScrolling ? this.getVirtualHeight() : this.getRightHeight();
        if (n2 < this.getViewportHeight()) {
            return null;
        }
        int n4 = 0;
        if (this.fAllDiffs != null) {
            Iterator iterator = this.fAllDiffs.iterator();
            int n5 = 0;
            while (iterator.hasNext()) {
                int n6;
                Diff diff = (Diff)iterator.next();
                int n7 = n6 = this.fSynchronizedScrolling ? diff.getMaxDiffHeight() : diff.getRightHeight();
                if (this.useChange(diff.fDirection) && !diff.fIsWhitespace) {
                    int n8 = n4 * point.y / n2;
                    int n9 = n6 * point.y / n2;
                    if (n9 < 3) {
                        n9 = 3;
                    }
                    if (n >= n8 && n < n8 + n9) {
                        return diff;
                    }
                }
                n4 += n6;
                ++n5;
            }
        }
        return null;
    }

    private void paintBirdsEyeView(Canvas canvas, GC gC) {
        int n;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Point point = canvas.getSize();
        int n2 = n = this.fSynchronizedScrolling ? this.getVirtualHeight() : this.getRightHeight();
        if (n < this.getViewportHeight()) {
            return;
        }
        Display display = canvas.getDisplay();
        int n3 = 0;
        if (this.fAllDiffs != null) {
            Iterator iterator = this.fAllDiffs.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                int n5;
                Diff diff = (Diff)iterator.next();
                int n6 = n5 = this.fSynchronizedScrolling ? diff.getMaxDiffHeight() : diff.getRightHeight();
                if (this.useChange(diff.fDirection) && !diff.fIsWhitespace) {
                    Color color;
                    int n7 = n3 * point.y / n;
                    int n8 = n5 * point.y / n;
                    if (n8 < 3) {
                        n8 = 3;
                    }
                    if ((color = this.getColor(display, this.getFillColor(diff))) != null) {
                        gC.setBackground(color);
                        gC.fillRectangle(2, n7, point.x - 4, n8);
                    }
                    if ((color = this.getColor(display, this.getStrokeColor(diff))) != null) {
                        gC.setForeground(color);
                        rectangle.x = 2;
                        rectangle.y = n7;
                        rectangle.width = point.x - 4 - 1;
                        rectangle.height = n8;
                        if (diff == this.fCurrentDiff || this.fCurrentDiff != null && diff == this.fCurrentDiff.fParent) {
                            gC.setLineWidth(2);
                            ++rectangle.x;
                            ++rectangle.y;
                            --rectangle.width;
                            --rectangle.height;
                        } else {
                            gC.setLineWidth(0);
                        }
                        gC.drawRectangle(rectangle);
                    }
                }
                n3 += n5;
                ++n4;
            }
        }
    }

    private void refreshBirdsEyeView() {
        if (this.fBirdsEyeCanvas != null) {
            this.fBirdsEyeCanvas.redraw();
        }
    }

    protected boolean handleSetFocus() {
        StyledText styledText;
        if (this.fFocusPart == null) {
            if (this.fLeft != null && this.fLeft.getEnabled()) {
                this.fFocusPart = this.fLeft;
            } else if (this.fRight != null && this.fRight.getEnabled()) {
                this.fFocusPart = this.fRight;
            } else if (this.fAncestor != null && this.fAncestor.getEnabled()) {
                this.fFocusPart = this.fAncestor;
            }
        }
        if (this.fFocusPart != null && (styledText = this.fFocusPart.getTextWidget()) != null) {
            return styledText.setFocus();
        }
        return false;
    }

    protected final Control createCenterControl(Composite composite) {
        if (this.fSynchronizedScrolling) {
            BufferedCanvas bufferedCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gC) {
                    TextMergeViewer.this.paintCenter((Canvas)this, gC);
                }
            };
            if (this.fUseResolveUI) {
                new HoverResizer((Canvas)bufferedCanvas, 1);
                this.fCenterButton = new Button((Composite)bufferedCanvas, this.fIsCarbon ? 0x800000 : 8);
                if (this.fNormalCursor == null) {
                    this.fNormalCursor = new Cursor((Device)bufferedCanvas.getDisplay(), 0);
                }
                this.fCenterButton.setCursor(this.fNormalCursor);
                this.fCenterButton.setText(COPY_RIGHT_TO_LEFT_INDICATOR);
                this.fCenterButton.pack();
                this.fCenterButton.setVisible(false);
                this.fCenterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        TextMergeViewer.this.fCenterButton.setVisible(false);
                        if (TextMergeViewer.this.fButtonDiff != null) {
                            TextMergeViewer.this.setCurrentDiff(TextMergeViewer.this.fButtonDiff, false);
                            TextMergeViewer.this.copy(TextMergeViewer.this.fCurrentDiff, TextMergeViewer.this.fCenterButton.getText().equals(TextMergeViewer.COPY_LEFT_TO_RIGHT_INDICATOR), ((TextMergeViewer)TextMergeViewer.this).fCurrentDiff.fDirection != 1);
                        }
                    }
                });
            } else {
                new ContentMergeViewer.Resizer((Control)bufferedCanvas, 1);
            }
            return bufferedCanvas;
        }
        return super.createCenterControl(composite);
    }

    private boolean handleMouseMoveOverCenter(Canvas canvas, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Diff diff = this.getDiffUnderMouse(canvas, n, n2, rectangle);
        if (diff != null && !diff.isUnresolvedIncomingOrConflicting()) {
            diff = null;
        }
        if (diff != this.fButtonDiff) {
            if (diff != null) {
                if (this.fLeft.isEditable()) {
                    this.fButtonDiff = diff;
                    this.fCenterButton.setText(COPY_RIGHT_TO_LEFT_INDICATOR);
                    String string = this.fCopyDiffRightToLeftItem.getAction().getToolTipText();
                    this.fCenterButton.setToolTipText(string);
                    this.fCenterButton.setBounds(rectangle);
                    this.fCenterButton.setVisible(true);
                } else if (this.fRight.isEditable()) {
                    this.fButtonDiff = diff;
                    this.fCenterButton.setText(COPY_LEFT_TO_RIGHT_INDICATOR);
                    String string = this.fCopyDiffLeftToRightItem.getAction().getToolTipText();
                    this.fCenterButton.setToolTipText(string);
                    this.fCenterButton.setBounds(rectangle);
                    this.fCenterButton.setVisible(true);
                } else {
                    this.fButtonDiff = null;
                }
            } else {
                this.fCenterButton.setVisible(false);
                this.fButtonDiff = null;
            }
        }
        return this.fButtonDiff != null;
    }

    protected final int getCenterWidth() {
        if (this.fSynchronizedScrolling) {
            return 34;
        }
        return super.getCenterWidth();
    }

    private int getDirection() {
        switch (this.fTextDirection) {
            case 0x2000000: 
            case 0x4000000: {
                if (this.fInheritedDirection == this.fTextDirection) {
                    return 0;
                }
                return this.fTextDirection;
            }
        }
        return this.fInheritedDirection;
    }

    private MergeSourceViewer createPart(Composite composite) {
        final MergeSourceViewer mergeSourceViewer = new MergeSourceViewer(composite, this.getDirection(), this.getResourceBundle(), this.getCompareConfiguration().getContainer());
        StyledText styledText = mergeSourceViewer.getTextWidget();
        if (!this.fConfirmSave) {
            mergeSourceViewer.hideSaveAction();
        }
        styledText.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TextMergeViewer.this.paint(paintEvent, mergeSourceViewer);
            }
        });
        styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TextMergeViewer.this.handleSelectionChanged(mergeSourceViewer);
            }
        });
        styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                TextMergeViewer.this.handleSelectionChanged(mergeSourceViewer);
            }
        });
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TextMergeViewer.this.fFocusPart = mergeSourceViewer;
                TextMergeViewer.this.connectGlobalActions(TextMergeViewer.this.fFocusPart);
            }

            public void focusLost(FocusEvent focusEvent) {
                TextMergeViewer.this.connectGlobalActions(null);
            }
        });
        mergeSourceViewer.addViewportListener(new IViewportListener(){

            public void viewportChanged(int n) {
                TextMergeViewer.this.syncViewport(mergeSourceViewer);
            }
        });
        Font font = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (font != null) {
            styledText.setFont(font);
        }
        if (this.fBackground != null) {
            styledText.setBackground(this.getColor(composite.getDisplay(), this.fBackground));
        }
        this.contributeFindAction(mergeSourceViewer);
        this.configureTextViewer((TextViewer)mergeSourceViewer);
        return mergeSourceViewer;
    }

    private void contributeFindAction(MergeSourceViewer mergeSourceViewer) {
        IWorkbenchPart iWorkbenchPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        FindReplaceAction findReplaceAction = iWorkbenchPart != null ? new FindReplaceAction(this.getResourceBundle(), "Editor.FindReplace.", iWorkbenchPart) : new FindReplaceAction(this.getResourceBundle(), "Editor.FindReplace.", mergeSourceViewer.getControl().getShell(), this.getFindReplaceTarget());
        findReplaceAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        mergeSourceViewer.addAction("find", (IAction)findReplaceAction);
    }

    private void connectGlobalActions(final MergeSourceViewer mergeSourceViewer) {
        if (this.fHandlerService != null) {
            if (mergeSourceViewer != null) {
                mergeSourceViewer.updateActions();
            }
            this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                public void run() {
                    int n = 0;
                    while (n < GLOBAL_ACTIONS.length) {
                        IAction iAction = null;
                        if (mergeSourceViewer != null && (iAction = mergeSourceViewer.getAction(TEXT_ACTIONS[n])) == null && TEXT_ACTIONS[n].equals("save")) {
                            iAction = mergeSourceViewer == TextMergeViewer.this.fLeft ? TextMergeViewer.this.fLeftSaveAction : TextMergeViewer.this.fRightSaveAction;
                        }
                        TextMergeViewer.this.fHandlerService.setGlobalActionHandler(GLOBAL_ACTIONS[n], iAction);
                        ++n;
                    }
                }
            });
        }
    }

    private IDocument getElementDocument(char c, Object object) {
        if (object instanceof IDocument) {
            return (IDocument)object;
        }
        ITypedElement iTypedElement = Utilities.getLeg((char)c, (Object)object);
        IDocument iDocument = null;
        switch (c) {
            case 'A': {
                iDocument = this.getDocument(iTypedElement, this.fAncestorContributor);
                break;
            }
            case 'L': {
                iDocument = this.getDocument(iTypedElement, this.fLeftContributor);
                break;
            }
            case 'R': {
                iDocument = this.getDocument(iTypedElement, this.fRightContributor);
            }
        }
        if (iDocument != null) {
            return iDocument;
        }
        return Utilities.getDocument((char)c, (Object)object, (boolean)this.isUsingDefaultContentProvider(), (boolean)this.canHaveSharedDocument());
    }

    private boolean isUsingDefaultContentProvider() {
        return this.getContentProvider() instanceof MergeViewerContentProvider;
    }

    private boolean canHaveSharedDocument() {
        return this.getDocumentPartitioning() != null || this.getDocumentPartitioner() == null;
    }

    private IDocument getDocument(ITypedElement iTypedElement, ContributorInfo contributorInfo) {
        if (contributorInfo != null && contributorInfo.getElement() == iTypedElement) {
            return contributorInfo.getDocument();
        }
        return null;
    }

    IDocument getDocument(char c, Object object) {
        IDocument iDocument = this.getElementDocument(c, object);
        if (iDocument != null) {
            return iDocument;
        }
        if (object instanceof IDiffElement) {
            IDiffContainer iDiffContainer = ((IDiffElement)object).getParent();
            return this.getElementDocument(c, iDiffContainer);
        }
        return null;
    }

    boolean sameDoc(char c, Object object, Object object2) {
        IDocument iDocument;
        IDocument iDocument2 = this.getDocument(c, object);
        return iDocument2 == (iDocument = this.getDocument(c, object2));
    }

    protected boolean doSave(Object object, Object object2) {
        if (object2 != null && object != null && this.sameDoc('A', object, object2) && this.sameDoc('L', object, object2) && this.sameDoc('R', object, object2)) {
            return false;
        }
        this.removeFromDocumentManager('A', object2);
        this.removeFromDocumentManager('L', object2);
        this.removeFromDocumentManager('R', object2);
        return super.doSave(object, object2);
    }

    private void removeFromDocumentManager(char c, Object object) {
        IDocument iDocument = this.getDocument(c, object);
        if (iDocument != null) {
            DocumentManager.remove((IDocument)iDocument);
        }
    }

    private ITypedElement getParent(char c) {
        Object object = this.getInput();
        if (object instanceof IDiffElement) {
            IDiffContainer iDiffContainer = ((IDiffElement)object).getParent();
            return Utilities.getLeg((char)c, (Object)iDiffContainer);
        }
        return null;
    }

    protected void updateContent(Object object, Object object2, Object object3) {
        Object object4;
        ICompareInput iCompareInput;
        IDiffContainer iDiffContainer;
        boolean bl = object == null && object2 == null && object3 == null;
        Object object5 = this.getInput();
        Position position = null;
        Position position2 = null;
        if (!bl && (object2 == null || object3 == null) && object5 instanceof IDiffElement && (iDiffContainer = ((IDiffElement)object5).getParent()) instanceof ICompareInput && ((iCompareInput = (ICompareInput)iDiffContainer).getAncestor() instanceof IDocumentRange || iCompareInput.getLeft() instanceof IDocumentRange || iCompareInput.getRight() instanceof IDocumentRange)) {
            if (object2 instanceof IDocumentRange) {
                position = ((IDocumentRange)object2).getRange();
            }
            if (object3 instanceof IDocumentRange) {
                position2 = ((IDocumentRange)object3).getRange();
            }
            object = iCompareInput.getAncestor();
            object2 = iCompareInput.getLeft();
            object3 = iCompareInput.getRight();
        }
        int n = 0;
        if (object2 != null) {
            ++n;
        }
        if (object3 != null) {
            ++n;
        }
        this.fHighlightRanges = n > 1;
        this.resetDiffs();
        this.fHasErrors = false;
        iCompareInput = this.getCompareConfiguration();
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        if (iMergeViewerContentProvider instanceof MergeViewerContentProvider) {
            object4 = (MergeViewerContentProvider)iMergeViewerContentProvider;
            object4.setAncestorError(null);
            object4.setLeftError(null);
            object4.setRightError(null);
        }
        object4 = this.fLeftContributor;
        ContributorInfo contributorInfo = this.fRightContributor;
        ContributorInfo contributorInfo2 = this.fAncestorContributor;
        this.fLeftContributor = this.createLegInfoFor(object2, 'L');
        this.fRightContributor = this.createLegInfoFor(object3, 'R');
        this.fAncestorContributor = this.createLegInfoFor(object, 'A');
        this.fLeftContributor.transferContributorStateFrom((ContributorInfo)object4);
        this.fRightContributor.transferContributorStateFrom(contributorInfo);
        this.fAncestorContributor.transferContributorStateFrom(contributorInfo2);
        this.disconnect((ContributorInfo)object4);
        this.disconnect(contributorInfo);
        this.disconnect(contributorInfo2);
        this.fLeftContributor.setEncodingIfAbsent(this.fRightContributor);
        this.fRightContributor.setEncodingIfAbsent(this.fLeftContributor);
        this.fAncestorContributor.setEncodingIfAbsent(this.fLeftContributor);
        this.fLeftContributor.setDocument(this.fLeft, iCompareInput.isLeftEditable() && iMergeViewerContentProvider.isLeftEditable(object5));
        this.fLeftLineCount = this.fLeft.getLineCount();
        this.fRightContributor.setDocument(this.fRight, iCompareInput.isRightEditable() && iMergeViewerContentProvider.isRightEditable(object5));
        this.fRightLineCount = this.fRight.getLineCount();
        this.fAncestorContributor.setDocument(this.fAncestor, false);
        if (this.isPatchHunk()) {
            this.setSyncScrolling(false);
        } else {
            this.setSyncScrolling(this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling"));
        }
        this.update(false);
        if (!(this.fHasErrors || bl || this.fComposite.isDisposed())) {
            if (this.isRefreshing()) {
                this.fLeftContributor.updateSelection(this.fLeft, !this.fSynchronizedScrolling);
                this.fRightContributor.updateSelection(this.fRight, !this.fSynchronizedScrolling);
                this.fAncestorContributor.updateSelection(this.fAncestor, !this.fSynchronizedScrolling);
                if (this.fSynchronizedScrolling && this.fSynchronziedScrollPosition != -1) {
                    this.synchronizedScrollVertical(this.fSynchronziedScrollPosition);
                }
            } else if (this.isPatchHunk()) {
                if (object3 != null && Utilities.getAdapter((Object)object3, IHunk.class) != null) {
                    this.fLeft.setTopIndex(this.getHunkStart());
                } else {
                    this.fRight.setTopIndex(this.getHunkStart());
                }
            } else {
                Diff diff = null;
                if (position != null) {
                    diff = this.findDiff('L', position);
                } else if (position2 != null) {
                    diff = this.findDiff('R', position2);
                }
                if (diff != null) {
                    this.setCurrentDiff(diff, true);
                } else {
                    this.selectFirstDiff(true);
                }
            }
        }
    }

    private boolean isRefreshing() {
        return this.isRefreshing;
    }

    private ContributorInfo createLegInfoFor(Object object, char c) {
        return new ContributorInfo(this, object, c);
    }

    private Diff findDiff(char c, Position position) {
        MergeSourceViewer mergeSourceViewer;
        int n = position.getOffset();
        int n2 = n + position.getLength();
        if (c == 'L') {
            mergeSourceViewer = this.fLeft;
        } else if (c == 'R') {
            mergeSourceViewer = this.fRight;
        } else {
            return null;
        }
        if (this.fChangeDiffs != null) {
            for (Diff diff : this.fChangeDiffs) {
                if (diff.isDeleted() || diff.fDirection == 0 || !diff.overlaps(mergeSourceViewer, n, n2)) continue;
                return diff;
            }
        }
        return null;
    }

    private void updateDiffBackground(Diff diff) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (diff == null || diff.fIsToken) {
            return;
        }
        if (this.fShowCurrentOnly && !this.isCurrentDiff(diff)) {
            return;
        }
        Color color = this.getColor(null, this.getFillColor(diff));
        if (color == null) {
            return;
        }
        if (this.isThreeWay()) {
            this.fAncestor.setLineBackground(diff.fAncestorPos, color);
        }
        this.fLeft.setLineBackground(diff.fLeftPos, color);
        this.fRight.setLineBackground(diff.fRightPos, color);
    }

    private void updateAllDiffBackgrounds(Display display) {
        if (this.fChangeDiffs != null) {
            boolean bl = this.isThreeWay();
            for (Diff diff : this.fChangeDiffs) {
                Color color = this.getColor(display, this.getFillColor(diff));
                if (bl) {
                    this.fAncestor.setLineBackground(diff.fAncestorPos, color);
                }
                this.fLeft.setLineBackground(diff.fLeftPos, color);
                this.fRight.setLineBackground(diff.fRightPos, color);
            }
        }
    }

    boolean isCurrentDiff(Diff diff) {
        if (diff == null) {
            return false;
        }
        if (diff == this.fCurrentDiff) {
            return true;
        }
        return this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
    }

    private void documentChanged(DocumentEvent documentEvent, boolean bl) {
        IDocument iDocument = documentEvent.getDocument();
        if (iDocument == this.fLeft.getDocument()) {
            this.setLeftDirty(bl);
        } else if (iDocument == this.fRight.getDocument()) {
            this.setRightDirty(bl);
        }
        this.updateLines(iDocument);
    }

    protected int findInsertionPosition(char c, ICompareInput iCompareInput) {
        ITypedElement iTypedElement = null;
        char c2 = '\u0000';
        switch (c) {
            case 'A': {
                iTypedElement = iCompareInput.getLeft();
                c2 = 'L';
                if (iTypedElement != null) break;
                iTypedElement = iCompareInput.getRight();
                c2 = 'R';
                break;
            }
            case 'L': {
                iTypedElement = iCompareInput.getRight();
                c2 = 'R';
                if (iTypedElement != null) break;
                iTypedElement = iCompareInput.getAncestor();
                c2 = 'A';
                break;
            }
            case 'R': {
                iTypedElement = iCompareInput.getLeft();
                c2 = 'L';
                if (iTypedElement != null) break;
                iTypedElement = iCompareInput.getAncestor();
                c2 = 'A';
            }
        }
        if (iTypedElement instanceof IDocumentRange) {
            IDocumentRange iDocumentRange = (IDocumentRange)iTypedElement;
            Position position = iDocumentRange.getRange();
            Diff diff = this.findDiff(c2, position.offset);
            if (diff != null) {
                switch (c) {
                    case 'A': {
                        if (diff.fAncestorPos == null) break;
                        return diff.fAncestorPos.offset;
                    }
                    case 'L': {
                        if (diff.fLeftPos == null) break;
                        return diff.fLeftPos.offset;
                    }
                    case 'R': {
                        if (diff.fRightPos == null) break;
                        return diff.fRightPos.offset;
                    }
                }
            }
        }
        return 0;
    }

    private void setError(char c, String string) {
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        if (iMergeViewerContentProvider instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mergeViewerContentProvider = (MergeViewerContentProvider)iMergeViewerContentProvider;
            switch (c) {
                case 'A': {
                    mergeViewerContentProvider.setAncestorError(string);
                    break;
                }
                case 'L': {
                    mergeViewerContentProvider.setLeftError(string);
                    break;
                }
                case 'R': {
                    mergeViewerContentProvider.setRightError(string);
                }
            }
        }
        this.fHasErrors = true;
    }

    private void updateDirtyState(IEditorInput iEditorInput, IDocumentProvider iDocumentProvider, char c) {
        boolean bl = iDocumentProvider.canSaveDocument((Object)iEditorInput);
        if (c == 'L') {
            this.setLeftDirty(bl);
        } else if (c == 'R') {
            this.setRightDirty(bl);
        }
    }

    private Position getNewRange(char c, Object object) {
        switch (c) {
            case 'A': {
                return (Position)this.fNewAncestorRanges.get(object);
            }
            case 'L': {
                return (Position)this.fNewLeftRanges.get(object);
            }
            case 'R': {
                return (Position)this.fNewRightRanges.get(object);
            }
        }
        return null;
    }

    private void addNewRange(char c, Object object, Position position) {
        switch (c) {
            case 'A': {
                this.fNewAncestorRanges.put(object, position);
                break;
            }
            case 'L': {
                this.fNewLeftRanges.put(object, position);
                break;
            }
            case 'R': {
                this.fNewRightRanges.put(object, position);
            }
        }
    }

    protected byte[] getContents(boolean bl) {
        String string;
        IDocument iDocument;
        MergeSourceViewer mergeSourceViewer;
        MergeSourceViewer mergeSourceViewer2 = mergeSourceViewer = bl ? this.fLeft : this.fRight;
        if (mergeSourceViewer != null && (iDocument = mergeSourceViewer.getDocument()) != null && (string = iDocument.get()) != null) {
            byte[] byArray;
            try {
                byArray = string.getBytes(bl ? this.fLeftContributor.getEncoding() : this.fRightContributor.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            return byArray;
        }
        return null;
    }

    private IRegion normalizeDocumentRegion(IDocument iDocument, IRegion iRegion) {
        if (iRegion == null || iDocument == null) {
            return iRegion;
        }
        int n = iDocument.getLength();
        int n2 = iRegion.getOffset();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n) {
            n2 = n;
        }
        int n3 = iRegion.getLength();
        if (n3 < 0) {
            n3 = 0;
        } else if (n2 + n3 > n) {
            n3 = n - n2;
        }
        return new Region(n2, n3);
    }

    protected final void handleResizeAncestor(int n, int n2, int n3, int n4) {
        if (n3 > 0) {
            Rectangle rectangle = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            int n5 = rectangle.height;
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(true);
            }
            if (this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getTextWidget().setVisible(true);
            }
            if (this.fAncestorCanvas != null) {
                this.fAncestorCanvas.setBounds(n, n2, this.fMarginWidth, n4 - n5);
                n += this.fMarginWidth;
                n3 -= this.fMarginWidth;
            }
            this.fAncestor.setBounds(n, n2, n3, n4);
        } else {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(false);
            }
            if (this.fAncestor.isControlOkToUse()) {
                StyledText styledText = this.fAncestor.getTextWidget();
                styledText.setVisible(false);
                this.fAncestor.setBounds(0, 0, 0, 0);
                if (this.fFocusPart == this.fAncestor) {
                    this.fFocusPart = this.fLeft;
                    this.fFocusPart.getTextWidget().setFocus();
                }
            }
        }
    }

    protected final void handleResizeLeftRight(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.fBirdsEyeCanvas != null) {
            n5 -= 12;
        }
        Rectangle rectangle = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        int n7 = rectangle.height + rectangle.x;
        Composite composite = (Composite)this.getControl();
        int n8 = n3;
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.setBounds(n, n2, this.fMarginWidth, n6 - n7);
            n += this.fMarginWidth;
            n8 -= this.fMarginWidth;
        }
        this.fLeft.setBounds(n, n2, n8, n6);
        n += n8;
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenterControl(composite);
        }
        this.fCenter.setBounds(n, n2, n4, n6 - n7);
        n += n4;
        if (!this.fSynchronizedScrolling && this.fRightCanvas != null) {
            this.fRightCanvas.setBounds(n, n2, this.fMarginWidth, n6 - n7);
            this.fRightCanvas.redraw();
            n += this.fMarginWidth;
        }
        int n9 = 0;
        if (this.fSynchronizedScrolling && this.fScrollCanvas != null) {
            rectangle = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            n9 = rectangle.width + 2 * rectangle.x + 1;
        }
        int n10 = n5 - n9;
        if (this.fRightCanvas != null) {
            n10 -= this.fMarginWidth;
        }
        this.fRight.setBounds(n, n2, n10, n6);
        n += n10;
        if (this.fSynchronizedScrolling) {
            if (this.fRightCanvas != null) {
                this.fRightCanvas.setBounds(n, n2, this.fMarginWidth, n6 - n7);
                n += this.fMarginWidth;
            }
            if (this.fScrollCanvas != null) {
                this.fScrollCanvas.setBounds(n, n2, n9, n6 - n7);
            }
        }
        if (this.fBirdsEyeCanvas != null) {
            int n11 = n9;
            int n12 = n7;
            if (this.fIsCarbon) {
                n11 += 2;
                n12 = 18;
            }
            if (this.fSummaryHeader != null) {
                this.fSummaryHeader.setBounds(n + n9, n2, 12, n11);
            }
            this.fBirdsEyeCanvas.setBounds(n + n9, n2 += n11, 12, n6 - (2 * n11 + n12));
        }
        this.updateVScrollBar();
        this.refreshBirdsEyeView();
    }

    private void handleSelectionChanged(MergeSourceViewer mergeSourceViewer) {
        Point point = mergeSourceViewer.getSelectedRange();
        Diff diff = this.findDiff(mergeSourceViewer, point.x, point.x + point.y);
        this.updateStatus(diff);
        this.setCurrentDiff(diff, false);
    }

    private static IRegion toRegion(Position position) {
        if (position != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    private static int maxWork(IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2, IRangeComparator iRangeComparator3) {
        int n = iRangeComparator2.getRangeCount();
        int n2 = iRangeComparator3.getRangeCount();
        if (iRangeComparator != null) {
            int n3 = iRangeComparator.getRangeCount();
            return 2 * Math.max(n3, n) + 2 * Math.max(n3, n2);
        }
        return 2 * Math.max(n, n2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void doDiff() {
        block30: {
            block29: {
                var1_1 = new ArrayList<Object>();
                this.fChangeDiffs = new ArrayList<E>();
                this.fCurrentDiff = null;
                var2_2 = null;
                var3_3 = this.fLeft.getDocument();
                var4_4 = this.fRight.getDocument();
                if (var3_3 == null || var4_4 == null) {
                    return;
                }
                var5_5 = null;
                var6_6 = this.fLeft.getRegion();
                var7_7 = this.fRight.getRegion();
                var8_8 = this.isThreeWay();
                if (var8_8 && !this.isIgnoreAncestor()) {
                    var2_2 = this.fAncestor.getDocument();
                    var5_5 = this.fAncestor.getRegion();
                }
                this.resetPositions(var3_3);
                this.resetPositions(var4_4);
                this.resetPositions(var2_2);
                this.fAncestor.resetLineBackground();
                this.fLeft.resetLineBackground();
                this.fRight.resetLineBackground();
                var9_9 = Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)"IGNORE_WHITESPACE", (boolean)false);
                var10_10 = new DocLineComparator(var4_4, TextMergeViewer.toRegion(var7_7), var9_9);
                var11_11 = new DocLineComparator(var3_3, TextMergeViewer.toRegion(var6_6), var9_9);
                var12_12 = null;
                var13_13 = true;
                if (var2_2 != null) {
                    var12_12 = new DocLineComparator(var2_2, TextMergeViewer.toRegion(var5_5), var9_9);
                    if (this.isPatchHunk()) {
                        var14_14 = ((ICompareInput)this.getInput()).getRight();
                        v0 = var13_13 = var14_14 != null && Utilities.getAdapter((Object)var14_14, IHunk.class) != null;
                        if (var13_13) {
                            var11_11 = new DocLineComparator(var2_2, TextMergeViewer.toRegion(var5_5), var9_9);
                        } else {
                            var10_10 = new DocLineComparator(var2_2, TextMergeViewer.toRegion(var5_5), var9_9);
                        }
                    }
                }
                if (!this.fSubDoc && var7_7 != null && var6_6 != null) {
                    var14_15 = 0;
                    var15_16 = 0;
                    if (var5_5 != null) {
                        var14_15 = var5_5.getOffset();
                        var15_16 = Math.max(0, var14_15 - 1);
                    }
                    var16_18 = Math.max(0, var6_6.getOffset() - 1);
                    var17_20 = Math.max(0, var7_7.getOffset() - 1);
                    if (var15_16 > 0 || var16_18 > 0 || var17_20 > 0) {
                        var18_22 /* !! */  = new Diff(null, 0, var2_2, var5_5, 0, var14_15, var3_3, var6_6, 0, var6_6.getOffset(), var4_4, var7_7, 0, var7_7.getOffset());
                        var1_1.add(var18_22 /* !! */ );
                    }
                }
                var14_14 = this.getResourceBundle();
                var15_17 = new Object[1];
                var16_19 = var12_12;
                var17_21 = var11_11;
                var18_22 /* !! */  = var10_10;
                var19_23 = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InterruptedException, InvocationTargetException {
                        String string = Utilities.getString((ResourceBundle)var14_14, (String)"compareProgressTask.title");
                        iProgressMonitor.beginTask(string, TextMergeViewer.maxWork((IRangeComparator)var16_19, (IRangeComparator)var17_21, (IRangeComparator)var18_22));
                        try {
                            var15_17[0] = RangeDifferencer.findRanges((IProgressMonitor)iProgressMonitor, (IRangeComparator)var16_19, (IRangeComparator)var17_21, (IRangeComparator)var18_22);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            System.gc();
                            throw new InvocationTargetException(outOfMemoryError);
                        }
                        if (iProgressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        iProgressMonitor.done();
                    }
                };
                var20_24 = null;
                try {
                    this.getCompareConfiguration().getContainer().run(true, true, var19_23);
                    var20_24 = (RangeDifference[])var15_17[0];
                }
                catch (InvocationTargetException v1) {
                    var21_25 = Utilities.getString((ResourceBundle)var14_14, (String)"tooComplexError.title");
                    var22_28 = Utilities.getString((ResourceBundle)var14_14, (String)"tooComplexError.format");
                    var23_30 = MessageFormat.format((String)var22_28, (Object[])new Object[]{Integer.toString(PlatformUI.getWorkbench().getProgressService().getLongOperationTime() / 1000)});
                    MessageDialog.openError((Shell)this.fComposite.getShell(), (String)var21_25, (String)var23_30);
                    var20_24 = null;
                }
                catch (InterruptedException v2) {}
                if (var20_24 != null) break block29;
                var21_25 = new Diff(null, 0, var2_2, var5_5, 0, var2_2 != null ? var2_2.getLength() : 0, var3_3, var6_6, 0, var3_3.getLength(), var4_4, var7_7, 0, var4_4.getLength());
                var1_1.add(var21_25);
                break block30;
            }
            var21_26 = 0;
            while (var21_26 < var20_24.length) {
                var22_28 = null;
                var23_30 = null;
                var24_31 = null;
                var25_32 = var20_24[var21_26];
                var26_33 = var25_32.kind();
                var27_34 = 0;
                var28_35 = 0;
                if (var12_12 != null) {
                    var27_34 = var12_12.getTokenStart(var25_32.ancestorStart());
                    var28_35 = TextMergeViewer.getTokenEnd2((ITokenComparator)var12_12, var25_32.ancestorStart(), var25_32.ancestorLength());
                }
                var29_36 = var11_11.getTokenStart(var25_32.leftStart());
                var30_37 = TextMergeViewer.getTokenEnd2((ITokenComparator)var11_11, var25_32.leftStart(), var25_32.leftLength());
                var31_38 = var10_10.getTokenStart(var25_32.rightStart());
                var32_39 = TextMergeViewer.getTokenEnd2((ITokenComparator)var10_10, var25_32.rightStart(), var25_32.rightLength());
                if (this.isPatchHunk()) {
                    if (var13_13) {
                        var29_36 = var30_37 = this.getHunkStart();
                    } else {
                        var31_38 = var32_39 = this.getHunkStart();
                    }
                }
                var33_40 = new Diff(null, var26_33, var2_2, var5_5, var27_34, var28_35, var3_3, var6_6, var29_36, var30_37, var4_4, var7_7, var31_38, var32_39);
                var1_1.add(var33_40);
                if (!var9_9 || this.isPatchHunk()) ** GOTO lbl-1000
                if (var12_12 != null) {
                    var22_28 = this.extract2(var2_2, (ITokenComparator)var12_12, var25_32.ancestorStart(), var25_32.ancestorLength());
                }
                var23_30 = this.extract2(var3_3, (ITokenComparator)var11_11, var25_32.leftStart(), var25_32.leftLength());
                var24_31 = this.extract2(var4_4, (ITokenComparator)var10_10, var25_32.rightStart(), var25_32.rightLength());
                if ((var22_28 == null || var22_28.trim().length() == 0) && var23_30.trim().length() == 0 && var24_31.trim().length() == 0) {
                    var33_40.fIsWhitespace = true;
                } else if (this.useChange(var26_33)) {
                    this.fChangeDiffs.add(var33_40);
                    this.updateDiffBackground(var33_40);
                    if (!this.isPatchHunk()) {
                        if (var23_30 == null) {
                            var23_30 = this.extract2(var3_3, (ITokenComparator)var11_11, var25_32.leftStart(), var25_32.leftLength());
                        }
                        if (var24_31 == null) {
                            var24_31 = this.extract2(var4_4, (ITokenComparator)var10_10, var25_32.rightStart(), var25_32.rightLength());
                        }
                        if (var23_30.length() > 0 && var24_31.length() > 0) {
                            if (var22_28 == null && var12_12 != null) {
                                var22_28 = this.extract2(var2_2, (ITokenComparator)var12_12, var25_32.ancestorStart(), var25_32.ancestorLength());
                            }
                            this.simpleTokenDiff(var33_40, var2_2, var22_28, var4_4, var24_31, var3_3, (String)var23_30);
                        }
                    }
                }
                ++var21_26;
            }
        }
        if (!this.fSubDoc && var7_7 != null && var6_6 != null) {
            var21_27 = 0;
            var22_29 = 0;
            if (var5_5 != null && var2_2 != null) {
                var21_27 = var5_5.getOffset() + var5_5.getLength();
                var22_29 = var2_2.getLength();
            }
            var23_30 = new Diff(null, 0, var2_2, var5_5, var21_27, var22_29, var3_3, var6_6, var6_6.getOffset() + var6_6.getLength(), var3_3.getLength(), var4_4, var7_7, var7_7.getOffset() + var7_7.getLength(), var4_4.getLength());
            var1_1.add(var23_30);
        }
        this.fAllDiffs = var1_1;
        this.invalidateTextPresentation();
    }

    private void resetPositions(IDocument iDocument) {
        if (iDocument == null) {
            return;
        }
        try {
            iDocument.removePositionCategory(DIFF_RANGE_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        iDocument.addPositionCategory(DIFF_RANGE_CATEGORY);
    }

    private Diff findDiff(char c, int n) {
        String string;
        IDocument iDocument = null;
        IDocument iDocument2 = this.fLeft.getDocument();
        IDocument iDocument3 = this.fRight.getDocument();
        if (iDocument2 == null || iDocument3 == null) {
            return null;
        }
        Position position = null;
        Position position2 = null;
        Position position3 = null;
        boolean bl = this.isThreeWay();
        if (bl && !this.isIgnoreAncestor()) {
            iDocument = this.fAncestor.getDocument();
        }
        boolean bl2 = Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)"IGNORE_WHITESPACE", (boolean)false);
        DocLineComparator docLineComparator = new DocLineComparator(iDocument3, TextMergeViewer.toRegion(position3), bl2);
        DocLineComparator docLineComparator2 = new DocLineComparator(iDocument2, TextMergeViewer.toRegion(position2), bl2);
        DocLineComparator docLineComparator3 = null;
        if (iDocument != null) {
            docLineComparator3 = new DocLineComparator(iDocument, TextMergeViewer.toRegion(position), bl2);
        }
        final ResourceBundle resourceBundle = this.getResourceBundle();
        final Object[] objectArray = new Object[1];
        final DocLineComparator docLineComparator4 = docLineComparator3;
        final DocLineComparator docLineComparator5 = docLineComparator2;
        final DocLineComparator docLineComparator6 = docLineComparator;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException, InvocationTargetException {
                String string = Utilities.getString((ResourceBundle)resourceBundle, (String)"compareProgressTask.title");
                iProgressMonitor.beginTask(string, TextMergeViewer.maxWork((IRangeComparator)docLineComparator4, (IRangeComparator)docLineComparator5, (IRangeComparator)docLineComparator6));
                try {
                    objectArray[0] = RangeDifferencer.findRanges((IProgressMonitor)iProgressMonitor, (IRangeComparator)docLineComparator4, (IRangeComparator)docLineComparator5, (IRangeComparator)docLineComparator6);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    System.gc();
                    throw new InvocationTargetException(outOfMemoryError);
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                iProgressMonitor.done();
            }
        };
        IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
        RangeDifference[] rangeDifferenceArray = null;
        try {
            iProgressService.run(true, true, iRunnableWithProgress);
            rangeDifferenceArray = (RangeDifference[])objectArray[0];
        }
        catch (InvocationTargetException invocationTargetException) {
            String string2 = Utilities.getString((ResourceBundle)resourceBundle, (String)"tooComplexError.title");
            string = Utilities.getString((ResourceBundle)resourceBundle, (String)"tooComplexError.format");
            String string3 = MessageFormat.format((String)string, (Object[])new Object[]{Integer.toString(iProgressService.getLongOperationTime() / 1000)});
            MessageDialog.openError((Shell)this.fComposite.getShell(), (String)string2, (String)string3);
            rangeDifferenceArray = null;
        }
        catch (InterruptedException interruptedException) {}
        if (rangeDifferenceArray != null) {
            int n2 = 0;
            while (n2 < rangeDifferenceArray.length) {
                int n3;
                int n4;
                int n5;
                int n6;
                Diff diff;
                string = rangeDifferenceArray[n2];
                int n7 = string.kind();
                int n8 = 0;
                int n9 = 0;
                if (docLineComparator3 != null) {
                    n8 = docLineComparator3.getTokenStart(string.ancestorStart());
                    n9 = TextMergeViewer.getTokenEnd2((ITokenComparator)docLineComparator3, string.ancestorStart(), string.ancestorLength());
                }
                if ((diff = new Diff(null, n7, iDocument, position, n8, n9, iDocument2, position2, n6 = docLineComparator2.getTokenStart(string.leftStart()), n5 = TextMergeViewer.getTokenEnd2((ITokenComparator)docLineComparator2, string.leftStart(), string.leftLength()), iDocument3, position3, n4 = docLineComparator.getTokenStart(string.rightStart()), n3 = TextMergeViewer.getTokenEnd2((ITokenComparator)docLineComparator, string.rightStart(), string.rightLength()))).isInRange(c, n)) {
                    return diff;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean useChange(int n) {
        if (n == 0) {
            return false;
        }
        if (n == 4) {
            return this.fShowPseudoConflicts;
        }
        return true;
    }

    private int getTokenEnd(ITokenComparator iTokenComparator, int n, int n2) {
        if (n2 <= 0) {
            return iTokenComparator.getTokenStart(n);
        }
        int n3 = n + n2 - 1;
        return iTokenComparator.getTokenStart(n3) + iTokenComparator.getTokenLength(n3);
    }

    private static int getTokenEnd2(ITokenComparator iTokenComparator, int n, int n2) {
        return iTokenComparator.getTokenStart(n + n2);
    }

    private String extract2(IDocument iDocument, ITokenComparator iTokenComparator, int n, int n2) {
        int n3 = iTokenComparator.getRangeCount();
        if (n2 > 0 && n3 > 0) {
            int n4 = iTokenComparator.getTokenStart(n);
            int n5 = n2 == 1 ? n4 + iTokenComparator.getTokenLength(n) : iTokenComparator.getTokenStart(n + n2);
            try {
                return iDocument.get(n4, n5 - n4);
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    private void simpleTokenDiff(Diff diff, IDocument iDocument, String string, IDocument iDocument2, String string2, IDocument iDocument3, String string3) {
        int n = 0;
        ITokenComparator iTokenComparator = null;
        if (iDocument != null) {
            n = diff.fAncestorPos.getOffset();
            iTokenComparator = this.createTokenComparator(string);
        }
        int n2 = diff.fRightPos.getOffset();
        ITokenComparator iTokenComparator2 = this.createTokenComparator(string2);
        int n3 = diff.fLeftPos.getOffset();
        ITokenComparator iTokenComparator3 = this.createTokenComparator(string3);
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findRanges((IRangeComparator)iTokenComparator, (IRangeComparator)iTokenComparator3, (IRangeComparator)iTokenComparator2);
        int n4 = 0;
        while (n4 < rangeDifferenceArray.length) {
            RangeDifference rangeDifference = rangeDifferenceArray[n4];
            int n5 = rangeDifference.kind();
            if (n5 != 0) {
                int n6 = n;
                int n7 = n;
                if (iDocument != null) {
                    n6 += iTokenComparator.getTokenStart(rangeDifference.ancestorStart());
                    n7 += this.getTokenEnd(iTokenComparator, rangeDifference.ancestorStart(), rangeDifference.ancestorLength());
                }
                int n8 = n3 + iTokenComparator3.getTokenStart(rangeDifference.leftStart());
                int n9 = n3 + this.getTokenEnd(iTokenComparator3, rangeDifference.leftStart(), rangeDifference.leftLength());
                int n10 = n2 + iTokenComparator2.getTokenStart(rangeDifference.rightStart());
                int n11 = n2 + this.getTokenEnd(iTokenComparator2, rangeDifference.rightStart(), rangeDifference.rightLength());
                Diff diff2 = new Diff(diff, n5, iDocument, null, n6, n7, iDocument3, null, n8, n9, iDocument2, null, n10, n11);
                int n12 = diff.fLeftPos.offset;
                int n13 = diff.fLeftPos.offset + diff.fLeftPos.length;
                int n14 = diff.fRightPos.offset;
                int n15 = diff.fRightPos.offset + diff.fRightPos.length;
                if (n12 != n8 || n13 != n9 || n14 != n10 || n15 != n11) {
                    diff2.fIsToken = true;
                    diff.add(diff2);
                }
            }
            ++n4;
        }
    }

    private void mergingTokenDiff(Diff diff, IDocument iDocument, String string, IDocument iDocument2, String string2, IDocument iDocument3, String string3) {
        ITokenComparator iTokenComparator = null;
        int n = 0;
        if (iDocument != null) {
            iTokenComparator = this.createTokenComparator(string);
            n = diff.fAncestorPos.getOffset();
        }
        int n2 = diff.fRightPos.getOffset();
        ITokenComparator iTokenComparator2 = this.createTokenComparator(string2);
        int n3 = diff.fLeftPos.getOffset();
        ITokenComparator iTokenComparator3 = this.createTokenComparator(string3);
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findRanges((IRangeComparator)iTokenComparator, (IRangeComparator)iTokenComparator3, (IRangeComparator)iTokenComparator2);
        int n4 = 0;
        while (n4 < rangeDifferenceArray.length) {
            RangeDifference rangeDifference = rangeDifferenceArray[n4];
            int n5 = n4;
            int n6 = -1;
            int n7 = -1;
            try {
                n6 = iDocument3.getLineOfOffset(n3 + iTokenComparator3.getTokenStart(rangeDifference.leftStart()));
                n7 = iDocument2.getLineOfOffset(n2 + iTokenComparator2.getTokenStart(rangeDifference.rightStart()));
            }
            catch (BadLocationException badLocationException) {}
            ++n4;
            while (n4 < rangeDifferenceArray.length) {
                rangeDifference = rangeDifferenceArray[n4];
                try {
                    if (n6 != iDocument3.getLineOfOffset(n3 + iTokenComparator3.getTokenStart(rangeDifference.leftStart())) || n7 != iDocument2.getLineOfOffset(n2 + iTokenComparator2.getTokenStart(rangeDifference.rightStart()))) {
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++n4;
            }
            int n8 = n4;
            RangeDifference rangeDifference2 = null;
            int n9 = n5;
            while (n9 < n8) {
                rangeDifference = rangeDifferenceArray[n9];
                if (this.useChange(rangeDifference.kind())) {
                    rangeDifference2 = rangeDifference;
                    break;
                }
                ++n9;
            }
            RangeDifference rangeDifference3 = null;
            int n10 = n8 - 1;
            while (n10 >= n5) {
                rangeDifference = rangeDifferenceArray[n10];
                if (this.useChange(rangeDifference.kind())) {
                    rangeDifference3 = rangeDifference;
                    break;
                }
                --n10;
            }
            if (rangeDifference2 != null && rangeDifference3 != null) {
                n10 = 0;
                int n11 = 0;
                if (iDocument != null) {
                    n10 = n + iTokenComparator.getTokenStart(rangeDifference2.ancestorStart());
                    n11 = n + this.getTokenEnd(iTokenComparator, rangeDifference3.ancestorStart(), rangeDifference3.ancestorLength());
                }
                int n12 = n3 + iTokenComparator3.getTokenStart(rangeDifference2.leftStart());
                int n13 = n3 + this.getTokenEnd(iTokenComparator3, rangeDifference3.leftStart(), rangeDifference3.leftLength());
                int n14 = n2 + iTokenComparator2.getTokenStart(rangeDifference2.rightStart());
                int n15 = n2 + this.getTokenEnd(iTokenComparator2, rangeDifference3.rightStart(), rangeDifference3.rightLength());
                Diff diff2 = new Diff(diff, rangeDifference2.kind(), iDocument, null, n10, n11, iDocument3, null, n12, n13, iDocument2, null, n14, n15);
                diff2.fIsToken = true;
                diff.add(diff2);
            }
            ++n4;
        }
    }

    private void updateControls() {
        IAction iAction;
        IMergeViewerContentProvider iMergeViewerContentProvider;
        boolean bl = false;
        boolean bl2 = false;
        this.updateStatus(this.fCurrentDiff);
        this.updateResolveStatus();
        if (this.fCurrentDiff != null && (iMergeViewerContentProvider = this.getMergeContentProvider()) != null && !this.isPatchHunk()) {
            bl2 = iMergeViewerContentProvider.isLeftEditable(this.getInput());
            bl = iMergeViewerContentProvider.isRightEditable(this.getInput());
        }
        if (this.fDirectionLabel != null) {
            if (this.fHighlightRanges && this.fCurrentDiff != null && this.isThreeWay() && !this.isIgnoreAncestor()) {
                this.fDirectionLabel.setImage(this.fCurrentDiff.getImage());
            } else {
                this.fDirectionLabel.setImage(null);
            }
        }
        if (this.fCopyDiffLeftToRightItem != null) {
            ((Action)this.fCopyDiffLeftToRightItem.getAction()).setEnabled(bl);
        }
        if (this.fCopyDiffRightToLeftItem != null) {
            ((Action)this.fCopyDiffRightToLeftItem.getAction()).setEnabled(bl2);
        }
        boolean bl3 = false;
        if (this.fCurrentDiff == null && this.fChangeDiffs != null && this.fChangeDiffs.size() > 0) {
            bl3 = true;
        } else if (this.fChangeDiffs != null && this.fChangeDiffs.size() > 1) {
            bl3 = true;
        } else if (this.fCurrentDiff != null && this.fCurrentDiff.fDiffs != null) {
            bl3 = true;
        } else if (this.fCurrentDiff != null && this.fCurrentDiff.fIsToken) {
            bl3 = true;
        }
        if (this.fNextDiff != null) {
            iAction = this.fNextDiff.getAction();
            iAction.setEnabled(bl3 || this.hasNextElement(true));
        }
        if (this.fPreviousDiff != null) {
            iAction = this.fPreviousDiff.getAction();
            iAction.setEnabled(bl3 || this.hasNextElement(false));
        }
        if (this.fNextChange != null) {
            iAction = this.fNextChange.getAction();
            iAction.setEnabled(bl3);
        }
        if (this.fPreviousChange != null) {
            iAction = this.fPreviousChange.getAction();
            iAction.setEnabled(bl3);
        }
    }

    private void updateResolveStatus() {
        RGB rGB = null;
        if (this.showResolveUI()) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (this.fChangeDiffs != null) {
                for (Diff diff : this.fChangeDiffs) {
                    if (!diff.isIncomingOrConflicting()) continue;
                    ++n;
                    if (diff.fResolved) continue;
                    if (diff.fDirection == 1) {
                        ++n3;
                        break;
                    }
                    ++n2;
                }
            }
            if (n > 0) {
                rGB = n3 > 0 ? this.SELECTED_CONFLICT : (n2 > 0 ? this.SELECTED_INCOMING : this.RESOLVED);
            }
        }
        if (this.fHeaderPainter.setColor(rGB)) {
            this.fSummaryHeader.redraw();
        }
    }

    private void updateStatus(Diff diff) {
        String string;
        String string2;
        if (!this.fShowMoreInfo) {
            return;
        }
        if (diff == null) {
            string2 = CompareMessages.TextMergeViewer_diffDescription_noDiff_format;
        } else {
            if (diff.fIsToken) {
                diff = diff.fParent;
            }
            string = CompareMessages.TextMergeViewer_diffDescription_diff_format;
            string2 = MessageFormat.format((String)string, (Object[])new String[]{this.getDiffType(diff), this.getDiffNumber(diff), this.getDiffRange(this.fLeft, diff.fLeftPos), this.getDiffRange(this.fRight, diff.fRightPos)});
        }
        string = CompareMessages.TextMergeViewer_statusLine_format;
        String string3 = MessageFormat.format((String)string, (Object[])new String[]{this.getCursorPosition(this.fLeft), this.getCursorPosition(this.fRight), string2});
        this.getCompareConfiguration().getContainer().setStatusMessage(string3);
    }

    private void clearStatus() {
        this.getCompareConfiguration().getContainer().setStatusMessage(null);
    }

    private String getDiffType(Diff diff) {
        String string = "";
        switch (diff.fDirection) {
            case 3: {
                string = CompareMessages.TextMergeViewer_direction_outgoing;
                break;
            }
            case 2: {
                string = CompareMessages.TextMergeViewer_direction_incoming;
                break;
            }
            case 1: {
                string = CompareMessages.TextMergeViewer_direction_conflicting;
            }
        }
        String string2 = CompareMessages.TextMergeViewer_diffType_format;
        return MessageFormat.format((String)string2, (Object[])new String[]{string, diff.changeType()});
    }

    private String getDiffNumber(Diff diff) {
        int n = 0;
        if (this.fChangeDiffs != null) {
            for (Diff diff2 : this.fChangeDiffs) {
                ++n;
                if (diff2 == diff) break;
            }
        }
        return Integer.toString(n);
    }

    private String getDiffRange(MergeSourceViewer mergeSourceViewer, Position position) {
        Point point = mergeSourceViewer.getLineRange(position, new Point(0, 0));
        int n = point.x + point.y;
        int n2 = point.x + 1;
        String string = n < n2 ? CompareMessages.TextMergeViewer_beforeLine_format : CompareMessages.TextMergeViewer_range_format;
        return MessageFormat.format((String)string, (Object[])new String[]{Integer.toString(n2), Integer.toString(n)});
    }

    private String getCursorPosition(MergeSourceViewer mergeSourceViewer) {
        if (mergeSourceViewer != null) {
            StyledText styledText = mergeSourceViewer.getTextWidget();
            IDocument iDocument = mergeSourceViewer.getDocument();
            if (iDocument != null) {
                int n = mergeSourceViewer.getVisibleRegion().getOffset();
                int n2 = n + styledText.getCaretOffset();
                try {
                    int n3 = iDocument.getLineOfOffset(n2);
                    int n4 = iDocument.getLineOffset(n3);
                    int n5 = 0;
                    int n6 = n4;
                    while (n6 < n2) {
                        if ('\t' == iDocument.getChar(n6)) {
                            ++n5;
                        }
                        ++n6;
                    }
                    n6 = styledText.getTabs();
                    int n7 = n2 - n4 + (n6 - 1) * n5;
                    String string = CompareMessages.TextMergeViewer_cursorPosition_format;
                    return MessageFormat.format((String)string, (Object[])new String[]{Integer.toString(n3 + 1), Integer.toString(n7 + 1)});
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return "";
    }

    protected void updateHeader() {
        super.updateHeader();
        this.updateControls();
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        this.fHandlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.fLeft.getControl().getShell());
        Action action = new Action(){

            public void run() {
                if (!TextMergeViewer.this.isIgnoreAncestor()) {
                    TextMergeViewer.this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (Object)Boolean.FALSE);
                }
                TextMergeViewer.this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR, (Object)(!TextMergeViewer.this.isIgnoreAncestor() ? 1 : 0));
                Utilities.initToggleAction((IAction)this, (ResourceBundle)TextMergeViewer.this.getResourceBundle(), (String)"action.IgnoreAncestor.", (boolean)TextMergeViewer.this.isIgnoreAncestor());
            }
        };
        action.setChecked(this.isIgnoreAncestor());
        Utilities.initAction((IAction)action, (ResourceBundle)this.getResourceBundle(), (String)"action.IgnoreAncestor.");
        Utilities.initToggleAction((IAction)action, (ResourceBundle)this.getResourceBundle(), (String)"action.IgnoreAncestor.", (boolean)this.isIgnoreAncestor());
        this.fIgnoreAncestorItem = new ActionContributionItem((IAction)action);
        this.fIgnoreAncestorItem.setVisible(false);
        toolBarManager.appendToGroup("modes", (IContributionItem)this.fIgnoreAncestorItem);
        toolBarManager.add((IContributionItem)new Separator());
        Action action2 = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(true, false, false)) {
                    TextMergeViewer.this.endOfDocumentReached(true);
                }
            }
        };
        Utilities.initAction((IAction)action2, (ResourceBundle)this.getResourceBundle(), (String)"action.NextDiff.");
        this.fNextDiff = new ActionContributionItem((IAction)action2);
        toolBarManager.appendToGroup("navigation", (IContributionItem)this.fNextDiff);
        action2 = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(false, false, false)) {
                    TextMergeViewer.this.endOfDocumentReached(false);
                }
            }
        };
        Utilities.initAction((IAction)action2, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevDiff.");
        this.fPreviousDiff = new ActionContributionItem((IAction)action2);
        toolBarManager.appendToGroup("navigation", (IContributionItem)this.fPreviousDiff);
        action2 = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(true, false, true)) {
                    TextMergeViewer.this.endOfDocumentReached(true);
                }
            }
        };
        Utilities.initAction((IAction)action2, (ResourceBundle)this.getResourceBundle(), (String)"action.NextChange.");
        this.fNextChange = new ActionContributionItem((IAction)action2);
        toolBarManager.appendToGroup("navigation", (IContributionItem)this.fNextChange);
        this.fHandlerService.registerAction((IAction)action2, "org.eclipse.compare.selectNextChange");
        action2 = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(false, false, true)) {
                    TextMergeViewer.this.endOfDocumentReached(false);
                }
            }
        };
        Utilities.initAction((IAction)action2, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevChange.");
        this.fPreviousChange = new ActionContributionItem((IAction)action2);
        toolBarManager.appendToGroup("navigation", (IContributionItem)this.fPreviousChange);
        this.fHandlerService.registerAction((IAction)action2, "org.eclipse.compare.selectPreviousChange");
        CompareConfiguration compareConfiguration = this.getCompareConfiguration();
        if (compareConfiguration.isRightEditable()) {
            action2 = new Action(){

                public void run() {
                    TextMergeViewer.this.copyDiffLeftToRight();
                }
            };
            Utilities.initAction((IAction)action2, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)action2);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            this.fHandlerService.registerAction((IAction)action2, "org.eclipse.compare.copyLeftToRight");
        }
        if (compareConfiguration.isLeftEditable()) {
            action2 = new Action(){

                public void run() {
                    TextMergeViewer.this.copyDiffRightToLeft();
                }
            };
            Utilities.initAction((IAction)action2, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)action2);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            this.fHandlerService.registerAction((IAction)action2, "org.eclipse.compare.copyRightToLeft");
        }
        this.fIgnoreWhitespace = ChangePropertyAction.createIgnoreWhiteSpaceAction((ResourceBundle)this.getResourceBundle(), (CompareConfiguration)this.getCompareConfiguration());
        this.fIgnoreWhitespace.setActionDefinitionId(ICompareUIConstants.COMMAND_IGNORE_WHITESPACE);
        this.fLeft.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fRight.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fAncestor.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fHandlerService.registerAction((IAction)this.fIgnoreWhitespace, this.fIgnoreWhitespace.getActionDefinitionId());
        this.showWhitespaceAction = new ShowWhitespaceAction(new MergeSourceViewer[]{this.fLeft, this.fRight, this.fAncestor});
        this.fHandlerService.registerAction((IAction)this.showWhitespaceAction, "org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters");
        this.toggleLineNumbersAction = new TextEditorPropertyAction(CompareMessages.TextMergeViewer_16, new MergeSourceViewer[]{this.fLeft, this.fRight, this.fAncestor}, "lineNumberRuler");
        this.fHandlerService.registerAction((IAction)this.toggleLineNumbersAction, "org.eclipse.ui.editors.lineNumberToggle");
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals("IGNORE_WHITESPACE") || string.equals("org.eclipse.compare.ShowPseudoConflicts")) {
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.update(true);
            this.selectFirstDiff(true);
        } else if (string.equals("org.eclipse.compare.UseSingleLine")) {
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fBasicCenterCurve = null;
            this.updateResolveStatus();
            this.invalidateLines();
        } else if (string.equals("org.eclipse.compare.HighlightTokenChanges")) {
            this.fHighlightTokenChanges = this.fPreferenceStore.getBoolean("org.eclipse.compare.HighlightTokenChanges");
            this.updateResolveStatus();
            this.updatePresentation(null);
        } else if (string.equals(this.fSymbolicFontName)) {
            this.updateFont();
            this.invalidateLines();
        } else if (string.equals(INCOMING_COLOR) || string.equals(OUTGOING_COLOR) || string.equals(CONFLICTING_COLOR) || string.equals(RESOLVED_COLOR)) {
            this.updateColors(null);
            this.invalidateLines();
            this.invalidateTextPresentation();
        } else if (string.equals("org.eclipse.compare.SynchronizeScrolling")) {
            boolean bl = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.setSyncScrolling(bl);
        } else if (string.equals("org.eclipse.compare.ShowMoreInfo")) {
            boolean bl = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowMoreInfo");
            if (bl != this.fShowMoreInfo) {
                this.fShowMoreInfo = bl;
                if (this.fShowMoreInfo) {
                    this.updateStatus(this.fCurrentDiff);
                } else {
                    this.clearStatus();
                }
            }
        } else {
            super.handlePropertyChangeEvent(propertyChangeEvent);
            if (string.equals(ICompareUIConstants.PROP_IGNORE_ANCESTOR)) {
                this.update(false);
                this.selectFirstDiff(true);
            }
        }
    }

    private void selectFirstDiff(boolean bl) {
        if (this.fLeft == null || this.fRight == null) {
            return;
        }
        if (this.fLeft.getDocument() == null || this.fRight.getDocument() == null) {
            return;
        }
        Diff diff = null;
        diff = bl ? TextMergeViewer.findNext(this.fRight, this.fChangeDiffs, -1, -1, false) : TextMergeViewer.findPrev(this.fRight, this.fChangeDiffs, 9999999, 9999999, false);
        this.setCurrentDiff(diff, true);
    }

    private void setSyncScrolling(boolean bl) {
        if (this.fSynchronizedScrolling != bl) {
            this.fSynchronizedScrolling = bl;
            this.scrollVertical(0, 0, 0, null);
            Control control = this.getCenterControl();
            if (control != null && !control.isDisposed()) {
                control.dispose();
            }
            this.fLeft.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
            this.fRight.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
            this.fComposite.layout(true);
        }
    }

    protected void updateToolItems() {
        if (!this.isPatchHunk()) {
            IAction iAction;
            if (this.fIgnoreAncestorItem != null) {
                this.fIgnoreAncestorItem.setVisible(this.isThreeWay());
            }
            if (this.fCopyDiffLeftToRightItem != null && (iAction = this.fCopyDiffLeftToRightItem.getAction()) != null) {
                iAction.setEnabled(iAction.isEnabled() && !this.fHasErrors);
            }
            if (this.fCopyDiffRightToLeftItem != null && (iAction = this.fCopyDiffRightToLeftItem.getAction()) != null) {
                iAction.setEnabled(iAction.isEnabled() && !this.fHasErrors);
            }
            super.updateToolItems();
        }
    }

    private void updateLines(IDocument iDocument) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        if (iDocument == this.fLeft.getDocument()) {
            n = this.fLeft.getLineCount();
            bl = this.fLeftLineCount != n;
            this.fLeftLineCount = n;
        } else if (iDocument == this.fRight.getDocument()) {
            n = this.fRight.getLineCount();
            bl2 = this.fRightLineCount != n;
            this.fRightLineCount = n;
        }
        if (bl || bl2) {
            Control control;
            if (bl) {
                if (this.fLeftCanvas != null) {
                    this.fLeftCanvas.redraw();
                }
            } else if (this.fRightCanvas != null) {
                this.fRightCanvas.redraw();
            }
            if ((control = this.getCenterControl()) != null) {
                control.redraw();
            }
            this.updateVScrollBar();
            this.refreshBirdsEyeView();
        }
    }

    private void invalidateLines() {
        if (this.isThreeWay()) {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.redraw();
            }
            if (this.fAncestor != null && this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getTextWidget().redraw();
            }
        }
        if (Utilities.okToUse((Widget)this.fLeftCanvas)) {
            this.fLeftCanvas.redraw();
        }
        if (this.fLeft != null && this.fLeft.isControlOkToUse()) {
            this.fLeft.getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.getCenterControl())) {
            this.getCenterControl().redraw();
        }
        if (this.fRight != null && this.fRight.isControlOkToUse()) {
            this.fRight.getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.fRightCanvas)) {
            this.fRightCanvas.redraw();
        }
    }

    private boolean showResolveUI() {
        if (!this.fUseResolveUI || !this.isThreeWay() || this.isIgnoreAncestor()) {
            return false;
        }
        CompareConfiguration compareConfiguration = this.getCompareConfiguration();
        boolean bl = compareConfiguration.isLeftEditable();
        boolean bl2 = compareConfiguration.isRightEditable();
        return bl || bl2;
    }

    private void paintCenter(Canvas canvas, GC gC) {
        Display display = canvas.getDisplay();
        this.checkForColorUpdate(display);
        if (!this.fSynchronizedScrolling) {
            return;
        }
        int n = this.fLeft.getTextWidget().getLineHeight();
        int n2 = this.fRight.getViewportHeight();
        Point point = canvas.getSize();
        int n3 = 0;
        int n4 = point.x;
        gC.setBackground(canvas.getBackground());
        gC.fillRectangle(n3 + 1, 0, n4 - 2, point.y);
        if (!this.fIsMotif) {
            gC.setBackground(display.getSystemColor(18));
            gC.fillRectangle(0, 0, 1, point.y);
            gC.fillRectangle(n4 - 1, 0, 1, point.y);
        }
        if (!this.fHighlightRanges) {
            return;
        }
        boolean bl = this.showResolveUI();
        if (this.fChangeDiffs != null) {
            int n5 = this.fLeft.getVerticalScrollOffset();
            int n6 = this.fRight.getVerticalScrollOffset();
            Point point2 = new Point(0, 0);
            for (Diff diff : this.fChangeDiffs) {
                int n7;
                int n8;
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.fLeftPos, point2);
                int n9 = point2.x * n + n5;
                int n10 = point2.y * n;
                this.fRight.getLineRange(diff.fRightPos, point2);
                int n11 = point2.x * n + n6;
                int n12 = point2.y * n;
                if (Math.max(n9 + n10, n11 + n12) < 0) continue;
                if (Math.min(n9, n11) >= n2) break;
                this.fPts[0] = n3;
                this.fPts[1] = n9;
                this.fPts[2] = n4;
                this.fPts[3] = n11;
                this.fPts[6] = n3;
                this.fPts[7] = n9 + n10;
                this.fPts[4] = n4;
                this.fPts[5] = n11 + n12;
                Color color = this.getColor(display, this.getFillColor(diff));
                Color color2 = this.getColor(display, this.getStrokeColor(diff));
                if (this.fUseSingleLine) {
                    n8 = 3;
                    gC.setBackground(color);
                    gC.fillRectangle(0, n9, n8, n10);
                    gC.fillRectangle(n4 - n8, n11, n8, n12);
                    gC.setLineWidth(0);
                    gC.setForeground(color2);
                    gC.drawRectangle(-1, n9, n8, n10);
                    gC.drawRectangle(n4 - n8, n11, n8, n12);
                    if (this.fUseSplines) {
                        int[] nArray = this.getCenterCurvePoints(n8, n9 + n10 / 2, n4 - n8, n11 + n12 / 2);
                        n7 = 1;
                        while (n7 < nArray.length) {
                            gC.drawLine(n8 + n7 - 1, nArray[n7 - 1], n8 + n7, nArray[n7]);
                            ++n7;
                        }
                    } else {
                        gC.drawLine(n8, n9 + n10 / 2, n4 - n8, n11 + n12 / 2);
                    }
                } else if (this.fUseSplines) {
                    gC.setBackground(color);
                    gC.setLineWidth(0);
                    gC.setForeground(color2);
                    int[] nArray = this.getCenterCurvePoints(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    int[] nArray2 = this.getCenterCurvePoints(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                    gC.setForeground(color);
                    gC.drawLine(0, nArray2[0], 0, nArray[0]);
                    n7 = 1;
                    while (n7 < nArray2.length) {
                        gC.setForeground(color);
                        gC.drawLine(n7, nArray2[n7], n7, nArray[n7]);
                        gC.setForeground(color2);
                        gC.drawLine(n7 - 1, nArray[n7 - 1], n7, nArray[n7]);
                        gC.drawLine(n7 - 1, nArray2[n7 - 1], n7, nArray2[n7]);
                        ++n7;
                    }
                } else {
                    gC.setBackground(color);
                    gC.fillPolygon(this.fPts);
                    gC.setLineWidth(0);
                    gC.setForeground(color2);
                    gC.drawLine(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    gC.drawLine(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                }
                if (!this.fUseSingleLine || !bl || !diff.isUnresolvedIncomingOrConflicting()) continue;
                n8 = (n4 - 5) / 2;
                int n13 = (n9 + n10 / 2 + (n11 + n12 / 2) - 5) / 2;
                gC.setBackground(color);
                gC.fillRectangle(n8, n13, 5, 5);
                gC.setForeground(color2);
                gC.drawRectangle(n8, n13, 5, 5);
            }
        }
    }

    private int[] getCenterCurvePoints(int n, int n2, int n3, int n4) {
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(n3 - n);
        }
        double d = n4 - n2;
        d /= 2.0;
        int n5 = n3 - n;
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray[n6] = (int)(-d * this.fBasicCenterCurve[n6] + d + (double)n2);
            ++n6;
        }
        return nArray;
    }

    private void buildBaseCenterCurve(int n) {
        double d = n;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int n2 = 0;
        while (n2 < this.getCenterWidth()) {
            double d2 = (double)n2 / d;
            this.fBasicCenterCurve[n2] = Math.cos(Math.PI * d2);
            ++n2;
        }
    }

    private void paintSides(GC gC, MergeSourceViewer mergeSourceViewer, Canvas canvas, boolean bl) {
        Display display = canvas.getDisplay();
        int n = mergeSourceViewer.getTextWidget().getLineHeight();
        int n2 = mergeSourceViewer.getViewportHeight();
        Point point = canvas.getSize();
        int n3 = 0;
        int n4 = this.fMarginWidth;
        int n5 = n4 / 2;
        gC.setBackground(canvas.getBackground());
        gC.fillRectangle(n3, 0, n4, point.y);
        if (!this.fIsMotif) {
            gC.setBackground(display.getSystemColor(18));
            if (bl) {
                gC.fillRectangle(0, 0, 1, point.y);
            } else {
                gC.fillRectangle(point.x - 1, 0, 1, point.y);
            }
        }
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fChangeDiffs != null) {
            int n6 = mergeSourceViewer.getVerticalScrollOffset() + 1;
            Point point2 = new Point(0, 0);
            for (Diff diff : this.fChangeDiffs) {
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                mergeSourceViewer.getLineRange(diff.getPosition(mergeSourceViewer), point2);
                int n7 = point2.x * n + n6;
                int n8 = point2.y * n;
                if (n7 + n8 < 0) continue;
                if (n7 >= n2) break;
                gC.setBackground(this.getColor(display, this.getFillColor(diff)));
                if (bl) {
                    gC.fillRectangle(n3, n7, n5, n8);
                } else {
                    gC.fillRectangle(n3 + n5, n7, n5, n8);
                }
                gC.setLineWidth(0);
                gC.setForeground(this.getColor(display, this.getStrokeColor(diff)));
                if (bl) {
                    gC.drawRectangle(n3 - 1, n7 - 1, n5, n8);
                    continue;
                }
                gC.drawRectangle(n3 + n5, n7 - 1, n5, n8);
            }
        }
    }

    private void paint(PaintEvent paintEvent, MergeSourceViewer mergeSourceViewer) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fChangeDiffs == null) {
            return;
        }
        Control control = (Control)paintEvent.widget;
        GC gC = paintEvent.gc;
        Display display = control.getDisplay();
        int n = mergeSourceViewer.getTextWidget().getLineHeight();
        int n2 = control.getSize().x;
        int n3 = mergeSourceViewer.getVerticalScrollOffset() + 1;
        int n4 = paintEvent.y + paintEvent.height;
        n3 += this.fTopInset;
        Point point = new Point(0, 0);
        for (Diff diff : this.fChangeDiffs) {
            if (diff.isDeleted() || this.fShowCurrentOnly && !this.isCurrentDiff(diff)) continue;
            mergeSourceViewer.getLineRange(diff.getPosition(mergeSourceViewer), point);
            int n5 = point.x * n + n3;
            int n6 = point.y * n;
            if (n5 + n6 < paintEvent.y) continue;
            if (n5 > n4) break;
            gC.setBackground(this.getColor(display, this.getStrokeColor(diff)));
            gC.fillRectangle(0, n5 - 1, n2, 1);
            gC.fillRectangle(0, n5 + n6 - 1, n2, 1);
        }
    }

    private RGB getFillColor(Diff diff) {
        boolean bl = this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
        RGB rGB = this.getBackground(null);
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            switch (diff.fDirection) {
                case 2: {
                    if (this.fLeftIsLocal) {
                        return bl ? rGB : this.INCOMING_FILL;
                    }
                    return bl ? rGB : this.OUTGOING_FILL;
                }
                case 4: {
                    return bl ? rGB : this.CONFLICT_FILL;
                }
                case 3: {
                    if (this.fLeftIsLocal) {
                        return bl ? rGB : this.OUTGOING_FILL;
                    }
                    return bl ? rGB : this.INCOMING_FILL;
                }
                case 1: {
                    return bl ? rGB : this.CONFLICT_FILL;
                }
            }
            return null;
        }
        return bl ? rGB : this.OUTGOING_FILL;
    }

    private RGB getStrokeColor(Diff diff) {
        boolean bl;
        boolean bl2 = bl = this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            switch (diff.fDirection) {
                case 2: {
                    if (this.fLeftIsLocal) {
                        return bl ? this.SELECTED_INCOMING : this.INCOMING;
                    }
                    return bl ? this.SELECTED_OUTGOING : this.OUTGOING;
                }
                case 4: {
                    return bl ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
                case 3: {
                    if (this.fLeftIsLocal) {
                        return bl ? this.SELECTED_OUTGOING : this.OUTGOING;
                    }
                    return bl ? this.SELECTED_INCOMING : this.INCOMING;
                }
                case 1: {
                    return bl ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
            }
            return null;
        }
        return bl ? this.SELECTED_OUTGOING : this.OUTGOING;
    }

    private Color getColor(Display display, RGB rGB) {
        Color color;
        if (rGB == null) {
            return null;
        }
        if (this.fColors == null) {
            this.fColors = new HashMap(20);
        }
        if ((color = (Color)this.fColors.get(rGB)) == null) {
            color = new Color((Device)display, rGB);
            this.fColors.put(rGB, color);
        }
        return color;
    }

    static RGB interpolate(RGB rGB, RGB rGB2, double d) {
        if (rGB != null && rGB2 != null) {
            return new RGB((int)((1.0 - d) * (double)rGB.red + d * (double)rGB2.red), (int)((1.0 - d) * (double)rGB.green + d * (double)rGB2.green), (int)((1.0 - d) * (double)rGB.blue + d * (double)rGB2.blue));
        }
        if (rGB != null) {
            return rGB;
        }
        if (rGB2 != null) {
            return rGB2;
        }
        return new RGB(128, 128, 128);
    }

    private Diff getNextVisibleDiff(boolean bl, boolean bl2) {
        Diff diff = null;
        MergeSourceViewer mergeSourceViewer = this.getNavigationPart();
        if (mergeSourceViewer == null) {
            return null;
        }
        Point point = mergeSourceViewer.getSelectedRange();
        while (true) {
            diff = null;
            diff = this.internalGetNextDiff(bl, bl2, mergeSourceViewer, point);
            if (diff == null || diff.fDirection != 4 || this.isAncestorVisible()) break;
            Position position = diff.getPosition(mergeSourceViewer);
            point = new Point(position.getOffset(), position.getLength());
            diff = null;
        }
        return diff;
    }

    private Diff internalGetNextDiff(boolean bl, boolean bl2, MergeSourceViewer mergeSourceViewer, Point point) {
        if (this.fChangeDiffs != null) {
            if (bl) {
                return TextMergeViewer.findNext(mergeSourceViewer, this.fChangeDiffs, point.x, point.x + point.y, bl2);
            }
            return TextMergeViewer.findPrev(mergeSourceViewer, this.fChangeDiffs, point.x, point.x + point.y, bl2);
        }
        return null;
    }

    private MergeSourceViewer getNavigationPart() {
        MergeSourceViewer mergeSourceViewer = this.fFocusPart;
        if (mergeSourceViewer == null) {
            mergeSourceViewer = this.fRight;
        }
        return mergeSourceViewer;
    }

    private Diff getWrappedDiff(Diff diff, boolean bl) {
        if (this.fChangeDiffs != null && this.fChangeDiffs.size() > 0) {
            if (bl) {
                return (Diff)this.fChangeDiffs.get(0);
            }
            return (Diff)this.fChangeDiffs.get(this.fChangeDiffs.size() - 1);
        }
        return null;
    }

    private boolean navigate(boolean bl, boolean bl2, boolean bl3) {
        Diff diff = null;
        boolean bl4 = false;
        do {
            if ((diff = this.getNextVisibleDiff(bl, bl3)) == null && bl2) {
                if (bl4) break;
                bl4 = true;
                diff = this.getWrappedDiff(diff, bl);
            }
            if (diff == null) continue;
            this.setCurrentDiff(diff, true, bl3);
        } while (diff != null && diff.fDirection == 4 && !this.isAncestorVisible());
        return diff == null;
    }

    private void endOfDocumentReached(boolean bl) {
        Control control = this.getControl();
        if (Utilities.okToUse((Widget)control)) {
            this.handleEndOfDocumentReached(control.getShell(), bl);
        }
    }

    private void handleEndOfDocumentReached(Shell shell, boolean bl) {
        boolean bl2 = this.hasNextElement(bl);
        IPreferenceStore iPreferenceStore = CompareUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION);
        if (!string.equals("prompt") && (bl2 || iPreferenceStore.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION).equals("loop"))) {
            this.performEndOfDocumentAction(shell, iPreferenceStore, ICompareUIConstants.PREF_NAVIGATION_END_ACTION, bl);
            return;
        }
        shell.getDisplay().beep();
        if (bl2) {
            String string2;
            String string3;
            String string4;
            String string5;
            if (bl) {
                string5 = CompareMessages.TextMergeViewer_0;
                string4 = CompareMessages.TextMergeViewer_1;
                string3 = CompareMessages.TextMergeViewer_2;
                string2 = CompareMessages.TextMergeViewer_3;
            } else {
                string5 = CompareMessages.TextMergeViewer_4;
                string4 = CompareMessages.TextMergeViewer_5;
                string3 = CompareMessages.TextMergeViewer_6;
                string2 = CompareMessages.TextMergeViewer_7;
            }
            String[] stringArray = new String[]{string3, "loop"};
            String[] stringArray2 = new String[]{string2, "next"};
            NavigationEndDialog navigationEndDialog = new NavigationEndDialog(shell, string5, null, string4, (String[][])new String[][]{stringArray, stringArray2});
            int n = navigationEndDialog.open();
            if (n == 0) {
                this.performEndOfDocumentAction(shell, iPreferenceStore, ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL, bl);
                if (navigationEndDialog.getToggleState()) {
                    iPreferenceStore.putValue(ICompareUIConstants.PREF_NAVIGATION_END_ACTION, iPreferenceStore.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL));
                }
            }
        } else {
            String string6;
            String string7;
            if (bl) {
                string7 = CompareMessages.TextMergeViewer_8;
                string6 = CompareMessages.TextMergeViewer_9;
            } else {
                string7 = CompareMessages.TextMergeViewer_10;
                string6 = CompareMessages.TextMergeViewer_11;
            }
            if (MessageDialog.openQuestion((Shell)shell, (String)string7, (String)string6)) {
                this.selectFirstDiff(bl);
            }
        }
    }

    private void performEndOfDocumentAction(Shell shell, IPreferenceStore iPreferenceStore, String string, boolean bl) {
        String string2 = iPreferenceStore.getString(string);
        if (string2.equals("next")) {
            ICompareNavigator iCompareNavigator = this.getCompareConfiguration().getContainer().getNavigator();
            if (this.hasNextElement(bl)) {
                iCompareNavigator.selectChange(bl);
            } else {
                shell.getDisplay().beep();
            }
        } else {
            this.selectFirstDiff(bl);
        }
    }

    private boolean hasNextElement(boolean bl) {
        ICompareNavigator iCompareNavigator = this.getCompareConfiguration().getContainer().getNavigator();
        if (iCompareNavigator instanceof CompareNavigator) {
            CompareNavigator compareNavigator = (CompareNavigator)iCompareNavigator;
            return compareNavigator.hasChange(bl);
        }
        return false;
    }

    private Diff findDiff(MergeSourceViewer mergeSourceViewer, int n, int n2) {
        if (this.fChangeDiffs != null) {
            for (Diff diff : this.fChangeDiffs) {
                if (!diff.overlaps(mergeSourceViewer, n, n2)) continue;
                return diff;
            }
        }
        return null;
    }

    private static Diff findNext(MergeSourceViewer mergeSourceViewer, List list, int n, int n2, boolean bl) {
        int n3 = 0;
        while (n3 < list.size()) {
            Diff diff = (Diff)list.get(n3);
            Position position = diff.getPosition(mergeSourceViewer);
            if (position != null) {
                int n4 = position.getOffset();
                if (n2 < n4) {
                    return diff;
                }
                if (bl && diff.fDiffs != null) {
                    Diff diff2 = null;
                    int n5 = n4 + position.getLength();
                    if (n == n4 && (n2 == n5 || n2 == n5 - 1)) {
                        diff2 = TextMergeViewer.findNext(mergeSourceViewer, diff.fDiffs, n - 1, n - 1, bl);
                    } else if (n2 < n5) {
                        diff2 = TextMergeViewer.findNext(mergeSourceViewer, diff.fDiffs, n, n2, bl);
                    }
                    if (diff2 != null) {
                        return diff2;
                    }
                }
            }
            ++n3;
        }
        return null;
    }

    private static Diff findPrev(MergeSourceViewer mergeSourceViewer, List list, int n, int n2, boolean bl) {
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            Diff diff = (Diff)list.get(n3);
            Position position = diff.getPosition(mergeSourceViewer);
            if (position != null) {
                int n4 = position.getOffset();
                int n5 = n4 + position.getLength();
                if (n > n5) {
                    if (bl && diff.fDiffs != null) {
                        return TextMergeViewer.findPrev(mergeSourceViewer, diff.fDiffs, n2, n2, bl);
                    }
                    return diff;
                }
                if (bl && diff.fDiffs != null) {
                    Diff diff2 = null;
                    if ((n != n4 || n2 != n5) && n >= n4) {
                        if (TextMergeViewer.isFirstDiff(mergeSourceViewer, n4, diff.fDiffs)) {
                            return diff;
                        }
                        diff2 = TextMergeViewer.findPrev(mergeSourceViewer, diff.fDiffs, n, n2, bl);
                    }
                    if (diff2 != null) {
                        return diff2;
                    }
                }
            }
            --n3;
        }
        return null;
    }

    private static boolean isFirstDiff(MergeSourceViewer mergeSourceViewer, int n, ArrayList arrayList) {
        if (arrayList.isEmpty()) {
            return false;
        }
        Diff diff = (Diff)arrayList.get(0);
        Position position = diff.getPosition(mergeSourceViewer);
        return position.getOffset() >= n;
    }

    private void setCurrentDiff(Diff diff, boolean bl) {
        this.setCurrentDiff(diff, bl, false);
    }

    private void setCurrentDiff(Diff diff, boolean bl, boolean bl2) {
        Diff diff2;
        if (this.fCenterButton != null && !this.fCenterButton.isDisposed()) {
            this.fCenterButton.setVisible(false);
        }
        Diff diff3 = this.fCurrentDiff;
        if (diff != null && bl) {
            if (diff.fIsToken || !this.fHighlightTokenChanges || bl2 || !diff.hasChildren()) {
                if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                    this.fAncestor.setSelection(diff.fAncestorPos);
                }
                this.fLeft.setSelection(diff.fLeftPos);
                this.fRight.setSelection(diff.fRightPos);
            } else {
                if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                    this.fAncestor.setSelection(new Position(diff.fAncestorPos.offset, 0));
                }
                this.fLeft.setSelection(new Position(diff.fLeftPos.offset, 0));
                this.fRight.setSelection(new Position(diff.fRightPos.offset, 0));
            }
            this.fCurrentDiff = diff;
            this.revealDiff(diff, diff.fIsToken);
        } else {
            this.fCurrentDiff = diff;
        }
        Diff diff4 = diff3 != null ? diff3.fParent : null;
        Diff diff5 = diff2 = this.fCurrentDiff != null ? this.fCurrentDiff.fParent : null;
        if (diff4 != diff2) {
            this.updateDiffBackground(diff4);
            this.updateDiffBackground(diff2);
        }
        this.updateControls();
        this.invalidateLines();
        this.refreshBirdsEyeView();
    }

    private void revealDiff(Diff diff, boolean bl) {
        int n;
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl) {
            int n3;
            Point point = new Point(0, 0);
            n2 = this.fLeft.getLineRange((Position)diff.fLeftPos, (Point)point).x;
            n = this.fRight.getLineRange((Position)diff.fRightPos, (Point)point).x;
            if (this.isThreeWay() && !this.isIgnoreAncestor() && (n3 = this.fAncestor.getLineRange((Position)diff.fAncestorPos, (Point)point).x) >= this.fAncestor.getTopIndex() && n3 <= this.fAncestor.getBottomIndex()) {
                bl2 = true;
            }
            if (n2 >= this.fLeft.getTopIndex() && n2 <= this.fLeft.getBottomIndex()) {
                bl3 = true;
            }
            if (n >= this.fRight.getTopIndex() && n <= this.fRight.getBottomIndex()) {
                bl4 = true;
            }
        }
        if (!bl3 || !bl4) {
            int n4 = 0;
            n2 = 0;
            n = 0;
            MergeSourceViewer mergeSourceViewer = null;
            if (bl3) {
                n2 = n = this.realToVirtualPosition(this.fLeft, this.fLeft.getTopIndex());
                n4 = n;
                mergeSourceViewer = this.fLeft;
            } else if (bl4) {
                n2 = n = this.realToVirtualPosition(this.fRight, this.fRight.getTopIndex());
                n4 = n;
                mergeSourceViewer = this.fRight;
            } else if (bl2) {
                n2 = n = this.realToVirtualPosition(this.fAncestor, this.fAncestor.getTopIndex());
                n4 = n;
                mergeSourceViewer = this.fAncestor;
            } else {
                int n5;
                if (this.fAllDiffs != null) {
                    n5 = 0;
                    Iterator iterator = this.fAllDiffs.iterator();
                    int n6 = 0;
                    while (iterator.hasNext()) {
                        Diff diff2 = (Diff)iterator.next();
                        if (diff2 == diff) break;
                        if (this.fSynchronizedScrolling) {
                            n5 += diff2.getMaxDiffHeight();
                        } else {
                            n4 += diff2.getAncestorHeight();
                            n2 += diff2.getLeftHeight();
                            n += diff2.getRightHeight();
                        }
                        ++n6;
                    }
                    if (this.fSynchronizedScrolling) {
                        n2 = n = n5;
                        n4 = n;
                    }
                }
                if ((n4 -= (n5 = this.fRight.getViewportLines() / 4)) < 0) {
                    n4 = 0;
                }
                if ((n2 -= n5) < 0) {
                    n2 = 0;
                }
                if ((n -= n5) < 0) {
                    n = 0;
                }
            }
            this.scrollVertical(n4, n2, n, mergeSourceViewer);
            if (this.fVScrollBar != null) {
                this.fVScrollBar.setSelection(n4);
            }
        }
        if (diff.fIsToken) {
            TextMergeViewer.reveal(this.fAncestor, diff.fAncestorPos);
            TextMergeViewer.reveal(this.fLeft, diff.fLeftPos);
            TextMergeViewer.reveal(this.fRight, diff.fRightPos);
        } else {
            TextMergeViewer.hscroll(this.fAncestor);
            TextMergeViewer.hscroll(this.fLeft);
            TextMergeViewer.hscroll(this.fRight);
        }
    }

    private static void reveal(MergeSourceViewer mergeSourceViewer, Position position) {
        Rectangle rectangle;
        StyledText styledText;
        if (mergeSourceViewer != null && position != null && (styledText = mergeSourceViewer.getTextWidget()) != null && !(rectangle = styledText.getClientArea()).isEmpty()) {
            mergeSourceViewer.revealRange(position.offset, position.length);
        }
    }

    private static void hscroll(MergeSourceViewer mergeSourceViewer) {
        StyledText styledText;
        if (mergeSourceViewer != null && (styledText = mergeSourceViewer.getTextWidget()) != null) {
            styledText.setHorizontalIndex(0);
        }
    }

    void copyAllUnresolved(boolean bl) {
        if (this.fChangeDiffs != null && this.isThreeWay() && !this.isIgnoreAncestor()) {
            IRewriteTarget iRewriteTarget = bl ? this.fRight.getRewriteTarget() : this.fLeft.getRewriteTarget();
            boolean bl2 = false;
            Iterator iterator = this.fChangeDiffs.iterator();
            try {
                while (iterator.hasNext()) {
                    Diff diff = (Diff)iterator.next();
                    switch (diff.fDirection) {
                        case 3: {
                            if (!bl) break;
                            if (!bl2) {
                                iRewriteTarget.beginCompoundChange();
                                bl2 = true;
                            }
                            this.copy(diff, bl);
                            break;
                        }
                        case 2: {
                            if (bl) break;
                            if (!bl2) {
                                iRewriteTarget.beginCompoundChange();
                                bl2 = true;
                            }
                            this.copy(diff, bl);
                            break;
                        }
                    }
                }
            }
            finally {
                if (bl2) {
                    iRewriteTarget.endCompoundChange();
                }
            }
        }
    }

    protected void copy(boolean bl) {
        if (!this.validateChange(!bl)) {
            return;
        }
        if (this.showResolveUI()) {
            this.copyAllUnresolved(bl);
            this.invalidateLines();
            return;
        }
        if (bl) {
            if (this.fLeft.getEnabled()) {
                String string = this.fLeft.getTextWidget().getText();
                this.fRight.getTextWidget().setText(string);
                this.fRight.setEnabled(true);
            } else {
                this.fRight.getTextWidget().setText("");
                this.fRight.setEnabled(false);
            }
            this.fRightLineCount = this.fRight.getLineCount();
            this.setRightDirty(true);
        } else {
            if (this.fRight.getEnabled()) {
                String string = this.fRight.getTextWidget().getText();
                this.fLeft.getTextWidget().setText(string);
                this.fLeft.setEnabled(true);
            } else {
                this.fLeft.getTextWidget().setText("");
                this.fLeft.setEnabled(false);
            }
            this.fLeftLineCount = this.fLeft.getLineCount();
            this.setLeftDirty(true);
        }
        this.update(false);
        this.selectFirstDiff(true);
    }

    private void copyDiffLeftToRight() {
        this.copy(this.fCurrentDiff, true, false);
    }

    private void copyDiffRightToLeft() {
        this.copy(this.fCurrentDiff, false, false);
    }

    private void copy(Diff diff, boolean bl, boolean bl2) {
        if (this.copy(diff, bl)) {
            if (bl2) {
                this.navigate(true, true, false);
            } else {
                this.revealDiff(diff, true);
                this.updateControls();
            }
        }
    }

    private boolean copy(Diff diff, boolean bl) {
        if (diff != null && !diff.isResolved()) {
            if (!this.validateChange(!bl)) {
                return false;
            }
            Position position = null;
            Position position2 = null;
            IDocument iDocument = null;
            IDocument iDocument2 = null;
            if (bl) {
                this.fRight.setEnabled(true);
                position = diff.fLeftPos;
                position2 = diff.fRightPos;
                iDocument = this.fLeft.getDocument();
                iDocument2 = this.fRight.getDocument();
            } else {
                this.fLeft.setEnabled(true);
                position = diff.fRightPos;
                position2 = diff.fLeftPos;
                iDocument = this.fRight.getDocument();
                iDocument2 = this.fLeft.getDocument();
            }
            if (iDocument != null) {
                int n = position.getOffset();
                int n2 = position.getLength();
                int n3 = position2.getOffset();
                int n4 = position2.getLength();
                try {
                    String string = null;
                    switch (diff.fDirection) {
                        case 2: 
                        case 3: {
                            string = iDocument.get(n, n2);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 1: {
                            string = iDocument2.get(n3, n4);
                            string = String.valueOf(string) + iDocument.get(n, n2);
                        }
                    }
                    if (string != null) {
                        iDocument2.replace(n3, n4, string);
                        position2.setOffset(n3);
                        position2.setLength(string.length());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            diff.setResolved(true);
            this.updateResolveStatus();
            return true;
        }
        return false;
    }

    private boolean validateChange(boolean bl) {
        ContributorInfo contributorInfo = bl ? this.fLeftContributor : this.fRightContributor;
        return contributorInfo.validateChange();
    }

    private int getVirtualHeight() {
        int n = 1;
        if (this.fAllDiffs != null) {
            Iterator iterator = this.fAllDiffs.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Diff diff = (Diff)iterator.next();
                n += diff.getMaxDiffHeight();
                ++n2;
            }
        }
        return n;
    }

    private int getRightHeight() {
        int n = 1;
        if (this.fAllDiffs != null) {
            Iterator iterator = this.fAllDiffs.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Diff diff = (Diff)iterator.next();
                n += diff.getRightHeight();
                ++n2;
            }
        }
        return n;
    }

    private int getViewportHeight() {
        StyledText styledText = this.fLeft.getTextWidget();
        int n = styledText.getClientArea().height;
        if (n == 0) {
            Rectangle rectangle = styledText.computeTrim(0, 0, 0, 0);
            int n2 = rectangle.height;
            int n3 = this.getHeaderHeight();
            Composite composite = (Composite)this.getControl();
            Rectangle rectangle2 = composite.getClientArea();
            n = rectangle2.height - n3 - n2;
        }
        return n / styledText.getLineHeight();
    }

    private int realToVirtualPosition(MergeSourceViewer mergeSourceViewer, int n) {
        if (!this.fSynchronizedScrolling || this.fAllDiffs == null) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        Point point = new Point(0, 0);
        for (Diff diff : this.fAllDiffs) {
            Position position = diff.getPosition(mergeSourceViewer);
            mergeSourceViewer.getLineRange(position, point);
            int n4 = point.y;
            int n5 = diff.getMaxDiffHeight();
            if (n <= n2 + n4) {
                n -= n2;
                n = n4 <= 0 ? 0 : n * n5 / n4;
                return n3 + n;
            }
            n2 += n4;
            n3 += n5;
        }
        return n3;
    }

    private void scrollVertical(int n, int n2, int n3, MergeSourceViewer mergeSourceViewer) {
        Control control;
        int n4;
        int n5 = 0;
        if (this.fSynchronizedScrolling) {
            n5 = this.getVirtualHeight() - n3;
            n4 = this.fRight.getViewportLines() / 4;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 > n4) {
                n5 = n4;
            }
        }
        this.fInScrolling = true;
        if (this.isThreeWay() && mergeSourceViewer != this.fAncestor && (this.fSynchronizedScrolling || mergeSourceViewer == null)) {
            n4 = this.virtualToRealPosition(this.fAncestor, n + n5) - n5;
            this.fAncestor.vscroll(n4);
        }
        if (mergeSourceViewer != this.fLeft && (this.fSynchronizedScrolling || mergeSourceViewer == null)) {
            n4 = this.virtualToRealPosition(this.fLeft, n2 + n5) - n5;
            this.fLeft.vscroll(n4);
        }
        if (mergeSourceViewer != this.fRight && (this.fSynchronizedScrolling || mergeSourceViewer == null)) {
            n4 = this.virtualToRealPosition(this.fRight, n3 + n5) - n5;
            this.fRight.vscroll(n4);
        }
        this.fInScrolling = false;
        if (this.isThreeWay() && this.fAncestorCanvas != null) {
            this.fAncestorCanvas.repaint();
        }
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.repaint();
        }
        if ((control = this.getCenterControl()) instanceof BufferedCanvas) {
            ((BufferedCanvas)control).repaint();
        }
        if (this.fRightCanvas != null) {
            this.fRightCanvas.repaint();
        }
    }

    private void syncViewport(MergeSourceViewer mergeSourceViewer) {
        if (this.fInScrolling) {
            return;
        }
        int n = mergeSourceViewer.getTopIndex();
        int n2 = mergeSourceViewer.getDocumentRegionOffset();
        int n3 = this.realToVirtualPosition(mergeSourceViewer, n - n2);
        this.scrollVertical(n3, n3, n3, mergeSourceViewer);
        if (this.fVScrollBar != null) {
            int n4 = Math.max(0, Math.min(n3, this.getVirtualHeight() - this.getViewportHeight()));
            this.fVScrollBar.setSelection(n4);
        }
    }

    private void updateVScrollBar() {
        if (Utilities.okToUse((Widget)this.fVScrollBar) && this.fSynchronizedScrolling) {
            int n = this.getVirtualHeight();
            int n2 = this.getViewportHeight();
            int n3 = n2 - 1;
            int n4 = n2 > n ? n : n2;
            this.fVScrollBar.setPageIncrement(n3);
            this.fVScrollBar.setMaximum(n);
            this.fVScrollBar.setThumb(n4);
        }
    }

    private int virtualToRealPosition(MergeSourceViewer mergeSourceViewer, int n) {
        if (!this.fSynchronizedScrolling || this.fAllDiffs == null) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        Point point = new Point(0, 0);
        for (Diff diff : this.fAllDiffs) {
            Position position = diff.getPosition(mergeSourceViewer);
            int n4 = mergeSourceViewer.getLineRange((Position)position, (Point)point).y;
            int n5 = diff.getMaxDiffHeight();
            if (n < n2 + n5) {
                n -= n2;
                n = n4 <= 0 ? 0 : (int)((double)n * ((double)n4 / (double)n5));
                return n3 + n;
            }
            n2 += n5;
            n3 += n4;
        }
        return n3;
    }

    protected void flushContent(Object object, IProgressMonitor iProgressMonitor) {
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        Object object2 = iMergeViewerContentProvider.getLeftContent(object);
        Object object3 = iMergeViewerContentProvider.getRightContent(object);
        if (object2 != null && this.getCompareConfiguration().isLeftEditable() && this.isLeftDirty() && this.fLeftContributor.hasSharedDocument(object2) && this.flush(this.fLeftContributor)) {
            this.setLeftDirty(false);
        }
        if (object3 != null && this.getCompareConfiguration().isRightEditable() && this.isRightDirty() && this.fRightContributor.hasSharedDocument(object3) && this.flush(this.fRightContributor)) {
            this.setRightDirty(false);
        }
        if (!(iMergeViewerContentProvider instanceof MergeViewerContentProvider) || this.isLeftDirty() || this.isRightDirty()) {
            super.flushContent(object, iProgressMonitor);
        }
    }

    private boolean flush(ContributorInfo contributorInfo) {
        try {
            return contributorInfo.flush();
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
            return false;
        }
    }

    private void handleException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            this.handleException(invocationTargetException.getTargetException());
            return;
        }
        CompareUIPlugin.log((Throwable)throwable);
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IMergeViewerTestAdapter.class) {
            return new IMergeViewerTestAdapter(){

                public IDocument getDocument(char c) {
                    switch (c) {
                        case 'L': {
                            return TextMergeViewer.this.fLeft.getDocument();
                        }
                        case 'R': {
                            return TextMergeViewer.this.fRight.getDocument();
                        }
                        case 'A': {
                            return TextMergeViewer.this.fAncestor.getDocument();
                        }
                    }
                    return null;
                }
            };
        }
        if (clazz == OutlineViewerCreator.class) {
            if (this.fOutlineViewerCreator == null) {
                this.fOutlineViewerCreator = new InternalOutlineViewerCreator();
            }
            return this.fOutlineViewerCreator;
        }
        if (clazz == IFindReplaceTarget.class) {
            return this.getFindReplaceTarget();
        }
        if (clazz == CompareHandlerService.class) {
            return this.fHandlerService;
        }
        return null;
    }

    protected void handleCompareInputChange() {
        try {
            this.beginRefresh();
            super.handleCompareInputChange();
        }
        finally {
            this.endRefresh();
        }
    }

    private void beginRefresh() {
        this.isRefreshing = true;
        this.fLeftContributor.cacheSelection(this.fLeft);
        this.fRightContributor.cacheSelection(this.fRight);
        this.fAncestorContributor.cacheSelection(this.fAncestor);
        if (this.fSynchronizedScrolling) {
            this.fSynchronziedScrollPosition = this.fVScrollBar.getSelection();
        }
    }

    private void endRefresh() {
        this.isRefreshing = false;
        this.fLeftContributor.cacheSelection(null);
        this.fRightContributor.cacheSelection(null);
        this.fAncestorContributor.cacheSelection(null);
        this.fSynchronziedScrollPosition = -1;
    }

    private void synchronizedScrollVertical(int n) {
        this.scrollVertical(n, n, n, null);
        this.workaround65205();
    }

    private boolean isIgnoreAncestor() {
        return Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)ICompareUIConstants.PROP_IGNORE_ANCESTOR, (boolean)false);
    }

    void update(boolean bl) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fHasErrors) {
            this.resetDiffs();
        } else {
            this.doDiff();
        }
        if (bl) {
            this.updateControls();
        }
        this.updateVScrollBar();
        this.updatePresentation(null);
    }

    private void resetDiffs() {
        this.fCurrentDiff = null;
        this.fChangeDiffs = null;
        this.fAllDiffs = null;
        this.resetPositions(this.fLeft.getDocument());
        this.resetPositions(this.fRight.getDocument());
        this.resetPositions(this.fAncestor.getDocument());
    }

    private boolean isPatchHunk() {
        return Utilities.isHunk((Object)this.getInput());
    }

    private int getHunkStart() {
        Object object = this.getInput();
        if (object != null && object instanceof DiffNode) {
            Object object2;
            Object object3;
            ITypedElement iTypedElement = ((DiffNode)object).getRight();
            if (iTypedElement != null && (object3 = Utilities.getAdapter((Object)iTypedElement, IHunk.class)) instanceof IHunk) {
                return ((IHunk)object3).getStartPosition();
            }
            object3 = ((DiffNode)object).getLeft();
            if (object3 != null && (object2 = Utilities.getAdapter((Object)object3, IHunk.class)) instanceof IHunk) {
                return ((IHunk)object2).getStartPosition();
            }
        }
        return 0;
    }

    private IFindReplaceTarget getFindReplaceTarget() {
        if (this.fFindReplaceTarget == null) {
            this.fFindReplaceTarget = new FindReplaceTarget();
        }
        return this.fFindReplaceTarget;
    }

    private class ChangeHighlighter
    implements ITextPresentationListener {
        private final MergeSourceViewer viewer;

        public ChangeHighlighter(MergeSourceViewer mergeSourceViewer) {
            this.viewer = mergeSourceViewer;
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            if (!TextMergeViewer.this.fHighlightTokenChanges) {
                return;
            }
            IRegion iRegion = textPresentation.getExtent();
            Diff[] diffArray = this.getChangeDiffs(iRegion);
            int n = 0;
            while (n < diffArray.length) {
                Diff diff = diffArray[n];
                StyleRange styleRange = this.getStyleRange(diff, iRegion);
                if (styleRange != null) {
                    textPresentation.mergeStyleRange(styleRange);
                }
                ++n;
            }
        }

        private StyleRange getStyleRange(Diff diff, IRegion iRegion) {
            return diff.getStyleRange(this.viewer, iRegion);
        }

        private Diff[] getChangeDiffs(IRegion iRegion) {
            if (TextMergeViewer.this.fChangeDiffs == null) {
                return new Diff[0];
            }
            ArrayList<Diff> arrayList = new ArrayList<Diff>();
            for (Diff diff : TextMergeViewer.this.fChangeDiffs) {
                Diff[] diffArray = diff.getChangeDiffs(this.viewer, iRegion);
                int n = 0;
                while (n < diffArray.length) {
                    Diff diff2 = diffArray[n];
                    arrayList.add(diff2);
                    ++n;
                }
            }
            return arrayList.toArray(new Diff[arrayList.size()]);
        }
    }

    class ChildPositionUpdater
    extends DefaultPositionUpdater {
        protected ChildPositionUpdater(String string) {
            super(string);
        }

        protected boolean notDeleted() {
            return true;
        }

        protected void adaptToInsert() {
            if (this.fPosition == TextMergeViewer.this.fLeft.getRegion() || this.fPosition == TextMergeViewer.this.fRight.getRegion()) {
                int n = this.fPosition.offset;
                int n2 = this.fPosition.offset + this.fPosition.length;
                n2 = Math.max(n, n2);
                int n3 = this.fOffset;
                int n4 = this.fOffset + this.fReplaceLength - 1;
                n4 = Math.max(n3, n4);
                if (n2 < n3) {
                    return;
                }
                if (n <= n3) {
                    this.fPosition.length += this.fReplaceLength;
                } else {
                    this.fPosition.offset += this.fReplaceLength;
                }
            } else {
                super.adaptToInsert();
            }
        }
    }

    class ContributorInfo
    implements IElementStateListener,
    VerifyListener,
    IDocumentListener {
        private final TextMergeViewer fViewer;
        private final Object fElement;
        private char fLeg;
        private String fEncoding;
        private IDocumentProvider fDocumentProvider;
        private IEditorInput fDocumentKey;
        private ISelection fSelection;
        private int fTopIndex = -1;
        private boolean fNeedsValidation = false;
        private MergeSourceViewer fSourceViewer;

        public ContributorInfo(TextMergeViewer textMergeViewer2, Object object, char c) {
            this.fViewer = textMergeViewer2;
            this.fElement = object;
            this.fLeg = c;
            if (this.fElement instanceof IEncodedStreamContentAccessor) {
                try {
                    this.fEncoding = ((IEncodedStreamContentAccessor)this.fElement).getCharset();
                }
                catch (CoreException coreException) {}
            }
        }

        public String getEncoding() {
            if (this.fEncoding == null) {
                return ResourcesPlugin.getEncoding();
            }
            return this.fEncoding;
        }

        public void setEncodingIfAbsent(ContributorInfo contributorInfo) {
            if (this.fEncoding == null) {
                this.fEncoding = contributorInfo.fEncoding;
            }
        }

        public IDocument getDocument() {
            IDocument iDocument;
            if (this.fDocumentProvider != null && (iDocument = this.fDocumentProvider.getDocument((Object)this.getDocumentKey())) != null) {
                return iDocument;
            }
            if (this.fElement instanceof IDocument) {
                return (IDocument)this.fElement;
            }
            if (this.fElement instanceof IDocumentRange) {
                return ((IDocumentRange)this.fElement).getDocument();
            }
            if (this.fElement instanceof IStreamContentAccessor) {
                return DocumentManager.get((Object)this.fElement);
            }
            return null;
        }

        public void setDocument(MergeSourceViewer mergeSourceViewer, boolean bl) {
            Assert.isTrue((this.fSourceViewer == null ? 1 : 0) != 0);
            this.fSourceViewer = mergeSourceViewer;
            try {
                this.internalSetDocument(mergeSourceViewer);
            }
            catch (RuntimeException runtimeException) {
                this.clearCachedDocument();
                throw runtimeException;
            }
            mergeSourceViewer.setEditable(bl);
            if (bl) {
                this.fNeedsValidation = true;
                mergeSourceViewer.getTextWidget().addVerifyListener((VerifyListener)this);
            }
        }

        private boolean internalSetDocument(MergeSourceViewer mergeSourceViewer) {
            Object object;
            if (mergeSourceViewer == null) {
                return false;
            }
            IDocument iDocument = null;
            Position position = null;
            if (this.fElement instanceof IDocumentRange) {
                iDocument = ((IDocumentRange)this.fElement).getDocument();
                position = ((IDocumentRange)this.fElement).getRange();
                this.connectToSharedDocument();
            } else if (this.fElement instanceof IDocument) {
                iDocument = (IDocument)this.fElement;
            } else if (this.fElement instanceof IStreamContentAccessor) {
                iDocument = DocumentManager.get((Object)this.fElement);
                if (iDocument == null) {
                    iDocument = this.createDocument();
                    DocumentManager.put((Object)this.fElement, (IDocument)iDocument);
                    TextMergeViewer.this.setupDocument(iDocument);
                } else if (this.fDocumentProvider == null) {
                    this.connectToSharedDocument();
                }
            } else if (this.fElement == null) {
                ITypedElement iTypedElement = this.fViewer.getParent(this.fLeg);
                if (iTypedElement instanceof IDocumentRange) {
                    iDocument = ((IDocumentRange)iTypedElement).getDocument();
                    iDocument.addPositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
                    object = this.fViewer.getInput();
                    position = this.fViewer.getNewRange(this.fLeg, object);
                    if (position == null) {
                        int n = 0;
                        if (object instanceof ICompareInput) {
                            n = this.fViewer.findInsertionPosition(this.fLeg, (ICompareInput)object);
                        }
                        position = new Position(n, 0);
                        try {
                            iDocument.addPosition(TextMergeViewer.DIFF_RANGE_CATEGORY, position);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                        }
                        catch (BadLocationException badLocationException) {}
                        this.fViewer.addNewRange(this.fLeg, object, position);
                    }
                } else if (iTypedElement instanceof IDocument) {
                    iDocument = ((IDocumentRange)this.fElement).getDocument();
                }
            }
            boolean bl = true;
            if (iDocument == null) {
                iDocument = new Document("");
                bl = false;
            }
            if (iDocument != (object = mergeSourceViewer.getDocument())) {
                this.updateViewerDocument(mergeSourceViewer, iDocument, position);
            } else {
                this.updateViewerDocumentRange(mergeSourceViewer, position);
            }
            iDocument.addDocumentListener((IDocumentListener)this);
            mergeSourceViewer.setEnabled(bl);
            return bl;
        }

        private void updateViewerDocumentRange(MergeSourceViewer mergeSourceViewer, Position position) {
            mergeSourceViewer.setRegion(position);
            if (this.fViewer.fSubDoc) {
                if (position != null) {
                    IRegion iRegion = this.fViewer.normalizeDocumentRegion(mergeSourceViewer.getDocument(), TextMergeViewer.toRegion(position));
                    mergeSourceViewer.setVisibleRegion(iRegion.getOffset(), iRegion.getLength());
                } else {
                    mergeSourceViewer.resetVisibleRegion();
                }
            } else {
                mergeSourceViewer.resetVisibleRegion();
            }
        }

        private void updateViewerDocument(MergeSourceViewer mergeSourceViewer, IDocument iDocument, Position position) {
            this.unsetDocument(mergeSourceViewer);
            if (iDocument == null) {
                return;
            }
            iDocument.addPositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
            if (this.fViewer.fPositionUpdater == null) {
                TextMergeViewer textMergeViewer = this.fViewer;
                ((Object)((Object)textMergeViewer)).getClass();
                this.fViewer.fPositionUpdater = (IPositionUpdater)textMergeViewer.new ChildPositionUpdater(TextMergeViewer.DIFF_RANGE_CATEGORY);
            } else {
                iDocument.removePositionUpdater(this.fViewer.fPositionUpdater);
            }
            iDocument.addPositionUpdater(this.fViewer.fPositionUpdater);
            mergeSourceViewer.setRegion(position);
            if (this.fViewer.fSubDoc) {
                if (position != null) {
                    IRegion iRegion = this.fViewer.normalizeDocumentRegion(iDocument, TextMergeViewer.toRegion(position));
                    mergeSourceViewer.setDocument(iDocument, iRegion.getOffset(), iRegion.getLength());
                } else {
                    mergeSourceViewer.setDocument(iDocument);
                }
            } else {
                mergeSourceViewer.setDocument(iDocument);
            }
            mergeSourceViewer.rememberDocument(iDocument);
        }

        private void unsetDocument(MergeSourceViewer mergeSourceViewer) {
            IDocument iDocument = this.internalGetDocument(mergeSourceViewer);
            if (iDocument != null) {
                mergeSourceViewer.rememberDocument(null);
                try {
                    iDocument.removePositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                if (TextMergeViewer.this.fPositionUpdater != null) {
                    iDocument.removePositionUpdater(TextMergeViewer.this.fPositionUpdater);
                }
                iDocument.removeDocumentListener((IDocumentListener)this);
            }
        }

        private IDocument createDocument() {
            IDocument iDocument = this.connectToSharedDocument();
            if (iDocument == null) {
                String string;
                IStreamContentAccessor iStreamContentAccessor = (IStreamContentAccessor)this.fElement;
                String string2 = null;
                try {
                    string = this.getEncoding();
                    string2 = Utilities.readString((IStreamContentAccessor)iStreamContentAccessor, (String)string);
                }
                catch (CoreException coreException) {
                    this.fViewer.setError(this.fLeg, coreException.getMessage());
                }
                iDocument = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)new PhpSourceParser());
                iDocument.set(string2 != null ? string2 : "");
                string = TextMergeViewer.this.getDocumentPartitioner();
                if (string != null) {
                    if (iDocument instanceof JobSafeStructuredDocument) {
                        ((JobSafeStructuredDocument)iDocument).setDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning", (IDocumentPartitioner)string);
                    } else {
                        iDocument.setDocumentPartitioner((IDocumentPartitioner)string);
                    }
                    string.connect(iDocument);
                }
            }
            return iDocument;
        }

        private IDocument connectToSharedDocument() {
            IEditorInput iEditorInput = this.getDocumentKey();
            if (iEditorInput != null) {
                if (this.fDocumentProvider != null) {
                    return this.fDocumentProvider.getDocument((Object)iEditorInput);
                }
                IDocumentProvider iDocumentProvider = this.getDocumentProvider();
                if (iDocumentProvider != null) {
                    try {
                        this.connect(iDocumentProvider, iEditorInput);
                        this.setCachedDocumentProvider(iEditorInput, iDocumentProvider);
                        IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
                        this.fViewer.updateDirtyState(iEditorInput, iDocumentProvider, this.fLeg);
                        return iDocument;
                    }
                    catch (CoreException coreException) {
                        CompareUIPlugin.log((Throwable)coreException);
                    }
                }
            }
            return null;
        }

        private void connect(IDocumentProvider iDocumentProvider, IEditorInput iEditorInput) throws CoreException {
            ISharedDocumentAdapter iSharedDocumentAdapter = (ISharedDocumentAdapter)Utilities.getAdapter((Object)this.fElement, ISharedDocumentAdapter.class);
            if (iSharedDocumentAdapter != null) {
                iSharedDocumentAdapter.connect(iDocumentProvider, iEditorInput);
            } else {
                iDocumentProvider.connect((Object)iEditorInput);
            }
        }

        private void disconnect(IDocumentProvider iDocumentProvider, IEditorInput iEditorInput) {
            ISharedDocumentAdapter iSharedDocumentAdapter = (ISharedDocumentAdapter)Utilities.getAdapter((Object)this.fElement, ISharedDocumentAdapter.class);
            if (iSharedDocumentAdapter != null) {
                iSharedDocumentAdapter.disconnect(iDocumentProvider, iEditorInput);
            } else {
                iDocumentProvider.disconnect((Object)iEditorInput);
            }
        }

        private void setCachedDocumentProvider(IEditorInput iEditorInput, IDocumentProvider iDocumentProvider) {
            this.fDocumentKey = iEditorInput;
            this.fDocumentProvider = iDocumentProvider;
            iDocumentProvider.addElementStateListener((IElementStateListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            IDocumentProvider iDocumentProvider = null;
            IEditorInput iEditorInput = this.getDocumentKey();
            ContributorInfo contributorInfo = this;
            synchronized (contributorInfo) {
                if (this.fDocumentProvider != null) {
                    iDocumentProvider = this.fDocumentProvider;
                    this.fDocumentProvider = null;
                    this.fDocumentKey = null;
                }
            }
            if (iDocumentProvider != null) {
                this.disconnect(iDocumentProvider, iEditorInput);
                iDocumentProvider.removeElementStateListener((IElementStateListener)this);
            }
            if (this.fSourceViewer != null && !this.fSourceViewer.getTextWidget().isDisposed()) {
                if (this.fNeedsValidation) {
                    this.fSourceViewer.getTextWidget().removeVerifyListener((VerifyListener)this);
                    this.fNeedsValidation = false;
                }
                if ((contributorInfo = this.internalGetDocument(this.fSourceViewer)) != null) {
                    contributorInfo.removeDocumentListener(this);
                }
            }
            this.clearCachedDocument();
        }

        private void clearCachedDocument() {
            IDocument iDocument = DocumentManager.get((Object)this.fElement);
            if (iDocument != null) {
                DocumentManager.remove((IDocument)iDocument);
            }
        }

        private IDocument internalGetDocument(MergeSourceViewer mergeSourceViewer) {
            IDocument iDocument = mergeSourceViewer.getDocument();
            if (iDocument == null) {
                iDocument = mergeSourceViewer.getRememberedDocument();
            }
            return iDocument;
        }

        private IEditorInput getDocumentKey() {
            ISharedDocumentAdapter iSharedDocumentAdapter;
            if (this.fDocumentKey != null) {
                return this.fDocumentKey;
            }
            if (this.isUsingDefaultContentProvider() && this.fElement != null && this.canHaveSharedDocument() && (iSharedDocumentAdapter = (ISharedDocumentAdapter)Utilities.getAdapter((Object)this.fElement, ISharedDocumentAdapter.class, (boolean)true)) != null) {
                return iSharedDocumentAdapter.getDocumentKey(this.fElement);
            }
            return null;
        }

        private IDocumentProvider getDocumentProvider() {
            IEditorInput iEditorInput;
            if (this.fDocumentProvider != null) {
                return this.fDocumentProvider;
            }
            if (this.isUsingDefaultContentProvider() && (iEditorInput = this.getDocumentKey()) != null) {
                return SharedDocumentAdapter.getDocumentProvider((IEditorInput)iEditorInput);
            }
            return null;
        }

        private boolean isUsingDefaultContentProvider() {
            return this.fViewer.isUsingDefaultContentProvider();
        }

        private boolean canHaveSharedDocument() {
            return this.fViewer.canHaveSharedDocument();
        }

        boolean hasSharedDocument(Object object) {
            return this.fElement == object && this.fDocumentProvider != null && this.fDocumentProvider.getDocument((Object)this.getDocumentKey()) != null;
        }

        public boolean flush() throws CoreException {
            IEditorInput iEditorInput;
            IDocument iDocument;
            if (this.fDocumentProvider != null && (iDocument = this.fDocumentProvider.getDocument((Object)(iEditorInput = this.getDocumentKey()))) != null) {
                ISharedDocumentAdapter iSharedDocumentAdapter = (ISharedDocumentAdapter)Utilities.getAdapter((Object)this.fElement, ISharedDocumentAdapter.class);
                if (iSharedDocumentAdapter != null) {
                    iSharedDocumentAdapter.flushDocument(this.fDocumentProvider, iEditorInput, iDocument, false);
                    return true;
                }
                try {
                    this.fDocumentProvider.aboutToChange((Object)iEditorInput);
                    this.fDocumentProvider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)iEditorInput, iDocument, false);
                    return true;
                }
                finally {
                    this.fDocumentProvider.changed((Object)iEditorInput);
                }
            }
            return false;
        }

        public void elementMoved(Object object, Object object2) {
            IEditorInput iEditorInput = this.getDocumentKey();
            if (iEditorInput != null && iEditorInput.equals(object)) {
                this.resetDocument();
            }
        }

        public void elementDirtyStateChanged(Object object, boolean bl) {
            if (!this.checkState()) {
                return;
            }
            IEditorInput iEditorInput = this.getDocumentKey();
            if (iEditorInput != null && iEditorInput.equals(object)) {
                this.fViewer.updateDirtyState(iEditorInput, this.getDocumentProvider(), this.fLeg);
            }
        }

        public void elementDeleted(Object object) {
            IEditorInput iEditorInput = this.getDocumentKey();
            if (iEditorInput != null && iEditorInput.equals(object)) {
                this.resetDocument();
            }
        }

        private void resetDocument() {
            this.clearCachedDocument();
            if (this.checkState()) {
                this.fViewer.refresh();
            }
        }

        private boolean checkState() {
            if (this.fViewer == null) {
                return false;
            }
            Control control = this.fViewer.getControl();
            if (control == null) {
                return false;
            }
            return !control.isDisposed();
        }

        public void elementContentReplaced(Object object) {
            if (!this.checkState()) {
                return;
            }
            IEditorInput iEditorInput = this.getDocumentKey();
            if (iEditorInput != null && iEditorInput.equals(object)) {
                this.fViewer.updateDirtyState(iEditorInput, this.getDocumentProvider(), this.fLeg);
            }
        }

        public void elementContentAboutToBeReplaced(Object object) {
        }

        public Object getElement() {
            return this.fElement;
        }

        public void cacheSelection(MergeSourceViewer mergeSourceViewer) {
            if (mergeSourceViewer == null) {
                this.fSelection = null;
                this.fTopIndex = -1;
            } else {
                this.fSelection = mergeSourceViewer.getSelection();
                this.fTopIndex = mergeSourceViewer.getTopIndex();
            }
        }

        public void updateSelection(MergeSourceViewer mergeSourceViewer, boolean bl) {
            if (this.fSelection != null) {
                mergeSourceViewer.setSelection(this.fSelection);
            }
            if (bl && this.fTopIndex != -1) {
                mergeSourceViewer.setTopIndex(this.fTopIndex);
            }
        }

        public void transferContributorStateFrom(ContributorInfo contributorInfo) {
            if (contributorInfo != null) {
                this.fSelection = contributorInfo.fSelection;
                this.fTopIndex = contributorInfo.fTopIndex;
            }
        }

        public boolean validateChange() {
            IStatus iStatus;
            if (this.fElement == null) {
                return true;
            }
            if (this.fDocumentProvider instanceof IDocumentProviderExtension) {
                IDocumentProviderExtension iDocumentProviderExtension = (IDocumentProviderExtension)this.fDocumentProvider;
                if (iDocumentProviderExtension.isReadOnly((Object)this.fDocumentKey)) {
                    try {
                        iDocumentProviderExtension.validateState((Object)this.fDocumentKey, (Object)TextMergeViewer.this.getControl().getShell());
                        iDocumentProviderExtension.updateStateCache((Object)this.fDocumentKey);
                    }
                    catch (CoreException coreException) {
                        ErrorDialog.openError((Shell)TextMergeViewer.this.getControl().getShell(), (String)CompareMessages.TextMergeViewer_12, (String)CompareMessages.TextMergeViewer_13, (IStatus)coreException.getStatus());
                        return false;
                    }
                }
                return !iDocumentProviderExtension.isReadOnly((Object)this.fDocumentKey);
            }
            IEditableContentExtension iEditableContentExtension = (IEditableContentExtension)Utilities.getAdapter((Object)this.fElement, IEditableContentExtension.class);
            if (iEditableContentExtension != null && iEditableContentExtension.isReadOnly() && !(iStatus = iEditableContentExtension.validateEdit(TextMergeViewer.this.getControl().getShell())).isOK()) {
                if (iStatus.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)TextMergeViewer.this.getControl().getShell(), (String)CompareMessages.TextMergeViewer_14, (String)CompareMessages.TextMergeViewer_15, (IStatus)iStatus);
                    return false;
                }
                if (iStatus.getSeverity() == 8) {
                    return false;
                }
            }
            return true;
        }

        public void verifyText(VerifyEvent verifyEvent) {
            if (!this.validateChange()) {
                verifyEvent.doit = false;
            }
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            boolean bl = true;
            if (this.fDocumentProvider != null && this.fDocumentKey != null) {
                bl = this.fDocumentProvider.canSaveDocument((Object)this.fDocumentKey);
            }
            TextMergeViewer.this.documentChanged(documentEvent, bl);
            if (this.fNeedsValidation && this.fSourceViewer != null && !this.fSourceViewer.getTextWidget().isDisposed()) {
                this.fSourceViewer.getTextWidget().removeVerifyListener((VerifyListener)this);
                this.fNeedsValidation = false;
            }
        }
    }

    class Diff {
        Position fAncestorPos;
        Position fLeftPos;
        Position fRightPos;
        Diff fParent;
        boolean fResolved;
        int fDirection;
        boolean fIsToken = false;
        ArrayList fDiffs;
        boolean fIsWhitespace = false;

        Diff(Diff diff, int n, IDocument iDocument, Position position, int n2, int n3, IDocument iDocument2, Position position2, int n4, int n5, IDocument iDocument3, Position position3, int n6, int n7) {
            this.fParent = diff != null ? diff : this;
            this.fDirection = n;
            this.fLeftPos = this.createPosition(iDocument2, position2, n4, n5);
            this.fRightPos = this.createPosition(iDocument3, position3, n6, n7);
            if (iDocument != null) {
                this.fAncestorPos = this.createPosition(iDocument, position, n2, n3);
            }
        }

        Position getPosition(char c) {
            switch (c) {
                case 'A': {
                    return this.fAncestorPos;
                }
                case 'L': {
                    return this.fLeftPos;
                }
                case 'R': {
                    return this.fRightPos;
                }
            }
            return null;
        }

        boolean isInRange(char c, int n) {
            Position position = this.getPosition(c);
            return n >= position.offset && n < position.offset + position.length;
        }

        String changeType() {
            boolean bl;
            boolean bl2 = this.fLeftPos.length == 0;
            boolean bl3 = bl = this.fRightPos.length == 0;
            if (this.fDirection == 3) {
                if (!bl2 && bl) {
                    return CompareMessages.TextMergeViewer_changeType_addition;
                }
                if (bl2 && !bl) {
                    return CompareMessages.TextMergeViewer_changeType_deletion;
                }
            } else {
                if (bl2 && !bl) {
                    return CompareMessages.TextMergeViewer_changeType_addition;
                }
                if (!bl2 && bl) {
                    return CompareMessages.TextMergeViewer_changeType_deletion;
                }
            }
            return CompareMessages.TextMergeViewer_changeType_change;
        }

        Image getImage() {
            int n = 3;
            switch (this.fDirection) {
                case 2: {
                    n += 4;
                    break;
                }
                case 3: {
                    n += 8;
                    break;
                }
                case 1: 
                case 4: {
                    n += 12;
                }
            }
            if (n != 0) {
                return TextMergeViewer.this.getCompareConfiguration().getImage(n);
            }
            return null;
        }

        Position createPosition(IDocument iDocument, Position position, int n, int n2) {
            try {
                int n3;
                int n4 = n2 - n;
                if (position != null) {
                    n3 = position.length;
                    if (n4 > n3) {
                        n4 = n3;
                    }
                } else {
                    n3 = iDocument.getLength();
                    if (n + n4 > n3) {
                        n4 = n3 - n;
                    }
                }
                Position position2 = null;
                try {
                    position2 = new Position(n, n4);
                }
                catch (RuntimeException runtimeException) {
                    position2 = new Position(0, 0);
                }
                try {
                    iDocument.addPosition(TextMergeViewer.DIFF_RANGE_CATEGORY, position2);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                return position2;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        void add(Diff diff) {
            if (this.fDiffs == null) {
                this.fDiffs = new ArrayList();
            }
            this.fDiffs.add(diff);
        }

        boolean isDeleted() {
            if (this.fAncestorPos != null && this.fAncestorPos.isDeleted()) {
                return true;
            }
            return this.fLeftPos.isDeleted() || this.fRightPos.isDeleted();
        }

        void setResolved(boolean bl) {
            this.fResolved = bl;
            if (bl) {
                this.fDiffs = null;
            }
        }

        boolean isResolved() {
            if (!this.fResolved && this.fDiffs != null) {
                for (Diff diff : this.fDiffs) {
                    if (diff.isResolved()) continue;
                    return false;
                }
                return true;
            }
            return this.fResolved;
        }

        private boolean isIncomingOrConflicting() {
            switch (this.fDirection) {
                case 2: {
                    if (!TextMergeViewer.this.fLeftIsLocal) break;
                    return true;
                }
                case 3: {
                    if (TextMergeViewer.this.fLeftIsLocal) break;
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private boolean isUnresolvedIncomingOrConflicting() {
            if (this.fResolved) {
                return false;
            }
            return this.isIncomingOrConflicting();
        }

        Position getPosition(MergeSourceViewer mergeSourceViewer) {
            if (mergeSourceViewer == TextMergeViewer.this.fLeft) {
                return this.fLeftPos;
            }
            if (mergeSourceViewer == TextMergeViewer.this.fRight) {
                return this.fRightPos;
            }
            if (mergeSourceViewer == TextMergeViewer.this.fAncestor) {
                return this.fAncestorPos;
            }
            return null;
        }

        boolean overlaps(MergeSourceViewer mergeSourceViewer, int n, int n2) {
            int n3;
            int n4;
            Position position = this.getPosition(mergeSourceViewer);
            return position != null && n < (n4 = (n3 = position.getOffset()) + position.getLength()) && n2 >= n3;
        }

        int getMaxDiffHeight() {
            Point point = new Point(0, 0);
            int n = ((TextMergeViewer)TextMergeViewer.this).fLeft.getLineRange((Position)this.fLeftPos, (Point)point).y;
            if (TextMergeViewer.this.isThreeWay()) {
                n = Math.max(n, ((TextMergeViewer)TextMergeViewer.this).fAncestor.getLineRange((Position)this.fAncestorPos, (Point)point).y);
            }
            return Math.max(n, ((TextMergeViewer)TextMergeViewer.this).fRight.getLineRange((Position)this.fRightPos, (Point)point).y);
        }

        int getAncestorHeight() {
            Point point = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fAncestor.getLineRange((Position)this.fAncestorPos, (Point)point).y;
        }

        int getLeftHeight() {
            Point point = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fLeft.getLineRange((Position)this.fLeftPos, (Point)point).y;
        }

        int getRightHeight() {
            Point point = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fRight.getLineRange((Position)this.fRightPos, (Point)point).y;
        }

        public Diff[] getChangeDiffs(MergeSourceViewer mergeSourceViewer, IRegion iRegion) {
            if (this.fDiffs != null && this.intersectsRegion(mergeSourceViewer, iRegion)) {
                ArrayList<Diff> arrayList = new ArrayList<Diff>();
                for (Diff diff : this.fDiffs) {
                    if (!diff.intersectsRegion(mergeSourceViewer, iRegion)) continue;
                    arrayList.add(diff);
                }
                return arrayList.toArray(new Diff[arrayList.size()]);
            }
            return new Diff[0];
        }

        private boolean intersectsRegion(MergeSourceViewer mergeSourceViewer, IRegion iRegion) {
            Position position = this.getPosition(mergeSourceViewer);
            if (position != null) {
                return position.overlapsWith(iRegion.getOffset(), iRegion.getLength());
            }
            return false;
        }

        public StyleRange getStyleRange(MergeSourceViewer mergeSourceViewer, IRegion iRegion) {
            int n;
            Color color = TextMergeViewer.this.getColor(null, this.getTextFillColor());
            if (color == null) {
                return null;
            }
            Position position = this.getPosition(mergeSourceViewer);
            int n2 = position.getOffset();
            int n3 = position.getLength();
            if (n2 < iRegion.getOffset()) {
                n3 -= iRegion.getOffset() - n2;
                n2 = iRegion.getOffset();
            }
            if (n2 + n3 > (n = iRegion.getOffset() + iRegion.getLength())) {
                n3 = n - n2;
            }
            if (n3 < 0) {
                return null;
            }
            return new StyleRange(n2, n3, null, color);
        }

        private RGB getTextFillColor() {
            if (TextMergeViewer.this.isThreeWay() && !TextMergeViewer.this.isIgnoreAncestor()) {
                switch (this.fDirection) {
                    case 2: {
                        if (TextMergeViewer.this.fLeftIsLocal) {
                            return TextMergeViewer.this.INCOMING_TEXT_FILL;
                        }
                        return TextMergeViewer.this.OUTGOING_TEXT_FILL;
                    }
                    case 4: {
                        return TextMergeViewer.this.CONFLICT_TEXT_FILL;
                    }
                    case 3: {
                        if (TextMergeViewer.this.fLeftIsLocal) {
                            return TextMergeViewer.this.OUTGOING_TEXT_FILL;
                        }
                        return TextMergeViewer.this.INCOMING_TEXT_FILL;
                    }
                    case 1: {
                        return TextMergeViewer.this.CONFLICT_TEXT_FILL;
                    }
                }
                return null;
            }
            return TextMergeViewer.this.OUTGOING_TEXT_FILL;
        }

        public boolean hasChildren() {
            return this.fDiffs != null && !this.fDiffs.isEmpty();
        }
    }

    private class FindReplaceTarget
    implements IFindReplaceTarget {
        private FindReplaceTarget() {
        }

        public boolean canPerformFind() {
            return TextMergeViewer.this.fFocusPart != null;
        }

        public int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3) {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().findAndSelect(n, string, bl, bl2, bl3);
        }

        public Point getSelection() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().getSelection();
        }

        public String getSelectionText() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().getSelectionText();
        }

        public boolean isEditable() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().isEditable();
        }

        public void replaceSelection(String string) {
            TextMergeViewer.this.fFocusPart.getFindReplaceTarget().replaceSelection(string);
        }
    }

    class HeaderPainter
    implements PaintListener {
        private static final int INSET = 2;
        private RGB fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = TextMergeViewer.this.fSummaryHeader.getDisplay().getSystemColor(18);
        }

        public boolean setColor(RGB rGB) {
            RGB rGB2 = this.fIndicatorColor;
            this.fIndicatorColor = rGB;
            if (rGB == null) {
                return rGB2 != null;
            }
            if (rGB2 != null) {
                return !rGB.equals((Object)rGB2);
            }
            return true;
        }

        private void drawBevelRect(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
            gC.setForeground(color);
            gC.drawLine(n, n2, n + n3 - 1, n2);
            gC.drawLine(n, n2, n, n2 + n4 - 1);
            gC.setForeground(color2);
            gC.drawLine(n + n3, n2, n + n3, n2 + n4);
            gC.drawLine(n, n2 + n4, n + n3, n2 + n4);
        }

        public void paintControl(PaintEvent paintEvent) {
            Point point = TextMergeViewer.this.fSummaryHeader.getSize();
            if (this.fIndicatorColor != null) {
                Display display = TextMergeViewer.this.fSummaryHeader.getDisplay();
                paintEvent.gc.setBackground(TextMergeViewer.this.getColor(display, this.fIndicatorColor));
                int n = Math.min(point.x, point.y) - 4;
                Rectangle rectangle = new Rectangle((point.x - n) / 2, (point.y - n) / 2, n, n);
                paintEvent.gc.fillRectangle(rectangle);
                if (display != null) {
                    this.drawBevelRect(paintEvent.gc, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, display.getSystemColor(18), display.getSystemColor(20));
                }
                paintEvent.gc.setForeground(this.fSeparatorColor);
                paintEvent.gc.setLineWidth(0);
                paintEvent.gc.drawLine(1, point.y - 1, point.x - 1 - 1, point.y - 1);
            }
        }
    }

    class HoverResizer
    extends ContentMergeViewer.Resizer {
        Canvas fCanvas;

        public HoverResizer(Canvas canvas, int n) {
            super((Control)canvas, n);
            this.fCanvas = canvas;
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (!this.fIsDown && TextMergeViewer.this.fUseSingleLine && TextMergeViewer.this.showResolveUI() && TextMergeViewer.this.handleMouseMoveOverCenter(this.fCanvas, mouseEvent.x, mouseEvent.y)) {
                return;
            }
            super.mouseMove(mouseEvent);
        }
    }

    private final class InternalOutlineViewerCreator
    extends OutlineViewerCreator
    implements ISelectionChangedListener {
        private InternalOutlineViewerCreator() {
        }

        public Viewer findStructureViewer(Viewer viewer, ICompareInput iCompareInput, Composite composite, CompareConfiguration compareConfiguration) {
            if (iCompareInput != this.getInput()) {
                return null;
            }
            final Viewer viewer2 = CompareUI.findStructureViewer((Viewer)viewer, (ICompareInput)iCompareInput, (Composite)composite, (CompareConfiguration)compareConfiguration);
            if (viewer2 != null) {
                viewer2.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        viewer2.removeSelectionChangedListener((ISelectionChangedListener)InternalOutlineViewerCreator.this);
                    }
                });
                viewer2.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            return viewer2;
        }

        public boolean hasViewerFor(Object object) {
            return true;
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            IStructuredSelection iStructuredSelection;
            Object object;
            Diff diff;
            ISelection iSelection = selectionChangedEvent.getSelection();
            if (iSelection instanceof IStructuredSelection && (diff = this.findDiff(object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement())) != null) {
                TextMergeViewer.this.setCurrentDiff(diff, true);
            }
        }

        private Diff findDiff(Object object) {
            if (object instanceof ICompareInput) {
                ICompareInput iCompareInput = (ICompareInput)object;
                Position position = this.getPosition(iCompareInput.getLeft());
                if (position != null) {
                    return this.findDiff(position, true);
                }
                position = this.getPosition(iCompareInput.getRight());
                if (position != null) {
                    return this.findDiff(position, false);
                }
            }
            return null;
        }

        private Diff findDiff(Position position, boolean bl) {
            for (Diff diff : TextMergeViewer.this.fAllDiffs) {
                Position position2 = bl ? diff.fLeftPos : diff.fRightPos;
                if (position2.offset + position2.length >= position.offset && diff.fDirection != 0) {
                    return diff;
                }
                if (position2.offset < position.offset) continue;
                return diff;
            }
            return null;
        }

        private Position getPosition(ITypedElement iTypedElement) {
            if (iTypedElement instanceof DocumentRangeNode) {
                DocumentRangeNode documentRangeNode = (DocumentRangeNode)iTypedElement;
                return documentRangeNode.getRange();
            }
            return null;
        }

        public Object getInput() {
            return TextMergeViewer.this.getInput();
        }
    }
}

