/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projection;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.projection.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.php.internal.ui.projection.ProjectionModelNodeAdapterFactoryPHP;
import org.eclipse.php.internal.ui.projection.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.projection.ProjectionModelNodeAdapterPHP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderPHP
implements IStructuredTextFoldingProvider,
IProjectionListener,
ITextInputListener {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.php.ui/projectionperf"));
    private IDocument fDocument;
    private ProjectionViewer fViewer;
    private boolean fProjectionNeedsToBeEnabled = false;
    private final int MAX_CHILDREN = 10;
    private final int MAX_SIBLINGS = 1000;
    private boolean foldingClasses;
    private boolean foldingFunctions;
    private boolean foldingPhpDoc;

    private void addAdapterToNodeAndChildren(Node node, int n) {
        if (node instanceof INodeNotifier && n < 10) {
            INodeNotifier iNodeNotifier = (INodeNotifier)node;
            ProjectionModelNodeAdapterPHP projectionModelNodeAdapterPHP = (ProjectionModelNodeAdapterPHP)iNodeNotifier.getExistingAdapter(ProjectionModelNodeAdapterPHP.class);
            if (projectionModelNodeAdapterPHP != null) {
                projectionModelNodeAdapterPHP.setProvider(this);
                projectionModelNodeAdapterPHP.updateAdapter(node, this.fViewer);
            } else {
                iNodeNotifier.getAdapterFor(ProjectionModelNodeAdapterPHP.class);
            }
            ProjectionModelNodeAdapterHTML projectionModelNodeAdapterHTML = (ProjectionModelNodeAdapterHTML)iNodeNotifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class);
            if (projectionModelNodeAdapterHTML != null) {
                projectionModelNodeAdapterHTML.updateAdapter(node);
            } else {
                iNodeNotifier.getAdapterFor(ProjectionModelNodeAdapterHTML.class);
            }
            int n2 = 0;
            Node node2 = node.getFirstChild();
            while (node2 != null && n2 < 1000) {
                Node node3 = node2;
                node2 = node3.getNextSibling();
                this.addAdapterToNodeAndChildren(node3, n + 1);
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAllAdapters() {
        long l = System.currentTimeMillis();
        if (this.fDocument != null) {
            IStructuredModel iStructuredModel = null;
            try {
                int n;
                IndexedRegion indexedRegion;
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (iStructuredModel != null && (indexedRegion = iStructuredModel.getIndexedRegion(n = 0)) instanceof Node) {
                    int n2 = 0;
                    Node node = (Node)indexedRegion;
                    while (node != null && n2 < 1000) {
                        Node node2 = node;
                        node = node2.getNextSibling();
                        this.addAdapterToNodeAndChildren(node2, 0);
                        ++n2;
                    }
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        if (debugProjectionPerf) {
            long l2 = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderJSP.addAllAdapters: " + (l2 - l));
        }
    }

    private ProjectionModelNodeAdapterFactoryHTML getAdapterFactoryHTML(boolean bl) {
        long l = System.currentTimeMillis();
        ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML = null;
        if (this.fDocument != null) {
            IStructuredModel iStructuredModel = null;
            try {
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (iStructuredModel != null) {
                    FactoryRegistry factoryRegistry = iStructuredModel.getFactoryRegistry();
                    if (!factoryRegistry.contains(ProjectionModelNodeAdapterHTML.class) && bl) {
                        ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML2 = new ProjectionModelNodeAdapterFactoryHTML();
                        factoryRegistry.addFactory((INodeAdapterFactory)projectionModelNodeAdapterFactoryHTML2);
                        IDOMModel iDOMModel = (IDOMModel)iStructuredModel;
                        IDOMDocument iDOMDocument = iDOMModel.getDocument();
                        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)((INodeNotifier)iDOMDocument).getAdapterFor(PropagatingAdapter.class);
                        if (propagatingAdapter != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)projectionModelNodeAdapterFactoryHTML2);
                        }
                    }
                    projectionModelNodeAdapterFactoryHTML = (ProjectionModelNodeAdapterFactoryHTML)factoryRegistry.getFactoryFor(ProjectionModelNodeAdapterHTML.class);
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        if (debugProjectionPerf) {
            long l2 = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderJSP.getAdapterFactoryHTML: " + (l2 - l));
        }
        return projectionModelNodeAdapterFactoryHTML;
    }

    private ProjectionModelNodeAdapterFactoryPHP getAdapterFactoryPHP(boolean bl) {
        long l = System.currentTimeMillis();
        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = null;
        if (this.fDocument != null) {
            IStructuredModel iStructuredModel = null;
            try {
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (iStructuredModel != null) {
                    FactoryRegistry factoryRegistry = iStructuredModel.getFactoryRegistry();
                    if (!factoryRegistry.contains(ProjectionModelNodeAdapterPHP.class) && bl) {
                        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP2 = new ProjectionModelNodeAdapterFactoryPHP();
                        factoryRegistry.addFactory((INodeAdapterFactory)projectionModelNodeAdapterFactoryPHP2);
                        IDOMModel iDOMModel = (IDOMModel)iStructuredModel;
                        IDOMDocument iDOMDocument = iDOMModel.getDocument();
                        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)((INodeNotifier)iDOMDocument).getAdapterFor(PropagatingAdapter.class);
                        if (propagatingAdapter != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)projectionModelNodeAdapterFactoryPHP2);
                        }
                    }
                    projectionModelNodeAdapterFactoryPHP = (ProjectionModelNodeAdapterFactoryPHP)factoryRegistry.getFactoryFor(ProjectionModelNodeAdapterPHP.class);
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        if (debugProjectionPerf) {
            long l2 = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderPHP.getAdapterFactoryPHP: " + (l2 - l));
        }
        return projectionModelNodeAdapterFactoryPHP;
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.projectionDisabled();
        this.fDocument = this.fViewer.getDocument();
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML;
            ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = this.getAdapterFactoryPHP(true);
            if (projectionModelNodeAdapterFactoryPHP != null) {
                projectionModelNodeAdapterFactoryPHP.addProjectionViewer(this.fViewer);
            }
            if ((projectionModelNodeAdapterFactoryHTML = this.getAdapterFactoryHTML(true)) != null) {
                projectionModelNodeAdapterFactoryHTML.addProjectionViewer(this.fViewer);
            }
            this.addAllAdapters();
        }
        this.fProjectionNeedsToBeEnabled = false;
        this.initializePreferences();
    }

    private void initializePreferences() {
        IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        this.foldingClasses = iPreferenceStore.getBoolean("foldClasses");
        this.foldingFunctions = iPreferenceStore.getBoolean("foldFunctions");
        this.foldingPhpDoc = iPreferenceStore.getBoolean("foldPHPDoc");
    }

    boolean isFoldingClasses() {
        return this.foldingClasses;
    }

    boolean isFoldingFunctions() {
        return this.foldingFunctions;
    }

    boolean isFoldingPhpDoc() {
        return this.foldingPhpDoc;
    }

    public void install(ProjectionViewer projectionViewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.fViewer = projectionViewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
        this.fViewer.addTextInputListener((ITextInputListener)this);
    }

    private boolean isInstalled() {
        return this.fViewer != null;
    }

    public void projectionDisabled() {
        ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML;
        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = this.getAdapterFactoryPHP(false);
        if (projectionModelNodeAdapterFactoryPHP != null) {
            projectionModelNodeAdapterFactoryPHP.removeProjectionViewer(this.fViewer);
        }
        if ((projectionModelNodeAdapterFactoryHTML = this.getAdapterFactoryHTML(false)) != null) {
            projectionModelNodeAdapterFactoryHTML.removeProjectionViewer(this.fViewer);
        }
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            this.fViewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.removeAllAdapters();
        this.fDocument = null;
        this.fProjectionNeedsToBeEnabled = false;
    }

    public void projectionEnabled() {
        this.initialize();
    }

    private void removeAdapterFromNodeAndChildren(Node node, int n) {
        if (node instanceof INodeNotifier) {
            INodeAdapter iNodeAdapter;
            INodeNotifier iNodeNotifier = (INodeNotifier)node;
            INodeAdapter iNodeAdapter2 = iNodeNotifier.getExistingAdapter(ProjectionModelNodeAdapterPHP.class);
            if (iNodeAdapter2 != null) {
                iNodeNotifier.removeAdapter(iNodeAdapter2);
            }
            if ((iNodeAdapter = iNodeNotifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class)) != null) {
                iNodeNotifier.removeAdapter(iNodeAdapter);
            }
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                Node node3 = node2;
                node2 = node3.getNextSibling();
                this.removeAdapterFromNodeAndChildren(node3, n + 1);
            }
        }
    }

    private void removeAllAdapters() {
        long l = System.currentTimeMillis();
        if (this.fDocument != null) {
            IStructuredModel iStructuredModel = null;
            try {
                int n;
                IndexedRegion indexedRegion;
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (iStructuredModel != null && (indexedRegion = iStructuredModel.getIndexedRegion(n = 0)) instanceof Node) {
                    Node node = (Node)indexedRegion;
                    while (node != null) {
                        Node node2 = node;
                        node = node2.getNextSibling();
                        this.removeAdapterFromNodeAndChildren(node2, 0);
                    }
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        if (debugProjectionPerf) {
            long l2 = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderJSP.addAllAdapters: " + (l2 - l));
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        if (this.fDocument != null && this.fDocument != iDocument2) {
            this.projectionDisabled();
            this.fProjectionNeedsToBeEnabled = true;
        }
    }

    public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
        if (this.fProjectionNeedsToBeEnabled && this.fDocument == null && iDocument2 != null) {
            this.projectionEnabled();
            this.fProjectionNeedsToBeEnabled = false;
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer.removeTextInputListener((ITextInputListener)this);
            this.fViewer = null;
        }
    }
}

