/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.parser.management.GlobalParsingManager;
import org.eclipse.php.internal.core.phpModel.parser.management.UserModelParserClientFactoryVersionDependent;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.util.DefaultCacheManager;

public class PHPUserModelManager {
    private final PHPUserModel userModel;
    private PHPUserModel cachedUserModel;
    private final IProject project;
    private IParserClientFactory parserClientFactory;

    PHPUserModelManager(IProject iProject, PHPUserModel pHPUserModel) {
        this.project = iProject;
        this.userModel = pHPUserModel;
        this.parserClientFactory = new UserModelParserClientFactoryVersionDependent(this);
        GlobalParsingManager.getInstance().addParserClient(this.parserClientFactory, iProject);
        this.cachedUserModel = new PHPUserModel();
        DefaultCacheManager.instance().load(iProject, this.cachedUserModel, false);
    }

    public void dispose() {
        IPath iPath = this.project.getLocation();
        if (iPath == null) {
            return;
        }
        File file = iPath.toFile();
        if (file.exists()) {
            DefaultCacheManager.instance().save(this.project, this.userModel, false);
        }
        GlobalParsingManager.getInstance().removeParserClient(this.parserClientFactory, this.project);
        this.parserClientFactory.dispose();
        this.parserClientFactory = null;
        this.cachedUserModel.dispose();
        this.cachedUserModel = null;
    }

    public void fileRemoved(IFile iFile) {
        this.userModel.delete(iFile.getFullPath().toString());
    }

    public synchronized void clean() {
        this.userModel.clear();
    }

    public IProject getProject() {
        return this.project;
    }

    public PHPUserModel getUserModel() {
        return this.userModel;
    }

    public boolean shouldParse(String string) {
        PHPFileData pHPFileData = this.cachedUserModel.getFileData(string);
        if (pHPFileData != null && pHPFileData.isValid()) {
            this.userModel.insert(pHPFileData);
            this.cachedUserModel.delete(string);
            return false;
        }
        return true;
    }
}

