/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public abstract class PHPElementResourceMapping
extends ResourceMapping {
    PHPElementResourceMapping() {
    }

    public PHPCodeData getPHPElement() {
        Object object = this.getModelObject();
        if (object instanceof PHPCodeData) {
            return (PHPCodeData)object;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PHPElementResourceMapping)) {
            return false;
        }
        return this.getPHPElement().equals(((PHPElementResourceMapping)((Object)object)).getPHPElement());
    }

    public int hashCode() {
        PHPCodeData pHPCodeData = this.getPHPElement();
        if (pHPCodeData == null) {
            return super.hashCode();
        }
        return pHPCodeData.hashCode();
    }

    public String getModelProviderId() {
        return "";
    }

    public static ResourceMapping create(Object object) {
        if (object instanceof PHPWorkspaceModelManager) {
            return PHPElementResourceMapping.create((PHPWorkspaceModelManager)object);
        }
        if (object instanceof PHPProjectModel) {
            return PHPElementResourceMapping.create((PHPProjectModel)object);
        }
        if (object instanceof PHPFileData) {
            return PHPElementResourceMapping.create((PHPFileData)object);
        }
        if (object instanceof PHPClassData) {
            return PHPElementResourceMapping.create((PHPClassData)object);
        }
        if (object instanceof PHPFunctionData) {
            return PHPElementResourceMapping.create((PHPFunctionData)object);
        }
        return null;
    }

    public static ResourceMapping create(PHPWorkspaceModelManager pHPWorkspaceModelManager) {
        return new PHPModelResourceMapping(pHPWorkspaceModelManager);
    }

    public static ResourceMapping create(PHPProjectModel pHPProjectModel) {
        return new PHPProjectResourceMapping(pHPProjectModel);
    }

    public static ResourceMapping create(PHPFileData pHPFileData) {
        if (pHPFileData == null) {
            return null;
        }
        return new CompilationUnitResourceMapping(pHPFileData);
    }

    public static ResourceMapping create(PHPClassData pHPClassData) {
        PHPCodeData pHPCodeData = pHPClassData.getContainer();
        if (pHPCodeData instanceof PHPFileData) {
            return PHPElementResourceMapping.create((PHPFileData)pHPCodeData);
        }
        return null;
    }

    public static ResourceMapping create(PHPFunctionData pHPFunctionData) {
        PHPCodeData pHPCodeData = pHPFunctionData.getContainer();
        if (pHPCodeData instanceof PHPFileData) {
            return PHPElementResourceMapping.create((PHPFileData)pHPCodeData);
        }
        return null;
    }

    private static final class CompilationUnitResourceMapping
    extends PHPElementResourceMapping {
        private final PHPFileData fUnit;

        private CompilationUnitResourceMapping(PHPFileData pHPFileData) {
            Assert.isNotNull((Object)pHPFileData);
            this.fUnit = pHPFileData;
        }

        public Object getModelObject() {
            return this.fUnit;
        }

        public IProject[] getProjects() {
            IResource iResource = PHPModelUtil.getResource((Object)this.fUnit);
            if (iResource != null && iResource.exists()) {
                return new IProject[]{iResource.getProject()};
            }
            return new IProject[0];
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            IResource iResource = PHPModelUtil.getResource((Object)this.fUnit);
            if (iResource != null) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{PHPModelUtil.getResource((Object)this.fUnit)}, 1, 0)};
            }
            return new ResourceTraversal[0];
        }
    }

    private static final class PHPModelResourceMapping
    extends PHPElementResourceMapping {
        private final PHPWorkspaceModelManager fModel;

        private PHPModelResourceMapping(PHPWorkspaceModelManager pHPWorkspaceModelManager) {
            Assert.isNotNull((Object)pHPWorkspaceModelManager);
            this.fModel = pHPWorkspaceModelManager;
        }

        public Object getModelObject() {
            return this.fModel;
        }

        public IProject[] getProjects() {
            PHPProjectModel[] pHPProjectModelArray = null;
            pHPProjectModelArray = this.fModel.listModels();
            IProject[] iProjectArray = new IProject[pHPProjectModelArray.length];
            int n = 0;
            while (n < pHPProjectModelArray.length) {
                iProjectArray[n] = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModelArray[n]);
                ++n;
            }
            return iProjectArray;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            PHPProjectModel[] pHPProjectModelArray = this.fModel.listModels();
            ResourceTraversal[] resourceTraversalArray = new ResourceTraversal[pHPProjectModelArray.length];
            PHPWorkspaceModelManager pHPWorkspaceModelManager = PHPWorkspaceModelManager.getInstance();
            int n = 0;
            while (n < pHPProjectModelArray.length) {
                resourceTraversalArray[n] = new ResourceTraversal(new IResource[]{pHPWorkspaceModelManager.getProjectForModel(pHPProjectModelArray[n])}, 2, 0);
                ++n;
            }
            return resourceTraversalArray;
        }
    }

    private static final class PHPProjectResourceMapping
    extends PHPElementResourceMapping {
        private final PHPProjectModel fProject;

        private PHPProjectResourceMapping(PHPProjectModel pHPProjectModel) {
            Assert.isNotNull((Object)pHPProjectModel);
            this.fProject = pHPProjectModel;
        }

        public Object getModelObject() {
            return this.fProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{PHPWorkspaceModelManager.getInstance().getProjectForModel(this.fProject)};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{PHPWorkspaceModelManager.getInstance().getProjectForModel(this.fProject)}, 2, 0)};
        }
    }
}

