/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.ui.preferences.IPHPPreferencePageBlock;

public class PHPPreferencePageBlocksRegistry {
    private static final String EXTENSION_POINT_NAME = "phpPreferencePageBlocks";
    private static final String BLOCK_TAG = "block";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PAGE_ID_ATTRIBUTE = "pageId";
    private static final String PDT_PREFIX = "org.eclipse.php.";
    private Dictionary pageBlocks = new Hashtable();
    private static PHPPreferencePageBlocksRegistry instance = null;
    private static Comparator pageBlockComparator = new PageBlockComparator();

    private PHPPreferencePageBlocksRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.php.ui", EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (BLOCK_TAG.equals(iConfigurationElement.getName())) {
                String string = iConfigurationElement.getAttribute(PAGE_ID_ATTRIBUTE);
                this.addBlock(this.pageBlocks, string, iConfigurationElement);
            }
            ++n;
        }
    }

    private void addBlock(Dictionary dictionary, String string, IConfigurationElement iConfigurationElement) {
        ArrayList<PHPPreferencePageBlocksFactory> arrayList = (ArrayList<PHPPreferencePageBlocksFactory>)dictionary.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<PHPPreferencePageBlocksFactory>(5);
        }
        arrayList.add(new PHPPreferencePageBlocksFactory(iConfigurationElement));
        dictionary.put(string, arrayList);
    }

    private Dictionary getPageBlocks() {
        return this.pageBlocks;
    }

    private static PHPPreferencePageBlocksRegistry getInstance() {
        if (instance == null) {
            instance = new PHPPreferencePageBlocksRegistry();
        }
        return instance;
    }

    public static IPHPPreferencePageBlock[] getPHPPreferencePageBlock(String string) throws Exception {
        List list = (List)PHPPreferencePageBlocksRegistry.getInstance().getPageBlocks().get(string);
        IPHPPreferencePageBlock[] iPHPPreferencePageBlockArray = PHPPreferencePageBlocksRegistry.getBlocks(list);
        Arrays.sort(iPHPPreferencePageBlockArray, pageBlockComparator);
        return iPHPPreferencePageBlockArray;
    }

    private static IPHPPreferencePageBlock[] getBlocks(List list) {
        if (list == null) {
            return new IPHPPreferencePageBlock[0];
        }
        IPHPPreferencePageBlock[] iPHPPreferencePageBlockArray = new IPHPPreferencePageBlock[list.size()];
        int n = 0;
        while (n < iPHPPreferencePageBlockArray.length) {
            iPHPPreferencePageBlockArray[n] = ((PHPPreferencePageBlocksFactory)list.get(n)).createPHPPreferencePageBlock();
            ++n;
        }
        return iPHPPreferencePageBlockArray;
    }

    class PHPPreferencePageBlocksFactory {
        private IConfigurationElement element;
        private IPHPPreferencePageBlock preferencesPageBlock;

        public PHPPreferencePageBlocksFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IPHPPreferencePageBlock createPHPPreferencePageBlock() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.ui.phpPreferencePageBlocks"){

                public void run() throws Exception {
                    PHPPreferencePageBlocksFactory.this.preferencesPageBlock = (IPHPPreferencePageBlock)PHPPreferencePageBlocksFactory.this.element.createExecutableExtension(PHPPreferencePageBlocksRegistry.CLASS_ATTRIBUTE);
                    PHPPreferencePageBlocksFactory.this.preferencesPageBlock.setComparableName(PHPPreferencePageBlocksFactory.this.element.getAttribute(PHPPreferencePageBlocksRegistry.NAME_ATTRIBUTE));
                }
            });
            return this.preferencesPageBlock;
        }
    }

    static class PageBlockComparator
    implements Comparator {
        PageBlockComparator() {
        }

        public int compare(Object object, Object object2) {
            IPHPPreferencePageBlock iPHPPreferencePageBlock = (IPHPPreferencePageBlock)object;
            IPHPPreferencePageBlock iPHPPreferencePageBlock2 = (IPHPPreferencePageBlock)object2;
            if (iPHPPreferencePageBlock != null && iPHPPreferencePageBlock2 != null) {
                boolean bl = iPHPPreferencePageBlock.getClass().getName().startsWith(PHPPreferencePageBlocksRegistry.PDT_PREFIX);
                boolean bl2 = iPHPPreferencePageBlock2.getClass().getName().startsWith(PHPPreferencePageBlocksRegistry.PDT_PREFIX);
                if (bl) {
                    if (!bl2) {
                        return -1;
                    }
                } else if (bl2) {
                    return 1;
                }
                return iPHPPreferencePageBlock.getComparableName().compareTo(iPHPPreferencePageBlock2.getComparableName());
            }
            if (iPHPPreferencePageBlock == null) {
                return iPHPPreferencePageBlock2 == null ? 0 : -1;
            }
            return 1;
        }
    }
}

