/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.ArchieveFileFilter;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElement;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class VariableCreationDialog
extends StatusDialog {
    private IDialogSettings fDialogSettings;
    private StringDialogField fNameField;
    private StatusInfo fNameStatus;
    private StringButtonDialogField fPathField;
    private StatusInfo fPathStatus;
    private IPVariableElement fElement;
    private List fExistingNames;

    public VariableCreationDialog(Shell shell, IPVariableElement iPVariableElement, List list) {
        super(shell);
        if (iPVariableElement == null) {
            this.setTitle(PHPUIMessages.VariableCreationDialog_titlenew);
        } else {
            this.setTitle(PHPUIMessages.VariableCreationDialog_titleedit);
        }
        this.fDialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
        this.fElement = iPVariableElement;
        this.fNameStatus = new StatusInfo();
        this.fPathStatus = new StatusInfo();
        NewVariableAdapter newVariableAdapter = new NewVariableAdapter();
        this.fNameField = new StringDialogField();
        this.fNameField.setDialogFieldListener(newVariableAdapter);
        this.fNameField.setLabelText(PHPUIMessages.VariableCreationDialog_name_label);
        this.fPathField = new StringButtonDialogField(newVariableAdapter);
        this.fPathField.setDialogFieldListener(newVariableAdapter);
        this.fPathField.setLabelText(PHPUIMessages.VariableCreationDialog_path_label);
        this.fPathField.setButtonLabel(PHPUIMessages.VariableCreationDialog_path_dir_button);
        this.fExistingNames = list;
        if (iPVariableElement != null) {
            this.fNameField.setText(iPVariableElement.getName());
            this.fPathField.setText(iPVariableElement.getPath().toString());
            this.fExistingNames.remove(iPVariableElement.getName());
        } else {
            this.fNameField.setText("");
            this.fPathField.setText("");
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.php.ui.variable_creation_dialog_context");
    }

    public IPVariableElement getIncludePathElement() {
        return new IPVariableElement(this.fNameField.getText(), (IPath)new Path(this.fPathField.getText()), IncludePathVariableManager.instance().isReserved(this.fNameField.getText()));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        int n = this.convertWidthInCharsToPixels(50);
        this.fNameField.doFillIntoGrid(composite3, 2);
        LayoutUtil.setWidthHint((Control)this.fNameField.getTextControl(null), n);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        DialogField.createEmptySpace(composite3, 1);
        this.fPathField.doFillIntoGrid(composite3, 3);
        LayoutUtil.setWidthHint((Control)this.fPathField.getTextControl(null), n);
        StringDialogField stringDialogField = this.fElement == null ? this.fNameField : this.fPathField;
        stringDialogField.postSetFocusOnDialogField(composite.getDisplay());
        VariableCreationDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void doChangeControlPressed(DialogField dialogField) {
        IPath iPath;
        if (dialogField == this.fPathField && (iPath = this.chooseExtDirectory()) != null) {
            this.fPathField.setText(iPath.toString());
        }
    }

    private void doFieldUpdated(DialogField dialogField) {
        if (dialogField == this.fNameField) {
            this.fNameStatus = this.nameUpdated();
        } else if (dialogField == this.fPathField) {
            this.fPathStatus = this.pathUpdated();
        }
        this.updateStatus(VariableCreationDialog.getMoreSevere((IStatus)this.fPathStatus, (IStatus)this.fNameStatus));
    }

    private static IStatus getMoreSevere(IStatus iStatus, IStatus iStatus2) {
        if (iStatus.getSeverity() > iStatus2.getSeverity()) {
            return iStatus;
        }
        return iStatus2;
    }

    private StatusInfo nameUpdated() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fNameField.getText();
        if (string.length() == 0) {
            statusInfo.setError(PHPUIMessages.VariableCreationDialog_error_entername);
            return statusInfo;
        }
        if (string.trim().length() != string.length()) {
            statusInfo.setError(PHPUIMessages.VariableCreationDialog_error_whitespace);
        } else if (!Path.ROOT.isValidSegment(string)) {
            statusInfo.setError(PHPUIMessages.VariableCreationDialog_error_invalidname);
        } else if (this.nameConflict(string)) {
            statusInfo.setError(PHPUIMessages.VariableCreationDialog_error_nameexists);
        }
        return statusInfo;
    }

    private boolean nameConflict(String string) {
        if (this.fElement != null && this.fElement.getName().equals(string)) {
            return false;
        }
        int n = 0;
        while (n < this.fExistingNames.size()) {
            IPVariableElement iPVariableElement = (IPVariableElement)this.fExistingNames.get(n);
            if (string.equals(iPVariableElement.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private StatusInfo pathUpdated() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fPathField.getText();
        if (string.length() > 0) {
            if (!Path.ROOT.isValidPath(string)) {
                statusInfo.setError(PHPUIMessages.VariableCreationDialog_error_invalidpath);
            } else if (!new File(string).exists()) {
                statusInfo.setWarning(PHPUIMessages.VariableCreationDialog_warning_pathnotexists);
            }
        }
        return statusInfo;
    }

    private String getInitPath() {
        String string = this.fPathField.getText();
        if (string.length() == 0) {
            string = "";
        } else {
            Path path = new Path(string);
            if (ArchieveFileFilter.isZipPath((IPath)path)) {
                path.removeLastSegments(1);
            }
            string = path.toOSString();
        }
        return string;
    }

    private IPath chooseExtDirectory() {
        String string = this.getInitPath();
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getParentShell());
        directoryDialog.setText(PHPUIMessages.VariableCreationDialog_extdirdialog_text);
        directoryDialog.setMessage(PHPUIMessages.VariableCreationDialog_extdirdialog_message);
        directoryDialog.setFilterPath(string);
        String string2 = directoryDialog.open();
        if (string2 != null) {
            return Path.fromOSString((String)string2);
        }
        return null;
    }

    private class NewVariableAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private NewVariableAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            VariableCreationDialog.this.doFieldUpdated(dialogField);
        }

        public void changeControlPressed(DialogField dialogField) {
            VariableCreationDialog.this.doChangeControlPressed(dialogField);
        }
    }
}

