/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.projection.ProjectionModelNodeAdapterFactoryPHP;
import org.eclipse.php.internal.ui.projection.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.projection.StructuredTextFoldingProviderPHP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Node;

public class ProjectionModelNodeAdapterPHP
extends ProjectionModelNodeAdapterHTML {
    private final Map<DataProjectionAnnotation, Position> addedAnnotations = new HashMap<DataProjectionAnnotation, Position>();
    private final Map<DataProjectionAnnotation, Position> currentAnnotations = new HashMap<DataProjectionAnnotation, Position>();
    private StructuredTextFoldingProviderPHP structuredTextFoldingProviderPHP;

    public ProjectionModelNodeAdapterPHP(ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP) {
        super(projectionModelNodeAdapterFactoryPHP);
    }

    public boolean isAdapterForType(Object object) {
        return object == ProjectionModelNodeAdapterPHP.class;
    }

    void updateAdapter(Node node, ProjectionViewer projectionViewer) {
        this.addedAnnotations.clear();
        this.currentAnnotations.clear();
        if (node.getNodeType() == 1) {
            assert (node instanceof ElementImplForPhp) : "Bad element";
            ElementImplForPhp elementImplForPhp = (ElementImplForPhp)node;
            if (elementImplForPhp.isPhpTag()) {
                IStructuredDocument iStructuredDocument = elementImplForPhp.getStructuredDocument();
                assert (iStructuredDocument != null) : "Document doesn't exist";
                IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)iStructuredDocument);
                assert (iStructuredModel != null) : "Model doesn't exist";
                DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                PHPFileData pHPFileData = dOMModelForPHP.getFileData();
                int n = elementImplForPhp.getStartOffset();
                int n2 = elementImplForPhp.getEndOffset();
                this.createFileAnnotations(pHPFileData, n, n2);
            }
        }
        super.updateAdapter(node, projectionViewer);
    }

    private void createFileAnnotations(PHPFileData pHPFileData, int n, int n2) {
        PHPFunctionData[] pHPFunctionDataArray;
        PHPFunctionData[] pHPFunctionDataArray2;
        PHPClassData[] pHPClassDataArray;
        PHPClassData[] pHPClassDataArray2 = pHPClassDataArray = pHPFileData.getClasses();
        int n3 = pHPClassDataArray.length;
        int n4 = 0;
        while (n4 < n3) {
            PHPClassVarData[] pHPClassVarDataArray;
            pHPFunctionDataArray2 = pHPClassDataArray2[n4];
            if (this.structuredTextFoldingProviderPHP.isFoldingClasses()) {
                this.createCodeDataAnnotations((CodeData)pHPFunctionDataArray2, n, n2);
            }
            PHPFunctionData[] pHPFunctionDataArray3 = pHPFunctionDataArray = pHPFunctionDataArray2.getFunctions();
            int n5 = pHPFunctionDataArray.length;
            int n6 = 0;
            while (n6 < n5) {
                pHPClassVarDataArray = pHPFunctionDataArray3[n6];
                if (this.structuredTextFoldingProviderPHP.isFoldingFunctions()) {
                    this.createCodeDataAnnotations((CodeData)pHPClassVarDataArray, n, n2);
                }
                if (this.structuredTextFoldingProviderPHP.isFoldingPhpDoc()) {
                    this.createDocBlockAnnotations(pHPClassVarDataArray.getDocBlock(), n, n2);
                }
                ++n6;
            }
            if (this.structuredTextFoldingProviderPHP.isFoldingPhpDoc()) {
                PHPClassConstData[] pHPClassConstDataArray;
                PHPClassVarData[] pHPClassVarDataArray2 = pHPClassVarDataArray = pHPFunctionDataArray2.getVars();
                int n7 = pHPClassVarDataArray.length;
                n5 = 0;
                while (n5 < n7) {
                    PHPClassVarData pHPClassVarData = pHPClassVarDataArray2[n5];
                    this.createDocBlockAnnotations(pHPClassVarData.getDocBlock(), n, n2);
                    ++n5;
                }
                PHPClassConstData[] pHPClassConstDataArray2 = pHPClassConstDataArray = pHPFunctionDataArray2.getConsts();
                int n8 = pHPClassConstDataArray.length;
                n7 = 0;
                while (n7 < n8) {
                    PHPClassConstData pHPClassConstData = pHPClassConstDataArray2[n7];
                    this.createDocBlockAnnotations(pHPClassConstData.getDocBlock(), n, n2);
                    ++n7;
                }
            }
            ++n4;
        }
        pHPFunctionDataArray = pHPFunctionDataArray2 = pHPFileData.getFunctions();
        int n9 = pHPFunctionDataArray2.length;
        n3 = 0;
        while (n3 < n9) {
            PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n3];
            if (this.structuredTextFoldingProviderPHP.isFoldingFunctions()) {
                this.createCodeDataAnnotations((CodeData)pHPFunctionData, n, n2);
            }
            if (this.structuredTextFoldingProviderPHP.isFoldingPhpDoc()) {
                this.createDocBlockAnnotations(pHPFunctionData.getDocBlock(), n, n2);
            }
            ++n3;
        }
        if (this.structuredTextFoldingProviderPHP.isFoldingPhpDoc()) {
            this.createDocBlockAnnotations(pHPFileData.getDocBlock(), n, n2);
        }
    }

    private void createCodeDataAnnotations(CodeData codeData, int n, int n2) {
        UserData userData = codeData.getUserData();
        int n3 = userData.getStartPosition();
        if (n3 > n && n3 < n2) {
            Position position = new Position(n3, userData.getEndPosition() - n3);
            DataProjectionAnnotation dataProjectionAnnotation = new DataProjectionAnnotation(codeData, false);
            DataProjectionAnnotation dataProjectionAnnotation2 = this.getExistingAnnotation(codeData);
            if (dataProjectionAnnotation2 == null) {
                this.currentAnnotations.put(dataProjectionAnnotation, position);
                this.addedAnnotations.put(dataProjectionAnnotation, position);
            } else {
                this.currentAnnotations.put(dataProjectionAnnotation2, position);
                this.previousAnnotations.remove((Object)dataProjectionAnnotation2);
            }
        }
    }

    private void createDocBlockAnnotations(PHPDocBlock pHPDocBlock, int n, int n2) {
        int n3 = pHPDocBlock.getStartPosition();
        if (n3 > n && n3 < n2) {
            Position position = new Position(n3, pHPDocBlock.getEndPosition() - n3);
            DataProjectionAnnotation dataProjectionAnnotation = new DataProjectionAnnotation(pHPDocBlock, false);
            DataProjectionAnnotation dataProjectionAnnotation2 = this.getExistingAnnotation(pHPDocBlock);
            if (dataProjectionAnnotation2 == null) {
                this.currentAnnotations.put(dataProjectionAnnotation, position);
                this.addedAnnotations.put(dataProjectionAnnotation, position);
            } else {
                this.currentAnnotations.put(dataProjectionAnnotation2, position);
                this.previousAnnotations.remove((Object)dataProjectionAnnotation2);
            }
        }
    }

    private DataProjectionAnnotation getExistingAnnotation(Object object) {
        return null;
    }

    void setProvider(StructuredTextFoldingProviderPHP structuredTextFoldingProviderPHP) {
        this.structuredTextFoldingProviderPHP = structuredTextFoldingProviderPHP;
    }

    public class DataProjectionAnnotation
    extends ProjectionAnnotation {
        private Object data;

        public DataProjectionAnnotation(Object object, boolean bl) {
            super(bl);
            this.data = object;
        }
    }
}

