/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text;

import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentCharacterIterator
implements CharacterIterator,
CharSequence {
    private int fIndex = -1;
    private final IDocument fDocument;
    private final int fFirst;
    private final int fLast;

    private void invariant() {
        Assert.isTrue((this.fIndex >= this.fFirst ? 1 : 0) != 0);
        Assert.isTrue((this.fIndex <= this.fLast ? 1 : 0) != 0);
    }

    public DocumentCharacterIterator(IDocument iDocument) {
        this(iDocument, 0);
    }

    public DocumentCharacterIterator(IDocument iDocument, int n) throws IllegalArgumentException {
        this(iDocument, n, iDocument.getLength());
    }

    public DocumentCharacterIterator(IDocument iDocument, int n, int n2) throws IllegalArgumentException {
        if (iDocument == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException();
        }
        if (n2 > iDocument.getLength()) {
            throw new IllegalArgumentException();
        }
        this.fDocument = iDocument;
        this.fFirst = n;
        this.fLast = n2;
        this.fIndex = n;
        this.invariant();
    }

    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    public char last() {
        if (this.fFirst == this.fLast) {
            return this.setIndex(this.getEndIndex());
        }
        return this.setIndex(this.getEndIndex() - 1);
    }

    public char current() {
        if (this.fIndex >= this.fFirst && this.fIndex < this.fLast) {
            try {
                return this.fDocument.getChar(this.fIndex);
            }
            catch (BadLocationException badLocationException) {}
        }
        return '\uffff';
    }

    public char next() {
        return this.setIndex(Math.min(this.fIndex + 1, this.getEndIndex()));
    }

    public char previous() {
        if (this.fIndex > this.getBeginIndex()) {
            return this.setIndex(this.fIndex - 1);
        }
        return '\uffff';
    }

    public char setIndex(int n) {
        if (n < this.getBeginIndex() || n > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.fIndex = n;
        this.invariant();
        return this.current();
    }

    public int getBeginIndex() {
        return this.fFirst;
    }

    public int getEndIndex() {
        return this.fLast;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int length() {
        return this.getEndIndex() - this.getBeginIndex();
    }

    public char charAt(int n) {
        if (n >= 0 && n < this.length()) {
            try {
                return this.fDocument.getChar(this.getBeginIndex() + n);
            }
            catch (BadLocationException badLocationException) {
                return '\uffff';
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public CharSequence subSequence(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new DocumentCharacterIterator(this.fDocument, this.getBeginIndex() + n, this.getBeginIndex() + n2);
    }
}

