/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.TreeSet;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public abstract class CompositePhpModel
implements IPhpModel {
    private IPhpModel[] models = new IPhpModel[0];

    public void addModel(IPhpModel iPhpModel) {
        if (this.indexOf(iPhpModel.getID()) != -1) {
            return;
        }
        IPhpModel[] iPhpModelArray = new IPhpModel[this.models.length + 1];
        System.arraycopy(this.models, 0, iPhpModelArray, 0, this.models.length);
        iPhpModelArray[iPhpModelArray.length - 1] = iPhpModel;
        this.models = iPhpModelArray;
    }

    public IPhpModel remove(String string) {
        if (string == null) {
            return null;
        }
        int n = this.indexOf(string);
        if (n == -1) {
            return null;
        }
        IPhpModel[] iPhpModelArray = new IPhpModel[this.models.length - 1];
        int n2 = 0;
        while (n2 < n) {
            iPhpModelArray[n2] = this.models[n2];
            ++n2;
        }
        n2 = n + 1;
        while (n2 < this.models.length) {
            iPhpModelArray[n2 - 1] = this.models[n2];
            ++n2;
        }
        IPhpModel iPhpModel = this.models[n];
        this.models = iPhpModelArray;
        return iPhpModel;
    }

    public IPhpModel getModel(String string) {
        int n = this.indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.models[n];
    }

    public IPhpModel[] getModels() {
        return this.models;
    }

    private int indexOf(String string) {
        int n = 0;
        while (n < this.models.length) {
            if (this.models[n].getID().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public CodeData[] getFileDatas() {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getFileDatas();
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public PHPFileData getFileData(String string) {
        int n = 0;
        while (n < this.models.length) {
            PHPFileData pHPFileData = this.models[n].getFileData(string);
            if (pHPFileData != null) {
                return pHPFileData;
            }
            ++n;
        }
        return null;
    }

    public CodeData[] getClasses() {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getClasses();
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public CodeData[] getClasses(String string) {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getClasses(string);
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public CodeData[] getClass(String string) {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getClass(string);
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public PHPClassData getClass(String string, String string2) {
        int n = 0;
        while (n < this.models.length) {
            PHPClassData pHPClassData = this.models[n].getClass(string, string2);
            if (pHPClassData != null && pHPClassData.getUserData() != null && pHPClassData.getUserData().getFileName().equals(string)) {
                return pHPClassData;
            }
            ++n;
        }
        return null;
    }

    public CodeData[] getFunctions() {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getFunctions();
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public CodeData[] getFunctions(String string) {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getFunctions(string);
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public CodeData[] getFunction(String string) {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getFunction(string);
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public PHPFunctionData getFunction(String string, String string2) {
        int n = 0;
        while (n < this.models.length) {
            PHPFunctionData pHPFunctionData = this.models[n].getFunction(string, string2);
            if (pHPFunctionData != null && pHPFunctionData.getUserData() != null && pHPFunctionData.getUserData().getFileName().equals(string)) {
                return pHPFunctionData;
            }
            ++n;
        }
        return null;
    }

    public CodeData[] getConstants() {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getConstants();
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public CodeData[] getConstants(String string, boolean bl) {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getConstants(string, bl);
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public CodeData[] getConstant(String string) {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getConstant(string);
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public PHPConstantData getConstant(String string, String string2) {
        int n = 0;
        while (n < this.models.length) {
            PHPConstantData pHPConstantData = this.models[n].getConstant(string, string2);
            if (pHPConstantData != null && pHPConstantData.getUserData() != null && pHPConstantData.getUserData().getFileName().equals(string)) {
                return pHPConstantData;
            }
            ++n;
        }
        return null;
    }

    public CodeData[] getGlobalVariables(String string, String string2, boolean bl) {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getGlobalVariables(string, string2, bl);
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public CodeData[] getVariables(String string, PHPCodeContext pHPCodeContext, String string2, boolean bl) {
        TreeSet<CodeData> treeSet = new TreeSet<CodeData>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getVariables(string, pHPCodeContext, string2, bl);
            if (codeDataArray != null) {
                int n2 = 0;
                while (n2 < codeDataArray.length) {
                    treeSet.add(codeDataArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new CodeData[treeSet.size()]);
    }

    public String getVariableType(String string, PHPCodeContext pHPCodeContext, String string2, int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.models.length) {
            String string3 = this.models[n2].getVariableType(string, pHPCodeContext, string2, n, bl);
            if (string3 != null && !string3.equals("")) {
                return string3;
            }
            ++n2;
        }
        return null;
    }

    public IPHPMarker[] getMarkers() {
        TreeSet<IPHPMarker> treeSet = new TreeSet<IPHPMarker>();
        int n = 0;
        while (n < this.models.length) {
            IPHPMarker[] iPHPMarkerArray = this.models[n].getMarkers();
            if (iPHPMarkerArray != null) {
                int n2 = 0;
                while (n2 < iPHPMarkerArray.length) {
                    treeSet.add(iPHPMarkerArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new IPHPMarker[treeSet.size()]);
    }

    public void clear() {
        int n = 0;
        while (n < this.models.length) {
            this.models[n].clear();
            ++n;
        }
    }

    public void dispose() {
        int n = 0;
        while (n < this.models.length) {
            this.models[n].dispose();
            ++n;
        }
    }
}

