/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
package org.eclipse.php.internal.debug.core;

import org.eclipse.osgi.util.NLS;

/**
 * Strings used by PHP Debugger Core
 * 
 */
public class PHPDebugCoreMessages extends NLS {
    private static final String BUNDLE_NAME = "org.eclipse.php.internal.debug.core.PHPDebugCoreMessages";//$NON-NLS-1$

    public static String LineBreakPointMessage_1;
    public static String ConditionalBreakPointMessage_1;
    public static String ConditionalBreakPointMessage_2;
    public static String DebuggerFileNotFound_1;
    public static String DebuggerDebugPortInUse_1;
    public static String DebuggerConnection_Problem_1;
    public static String DebuggerConnection_Problem_2;
    public static String DebuggerConnection_Problem_3;
    public static String DebuggerConnection_Failed_1;
    public static String DebuggerConnection_Exception_1;
    public static String Debugger_Unexpected_Error_1;
    public static String Debugger_ResourceNotFound;
    public static String Debugger_LaunchError_title;
    public static String Debugger_InvalidDebugResource;
    public static String Debugger_Error;
    public static String Debugger_Error_Message;
    public static String Debugger_Error_Message_2;
    public static String Debugger_Error_Message_3;
    public static String Debugger_Incompatible_Protocol;
    public static String Port_Error_Message_Message;
    public static String Port_Error_Message_Title;
    
    public static String configurationError;

	public static String PHPLaunchUtilities_activeLaunchDetected;
	public static String PHPLaunchUtilities_confirmation;
	public static String PHPLaunchUtilities_multipleLaunchesPrompt;
	public static String PHPLaunchUtilities_phpLaunchTitle;
	public static String PHPLaunchUtilities_rememberDecision;
	public static String PHPLaunchUtilities_PHPPerspectiveSwitchTitle;
	public static String PHPLaunchUtilities_PHPPerspectiveSwitchMessage;
	public static String PHPLaunchUtilities_terminate;
	public static String PHPLaunchUtilities_waitingForDebugger;
	
	public static String PHPWebPageLaunchDelegate_serverNotFound;

    static {
        // load message values from bundle file
        NLS.initializeMessages(BUNDLE_NAME, PHPDebugCoreMessages.class);
    }

    private PHPDebugCoreMessages() {
        // cannot create new instance
    }
}
