/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPExecutableLaunchDelegate;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtil;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPsComboBlock;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PHPExecutableLaunchTab
extends AbstractLaunchConfigurationTab {
    public static final String FIRST_EDIT = "editedByPHPExecutableLaunchTab";
    private Text argumentField;
    private Button argumentVariablesButton;
    protected Button breakOnFirstLine;
    private boolean enableDebugInfoOption;
    protected boolean enableFileSelection = true;
    protected boolean enableBreakpointSelection = true;
    private final ISelectionChangedListener fSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PHPExecutableLaunchTab.this.handleSelectedPHPexeChanged();
        }
    };
    private Button fileLocationButton;
    protected WidgetListener fListener = new WidgetListener();
    private Text locationField;
    protected PHPsComboBlock phpsComboBlock = new PHPsComboBlock();
    private Button runWithDebugInfo;
    protected SelectionAdapter selectionAdapter;

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void addControlAccessibleListener(Control control, String string) {
        String[] stringArray = string.split("&");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stringBuffer.toString()));
    }

    protected void createArgumentComponent(Composite composite) {
        Group group = new Group(composite, 0);
        String string = PHPDebugUIMessages.PHP_File;
        group.setText(string);
        GridLayout gridLayout = new GridLayout(3, false);
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setFont(composite.getFont());
        this.argumentField = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.argumentField.setLayoutData((Object)gridData);
        this.argumentField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentField, group.getText());
        this.argumentVariablesButton = this.createPushButton((Composite)group, PHPDebugUIMessages.Browse, null);
        gridData = (GridData)this.argumentVariablesButton.getLayoutData();
        gridData.horizontalSpan = 1;
        this.argumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentVariablesButton, this.argumentVariablesButton.getText());
    }

    private void createBreakControl(Composite composite) {
        String string = this.getLaunchConfigurationDialog().getMode();
        if ("debug".equals(string) && this.enableBreakpointSelection) {
            Group group = new Group(composite, 0);
            group.setText(PHPDebugUIMessages.Breakpoint_Group_Label);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            GridData gridData = new GridData(768);
            group.setLayout((Layout)gridLayout);
            group.setLayoutData((Object)gridData);
            this.breakOnFirstLine = this.createCheckButton((Composite)group, PHPDebugUIMessages.Breakpoint_Group_BreakAtFirstLine);
            this.breakOnFirstLine.addSelectionListener((SelectionListener)this.fListener);
            if (!this.enableBreakpointSelection) {
                this.setEnableBreakpointSelection(this.enableBreakpointSelection);
            }
        }
    }

    public void createControl(Composite composite) {
        if (this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.setEnableDebugInfoOption(true);
        }
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.createLocationComponent(composite2);
        if (this.enableFileSelection) {
            this.createArgumentComponent(composite2);
        }
        this.createDebugInfoComponent(composite2);
        this.runWithDebugInfo.setVisible(this.enableDebugInfoOption);
        this.createBreakControl(composite2);
        this.createVerticalSpacer(composite2, 1);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createDebugInfoComponent(Composite composite) {
        this.runWithDebugInfo = new Button(composite, 32);
        this.runWithDebugInfo.setText(PHPDebugUIMessages.PHPexe_Run_With_Debug_Info);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.runWithDebugInfo.setLayoutData((Object)gridData);
        this.runWithDebugInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createLocationComponent(Composite composite) {
        this.phpsComboBlock.createControl(composite);
        Control control = this.phpsComboBlock.getControl();
        this.phpsComboBlock.addSelectionChangedListener(this.fSelectionListener);
        GridData gridData = new GridData(768);
        control.setLayoutData((Object)gridData);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    private boolean fileExists(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        Path path = new Path(string);
        boolean bl = ResourcesPlugin.getWorkspace().getRoot().exists((IPath)path);
        return bl;
    }

    protected PHPexeDescriptor getDefaultPHPexeDescriptor() {
        return null;
    }

    public String getName() {
        return "PHP Script";
    }

    protected PHPexeDescriptor getSpecificPHPexeDescriptor() {
        return null;
    }

    protected String getWorkingDirectoryLabel() {
        return PHPDebugUIMessages.WorkingDirectory;
    }

    protected void handleBreakButtonSelected() {
        this.updateLaunchConfigurationDialog();
    }

    protected void handleFileLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String string = fileDialog.open();
        if (string != null) {
            this.locationField.setText(string);
        }
    }

    protected void handleSelectedPHPexeChanged() {
        this.updateLaunchConfigurationDialog();
    }

    private void handleVariablesButtonSelected(Text text) {
        IFile iFile = null;
        IResource iResource = LaunchUtilities.getFileFromDialog(null, this.getShell(), LaunchUtil.getFileExtensions(), LaunchUtil.getRequiredNatures(), true);
        if (iResource instanceof IFile) {
            iFile = (IFile)iResource;
        }
        if (iFile != null) {
            text.setText(iFile.getFullPath().toString());
            text.setData((Object)iFile.getLocation().toString());
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.updateLocation(iLaunchConfiguration);
        if (this.enableDebugInfoOption) {
            this.updateDebugInfoOption(iLaunchConfiguration);
        }
        if (this.enableFileSelection) {
            this.updateArgument(iLaunchConfiguration);
        }
        try {
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(iLaunchConfiguration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        this.isValid(iLaunchConfiguration);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        block8: {
            block9: {
                Object object;
                block7: {
                    this.setErrorMessage(null);
                    try {
                        String string = iLaunchConfiguration.getAttribute("ATTR_LOCATION", "");
                        boolean bl = true;
                        try {
                            object = new File(string);
                            if (!((File)object).exists()) {
                                bl = false;
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            bl = false;
                        }
                        if (bl) break block7;
                        this.setErrorMessage(PHPDebugUIMessages.PHP_Location_Message);
                        return false;
                    }
                    catch (CoreException coreException) {}
                }
                if (!this.enableFileSelection || this.fileExists((String)(object = iLaunchConfiguration.getAttribute("ATTR_FILE", "")))) break block8;
                if (!ExternalFilesRegistry.getInstance().isEntryExist((String)object)) break block9;
                return true;
            }
            this.setErrorMessage(PHPDebugUIMessages.PHP_File_Not_Exist);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = this.phpsComboBlock.getSelectedLocation();
        if (string.length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string);
        }
        String string2 = null;
        if (!this.enableFileSelection || (string2 = this.argumentField.getText().trim()).length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", null);
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE_FULL_PATH", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", string2);
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE_FULL_PATH", this.argumentField.getData().toString());
        }
        boolean bl = this.enableDebugInfoOption ? this.runWithDebugInfo != null && this.runWithDebugInfo.getSelection() : true;
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", bl);
        if (this.breakOnFirstLine != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        }
        this.applyLaunchDelegateConfiguration(iLaunchConfigurationWorkingCopy);
    }

    protected void applyLaunchDelegateConfiguration(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, PHPExecutableLaunchDelegate.class.getName());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        try {
            String string = iLaunchConfigurationWorkingCopy.getAttribute("ATTR_LOCATION", "");
            if (string.equals("")) {
                PHPexes pHPexes = new PHPexes();
                pHPexes.load(PHPProjectPreferences.getModelPreferences());
                PHPexeItem pHPexeItem = pHPexes.getDefaultItem();
                if (pHPexeItem == null) {
                    return;
                }
                string = pHPexeItem.getPhpEXE().toString();
                iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string);
                iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine());
                this.applyLaunchDelegateConfiguration(iLaunchConfigurationWorkingCopy);
            }
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error setting default configuration", coreException);
        }
    }

    public void setEnableDebugInfoOption(boolean bl) {
        if (bl == this.enableDebugInfoOption) {
            return;
        }
        if (!this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.enableDebugInfoOption = false;
            return;
        }
        this.enableDebugInfoOption = bl;
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setVisible(bl);
        }
    }

    public void setEnableFileSelection(boolean bl) {
        if (bl == this.enableFileSelection) {
            return;
        }
        this.enableFileSelection = bl;
        if (this.argumentVariablesButton != null) {
            this.argumentVariablesButton.setVisible(bl);
        }
        if (this.argumentField != null) {
            this.argumentField.setVisible(bl);
        }
    }

    public void setEnableBreakpointSelection(boolean bl) {
        if (bl == this.enableBreakpointSelection) {
            return;
        }
        this.enableBreakpointSelection = bl;
        if (this.breakOnFirstLine != null) {
            this.breakOnFirstLine.setSelection(bl);
            this.breakOnFirstLine.setEnabled(bl);
        }
    }

    protected void updateArgument(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        String string2 = "";
        try {
            string = iLaunchConfiguration.getAttribute("ATTR_FILE", "");
            string2 = iLaunchConfiguration.getAttribute("ATTR_FILE_FULL_PATH", "");
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        if (this.argumentField != null) {
            this.argumentField.setText(string);
            this.argumentField.setData((Object)string2);
        }
    }

    protected void updateDebugInfoOption(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = PHPDebugPlugin.getDebugInfoOption();
        try {
            bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", bl);
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setSelection(bl);
        }
    }

    protected void updateLocation(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute("ATTR_LOCATION", "");
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        PHPexes pHPexes = this.phpsComboBlock.getPHPs(true);
        PHPexeItem pHPexeItem = string != null && string.length() > 0 ? pHPexes.getItemForFile(string) : pHPexes.getDefaultItem();
        this.phpsComboBlock.setPHPexe(pHPexeItem);
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            PHPExecutableLaunchTab.this.setDirty(true);
            Object object = selectionEvent.getSource();
            if (object == PHPExecutableLaunchTab.this.fileLocationButton) {
                PHPExecutableLaunchTab.this.handleFileLocationButtonSelected();
            } else if (object == PHPExecutableLaunchTab.this.argumentVariablesButton) {
                PHPExecutableLaunchTab.this.handleVariablesButtonSelected(PHPExecutableLaunchTab.this.argumentField);
            } else if (object == PHPExecutableLaunchTab.this.breakOnFirstLine) {
                PHPExecutableLaunchTab.this.handleBreakButtonSelected();
            }
        }
    }
}

