/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.filesystem;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExternalFileStore
extends FileStore {
    private File file;
    private String filePath;

    protected ExternalFileStore(File file) throws IllegalArgumentException {
        if (file.exists()) {
            throw new IllegalArgumentException("ExternalFileStore should be used for non-existing files only.");
        }
        this.file = file;
        this.filePath = file.getPath();
    }

    public String[] childNames(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return EMPTY_STRING_ARRAY;
    }

    public IFileInfo fetchInfo(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        FileInfo fileInfo = new FileInfo(this.file.getName());
        fileInfo.setExists(false);
        return fileInfo;
    }

    public IFileStore getChild(String string) {
        return new ExternalFileStore(new File(this.file, string));
    }

    public String getName() {
        return this.file.getName();
    }

    public IFileStore getParent() {
        File file = this.file.getParentFile();
        return file == null ? null : new ExternalFileStore(file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public InputStream openInputStream(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return new ByteArrayInputStream(new byte[0]);
    }

    public URI toURI() {
        return URIUtil.toURI((String)this.filePath);
    }

    public String toString() {
        return this.filePath;
    }
}

