/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.saveFiles;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.saveFiles.ResourceAndContainerGroup;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.wizards.PHPProjectCreationWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class SaveAsDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "SaveAsDialogSettings";
    private static final int NEW_PROJ_ID = 1025;
    private IFile originalFile = null;
    private String originalName = null;
    private IPath result;
    private ResourceAndContainerGroup resourceGroup;
    private Button okButton;
    private Button newProjectButton;
    private Image dlgTitleImage = null;
    private PHPProjectCreationWizard newProjectWizard;

    public SaveAsDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.save_as_dialog_context");
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.initializeControls();
        this.validatePage();
        this.resourceGroup.setFocus();
        this.setTitle("");
        this.dlgTitleImage = IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_DLGBAN_SAVEAS_DLG").createImage();
        this.setTitleImage(PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_WIZBAN_ADD_PHP_FILE));
        this.setMessage("");
        return control;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.makeColumnsEqualWidth = false;
        this.newProjectButton = this.createButton(composite, 1025, PHPUIMessages.getString("SaveAsDialog.createNewProject"), false);
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(1808));
        composite3.setFont(composite2.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SaveAsDialog.this.setDialogComplete(SaveAsDialog.this.validatePage());
            }
        };
        this.resourceGroup = new ResourceAndContainerGroup(composite3, listener, "", "");
        this.resourceGroup.setAllowExistingResources(true);
        return composite2;
    }

    public IPath getResult() {
        return this.result;
    }

    private void initializeControls() {
        if (this.originalFile != null) {
            this.resourceGroup.setContainerFullPath(this.originalFile.getParent().getFullPath());
            this.resourceGroup.setResource(this.originalFile.getName());
        } else if (this.originalName != null) {
            this.resourceGroup.setResource(this.originalName);
        }
        this.setDialogComplete(this.validatePage());
    }

    protected void okPressed() {
        IFile iFile;
        IPath iPath = this.resourceGroup.getContainerFullPath().append(this.resourceGroup.getResource());
        if (iPath.getFileExtension() == null) {
            if (this.originalFile != null && this.originalFile.getFileExtension() != null) {
                iPath = iPath.addFileExtension(this.originalFile.getFileExtension());
            } else if (this.originalName != null) {
                int n = this.originalName.lastIndexOf(46);
                if (++n > 0 && n < this.originalName.length()) {
                    iPath = iPath.addFileExtension(this.originalName.substring(n));
                }
            }
        }
        if ((iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath)).exists()) {
            String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String string = NLS.bind((String)"", (Object)iPath.toOSString());
            MessageDialog messageDialog = new MessageDialog(this.getShell(), "", null, string, 3, stringArray, 0);
            int n = messageDialog.open();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    this.cancelPressed();
                    return;
                }
            }
        }
        this.result = iPath;
        this.close();
    }

    protected void setDialogComplete(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public void setOriginalFile(IFile iFile) {
        this.originalFile = iFile;
    }

    public void setOriginalName(String string) {
        this.originalName = string;
    }

    private boolean validatePage() {
        IProject iProject;
        String string;
        IStatus iStatus;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (!this.resourceGroup.getResource().equals("")) {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            } else {
                this.setErrorMessage(null);
            }
            return false;
        }
        String string2 = this.resourceGroup.getResource();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IPath iPath = this.resourceGroup.getContainerFullPath();
        if (iPath != null && (iStatus = iWorkspace.validateName(string = iPath.segment(0), 4)).isOK() && !(iProject = iWorkspace.getRoot().getProject(string)).isOpen()) {
            this.setErrorMessage("");
            return false;
        }
        string = iWorkspace.validateName(string2, 1);
        if (!string.isOK()) {
            this.setErrorMessage(string.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return iDialogSettings2;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.okPressed();
        } else if (1 == n) {
            this.cancelPressed();
        } else if (1025 == n) {
            this.newProjectWizard = new PHPProjectCreationWizard();
            WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)this.newProjectWizard);
            if (wizardDialog.open() == 0) {
                this.resourceGroup.refresh();
            }
        }
    }
}

