/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.SimplePHPCodeDataVisitor;
import org.eclipse.php.internal.core.util.Visitor;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPElementImageProvider;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class PHPCompletionRendererVisitor
extends SimplePHPCodeDataVisitor {
    private String text;
    private Image image;
    protected StringBuffer buffer = new StringBuffer();

    public void init(CodeData codeData) {
        this.buffer.setLength(0);
        codeData.accept((Visitor)this);
        this.text = this.buffer.toString();
    }

    public String getDisplayString() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public void visit(CodeData codeData) {
        this.buffer.append(codeData.getName());
    }

    public void visit(PHPFunctionData pHPFunctionData) {
        int n = pHPFunctionData.getModifiers();
        int n2 = this.computeAdornments(n, 0);
        this.image = PHPModifier.isProtected((int)n) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_MISC_PROTECTED, n2, PHPElementImageProvider.SMALL_SIZE) : (PHPModifier.isPrivate((int)n) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_MISC_PRIVATE, n2, PHPElementImageProvider.SMALL_SIZE) : PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_MISC_PUBLIC, n2, PHPElementImageProvider.SMALL_SIZE));
        this.buffer.append(pHPFunctionData.getName());
        this.buffer.append("(");
        PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = pHPFunctionData.getParameters();
        int n3 = 0;
        while (n3 < pHPFunctionParameterArray.length) {
            if (n3 != 0) {
                this.buffer.append(", ");
            }
            this.visit(pHPFunctionParameterArray[n3]);
            ++n3;
        }
        this.buffer.append(")");
        String string = pHPFunctionData.getReturnType().trim();
        string = string.split(" ", 2)[0];
        string = "  " + string;
        this.buffer.append(string);
    }

    public void visit(PHPClassVarData pHPClassVarData) {
        int n = pHPClassVarData.getModifiers();
        int n2 = this.computeAdornments(n, 0);
        this.image = PHPModifier.isProtected((int)n) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_FIELD_PROTECTED, n2, PHPElementImageProvider.SMALL_SIZE) : (PHPModifier.isPrivate((int)n) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_FIELD_PRIVATE, n2, PHPElementImageProvider.SMALL_SIZE) : PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_FIELD_PUBLIC, n2, PHPElementImageProvider.SMALL_SIZE));
        super.visit(pHPClassVarData);
    }

    public void visit(PHPClassConstData pHPClassConstData) {
        this.image = PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_CONSTANT, 2, PHPElementImageProvider.SMALL_SIZE);
        super.visit(pHPClassConstData);
    }

    public void visit(PHPConstantData pHPConstantData) {
        this.image = PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_CONSTANT, 2, PHPElementImageProvider.SMALL_SIZE);
        super.visit(pHPConstantData);
    }

    public void visit(PHPClassData pHPClassData) {
        int n = pHPClassData.getModifiers();
        int n2 = this.computeAdornments(n, 0);
        this.image = PHPModifier.isInterface((int)n) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_OBJS_INTERFACE, n2, PHPElementImageProvider.SMALL_SIZE) : PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_OBJS_CLASS, n2, PHPElementImageProvider.SMALL_SIZE);
        super.visit(pHPClassData);
    }

    public void visit(PHPKeywordData pHPKeywordData) {
        this.image = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_KEYWORD);
        super.visit(pHPKeywordData);
    }

    public void visit(PHPVariableData pHPVariableData) {
        this.image = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_FIELD_PUBLIC);
        super.visit(pHPVariableData);
    }

    public void visit(PHPFunctionData.PHPFunctionParameter pHPFunctionParameter) {
        String string = pHPFunctionParameter.getClassType();
        if (string != null && string.length() != 0) {
            this.buffer.append(string).append(" ");
        }
        if (pHPFunctionParameter.isConst()) {
            this.buffer.append("const ");
        }
        if (pHPFunctionParameter.isReference()) {
            this.buffer.append("&");
        }
        if (this.buffer.length() > 0) {
            this.buffer.append("$");
        }
        this.buffer.append(pHPFunctionParameter.getName());
        String string2 = pHPFunctionParameter.getDefaultValue();
        if (string2 != null && string2.length() != 0) {
            this.buffer.append(" = ").append(string2);
        }
    }

    private int computeAdornments(int n, int n2) {
        if (PHPModifier.isAbstract((int)n)) {
            n2 |= 4;
        }
        if (PHPModifier.isFinal((int)n)) {
            n2 |= 8;
        }
        if (PHPModifier.isStatic((int)n)) {
            n2 |= 1;
        }
        return n2;
    }
}

