/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates.resolver;

import java.util.ArrayList;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateContext;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PhpTemplateVariableResolver
extends TemplateVariableResolver {
    private static final String DEFAULT_VAR = "var";

    public PhpTemplateVariableResolver() {
        super("variable", "resolving a php variable");
    }

    protected String[] resolveAll(TemplateContext templateContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PhpTemplateContext phpTemplateContext = (PhpTemplateContext)templateContext;
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        if (iModelManager == null) {
            return new String[]{DEFAULT_VAR};
        }
        IStructuredModel iStructuredModel = iModelManager.getExistingModelForRead(phpTemplateContext.getDocument());
        if (iStructuredModel == null) {
            return new String[]{DEFAULT_VAR};
        }
        try {
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            PHPFileData pHPFileData = dOMModelForPHP.getFileData();
            if (pHPFileData == null) {
                String[] stringArray = new String[]{DEFAULT_VAR};
                return stringArray;
            }
            PHPCodeContext pHPCodeContext = ModelSupport.createContext((PHPFileData)pHPFileData, (int)phpTemplateContext.getStart());
            PHPVariablesTypeManager pHPVariablesTypeManager = pHPFileData.getVariableTypeManager();
            PHPVariableData[] pHPVariableDataArray = pHPVariablesTypeManager.getVariables(pHPCodeContext);
            if (pHPVariableDataArray == null) {
                String[] stringArray = new String[]{DEFAULT_VAR};
                return stringArray;
            }
            int n = 0;
            while (n < pHPVariableDataArray.length) {
                PHPVariableData pHPVariableData = pHPVariableDataArray[n];
                PHPVariableTypeData pHPVariableTypeData = pHPVariablesTypeManager.getVariableTypeDataByPosition(pHPCodeContext, pHPVariableData.getName(), phpTemplateContext.getStart());
                if (pHPVariableTypeData != null) {
                    arrayList.add(pHPVariableData.getName());
                }
                ++n;
            }
        }
        finally {
            iStructuredModel.releaseFromRead();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

