/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.project.PHPNature;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PHPFileCreationWizardPage
extends WizardPage {
    protected Text containerText;
    protected Text fileText;
    private ISelection selection;
    protected static final String UTF_8 = "UTF 8";
    protected static final String NO_TEMPLATE = "-- none -- ";

    public PHPFileCreationWizardPage(ISelection iSelection) {
        super("wizardPage");
        this.setTitle("New PHP file");
        this.setDescription("Create a new PHP file");
        this.setImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_PHP_FILE);
        this.selection = iSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        Label label = new Label(composite2, 0);
        label.setText("Source Folder");
        this.containerText = new Text(composite2, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 400;
        this.containerText.setLayoutData((Object)gridData);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PHPFileCreationWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPFileCreationWizardPage.this.handleBrowse();
            }
        });
        label = new Label(composite2, 0);
        label.setText("File Name");
        this.fileText = new Text(composite2, 2052);
        this.fileText.setFocus();
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gridData);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PHPFileCreationWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.selection;
            if (iStructuredSelection.size() > 1) {
                return;
            }
            Object object = iStructuredSelection.getFirstElement();
            IContainer iContainer = null;
            if (object instanceof PHPCodeData) {
                object = PHPModelUtil.getResource((Object)object);
            } else if (object instanceof PHPNature) {
                object = ((PHPNature)object).getProject();
            } else if (object instanceof PHPProjectModel) {
                object = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)object);
            }
            if (object instanceof IResource) {
                iContainer = object instanceof IContainer ? (IContainer)object : ((IResource)object).getParent();
            } else if (object instanceof PHPProjectModel) {
                iContainer = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)object);
            }
            if (iContainer != null) {
                this.containerText.setText(iContainer.getFullPath().toString());
            }
        }
        this.setInitialFileName("newfile.php");
    }

    protected void setInitialFileName(String string) {
        this.fileText.setText(string);
        this.fileText.setSelection(0, 7);
    }

    private void handleBrowse() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select New File Folder");
        containerSelectionDialog.showClosedProjects(false);
        if (containerSelectionDialog.open() == 0 && (objectArray = containerSelectionDialog.getResult()).length == 1) {
            this.containerText.setText(((Path)objectArray[0]).toOSString());
        }
    }

    protected void dialogChanged() {
        String string = this.getContainerName();
        String string2 = this.getFileName();
        if (string.length() == 0) {
            this.updateStatus("Folder must be specified");
            return;
        }
        IContainer iContainer = this.getContainer(string);
        if (iContainer == null || !iContainer.exists()) {
            this.updateStatus("Selected folder does not exist");
            return;
        }
        if (!iContainer.getProject().isOpen()) {
            this.updateStatus("Selected folder is in closed project");
            return;
        }
        if (string2 != null && !string2.equals("") && iContainer.getFile((IPath)new Path(string2)).exists()) {
            this.updateStatus("Specified file already exists");
            return;
        }
        if (string2.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        IContentType iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        if (!iContentType.isAssociatedWith(string2)) {
            String[] stringArray = iContentType.getFileSpecs(8);
            StringBuffer stringBuffer = new StringBuffer("The file name must end in one of the following extensions [");
            stringBuffer.append(stringArray[0]);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                stringBuffer.append(", ").append(string3);
                ++n2;
            }
            stringBuffer.append("]");
            this.updateStatus(stringBuffer.toString());
            return;
        }
        this.updateStatus(null);
    }

    IContainer getContainer(String string) {
        Path path = new Path(string);
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        return iResource instanceof IContainer ? (IContainer)iResource : null;
    }

    private void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

