/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.fields;

import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;

public class StringDialogField
extends DialogField {
    protected String fText = "";
    protected Text fTextControl;
    protected ModifyListener fModifyListener;
    protected IContentAssistProcessor fContentAssistProcessor;

    public void setContentAssistProcessor(IContentAssistProcessor iContentAssistProcessor) {
        this.fContentAssistProcessor = iContentAssistProcessor;
        if (this.fContentAssistProcessor != null && this.isOkToUse((Control)this.fTextControl)) {
            ContentAssistHandler.createHandlerForText((Text)this.fTextControl, (SubjectControlContentAssistant)StringDialogField.createPHPContentAssistant(this.fContentAssistProcessor));
        }
    }

    public static SubjectControlContentAssistant createPHPContentAssistant(IContentAssistProcessor iContentAssistProcessor) {
        SubjectControlContentAssistant subjectControlContentAssistant = new SubjectControlContentAssistant();
        subjectControlContentAssistant.setContentAssistProcessor(iContentAssistProcessor, "__dftl_partition_content_type");
        subjectControlContentAssistant.setContextInformationPopupOrientation(20);
        subjectControlContentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        });
        return subjectControlContentAssistant;
    }

    public IContentAssistProcessor getContentAssistProcessor() {
        return this.fContentAssistProcessor;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)StringDialogField.gridDataForText(n - 1));
        return new Control[]{label, text};
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForText(int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = n;
        return gridData;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setFocus();
            this.fTextControl.setSelection(0, this.fTextControl.getText().length());
        }
        return true;
    }

    public Text getTextControl(Composite composite) {
        if (this.fTextControl == null) {
            this.assertCompositeNotNull(composite);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    StringDialogField.this.doModifyText(modifyEvent);
                }
            };
            this.fTextControl = new Text(composite, 2052);
            this.fTextControl.setText(this.fText);
            this.fTextControl.setFont(composite.getFont());
            this.fTextControl.addModifyListener(this.fModifyListener);
            this.fTextControl.setEnabled(this.isEnabled());
            if (this.fContentAssistProcessor != null) {
                ContentAssistHandler.createHandlerForText((Text)this.fTextControl, (SubjectControlContentAssistant)StringDialogField.createPHPContentAssistant(this.fContentAssistProcessor));
            }
        }
        return this.fTextControl;
    }

    protected void doModifyText(ModifyEvent modifyEvent) {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fText = this.fTextControl.getText();
        }
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        this.fText = string;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setText(string);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String string) {
        this.fText = string;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.removeModifyListener(this.fModifyListener);
            this.fTextControl.setText(string);
            this.fTextControl.addModifyListener(this.fModifyListener);
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
    }
}

