/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsValueDeserializer;
import org.eclipse.php.internal.debug.core.zend.debugger.StackVariable;

public class DefaultExpressionsManager
implements ExpressionsManager {
    private static final Expression[] EMPTY_VARIABLE_ARRAY = new Expression[0];
    private static final byte[] ILLEGAL_VAR = new byte[]{78};
    private Debugger debugger;
    private Map hashResultDepthOne = new HashMap();
    private Map hashResultDepthZero = new HashMap();
    private String[] localsVariablePath = new String[]{"get_defined_vars()"};
    private String[] globalVariablePath = new String[]{"$GLOBALS"};
    private ExpressionsValueDeserializer expressionValueDeserializer;

    public DefaultExpressionsManager(Debugger debugger, String transferEncoding) {
        this.debugger = debugger;
        this.expressionValueDeserializer = new ExpressionsValueDeserializer(transferEncoding);
    }

    public byte[] getExpressionValue(Expression expression, int depth) {
        if (!this.debugger.isActive()) {
            return ILLEGAL_VAR;
        }
        if (expression instanceof StackVariable) {
            return this.getStackVariableValue((StackVariable)expression, depth);
        }
        String[] name = DefaultExpressionsManager.minimizeArray(expression.getName());
        return this.getVariableValue(name, depth);
    }

    public boolean assignValue(Expression expression, String value, int depth) {
        String[] name = DefaultExpressionsManager.minimizeArray(expression.getName());
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        boolean status = this.debugger.assignValue(name[0], value, depth, path);
        byte[] eValue = this.debugger.getVariableValue(name[0], depth, path);
        if (status) {
            String key = DefaultExpressionsManager.buildKey(name);
            if (depth == 1) {
                this.hashResultDepthOne.put(key, eValue);
            } else if (depth == 0) {
                this.hashResultDepthZero.put(key, eValue);
            }
        }
        return status;
    }

    private byte[] getVariableValue(String[] name, int depth) {
        String key = DefaultExpressionsManager.buildKey(name);
        if (this.hashResultDepthOne.containsKey(key)) {
            return (byte[])this.hashResultDepthOne.get(key);
        }
        if (depth == 0 && this.hashResultDepthZero.containsKey(key)) {
            return (byte[])this.hashResultDepthZero.get(key);
        }
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        byte[] value = this.debugger.getVariableValue(name[0], depth, path);
        if (value != null) {
            if (depth == 1) {
                this.hashResultDepthOne.put(key, value);
            } else if (depth == 0) {
                this.hashResultDepthZero.put(key, value);
            }
        } else {
            value = new byte[]{78};
        }
        return value;
    }

    private static String buildKey(String[] name) {
        StringBuffer buffer = new StringBuffer(name.length * 5);
        int i = 0;
        while (i < name.length) {
            buffer.append(name[i]);
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    private static String[] minimizeArray(String[] name) {
        String firstName = name[0];
        if (firstName.startsWith("$GLOBALS[GLOBALS]")) {
            name[0] = firstName = "$GLOBALS" + firstName.substring(17);
            return DefaultExpressionsManager.minimizeArray(name);
        }
        if (name.length < 2) {
            return name;
        }
        if (name[0].equals("get_defined_vars()") && name[1].equals("GLOBALS")) {
            String[] newName = new String[name.length - 1];
            newName[0] = "$GLOBALS";
            System.arraycopy(name, 2, newName, 1, name.length - 2);
            return DefaultExpressionsManager.minimizeArray(newName);
        }
        if (name[0].equals("$GLOBALS") && name[1].equals("GLOBALS")) {
            String[] newName = new String[name.length - 1];
            newName[0] = name[0];
            System.arraycopy(name, 2, newName, 1, name.length - 2);
            return DefaultExpressionsManager.minimizeArray(newName);
        }
        return name;
    }

    public Expression[] getLocalVariables() {
        return this.getLocalVariables(1);
    }

    public Expression[] getLocalVariables(int depth) {
        byte[] value = this.getVariableValue(this.localsVariablePath, depth);
        ExpressionValue variableValue = this.expressionValueDeserializer.deserializer(null, value);
        Expression[] localVariables = variableValue.getChildren();
        if (localVariables == null) {
            localVariables = EMPTY_VARIABLE_ARRAY;
        }
        int i = 0;
        while (i < localVariables.length) {
            String s = localVariables[i].getFullName();
            if (s.equals("$GLOBALS")) {
                Expression[] newLocals = new Expression[localVariables.length - 1];
                System.arraycopy(localVariables, 0, newLocals, 0, i);
                System.arraycopy(localVariables, i + 1, newLocals, i, localVariables.length - i - 1);
                localVariables = newLocals;
                break;
            }
            ++i;
        }
        this.hashResultDepthOne.put("LOCALS", localVariables);
        return localVariables;
    }

    public Expression[] getGlobalVariables() {
        return this.getGlobalVariables(1);
    }

    public Expression[] getGlobalVariables(int depth) {
        byte[] value = this.getVariableValue(this.globalVariablePath, depth);
        ExpressionValue variableValue = this.expressionValueDeserializer.deserializer(null, value);
        Expression[] globalVariables = variableValue.getChildren();
        if (globalVariables == null) {
            globalVariables = EMPTY_VARIABLE_ARRAY;
        }
        int i = 0;
        while (i < globalVariables.length) {
            String s = globalVariables[i].getFullName();
            if (s.equals("$GLOBALS")) {
                Expression[] newGlobals = new Expression[globalVariables.length - 1];
                System.arraycopy(globalVariables, 0, newGlobals, 0, i);
                System.arraycopy(globalVariables, i + 1, newGlobals, i, globalVariables.length - i - 1);
                globalVariables = newGlobals;
                break;
            }
            ++i;
        }
        this.hashResultDepthOne.put("GlOBAS", globalVariables);
        return globalVariables;
    }

    private byte[] getStackVariableValue(StackVariable variable, int depth) {
        int layer = variable.getStackDepth();
        String[] name = variable.getName();
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        return this.debugger.getStackVariableValue(layer, name[0], depth, path);
    }

    public void clear() {
        this.hashResultDepthOne.clear();
        this.hashResultDepthZero.clear();
    }

    public Expression buildExpression(String name) {
        return new DefaultExpression(name);
    }

    public void update(Expression expression, int depth) {
        byte[] value = this.getExpressionValue(expression, depth);
        expression.setValue(this.expressionValueDeserializer.deserializer(expression, value));
    }
}

