/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.OverrideIndicatorManager;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionProcessor;
import org.eclipse.php.internal.ui.text.correction.QuickAssistLightBulbUpdater;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class PhpSelectAnnotationRulerAction
extends SelectMarkerRulerAction {
    private ITextEditor fTextEditor;
    private Position fPosition;
    private Annotation fAnnotation;
    private AnnotationPreferenceLookup fAnnotationPreferenceLookup;
    private IPreferenceStore fStore;
    private boolean fHasCorrection;
    private ResourceBundle fBundle;

    public PhpSelectAnnotationRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        this.fBundle = bundle;
        this.fTextEditor = editor;
        this.fAnnotationPreferenceLookup = EditorsUI.getAnnotationPreferenceLookup();
        this.fStore = PHPUiPlugin.getDefault().getPreferenceStore();
    }

    public void run() {
        if (this.fStore.getBoolean("editor_annotation_roll_over")) {
            return;
        }
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.fAnnotation instanceof OverrideIndicatorManager.OverrideIndicator) {
            ((OverrideIndicatorManager.OverrideIndicator)this.fAnnotation).open();
            return;
        }
        if (this.fHasCorrection) {
            ITextOperationTarget operation = (ITextOperationTarget)this.fTextEditor.getAdapter(ITextOperationTarget.class);
            if (operation != null && operation.canDoOperation(22)) {
                this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
                operation.doOperation(22);
            }
            return;
        }
        super.run();
    }

    public void update() {
        this.findPhpAnnotation();
        this.setEnabled(true);
        if (this.fAnnotation instanceof OverrideIndicatorManager.OverrideIndicator) {
            this.initialize(this.fBundle, "PhpSelectAnnotationRulerAction.OpenSuperImplementation.");
            return;
        }
        if (this.fHasCorrection) {
            if (this.fAnnotation instanceof QuickAssistLightBulbUpdater.AssistAnnotation) {
                this.initialize(this.fBundle, "PhpSelectAnnotationRulerAction.QuickAssist.");
            } else {
                this.initialize(this.fBundle, "PhpSelectAnnotationRulerAction.QuickFix.");
            }
            return;
        }
        this.initialize(this.fBundle, "PhpSelectAnnotationRulerAction.GotoAnnotation.");
        super.update();
    }

    private void findPhpAnnotation() {
        this.fPosition = null;
        this.fAnnotation = null;
        this.fHasCorrection = false;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension annotationAccess = this.getAnnotationAccessExtension();
        IDocument document = this.getDocument();
        if (model == null) {
            return;
        }
        boolean hasAssistLightbulb = this.fStore.getBoolean("org.eclipse.php.quickassist.lightbulb");
        Iterator iter = model.getAnnotationIterator();
        int layer = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            String key;
            AnnotationPreference preference;
            boolean isReadOnly;
            Position position;
            Annotation annotation = (Annotation)iter.next();
            if (annotation.isMarkedDeleted()) continue;
            int annotationLayer = layer;
            if (annotationAccess != null && (annotationLayer = annotationAccess.getLayer(annotation)) < layer || !this.includesRulerLine(position = model.getPosition(annotation), document)) continue;
            boolean bl = isReadOnly = this.fTextEditor instanceof ITextEditorExtension && ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly();
            if (!isReadOnly && (hasAssistLightbulb && annotation instanceof QuickAssistLightBulbUpdater.AssistAnnotation || PHPCorrectionProcessor.hasCorrections(annotation))) {
                this.fPosition = position;
                this.fAnnotation = annotation;
                this.fHasCorrection = true;
                layer = annotationLayer;
                continue;
            }
            if (this.fHasCorrection || (preference = this.fAnnotationPreferenceLookup.getAnnotationPreference(annotation)) == null || (key = preference.getVerticalRulerPreferenceKey()) == null || !(annotation instanceof OverrideIndicatorManager.OverrideIndicator)) continue;
            this.fPosition = position;
            this.fAnnotation = annotation;
            this.fHasCorrection = false;
            layer = annotationLayer;
        }
    }
}

