/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.internal.ui.scriptview.SelectionTransferDropAdapter;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.ui.actions.ReorgMoveAction;
import org.eclipse.ui.PlatformUI;

public class PHPSelectionTransferDropAdapter
extends SelectionTransferDropAdapter {
    public PHPSelectionTransferDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    public boolean performDrop(Object data) {
        try {
            switch (this.getCurrentOperation()) {
                case 2: {
                    this.handleDropMove(this.getCurrentTarget());
                    break;
                }
                case 1: {
                    this.handleDropCopy(this.getCurrentTarget());
                }
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), (String)ScriptMessages.SelectionTransferDropAdapter_error_title, (String)ScriptMessages.SelectionTransferDropAdapter_error_message);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private void handleDropMove(Object target) throws ModelException, InvocationTargetException, InterruptedException {
        List elements = ((IStructuredSelection)this.getSelection()).toList();
        IModelElement[] modelElements = ReorgUtils.getModelElements((List)elements);
        Object[] resources = ReorgUtils.getResources((IModelElement[])modelElements);
        ReorgMoveAction action = new ReorgMoveAction();
        action.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        StructuredSelection selection = new StructuredSelection(resources);
        action.selectionChanged(null, (ISelection)selection);
        action.run((IAction)null);
    }

    private void handleDropCopy(Object target) throws ModelException, InvocationTargetException, InterruptedException {
        List elements = ((IStructuredSelection)this.getSelection()).toList();
        IModelElement[] modelElements = ReorgUtils.getModelElements((List)elements);
        IResource[] resources = ReorgUtils.getResources((IModelElement[])modelElements);
        ReorgCopyStarter starter = null;
        if (target instanceof IModelElement) {
            starter = ReorgCopyStarter.create((IModelElement[])modelElements, (IResource[])resources, (IModelElement)((IModelElement)target));
        } else if (target instanceof IResource) {
            starter = ReorgCopyStarter.create((IModelElement[])modelElements, (IResource[])resources, (IResource)((IResource)target));
        }
        if (starter != null) {
            starter.run(this.getViewer().getControl().getShell());
        }
    }
}

