/* The following code was generated by JFlex 1.4.1 on 7/15/09 12:31 PM */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.IOException;
import java.util.ArrayList;

import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTagKinds;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 7/15/09 12:31 PM from the specification file
 * <tt>documentor_compiler_ast_scanner.flex</tt>
 */
public class DocumentorLexer implements IDocumentorLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_IN_TAGS = 6;
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SHORT_DESC = 2;
  public static final int ST_IN_LONG_DESC = 4;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  1,  2,  3,  4,  5,  6, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\1\11\0\1\4\2\0"+
    "\1\37\1\6\1\5\20\0\1\7\1\10\1\11\1\15\1\26\1\16"+
    "\1\32\1\22\1\20\1\25\1\0\1\34\1\31\1\30\1\33\1\21"+
    "\1\24\1\0\1\14\1\12\1\13\1\17\1\35\1\36\1\27\1\23"+
    "\7\0\1\10\1\11\1\15\1\26\1\16\1\32\1\22\1\20\1\25"+
    "\1\0\1\34\1\31\1\30\1\33\1\21\1\24\1\0\1\14\1\12"+
    "\1\13\1\17\1\35\1\36\1\27\1\23\uff86\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\1\0\1\1\1\0\1\1\3\2\2\3"+
    "\3\2\2\4\3\2\2\5\1\2\2\1\2\2\2\1"+
    "\1\2\3\0\1\6\1\7\2\6\2\1\1\0\1\1"+
    "\1\10\22\0\1\11\1\1\2\0\1\12\1\0\1\1"+
    "\20\0\1\13\66\0\2\13\4\0\1\14\30\0\1\15"+
    "\5\0\1\16\30\0\1\17\11\0\1\20\4\0\1\21"+
    "\6\0\1\22\3\0\1\23\2\0\1\24\11\0\1\25"+
    "\4\0\1\26\6\0\1\27\3\0\1\30\2\0\1\31"+
    "\6\0\1\32\7\0\1\33\10\0\1\34\6\0\1\35"+
    "\7\0\1\36\10\0\1\37\2\0\1\40\1\41\1\42"+
    "\2\0\1\43\1\44\3\0\1\45\2\0\1\46\2\0"+
    "\1\47\4\0\1\50\1\51\1\52\2\0\1\53\1\54"+
    "\3\0\1\55\2\0\1\56\2\0\1\57\11\0\1\60"+
    "\1\61\3\0\1\62\1\0\1\63\6\0\1\64\1\65"+
    "\3\0\1\66\1\0\1\67\1\70\2\0\1\71\1\72"+
    "\1\0\1\73\1\74\2\0\1\75\2\0\1\76\1\77"+
    "\1\0\1\100\1\101\2\0\1\102\1\0\1\103\3\0"+
    "\1\104\1\0\1\105\3\0\1\106\2\0\1\107\1\110"+
    "\1\111\2\0\1\112\1\113\10\0\1\114\1\0\1\115"+
    "\1\0\1\116\1\117";

  private static int [] zzUnpackAction() {
    int [] result = new int[435];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\40\0\100\0\140\0\200\0\240\0\300\0\340"+
    "\0\u0100\0\u0120\0\u0140\0\u0100\0\u0160\0\u0180\0\u01a0\0\u01c0"+
    "\0\u0100\0\u01e0\0\u0200\0\u0220\0\u0240\0\u0100\0\u0260\0\u0280"+
    "\0\u02a0\0\u02c0\0\u02e0\0\u0300\0\u0320\0\u0340\0\u0360\0\u0380"+
    "\0\u0140\0\u0180\0\u0100\0\u0100\0\u03a0\0\u03c0\0\u01c0\0\u0200"+
    "\0\u0220\0\u03e0\0\u0100\0\u0400\0\u0420\0\u0440\0\u0460\0\u0480"+
    "\0\u04a0\0\u04c0\0\u04e0\0\u0500\0\u0520\0\u0540\0\u0560\0\u0580"+
    "\0\u05a0\0\u05c0\0\u05e0\0\u0240\0\u0280\0\u0100\0\u0600\0\u02e0"+
    "\0\u0300\0\u0100\0\u0360\0\u0620\0\u0640\0\u0660\0\u0680\0\u06a0"+
    "\0\u06c0\0\u06e0\0\u0700\0\u0720\0\u0740\0\u0760\0\u0780\0\u07a0"+
    "\0\u07c0\0\u07e0\0\u0800\0\u0820\0\u0840\0\u0860\0\u0880\0\u08a0"+
    "\0\u08c0\0\u08e0\0\u0900\0\u0920\0\u0940\0\u0960\0\u0980\0\u09a0"+
    "\0\u09c0\0\u09e0\0\u0a00\0\u0a20\0\u0a40\0\u0a60\0\u0a80\0\u0aa0"+
    "\0\u0ac0\0\u0ae0\0\u0b00\0\u0b20\0\u0b40\0\u0b60\0\u0b80\0\u0ba0"+
    "\0\u0bc0\0\u0be0\0\u0c00\0\u0c20\0\u0c40\0\u0c60\0\u0c80\0\u0ca0"+
    "\0\u0cc0\0\u0ce0\0\u0d00\0\u0d20\0\u0d40\0\u0d60\0\u0d80\0\u0da0"+
    "\0\u0dc0\0\u0de0\0\u0e00\0\u0e20\0\u0e40\0\u0e60\0\u0e80\0\u0ea0"+
    "\0\u0ec0\0\u0ee0\0\u0f00\0\u0100\0\u0f20\0\u0f40\0\u0f60\0\u0f80"+
    "\0\u0fa0\0\u0100\0\u0fc0\0\u0fe0\0\u1000\0\u1020\0\u1040\0\u1060"+
    "\0\u1080\0\u10a0\0\u10c0\0\u10e0\0\u1100\0\u1120\0\u1140\0\u1160"+
    "\0\u1180\0\u11a0\0\u11c0\0\u11e0\0\u1200\0\u1220\0\u1240\0\u1260"+
    "\0\u1280\0\u12a0\0\u0100\0\u12c0\0\u12e0\0\u1300\0\u1320\0\u1340"+
    "\0\u0100\0\u1360\0\u1380\0\u13a0\0\u13c0\0\u13e0\0\u1400\0\u1420"+
    "\0\u1440\0\u1460\0\u1480\0\u14a0\0\u14c0\0\u14e0\0\u1500\0\u1520"+
    "\0\u1540\0\u1560\0\u1580\0\u15a0\0\u15c0\0\u15e0\0\u1600\0\u1620"+
    "\0\u1640\0\u0100\0\u1660\0\u1680\0\u16a0\0\u16c0\0\u16e0\0\u1700"+
    "\0\u1720\0\u1740\0\u1760\0\u0100\0\u1780\0\u17a0\0\u17c0\0\u17e0"+
    "\0\u0100\0\u1800\0\u1820\0\u1840\0\u1860\0\u1880\0\u18a0\0\u0100"+
    "\0\u18c0\0\u18e0\0\u1900\0\u0100\0\u1920\0\u1940\0\u0100\0\u1960"+
    "\0\u1980\0\u19a0\0\u19c0\0\u19e0\0\u1a00\0\u1a20\0\u1a40\0\u1a60"+
    "\0\u0100\0\u1a80\0\u1aa0\0\u1ac0\0\u1ae0\0\u0100\0\u1b00\0\u1b20"+
    "\0\u1b40\0\u1b60\0\u1b80\0\u1ba0\0\u0100\0\u1bc0\0\u1be0\0\u1c00"+
    "\0\u0100\0\u1c20\0\u1c40\0\u0100\0\u1c60\0\u1c80\0\u1ca0\0\u1cc0"+
    "\0\u1ce0\0\u1d00\0\u0100\0\u1d20\0\u1d40\0\u1d60\0\u1d80\0\u1da0"+
    "\0\u1dc0\0\u1de0\0\u0100\0\u1e00\0\u1e20\0\u1e40\0\u1e60\0\u1e80"+
    "\0\u1ea0\0\u1ec0\0\u1ee0\0\u0100\0\u1f00\0\u1f20\0\u1f40\0\u1f60"+
    "\0\u1f80\0\u1fa0\0\u0100\0\u1fc0\0\u1fe0\0\u2000\0\u2020\0\u2040"+
    "\0\u2060\0\u2080\0\u0100\0\u20a0\0\u20c0\0\u20e0\0\u2100\0\u2120"+
    "\0\u2140\0\u2160\0\u2180\0\u0100\0\u21a0\0\u21c0\0\u0100\0\u0100"+
    "\0\u21e0\0\u2200\0\u2220\0\u0100\0\u0100\0\u2240\0\u2260\0\u2280"+
    "\0\u0100\0\u22a0\0\u22c0\0\u0100\0\u22e0\0\u2300\0\u0100\0\u2320"+
    "\0\u2340\0\u2360\0\u2380\0\u0100\0\u0100\0\u23a0\0\u23c0\0\u23e0"+
    "\0\u0100\0\u0100\0\u2400\0\u2420\0\u2440\0\u0100\0\u2460\0\u2480"+
    "\0\u0100\0\u24a0\0\u24c0\0\u0100\0\u24e0\0\u2500\0\u2520\0\u2540"+
    "\0\u2560\0\u2580\0\u25a0\0\u25c0\0\u25e0\0\u0100\0\u0100\0\u2600"+
    "\0\u2620\0\u2640\0\u0100\0\u2660\0\u0100\0\u2680\0\u26a0\0\u26c0"+
    "\0\u26e0\0\u2700\0\u2720\0\u0100\0\u0100\0\u2740\0\u2760\0\u2780"+
    "\0\u0100\0\u27a0\0\u0100\0\u0100\0\u27c0\0\u27e0\0\u0100\0\u0100"+
    "\0\u2800\0\u2820\0\u0100\0\u2840\0\u2860\0\u0100\0\u2880\0\u28a0"+
    "\0\u0100\0\u0100\0\u28c0\0\u28e0\0\u0100\0\u2900\0\u2920\0\u0100"+
    "\0\u2940\0\u0100\0\u2960\0\u2980\0\u29a0\0\u0100\0\u29c0\0\u0100"+
    "\0\u29e0\0\u2a00\0\u2a20\0\u0100\0\u2a40\0\u2a60\0\u0100\0\u0100"+
    "\0\u0100\0\u2a80\0\u2aa0\0\u0100\0\u0100\0\u2ac0\0\u2ae0\0\u2b00"+
    "\0\u2b20\0\u2b40\0\u2b60\0\u2b80\0\u2ba0\0\u0100\0\u2bc0\0\u0100"+
    "\0\u2be0\0\u0100\0\u0100";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[435];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\45\11\1\12\33\11\1\13\1\14\1\15\1\16\1\11"+
    "\1\17\32\11\1\20\1\21\1\22\1\23\1\11\1\17"+
    "\1\24\31\11\1\25\1\26\1\27\1\30\34\11\1\31"+
    "\1\26\1\27\1\32\2\11\1\24\31\11\1\33\1\26"+
    "\1\27\1\34\34\11\1\35\1\26\1\27\1\36\2\11"+
    "\1\37\30\11\44\0\1\40\34\0\1\41\2\0\1\42"+
    "\1\0\1\43\33\0\1\14\42\0\1\44\33\0\1\45"+
    "\1\43\1\46\35\0\1\47\1\21\1\22\1\50\1\0"+
    "\1\43\1\51\32\0\1\21\36\0\1\52\1\21\1\22"+
    "\1\0\1\53\1\0\1\51\40\0\1\54\1\0\1\55"+
    "\1\56\1\57\1\60\1\61\1\62\2\0\1\63\1\0"+
    "\1\64\1\65\1\66\1\0\1\67\1\70\1\71\1\72"+
    "\1\0\1\73\3\0\1\74\2\0\1\75\35\0\1\26"+
    "\42\0\1\76\33\0\1\31\2\0\1\32\2\0\1\51"+
    "\31\0\1\77\3\0\1\76\1\0\1\51\31\0\1\100"+
    "\2\0\1\101\40\0\1\102\33\0\1\35\2\0\1\36"+
    "\2\0\1\103\31\0\1\104\3\0\1\102\1\0\1\103"+
    "\40\0\1\105\1\0\1\106\1\107\1\110\1\111\1\112"+
    "\1\113\2\0\1\114\1\0\1\115\1\116\1\117\1\0"+
    "\1\120\1\121\1\122\1\123\1\0\1\124\6\0\1\125"+
    "\34\0\1\45\40\0\1\43\36\0\1\52\1\21\1\22"+
    "\3\0\1\51\41\0\1\126\3\0\1\127\1\0\1\130"+
    "\33\0\1\131\2\0\1\132\1\133\5\0\1\134\31\0"+
    "\1\135\1\136\1\137\34\0\1\140\31\0\1\141\10\0"+
    "\1\142\45\0\1\143\22\0\1\144\56\0\1\145\16\0"+
    "\1\146\3\0\1\147\45\0\1\150\10\0\1\151\22\0"+
    "\1\152\37\0\1\153\46\0\1\154\37\0\1\155\22\0"+
    "\1\156\37\0\1\157\5\0\1\160\22\0\1\77\5\0"+
    "\1\51\31\0\1\104\5\0\1\103\41\0\1\161\3\0"+
    "\1\162\1\0\1\163\33\0\1\164\2\0\1\165\1\166"+
    "\5\0\1\167\31\0\1\170\1\171\1\172\34\0\1\173"+
    "\31\0\1\174\10\0\1\175\45\0\1\176\22\0\1\177"+
    "\56\0\1\200\16\0\1\201\3\0\1\202\45\0\1\203"+
    "\10\0\1\204\22\0\1\205\37\0\1\206\46\0\1\207"+
    "\37\0\1\210\22\0\1\211\37\0\1\212\5\0\1\213"+
    "\22\0\1\125\1\214\1\215\46\0\1\216\42\0\1\217"+
    "\35\0\1\220\34\0\1\221\45\0\1\222\32\0\1\223"+
    "\61\0\1\224\17\0\1\225\40\0\1\226\51\0\1\227"+
    "\24\0\1\230\37\0\1\231\50\0\1\232\23\0\1\233"+
    "\45\0\1\234\42\0\1\235\32\0\1\236\1\237\43\0"+
    "\1\240\51\0\1\241\17\0\1\242\36\0\1\243\11\0"+
    "\1\244\26\0\1\245\41\0\1\246\15\0\1\247\35\0"+
    "\1\250\1\0\1\251\34\0\1\252\23\0\1\253\37\0"+
    "\1\254\35\0\1\255\42\0\1\256\35\0\1\257\34\0"+
    "\1\260\45\0\1\261\32\0\1\262\61\0\1\263\17\0"+
    "\1\264\40\0\1\265\51\0\1\266\24\0\1\267\37\0"+
    "\1\270\50\0\1\271\23\0\1\272\45\0\1\273\42\0"+
    "\1\274\32\0\1\275\1\276\43\0\1\277\51\0\1\300"+
    "\17\0\1\301\36\0\1\302\11\0\1\303\26\0\1\304"+
    "\41\0\1\305\15\0\1\306\35\0\1\307\1\0\1\310"+
    "\34\0\1\311\23\0\1\312\37\0\1\313\25\0\1\214"+
    "\50\0\1\314\42\0\1\315\41\0\1\316\32\0\1\317"+
    "\50\0\1\320\30\0\1\321\43\0\1\322\37\0\1\323"+
    "\37\0\1\324\35\0\1\325\36\0\1\326\44\0\1\327"+
    "\44\0\1\330\21\0\1\331\36\0\1\332\36\0\1\333"+
    "\63\0\1\334\27\0\1\335\34\0\1\336\34\0\1\337"+
    "\36\0\1\340\36\0\1\341\43\0\1\342\35\0\1\343"+
    "\55\0\1\344\21\0\1\345\31\0\1\346\45\0\1\347"+
    "\33\0\1\350\40\0\1\351\42\0\1\352\41\0\1\353"+
    "\32\0\1\354\50\0\1\355\30\0\1\356\43\0\1\357"+
    "\37\0\1\360\37\0\1\361\35\0\1\362\36\0\1\363"+
    "\44\0\1\364\44\0\1\365\21\0\1\366\36\0\1\367"+
    "\36\0\1\370\63\0\1\371\27\0\1\372\34\0\1\373"+
    "\34\0\1\374\36\0\1\375\36\0\1\376\43\0\1\377"+
    "\35\0\1\u0100\55\0\1\u0101\21\0\1\u0102\31\0\1\u0103"+
    "\45\0\1\u0104\33\0\1\u0105\41\0\1\u0106\35\0\1\u0107"+
    "\46\0\1\u0108\43\0\1\u0109\22\0\1\u010a\45\0\1\u010b"+
    "\35\0\1\u010c\61\0\1\u010d\15\0\1\u010e\45\0\1\u010f"+
    "\31\0\1\u0110\47\0\1\u0111\23\0\1\u0112\57\0\1\u0113"+
    "\17\0\1\u0114\45\0\1\u0115\35\0\1\u0116\37\0\1\u0117"+
    "\41\0\1\u0118\42\0\1\u0119\51\0\1\u011a\16\0\1\u011b"+
    "\56\0\1\u011c\33\0\1\u011d\26\0\1\u011e\35\0\1\u011f"+
    "\46\0\1\u0120\43\0\1\u0121\22\0\1\u0122\45\0\1\u0123"+
    "\35\0\1\u0124\61\0\1\u0125\15\0\1\u0126\45\0\1\u0127"+
    "\31\0\1\u0128\47\0\1\u0129\23\0\1\u012a\57\0\1\u012b"+
    "\17\0\1\u012c\45\0\1\u012d\35\0\1\u012e\37\0\1\u012f"+
    "\41\0\1\u0130\42\0\1\u0131\51\0\1\u0132\16\0\1\u0133"+
    "\56\0\1\u0134\33\0\1\u0135\22\0\1\u0136\41\0\1\u0137"+
    "\41\0\1\u0138\40\0\1\u0139\37\0\1\u013a\47\0\1\u013b"+
    "\24\0\1\u013c\60\0\1\u013d\25\0\1\u013e\43\0\1\u013f"+
    "\43\0\1\u0140\37\0\1\u0141\30\0\1\u0142\31\0\1\u0143"+
    "\41\0\1\u0144\54\0\1\u0145\21\0\1\u0146\50\0\1\u0147"+
    "\23\0\1\u0148\46\0\1\u0149\37\0\1\u014a\26\0\1\u014b"+
    "\41\0\1\u014c\41\0\1\u014d\40\0\1\u014e\37\0\1\u014f"+
    "\47\0\1\u0150\24\0\1\u0151\60\0\1\u0152\25\0\1\u0153"+
    "\43\0\1\u0154\43\0\1\u0155\37\0\1\u0156\30\0\1\u0157"+
    "\31\0\1\u0158\41\0\1\u0159\54\0\1\u015a\21\0\1\u015b"+
    "\50\0\1\u015c\23\0\1\u015d\46\0\1\u015e\37\0\1\u015f"+
    "\33\0\1\u0160\57\0\1\u0161\36\0\1\u0162\13\0\1\u0163"+
    "\43\0\1\u0164\45\0\1\u0165\33\0\1\u0166\37\0\1\u0167"+
    "\34\0\1\u0168\34\0\1\u0169\37\0\1\u016a\45\0\1\u016b"+
    "\40\0\1\u016c\53\0\1\u016d\21\0\1\u016e\57\0\1\u016f"+
    "\36\0\1\u0170\13\0\1\u0171\43\0\1\u0172\45\0\1\u0173"+
    "\33\0\1\u0174\37\0\1\u0175\34\0\1\u0176\34\0\1\u0177"+
    "\37\0\1\u0178\45\0\1\u0179\40\0\1\u017a\53\0\1\u017b"+
    "\17\0\1\u017c\34\0\1\u017d\37\0\1\u017e\60\0\1\u017f"+
    "\31\0\1\u0180\34\0\1\u0181\42\0\1\u0182\45\0\1\u0183"+
    "\21\0\1\u0184\40\0\1\u0185\36\0\1\u0186\34\0\1\u0187"+
    "\37\0\1\u0188\60\0\1\u0189\31\0\1\u018a\34\0\1\u018b"+
    "\42\0\1\u018c\45\0\1\u018d\21\0\1\u018e\40\0\1\u018f"+
    "\37\0\1\u0190\45\0\1\u0191\30\0\1\u0192\63\0\1\u0193"+
    "\16\0\1\u0194\36\0\1\u0195\36\0\1\u0196\45\0\1\u0197"+
    "\30\0\1\u0198\63\0\1\u0199\16\0\1\u019a\36\0\1\u019b"+
    "\40\0\1\u019c\35\0\1\u019d\21\0\1\u019e\27\0\1\u019f"+
    "\27\0\1\u01a0\37\0\1\u01a1\35\0\1\u01a2\21\0\1\u01a3"+
    "\27\0\1\u01a4\27\0\1\u01a5\37\0\1\u01a6\35\0\1\u01a7"+
    "\41\0\1\u01a8\35\0\1\u01a9\33\0\1\u01aa\54\0\1\u01ab"+
    "\22\0\1\u01ac\54\0\1\u01ad\40\0\1\u01ae\24\0\1\u01af"+
    "\52\0\1\u01b0\24\0\1\u01b1\42\0\1\u01b2\37\0\1\u01b3"+
    "\21\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[11264];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\1\1\1\0\1\1\1\0\1\1\1\11\2\1"+
    "\1\11\4\1\1\11\4\1\1\11\11\1\3\0\2\11"+
    "\4\1\1\0\1\1\1\11\22\0\1\11\1\1\2\0"+
    "\1\11\1\0\1\1\20\0\1\1\66\0\1\11\1\1"+
    "\4\0\1\11\30\0\1\11\5\0\1\11\30\0\1\11"+
    "\11\0\1\11\4\0\1\11\6\0\1\11\3\0\1\11"+
    "\2\0\1\11\11\0\1\11\4\0\1\11\6\0\1\11"+
    "\3\0\1\11\2\0\1\11\6\0\1\11\7\0\1\11"+
    "\10\0\1\11\6\0\1\11\7\0\1\11\10\0\1\11"+
    "\2\0\2\11\1\1\2\0\2\11\3\0\1\11\2\0"+
    "\1\11\2\0\1\11\4\0\2\11\1\1\2\0\2\11"+
    "\3\0\1\11\2\0\1\11\2\0\1\11\11\0\2\11"+
    "\3\0\1\11\1\0\1\11\6\0\2\11\3\0\1\11"+
    "\1\0\2\11\2\0\2\11\1\0\1\1\1\11\2\0"+
    "\1\11\2\0\2\11\1\0\1\1\1\11\2\0\1\11"+
    "\1\0\1\11\3\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\3\11\2\0\2\11\10\0\1\11\1\0\1\11"+
    "\1\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[435];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private String shortDesc = null;
    private String longDesc = null;
    private ArrayList<PHPDocTag> tagList = null;
    private int currTagId = 0;
    private int tagPosition = 0;
    private StringBuffer sBuffer = null;
    private int numOfLines = 0;
    private int startPos = 0;

    public PHPDocBlock parse (){
    	int start = zzStartRead - zzPushbackPos;
        longDesc = "";
        tagList = new ArrayList<PHPDocTag>();
        sBuffer = new StringBuffer();
        numOfLines = 1;

        //start parsing
        try {
            next_token();
        } catch (IOException e) {
            Logger.logException(e);
        }

        PHPDocTag[] tags = new PHPDocTag[tagList.size()];
        tagList.toArray(tags);

        PHPDocBlock rv = new PHPDocBlock(start, zzMarkedPos - zzPushbackPos, shortDesc, tags);

        return rv;

    }

    private void startTagsState(int firstState){
        updateStartPos();
        hendleDesc();
        currTagId = firstState;
        tagPosition = findTagPosition();
        sBuffer = new StringBuffer();
        yybegin(ST_IN_TAGS);
    }

    private int findTagPosition(){
    	for (int i = zzStartRead; i < zzMarkedPos; i++) {
			if(zzBuffer[i]=='@'){
				return i - zzPushbackPos;
			}
		}
    	return -1;
    }
    private void setNewTag(int newTag){
       updateStartPos();
       setTagValue();

       sBuffer = new StringBuffer();
       currTagId = newTag;
       tagPosition = findTagPosition();
    }

    private void setTagValue(){
        String value = sBuffer.toString();
        // special case for backward compatibility
        if (currTagId == PHPDocTagKinds.DESC) {
            shortDesc = shortDesc + value;
            return;
        }

        PHPDocTag basicPHPDocTag = new PHPDocTag(tagPosition, zzStartRead - zzPushbackPos, currTagId,value);
        tagList.add(basicPHPDocTag);
    }

    private void appendText(){
    	if(oldString != null){
    		sBuffer.append(oldString);
    	}
       	sBuffer.append(zzBuffer, startPos, zzMarkedPos-startPos);
       	updateStartPos();
    }

    private void hendleDesc() {
        if(zzLexicalState == ST_IN_SHORT_DESC){
            shortDesc = sBuffer.toString().trim();
        }
        else{
            longDesc = sBuffer.toString().trim();
        }

        sBuffer = new StringBuffer();
    }

    private void startLongDescState() {
        hendleDesc();
        updateStartPos();
        yybegin(ST_IN_LONG_DESC);
    }

    private void hendleNewLine() {
        appendText();
        if(numOfLines==4){
            int firstLineEnd = sBuffer.indexOf("\n",1);
            shortDesc = sBuffer.substring(0,firstLineEnd);
            shortDesc = shortDesc.trim();
            sBuffer.delete(0,firstLineEnd);
            yybegin(ST_IN_LONG_DESC);
        }
        else{
          numOfLines++;
        }
    }

    private void appendLastText(){
       sBuffer.append(zzBuffer, startPos, zzMarkedPos-startPos-2);
       updateStartPos();
    }

    int maxNumberofLines = 4;

    private void handleDocEnd_shortDesc() {
        appendLastText();
        if(numOfLines==maxNumberofLines){
            int firstLineEnd = sBuffer.indexOf("\n",1);
            shortDesc = sBuffer.substring(0,firstLineEnd);
            shortDesc = shortDesc.trim();
            sBuffer.delete(0,firstLineEnd);
            longDesc = sBuffer.toString().trim();
        }
        else{
            shortDesc = sBuffer.toString().trim();
        }
    }

    private void handleDocEnd_longDesc() {
       appendLastText();
       longDesc = sBuffer.toString().trim();
    }

    private void handleDocEnd_inTags() {
        appendLastText();
        setTagValue();
    }


    private void updateStartPos(){
        startPos = zzMarkedPos;
        oldString = null;
    }
    
    public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
    	this.zzReader = reader;
    	this.zzBuffer = buffer;
    	this.zzMarkedPos = parameters[0];
    	this.zzPushbackPos = parameters[1];
    	this.zzCurrentPos = parameters[2];
    	this.zzStartRead = parameters[3];
    	this.zzEndRead = parameters[4];
    	this.yyline = parameters[5];  
    }
    
    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
    }
    
    public char[] getBuffer(){
    	return zzBuffer;
    }
    


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DocumentorLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public DocumentorLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 134) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


    /* The following fields are added in order to support the change in zzRefill */
    
     String oldString=null;
    
 /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
	
	oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 16: 
          { startTagsState(PHPDocTagKinds.TODO);
          }
        case 80: break;
        case 44: 
          { setNewTag(PHPDocTagKinds.RETURN);
          }
        case 81: break;
        case 51: 
          { startTagsState(PHPDocTagKinds.VERSION);
          }
        case 82: break;
        case 45: 
          { setNewTag(PHPDocTagKinds.GLOBAL);
          }
        case 83: break;
        case 32: 
          { startTagsState(PHPDocTagKinds.ACCESS);
          }
        case 84: break;
        case 71: 
          { startTagsState(PHPDocTagKinds.DEPRECATED);
          }
        case 85: break;
        case 13: 
          { startTagsState(PHPDocTagKinds.VAR);
          }
        case 86: break;
        case 69: 
          { setNewTag(PHPDocTagKinds.COPYRIGHT);
          }
        case 87: break;
        case 15: 
          { setNewTag(PHPDocTagKinds.VAR);
          }
        case 88: break;
        case 42: 
          { setNewTag(PHPDocTagKinds.STATIC);
          }
        case 89: break;
        case 59: 
          { startTagsState(PHPDocTagKinds.PROPERTY);
          }
        case 90: break;
        case 18: 
          { startTagsState(PHPDocTagKinds.DESC);
          }
        case 91: break;
        case 63: 
          { setNewTag(PHPDocTagKinds.CATEGORY);
          }
        case 92: break;
        case 12: 
          { startTagsState(PHPDocTagKinds.SEE);
          }
        case 93: break;
        case 14: 
          { setNewTag(PHPDocTagKinds.SEE);
          }
        case 94: break;
        case 50: 
          { startTagsState(PHPDocTagKinds.LICENSE);
          }
        case 95: break;
        case 21: 
          { setNewTag(PHPDocTagKinds.TODO);
          }
        case 96: break;
        case 43: 
          { setNewTag(PHPDocTagKinds.THROWS);
          }
        case 97: break;
        case 65: 
          { setNewTag(PHPDocTagKinds.INTERNAL);
          }
        case 98: break;
        case 20: 
          { startTagsState(PHPDocTagKinds.NAME);
          }
        case 99: break;
        case 19: 
          { startTagsState(PHPDocTagKinds.LINK);
          }
        case 100: break;
        case 17: 
          { startTagsState(PHPDocTagKinds.USES);
          }
        case 101: break;
        case 23: 
          { setNewTag(PHPDocTagKinds.DESC);
          }
        case 102: break;
        case 52: 
          { setNewTag(PHPDocTagKinds.EXAMPLE);
          }
        case 103: break;
        case 9: 
          { handleDocEnd_longDesc();return -1;
          }
        case 104: break;
        case 29: 
          { setNewTag(PHPDocTagKinds.SINCE);
          }
        case 105: break;
        case 31: 
          { setNewTag(PHPDocTagKinds.FINAL);
          }
        case 106: break;
        case 79: 
          { setNewTag(PHPDocTagKinds.PROPERTY_WRITE);
          }
        case 107: break;
        case 47: 
          { setNewTag(PHPDocTagKinds.METHOD);
          }
        case 108: break;
        case 55: 
          { setNewTag(PHPDocTagKinds.VERSION);
          }
        case 109: break;
        case 38: 
          { startTagsState(PHPDocTagKinds.IGNORE);
          }
        case 110: break;
        case 67: 
          { startTagsState(PHPDocTagKinds.COPYRIGHT);
          }
        case 111: break;
        case 36: 
          { startTagsState(PHPDocTagKinds.RETURN);
          }
        case 112: break;
        case 68: 
          { setNewTag(PHPDocTagKinds.STATICVAR);
          }
        case 113: break;
        case 58: 
          { startTagsState(PHPDocTagKinds.CATEGORY);
          }
        case 114: break;
        case 78: 
          { startTagsState(PHPDocTagKinds.PROPERTY_WRITE);
          }
        case 115: break;
        case 49: 
          { startTagsState(PHPDocTagKinds.PACKAGE);
          }
        case 116: break;
        case 37: 
          { startTagsState(PHPDocTagKinds.GLOBAL);
          }
        case 117: break;
        case 25: 
          { setNewTag(PHPDocTagKinds.NAME);
          }
        case 118: break;
        case 26: 
          { startTagsState(PHPDocTagKinds.SINCE);
          }
        case 119: break;
        case 24: 
          { setNewTag(PHPDocTagKinds.LINK);
          }
        case 120: break;
        case 41: 
          { setNewTag(PHPDocTagKinds.AUTHOR);
          }
        case 121: break;
        case 6: 
          { appendText();
    startLongDescState();
          }
        case 122: break;
        case 22: 
          { setNewTag(PHPDocTagKinds.USES);
          }
        case 123: break;
        case 60: 
          { startTagsState(PHPDocTagKinds.INTERNAL);
          }
        case 124: break;
        case 75: 
          { setNewTag(PHPDocTagKinds.FILESOURCE);
          }
        case 125: break;
        case 61: 
          { setNewTag(PHPDocTagKinds.ABSTRACT);
          }
        case 126: break;
        case 62: 
          { setNewTag(PHPDocTagKinds.TUTORIAL);
          }
        case 127: break;
        case 54: 
          { setNewTag(PHPDocTagKinds.LICENSE);
          }
        case 128: break;
        case 11: 
          { updateStartPos();
        yybegin(ST_IN_SHORT_DESC);
          }
        case 129: break;
        case 30: 
          { setNewTag(PHPDocTagKinds.PARAM);
          }
        case 130: break;
        case 3: 
          { hendleNewLine();
          }
        case 131: break;
        case 1: 
          { updateStartPos();
          }
        case 132: break;
        case 28: 
          { startTagsState(PHPDocTagKinds.FINAL);
          }
        case 133: break;
        case 35: 
          { startTagsState(PHPDocTagKinds.THROWS);
          }
        case 134: break;
        case 40: 
          { setNewTag(PHPDocTagKinds.ACCESS);
          }
        case 135: break;
        case 4: 
          { startLongDescState();
          }
        case 136: break;
        case 34: 
          { startTagsState(PHPDocTagKinds.STATIC);
          }
        case 137: break;
        case 73: 
          { setNewTag(PHPDocTagKinds.SUBPACKAGE);
          }
        case 138: break;
        case 5: 
          { appendText();
          }
        case 139: break;
        case 77: 
          { setNewTag(PHPDocTagKinds.PROPERTY_READ);
          }
        case 140: break;
        case 66: 
          { startTagsState(PHPDocTagKinds.STATICVAR);
          }
        case 141: break;
        case 39: 
          { startTagsState(PHPDocTagKinds.METHOD);
          }
        case 142: break;
        case 27: 
          { startTagsState(PHPDocTagKinds.PARAM);
          }
        case 143: break;
        case 53: 
          { setNewTag(PHPDocTagKinds.PACKAGE);
          }
        case 144: break;
        case 56: 
          { startTagsState(PHPDocTagKinds.ABSTRACT);
          }
        case 145: break;
        case 57: 
          { startTagsState(PHPDocTagKinds.TUTORIAL);
          }
        case 146: break;
        case 74: 
          { setNewTag(PHPDocTagKinds.DEPRECATED);
          }
        case 147: break;
        case 72: 
          { startTagsState(PHPDocTagKinds.FILESOURCE);
          }
        case 148: break;
        case 33: 
          { startTagsState(PHPDocTagKinds.AUTHOR);
          }
        case 149: break;
        case 76: 
          { startTagsState(PHPDocTagKinds.PROPERTY_READ);
          }
        case 150: break;
        case 7: 
          { maxNumberofLines = 4;
    handleDocEnd_shortDesc();
    return -1;
          }
        case 151: break;
        case 46: 
          { setNewTag(PHPDocTagKinds.IGNORE);
          }
        case 152: break;
        case 64: 
          { setNewTag(PHPDocTagKinds.PROPERTY);
          }
        case 153: break;
        case 10: 
          { handleDocEnd_inTags();return -1;
          }
        case 154: break;
        case 70: 
          { startTagsState(PHPDocTagKinds.SUBPACKAGE);
          }
        case 155: break;
        case 48: 
          { startTagsState(PHPDocTagKinds.EXAMPLE);
          }
        case 156: break;
        case 2: 
          { 
          }
        case 157: break;
        case 8: 
          { maxNumberofLines = 5;
    handleDocEnd_shortDesc();
    return -1;
          }
        case 158: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            return YYEOF;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java DocumentorLexer <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        DocumentorLexer scanner = null;
        try {
          scanner = new DocumentorLexer( new java.io.FileReader(argv[i]) );
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
