/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.daemon;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.daemon.communication.CommunicationDaemonRegistry;
import org.osgi.framework.BundleContext;

public class DaemonPlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.debug.daemon";
    private static final int INTERNAL_ERROR = 10001;
    public static final boolean isDebugMode;
    private static DaemonPlugin plugin;
    private ICommunicationDaemon[] daemons;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.php.debug.daemon/debug");
        isDebugMode = value != null && value.equalsIgnoreCase("true");
    }

    public DaemonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeAfterStart(context);
    }

    void initializeAfterStart(BundleContext context) {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                DaemonPlugin.this.startDaemons(null);
                return Status.OK_STATUS;
            }
        };
        job.schedule(30L);
    }

    public void startDaemons(String debuggerID) {
        if (this.daemons == null) {
            this.daemons = CommunicationDaemonRegistry.getBestMatchCommunicationDaemons();
        }
        if (this.daemons != null) {
            int i = 0;
            while (i < this.daemons.length) {
                if (debuggerID == null || this.daemons[i].isDebuggerDaemon() && debuggerID.equals(this.daemons[i].getDebuggerID())) {
                    this.daemons[i].init();
                    this.daemons[i].startListen();
                }
                ++i;
            }
        }
    }

    public void stopDaemons(String debuggerID) {
        if (this.daemons != null) {
            int i = 0;
            while (i < this.daemons.length) {
                if (debuggerID == null || this.daemons[i].isDebuggerDaemon() && debuggerID.equals(this.daemons[i].getDebuggerID())) {
                    this.daemons[i].stopListen();
                }
                ++i;
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.stopDaemons(null);
        this.daemons = null;
    }

    public boolean validateCommunicationDaemons(String debuggerID) {
        boolean validated = true;
        if (this.daemons != null) {
            int i = 0;
            while (i < this.daemons.length) {
                if ((debuggerID == null || this.daemons[i].isDebuggerDaemon() && debuggerID.equals(this.daemons[i].getDebuggerID())) && !this.daemons[i].isListening()) {
                    validated &= this.daemons[i].resetSocket();
                }
                ++i;
            }
        }
        return validated;
    }

    public static String getID() {
        return ID;
    }

    public static DaemonPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        DaemonPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        DaemonPlugin.log((IStatus)new Status(4, ID, 10001, "Debug Daemon plugin internal error", e));
    }

    public static void logErrorMessage(String message) {
        DaemonPlugin.log((IStatus)new Status(4, ID, 10001, message, null));
    }
}

