/* The following code was generated by JFlex 1.2.2 on 5/6/09 10:11 PM */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.php.internal.core.documentModel.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.parser.ContextRegionContainer;
import org.eclipse.wst.xml.core.internal.parser.IntStack;
import org.eclipse.wst.xml.core.internal.parser.regions.XMLParserRegionFactory;
import org.eclipse.wst.xml.core.internal.regions.DOMRegionContext;



/**
 * This class is a scanner generated by 
 * <a href="http://www.informatik.tu-muenchen.de/~kleing/jflex/">JFlex</a> 1.2.2
 * on 5/6/09 10:11 PM from the specification file
 * <tt>file:/C:/Documents and Settings/michael/workspace/studio7.0/org.eclipse.php.core/Resources/parserTools/highlighting/PHPTokenizer.jflex</tt>
 */
public class PHPTokenizer implements BlockTokenizer, PHPRegionContext, DOMRegionContext {

  /** this character denotes the end of file */
  final public static int YYEOF = -1;

  /** lexical states */
  final public static int ST_XML_DOCTYPE_EXTERNAL_ID = 12;
  final public static int ST_XML_ELEMENT_DECLARATION_CONTENT = 16;
  final public static int ST_XML_DECLARATION_CLOSE = 10;
  final public static int ST_XML_TAG_NAME = 5;
  final public static int ST_XML_ATTRIBUTE_VALUE = 8;
  final public static int ST_XML_DOCTYPE_ID_SYSTEM = 14;
  final public static int ST_XML_ATTRIBUTE_NAME = 6;
  final public static int ST_XML_DOCTYPE_DECLARATION = 11;
  final public static int ST_XML_ELEMENT_DECLARATION = 15;
  final public static int ST_XML_ATTLIST_DECLARATION = 17;
  final public static int ST_XML_COMMENT_END = 4;
  final public static int ST_BLOCK_TAG_INTERNAL_SCAN = 23;
  final public static int ST_ABORT_EMBEDDED = 24;
  final public static int ST_CDATA_TEXT = 1;
  final public static int ST_XML_COMMENT = 3;
  final public static int ST_PHP_CONTENT = 20;
  final public static int ST_CDATA_END = 2;
  final public static int ST_XML_ATTRIBUTE_VALUE_DQUOTED = 22;
  final public static int ST_XML_ATTLIST_DECLARATION_CONTENT = 18;
  final public static int ST_BLOCK_TAG_SCAN = 19;
  final public static int ST_XML_ATTRIBUTE_VALUE_SQUOTED = 21;
  final public static int ST_XML_DECLARATION = 9;
  final public static int YYINITIAL = 0;
  final public static int ST_XML_EQUALS = 7;
  final public static int ST_XML_DOCTYPE_ID_PUBLIC = 13;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\0\1\4\1\21\2\0\1\13\22\0\1\13\1\20\1\10\1\50"+
    "\1\61\1\16\1\11\1\12\1\15\1\15\1\15\1\15\1\15\1\6"+
    "\1\5\1\3\12\14\1\7\1\53\1\1\1\41\1\2\1\27\1\15"+
    "\1\25\1\54\1\23\1\24\1\34\1\51\1\33\1\60\1\36\1\33"+
    "\1\33\1\32\1\31\1\40\1\37\1\43\1\33\1\33\1\35\1\26"+
    "\1\52\2\33\1\33\1\42\1\33\1\22\1\0\1\17\1\0\1\7"+
    "\1\0\1\45\1\54\1\55\1\46\1\34\1\51\1\33\1\60\1\36"+
    "\2\33\1\32\1\31\1\40\1\37\1\43\1\33\1\33\1\35\1\44"+
    "\1\52\1\33\1\33\1\30\1\42\1\33\1\62\1\47\72\0\1\57"+
    "\10\0\27\56\1\0\37\56\1\0\72\56\2\0\13\56\2\0\10\56"+
    "\1\0\65\56\1\0\104\56\11\0\44\56\3\0\2\56\4\0\36\56"+
    "\70\0\131\56\22\0\7\56\16\0\2\57\56\0\106\57\32\0\2\57"+
    "\44\0\1\56\1\57\3\56\1\0\1\56\1\0\24\56\1\0\54\56"+
    "\1\0\7\56\3\0\1\56\1\0\1\56\1\0\1\56\1\0\1\56"+
    "\1\0\22\56\15\0\14\56\1\0\102\56\1\0\14\56\1\0\44\56"+
    "\1\0\4\57\11\0\65\56\2\0\2\56\2\0\2\56\3\0\34\56"+
    "\2\0\10\56\2\0\2\56\67\0\46\56\2\0\1\56\7\0\46\56"+
    "\12\0\21\57\1\0\27\57\1\0\3\57\1\0\1\57\1\0\2\57"+
    "\1\0\1\57\13\0\33\56\5\0\3\56\56\0\32\56\5\0\1\57"+
    "\12\56\10\57\15\0\12\57\6\0\1\57\107\56\2\0\5\56\1\0"+
    "\17\56\1\0\4\56\1\0\1\56\17\57\2\56\2\57\1\0\4\57"+
    "\2\0\12\57\u0207\0\3\57\1\0\65\56\2\0\1\57\1\56\20\57"+
    "\3\0\4\57\3\0\12\56\2\57\2\0\12\57\21\0\3\57\1\0"+
    "\10\56\2\0\2\56\2\0\26\56\1\0\7\56\1\0\1\56\3\0"+
    "\4\56\2\0\1\57\1\0\7\57\2\0\2\57\2\0\3\57\11\0"+
    "\1\57\4\0\2\56\1\0\3\56\2\57\2\0\12\57\2\56\20\0"+
    "\1\57\2\0\6\56\4\0\2\56\2\0\26\56\1\0\7\56\1\0"+
    "\2\56\1\0\2\56\1\0\2\56\2\0\1\57\1\0\5\57\4\0"+
    "\2\57\2\0\3\57\13\0\4\56\1\0\1\56\7\0\12\57\2\57"+
    "\3\56\14\0\3\57\1\0\7\56\1\0\1\56\1\0\3\56\1\0"+
    "\26\56\1\0\7\56\1\0\2\56\1\0\5\56\2\0\1\57\1\56"+
    "\10\57\1\0\3\57\1\0\3\57\22\0\1\56\5\0\12\57\21\0"+
    "\3\57\1\0\10\56\2\0\2\56\2\0\26\56\1\0\7\56\1\0"+
    "\2\56\2\0\4\56\2\0\1\57\1\56\6\57\3\0\2\57\2\0"+
    "\3\57\10\0\2\57\4\0\2\56\1\0\3\56\4\0\12\57\22\0"+
    "\2\57\1\0\6\56\3\0\3\56\1\0\4\56\3\0\2\56\1\0"+
    "\1\56\1\0\2\56\3\0\2\56\3\0\3\56\3\0\10\56\1\0"+
    "\3\56\4\0\5\57\3\0\3\57\1\0\4\57\11\0\1\57\17\0"+
    "\11\57\21\0\3\57\1\0\10\56\1\0\3\56\1\0\27\56\1\0"+
    "\12\56\1\0\5\56\4\0\7\57\1\0\3\57\1\0\4\57\7\0"+
    "\2\57\11\0\2\56\4\0\12\57\22\0\2\57\1\0\10\56\1\0"+
    "\3\56\1\0\27\56\1\0\12\56\1\0\5\56\4\0\7\57\1\0"+
    "\3\57\1\0\4\57\7\0\2\57\7\0\1\56\1\0\2\56\4\0"+
    "\12\57\22\0\2\57\1\0\10\56\1\0\3\56\1\0\27\56\1\0"+
    "\20\56\4\0\6\57\2\0\3\57\1\0\4\57\11\0\1\57\10\0"+
    "\2\56\4\0\12\57\221\0\56\56\1\0\1\56\1\57\2\56\7\57"+
    "\5\0\6\56\1\57\10\57\1\0\12\57\47\0\2\56\1\0\1\56"+
    "\2\0\2\56\1\0\1\56\2\0\1\56\6\0\4\56\1\0\7\56"+
    "\1\0\3\56\1\0\1\56\1\0\1\56\2\0\2\56\1\0\2\56"+
    "\1\0\1\56\1\57\2\56\6\57\1\0\2\57\1\56\2\0\5\56"+
    "\1\0\1\57\1\0\6\57\2\0\12\57\76\0\2\57\6\0\12\57"+
    "\13\0\1\57\1\0\1\57\1\0\1\57\4\0\2\57\10\56\1\0"+
    "\41\56\7\0\24\57\1\0\6\57\4\0\6\57\1\0\1\57\1\0"+
    "\25\57\3\0\7\57\1\0\1\57\346\0\46\56\12\0\47\56\11\0"+
    "\1\56\1\0\2\56\1\0\3\56\1\0\1\56\1\0\2\56\1\0"+
    "\5\56\51\0\1\56\1\0\1\56\1\0\1\56\13\0\1\56\1\0"+
    "\1\56\1\0\1\56\3\0\2\56\3\0\1\56\5\0\3\56\1\0"+
    "\1\56\1\0\1\56\1\0\1\56\1\0\1\56\3\0\2\56\3\0"+
    "\2\56\1\0\1\56\50\0\1\56\11\0\1\56\2\0\1\56\2\0"+
    "\2\56\7\0\2\56\1\0\1\56\1\0\7\56\50\0\1\56\4\0"+
    "\1\56\10\0\1\56\u0c06\0\234\56\4\0\132\56\6\0\26\56\2\0"+
    "\6\56\2\0\46\56\2\0\6\56\2\0\10\56\1\0\1\56\1\0"+
    "\1\56\1\0\1\56\1\0\37\56\2\0\65\56\1\0\7\56\1\0"+
    "\1\56\3\0\3\56\1\0\7\56\3\0\4\56\2\0\6\56\4\0"+
    "\15\56\5\0\3\56\1\0\7\56\323\0\15\57\4\0\1\57\104\0"+
    "\1\56\3\0\2\56\2\0\1\56\121\0\3\56\u0e82\0\1\57\1\0"+
    "\1\56\31\0\11\56\6\57\1\0\5\57\13\0\124\56\4\0\2\57"+
    "\2\0\2\57\2\0\132\56\1\0\3\57\6\0\50\56\u1cd3\0\u51a6\56"+
    "\u0c5a\0\u2ba4\56\134\0\u0800\0\u1ffe\0\2\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    51,   102,   153,   204,   255,   306,   357,   408,   459, 
      510,   561,   612,   663,   714,   765,   816,   867,   918,   969, 
     1020,  1071,  1122,  1173,  1224,  1275,  1326,  1377,  1428,  1479, 
     1530,  1479,  1581,  1632,  1479,  1479,  1530,  1683,  1734,  1479, 
     1785,  1836,  1887,  1938,  1989,  2040,  1479,  2091,  2142,  2193, 
     2244,  2295,  2346,  1479,  2397,  2448,  2499,  1530,  2550,  2601, 
     2652,  2703,  2754,  2754,  2805,  2856,  2907,  2958,  2958,  3009, 
     3060,  3111,  3162,  3162,  3213,  3264,  3315,  3366,  1479,  3417, 
     3417,  3468,  3519,  3570,  3621,  1479,  1479,  1581,  1479,  1581, 
     3672,  3723,  3774,  1479,  3825,  3876,  1479,  3927,  1479,  1479, 
     3978,  4029,  4080,  4131,  4182,  4233,  4284,  4335,  4386,  1479, 
     4437,  2091,  4488,  2244,  1479,  2295,  3978,  4539,  4590,  4641, 
     2550,  1479,  4692,  4743,  2754,  4794,  2805,  1479,  4845,  4896, 
     4947,  4947,  4998,  5049,  2907,  2754,  2958,  5100,  3009,  1479, 
     5151,  3060,  3111,  2958,  3162,  5202,  3213,  1479,  5253,  5304, 
     5355,  5355,  5406,  5457,  5508,  3417,  5559,  3468,  1479,  5610, 
     5661,  5712,  5712,  5763,  5814,  5865,  1479,  3825,  1479,  3927, 
     5916,  5967,  6018,  6069,  6120,  6171,  1479,  6222,  6273,  1479, 
     1479,  1479,  6324,  6375,  6426,  6477,  6528,  4845,  6579,  6579, 
     5253,  6630,  6630,  6681,  5610,  6732,  6732,  6783,  1479,  6834, 
     6885,  6936,  1479,  6987,  7038,  7089,  7140,  7191,  7242,  4998, 
     5406,  7293,  5763,  7344,  7395,  6018,  7446,  7497,  7548,  7599, 
     7650,  7701,  7752,  7803,  7854,  7905,  7956,  1479,  1479,  8007, 
     8058,  8109,  1479,  1479,  1479,  8160,  8211,  8262,  8313,  8364, 
     1479,  3315,  3570
  };

  /** 
   * The packed transition table of the DFA
   */
  final private static String yy_packed = 
    "\1\32\1\33\7\32\1\34\4\32\1\35\44\32\1\36"+
    "\1\37\61\36\1\40\1\41\15\40\1\42\1\40\1\43"+
    "\41\40\1\44\1\45\61\44\1\40\1\41\4\40\1\46"+
    "\12\40\1\43\41\40\1\47\1\33\1\50\1\51\3\47"+
    "\1\52\13\47\4\53\1\47\11\53\1\47\5\53\2\47"+
    "\2\53\1\47\3\53\1\47\1\53\2\47\1\40\1\54"+
    "\1\50\1\51\1\55\2\40\1\56\3\40\1\55\5\40"+
    "\1\55\1\40\4\56\1\40\11\56\1\40\5\56\2\40"+
    "\2\56\1\40\3\56\1\40\1\56\3\40\1\54\1\50"+
    "\1\51\1\55\2\40\1\56\3\40\1\55\5\40\1\55"+
    "\1\40\4\56\1\40\11\56\1\57\5\56\2\40\2\56"+
    "\1\40\3\56\1\40\1\56\2\40\1\60\1\61\1\50"+
    "\1\62\1\55\3\60\1\63\1\60\1\64\1\55\5\60"+
    "\1\55\41\60\1\40\1\65\1\66\1\40\1\55\6\40"+
    "\1\55\5\40\1\55\2\40\1\67\1\70\6\40\1\71"+
    "\10\40\1\70\1\67\15\40\1\72\1\66\1\40\1\55"+
    "\6\40\1\55\5\40\1\55\1\73\41\40\1\72\1\66"+
    "\1\40\1\55\2\40\1\74\3\40\1\55\5\40\1\55"+
    "\1\73\4\74\1\40\11\74\1\40\5\74\2\40\2\74"+
    "\1\40\3\74\1\40\1\74\3\40\1\72\1\66\1\40"+
    "\1\55\6\40\1\55\5\40\1\55\1\73\12\40\1\75"+
    "\5\40\1\76\17\40\1\77\1\72\1\66\1\100\1\55"+
    "\3\77\1\101\1\77\1\102\1\55\5\77\1\55\1\103"+
    "\40\77\1\104\1\72\1\66\1\105\1\55\3\104\1\106"+
    "\1\104\1\107\1\55\5\104\1\55\1\110\40\104\1\111"+
    "\1\72\1\66\1\112\1\55\3\111\1\113\1\111\1\114"+
    "\1\55\5\111\1\55\41\111\1\115\1\116\1\117\60\115"+
    "\1\120\1\72\1\66\1\121\1\55\3\120\1\122\1\120"+
    "\1\123\1\55\5\120\1\55\41\120\1\124\1\125\1\126"+
    "\60\124\1\127\1\130\61\127\1\131\1\132\14\131\1\133"+
    "\10\131\1\133\33\131\1\134\1\135\10\134\1\136\35\134"+
    "\1\137\10\134\1\137\1\134\1\140\1\135\6\140\1\141"+
    "\37\140\1\142\10\140\1\142\1\140\1\40\1\72\17\40"+
    "\1\43\42\40\1\41\17\40\1\43\41\40\1\32\1\0"+
    "\7\32\1\0\4\32\1\0\44\32\3\0\1\143\12\0"+
    "\1\144\1\0\1\145\6\0\1\146\37\0\1\147\2\0"+
    "\1\150\3\0\1\147\5\0\1\147\1\0\4\150\1\0"+
    "\11\150\1\0\5\150\1\0\1\151\2\150\1\0\3\150"+
    "\1\0\1\150\6\0\1\147\2\0\1\152\3\0\1\147"+
    "\5\0\1\147\1\0\4\152\1\0\11\152\1\0\5\152"+
    "\2\0\2\152\1\0\3\152\1\0\1\152\103\0\1\144"+
    "\1\0\1\153\6\0\1\146\53\0\1\153\61\0\1\154"+
    "\51\0\1\155\54\0\1\47\3\0\17\47\4\0\1\47"+
    "\11\0\1\47\5\0\2\47\2\0\1\47\3\0\1\47"+
    "\1\0\2\47\2\0\1\156\60\0\1\47\3\0\1\47"+
    "\3\52\4\47\1\52\6\47\4\53\1\47\11\53\1\47"+
    "\5\53\2\47\2\53\1\47\3\53\1\52\1\53\2\47"+
    "\5\0\3\53\4\0\1\53\6\0\4\53\1\0\11\53"+
    "\1\0\5\53\2\0\2\53\1\0\5\53\5\0\1\143"+
    "\3\0\1\157\6\0\1\144\1\0\1\145\2\0\4\157"+
    "\1\146\11\157\1\0\5\157\2\0\2\157\1\0\3\157"+
    "\1\0\1\157\6\0\1\55\6\0\1\55\5\0\1\55"+
    "\46\0\3\56\4\0\1\56\6\0\4\56\1\0\11\56"+
    "\1\0\5\56\2\0\2\56\1\0\5\56\2\0\1\60"+
    "\2\0\1\160\1\0\3\60\1\0\1\60\2\0\5\60"+
    "\1\0\41\60\3\0\1\143\3\0\1\161\6\0\1\144"+
    "\1\0\1\145\2\0\4\161\1\146\11\161\1\0\5\161"+
    "\2\0\2\161\1\0\3\161\1\0\1\161\2\0\1\60"+
    "\1\0\1\156\1\160\1\0\3\60\1\0\1\60\2\0"+
    "\5\60\1\0\41\60\1\162\1\0\6\162\1\163\52\162"+
    "\1\164\1\0\10\164\1\163\50\164\3\0\1\143\12\0"+
    "\1\144\1\0\1\165\6\0\1\146\72\0\1\166\51\0"+
    "\1\167\15\0\1\167\50\0\1\170\30\0\17\171\1\172"+
    "\43\171\5\0\3\74\4\0\1\74\6\0\4\74\1\0"+
    "\11\74\1\0\5\74\2\0\2\74\1\0\5\74\44\0"+
    "\1\173\72\0\1\174\10\0\1\77\2\0\1\175\1\0"+
    "\3\77\1\0\1\77\2\0\5\77\1\0\41\77\1\101"+
    "\1\0\1\176\1\177\1\176\3\101\1\200\1\101\2\176"+
    "\5\101\1\176\41\101\1\201\1\0\1\202\1\203\1\202"+
    "\3\204\1\202\1\201\1\205\1\206\3\204\1\201\1\204"+
    "\1\206\1\201\24\204\1\201\6\204\2\201\2\204\1\201"+
    "\1\103\2\171\1\207\1\171\3\103\1\171\1\103\2\171"+
    "\3\103\1\210\1\103\1\171\41\103\1\104\2\0\1\211"+
    "\1\0\3\104\1\0\1\104\2\0\5\104\1\0\41\104"+
    "\1\106\2\212\1\213\1\212\3\106\1\214\1\106\2\212"+
    "\5\106\1\212\41\106\1\107\2\215\1\216\1\215\3\107"+
    "\1\215\1\107\1\214\1\215\5\107\1\215\41\107\1\110"+
    "\2\171\1\217\1\171\3\110\1\171\1\110\2\171\3\110"+
    "\1\220\1\110\1\171\41\110\1\111\2\0\1\221\1\0"+
    "\3\111\1\0\1\111\2\0\5\111\1\0\41\111\1\113"+
    "\1\0\1\222\1\223\1\222\3\113\1\224\1\113\2\222"+
    "\5\113\1\222\41\113\1\225\1\0\1\226\1\227\1\226"+
    "\3\230\1\226\1\225\1\231\1\232\3\230\1\225\1\230"+
    "\1\232\1\225\24\230\1\225\6\230\2\225\2\230\1\225"+
    "\2\115\1\0\62\115\1\0\15\115\1\233\42\115\1\120"+
    "\2\0\1\234\1\0\3\120\1\0\1\120\2\0\5\120"+
    "\1\0\41\120\1\122\1\0\1\235\1\236\1\235\3\122"+
    "\1\237\1\122\2\235\5\122\1\235\41\122\1\240\1\0"+
    "\1\241\1\242\1\241\3\243\1\241\1\240\1\244\1\245"+
    "\3\243\1\240\1\243\1\245\1\240\24\243\1\240\6\243"+
    "\2\240\2\243\1\240\2\124\1\0\62\124\1\0\15\124"+
    "\1\246\42\124\2\0\1\247\60\0\1\134\1\0\10\134"+
    "\1\0\35\134\1\250\10\134\1\250\1\134\3\0\1\251"+
    "\12\0\1\144\1\0\1\153\6\0\1\146\33\0\62\134"+
    "\1\0\1\140\1\0\6\140\1\0\37\140\1\252\10\140"+
    "\1\252\63\140\7\0\1\253\13\0\1\254\44\0\1\255"+
    "\6\0\1\255\5\0\1\255\21\0\1\256\23\0\1\147"+
    "\2\0\1\32\3\0\1\147\5\0\1\147\1\0\4\32"+
    "\1\0\11\32\1\0\5\32\2\0\2\32\1\0\3\32"+
    "\1\0\1\32\2\0\1\257\1\0\2\257\1\260\3\150"+
    "\1\257\1\0\1\257\1\260\1\150\1\257\1\0\2\257"+
    "\1\260\1\257\4\150\1\257\11\150\1\257\5\150\2\257"+
    "\2\150\1\261\5\150\2\257\14\0\1\262\13\0\1\263"+
    "\32\0\1\257\1\0\2\257\1\260\3\152\1\257\1\0"+
    "\1\257\1\260\1\152\1\257\1\0\2\257\1\260\1\257"+
    "\4\152\1\257\11\152\1\257\5\152\2\257\2\152\1\264"+
    "\5\152\2\257\22\0\1\254\42\0\1\265\62\0\1\266"+
    "\65\0\3\157\4\0\1\157\6\0\4\157\1\0\11\157"+
    "\1\0\5\157\2\0\2\157\1\0\5\157\7\0\3\161"+
    "\4\0\1\161\6\0\4\161\1\0\11\161\1\0\5\161"+
    "\2\0\2\161\1\0\5\161\25\0\1\267\31\0\1\267"+
    "\33\0\1\270\15\0\1\270\52\0\1\271\63\0\1\272"+
    "\101\0\1\273\6\0\1\176\1\0\6\176\1\200\52\176"+
    "\1\201\1\0\1\202\1\274\1\202\3\201\1\202\1\201"+
    "\1\200\1\202\5\201\1\202\41\201\1\202\1\0\10\202"+
    "\1\200\50\202\1\201\1\0\1\202\1\274\1\202\3\201"+
    "\1\202\1\201\1\275\1\202\5\201\1\202\41\201\12\0"+
    "\1\276\50\0\1\202\1\0\10\202\1\275\50\202\10\212"+
    "\1\214\52\212\12\215\1\214\50\215\1\222\1\0\6\222"+
    "\1\224\52\222\1\225\1\0\1\226\1\277\1\226\3\225"+
    "\1\226\1\225\1\224\1\226\5\225\1\226\41\225\1\226"+
    "\1\0\10\226\1\224\50\226\1\225\1\0\1\226\1\277"+
    "\1\226\3\225\1\226\1\225\1\300\1\226\5\225\1\226"+
    "\41\225\12\0\1\301\50\0\1\226\1\0\10\226\1\300"+
    "\50\226\2\115\1\0\17\115\1\302\40\115\1\235\1\0"+
    "\6\235\1\237\52\235\1\240\1\0\1\241\1\303\1\241"+
    "\3\240\1\241\1\240\1\237\1\241\5\240\1\241\41\240"+
    "\1\241\1\0\10\241\1\237\50\241\1\240\1\0\1\241"+
    "\1\303\1\241\3\240\1\241\1\240\1\304\1\241\5\240"+
    "\1\241\41\240\12\0\1\305\50\0\1\241\1\0\10\241"+
    "\1\304\50\241\2\124\1\0\17\124\1\306\40\124\6\0"+
    "\1\307\77\0\1\310\43\0\1\255\6\0\1\255\5\0"+
    "\1\255\121\0\1\311\2\0\1\257\1\0\7\257\1\0"+
    "\4\257\1\0\34\257\1\0\10\257\1\0\2\257\1\260"+
    "\4\257\1\0\1\257\1\260\2\257\1\0\2\257\1\260"+
    "\31\257\1\312\7\257\14\0\1\262\36\0\1\313\23\0"+
    "\1\314\6\0\3\314\6\0\1\314\10\0\2\314\2\0"+
    "\1\314\2\0\2\314\33\0\1\315\15\0\1\315\50\0"+
    "\1\316\61\0\1\317\57\0\1\320\15\0\1\320\50\0"+
    "\1\321\33\0\1\322\1\0\3\322\2\0\1\205\4\322"+
    "\1\0\2\322\1\0\24\322\1\0\6\322\2\0\2\322"+
    "\4\0\1\323\1\0\3\323\2\0\1\231\4\323\1\0"+
    "\2\323\1\0\24\323\1\0\6\323\2\0\2\323\1\0"+
    "\2\115\1\0\20\115\1\324\37\115\3\0\1\325\1\0"+
    "\3\325\2\0\1\244\4\325\1\0\2\325\1\0\24\325"+
    "\1\0\6\325\2\0\2\325\1\0\2\124\1\0\20\124"+
    "\1\326\37\124\24\0\1\327\101\0\1\330\3\0\1\330"+
    "\66\0\1\312\23\0\1\314\6\0\3\314\6\0\1\314"+
    "\10\0\2\314\2\0\1\314\1\0\1\313\2\314\47\0"+
    "\1\331\56\0\1\332\60\0\1\333\62\0\1\334\64\0"+
    "\1\335\24\0\2\115\1\0\21\115\1\336\36\115\2\124"+
    "\1\0\21\124\1\337\36\124\25\0\1\340\100\0\1\341"+
    "\54\0\1\342\65\0\1\343\53\0\1\344\54\0\1\345"+
    "\31\0\1\345\5\0\2\115\1\0\22\115\1\346\35\115"+
    "\2\124\1\0\22\124\1\347\35\124\26\0\1\350\70\0"+
    "\1\351\54\0\1\352\15\0\1\352\44\0\1\353\15\0"+
    "\1\353\16\0\2\115\1\0\23\115\1\354\34\115\2\124"+
    "\1\0\23\124\1\355\34\124\25\0\1\356\35\0\2\115"+
    "\1\0\22\115\1\357\35\115\2\124\1\0\22\124\1\360"+
    "\35\124\22\0\1\361\40\0\2\115\1\0\17\115\1\362"+
    "\40\115\2\124\1\0\17\124\1\363\40\124";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack(yy_packed);


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  // final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",		//$NON-NLS-1$
    "Internal error: unknown state",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"	//$NON-NLS-1$
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     1,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  9,  1,  9, 
     1,  1,  9,  9,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  9,  1, 
     1,  1,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9,  1, 
     1,  1,  1,  1,  1,  9,  9,  1,  9,  1,  1,  1,  1,  9,  1,  1, 
     9,  1,  9,  9,  1,  1,  0,  1,  0,  1,  0,  0,  0,  9,  1,  0, 
     1,  0,  9,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  9, 
     1,  0,  0,  1,  1,  0,  0,  1,  0,  0,  0,  9,  0,  0,  0,  1, 
     0,  0,  0,  9,  1,  0,  0,  1,  1,  0,  1,  0,  0,  0,  9,  1, 
     0,  0,  1,  1,  0,  1,  9,  0,  9,  0,  0,  0,  1,  0,  1,  1, 
     9,  0,  0,  9,  9,  9,  0,  0,  0,  0,  0,  0,  1,  0,  0,  1, 
     0,  1,  0,  1,  0,  1,  9,  0,  0,  1,  9,  0,  0,  0,  0,  0, 
     0,  0,  0,  1,  0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0, 
     0,  0,  0,  9,  9,  1,  1,  0,  9,  9,  9,  1,  1,  0,  1,  1, 
     9,  1,  1
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[16384];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  // private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  // private boolean yy_atBOL;

  /** yy_atEOF == true <=> the scanner has returned a value for EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */
	// where the last internal container block was found
	private int fLastInternalBlockStart = -1;

	private int fTokenCount = 0;
 
	// required holders for white-space compacting
	private boolean fShouldLoadBuffered = false;
	private String fBufferedContext = null;
	private String fBufferedText = null;
	private int fBufferedStart = 1;
	private int fBufferedLength = 0;
	
	// help for php container text region
	private ContextRegionContainer fBufferedEmbeddedContainer = null;
	private String f_context = null;


	// state stack for handling embedded regions
	private IntStack fStateStack = new IntStack();

	// a "hint" as to what an embedded region should be evaluated
	private String fEmbeddedHint = UNDEFINED;
	// a "hint" as to what state to enter once an embedded region has 
	// been completed
	private int fEmbeddedPostState = YYINITIAL;
	// the container used to create embedded regions
	private ContextRegionContainer fEmbeddedContainer = null;
	private static final String PROXY_CONTEXT = "PROXY_CONTEXT";

	private String context = null;
	private String text = null;
	private int start = 0;
	private int textLength = 0;
	private int length = 0;

	// offset for tracking position specific block tags
	private int fOffset = 0;
	
	// the name of the current tag being opened
	private String fCurrentTagName = null;

	// the list of tag name BlockMarkers
	private List fBlockMarkers = new ArrayList();

	// required to not seek text blocks on an end tag
	private boolean fIsBlockingEnabled = false;
	private boolean fIsCaseSensitiveBlocking = true;

	// the name of the current tag inside of an embedded region
	private String internalTagName = null;
	private String internalContext = null;
	
	private final XMLParserRegionFactory fRegionFactory = new XMLParserRegionFactory();

/**
 * user method 
 */
public final void addBlockMarker(BlockMarker marker) {
	if(containsTagName(marker.getTagName()))
		return;
	fBlockMarkers.add(marker);
}
/**
 * user method 
 */
public final void removeBlockMarker(BlockMarker marker) {
	fBlockMarkers.remove(marker);
}
/**
 * user method 
 */
public final void removeBlockMarker(String tagname) {
	if (fBlockMarkers != null) {
		Iterator blocks = fBlockMarkers.iterator();
		while (blocks.hasNext()) {
			if (((BlockMarker) blocks.next()).getTagName().equals(tagname))
				blocks.remove();
		}
	}
}
/* user method */
public boolean getBlockMarkerCaseSensitivity() {
        return getBlockMarkerCaseSensitivity(fCurrentTagName);
}
/* user method */
public boolean getBlockMarkerCaseSensitivity(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker)iterator.next();
		boolean casesensitive = marker.isCaseSensitive();
		if(casesensitive && marker.getTagName().equals(name))
			return casesensitive;
		else if(!casesensitive && marker.getTagName().equalsIgnoreCase(name))
			return casesensitive;
	}
	return true;
}
/* user method */
public String getBlockMarkerContext() {
	return getBlockMarkerContext(fCurrentTagName);
}
/* user method */
public String getBlockMarkerContext(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker)iterator.next();
		if(marker.getTagName().equals(name))
			return marker.getContext();
	}
	return BLOCK_TEXT;
}
/* user method */
public List getBlockMarkers() {
	return fBlockMarkers;
}
/* user method */
public final int getOffset() {
	return fOffset + yychar;
}
private final boolean isBlockMarker() {
	return isBlockMarker(fCurrentTagName);
}
private final boolean isBlockMarker(String tagName) {
	if (!fIsBlockingEnabled)
		return false;
	return containsTagName(tagName);
}
/**
 * user method
 */
public final void beginBlockTagScan(String newTagName) {
	beginBlockMarkerScan(newTagName, BLOCK_TEXT);
}
/**
 * user method
 *
 * Special tokenizer setup.  Allows tokenization to be initiated at the
 * start of a text block within a "newTagName" tag.
 *
 * Example: 
 *	Tokenizer toker = new Tokenizer();
 *	toker.setCaseSensitiveBlocking(false);
 *	toker.reset(new java.io.StringReader("afiuhqwkejhtasihgalkwhtq</scripter></scr></script>asgdasga"));
 *	toker.beginBlockMarkerScan("script", BLOCK_TEXT);
 *	toker.getRegions(); 
 *
 * Returns:
 *	BLOCK_TEXT: 0-40
 *	XML_END_TAG_OPEN: 41-42
 *	XML_TAG_NAME: 43-48
 *	XML_TAG_CLOSE: 49-49
 *	XML_CONTENT: 50-57
 *
 */
public final void beginBlockMarkerScan(String newTagName, String blockcontext) {
	yybegin(ST_BLOCK_TAG_SCAN);
	fCurrentTagName = newTagName;
}
/**
 * Method doScan.
 * 
 * Returns a context region for all of the text from the current position upto the end of input or
 * to right *before* the first occurence of searchString
 * 
 * @param searchString - target string to search for ex.: "-->", "</tagname"
 * @param requireTailSeparator - whether the target must be immediately followed by whitespace or '>'
 * @param context - the context of the scanned region if non-zero length
 * @param exitState - the state to go to if the region was of non-zero length
 * @param abortState - the state to go to if the searchString was found immediately
 * @return String - the context found: the desired context on a non-zero length match, the abortContext on immediate success
 * @throws IOException
 */
private final String doScan(String searchString, boolean allowPHP, boolean requireTailSeparator, String searchContext, int exitState, int immediateFallbackState) throws IOException {
	boolean stillSearching = true;
	// Disable further block (probably)
	fIsBlockingEnabled = false;
	int searchStringLength = searchString.length();
	int n = 0;
	char lastCheckChar;
	int i;
	boolean same = false;
	while (stillSearching) {
		n = 0;
		// Ensure that enough data from the input exists to compare against the search String.
		n = yy_advance();
		while(n != YYEOF && yy_currentPos < searchStringLength)
			n = yy_advance();
		// If the input was too short or we've exhausted the input, stop immediately.
		if (n == YYEOF) {
			stillSearching = false;
		}
		else {
			
			/**
			 * Look for starting PHPs "<?"
			 */
			// Look for a PHP beginning at the current position; this case wouldn't be handled by the preceding section
			// since it relies upon *having* closeTagStringLength amount of input to work as designed.  Must be sure we don't
			// spill over the end of the buffer while checking.
			if(allowPHP && yy_startRead != fLastInternalBlockStart && yy_currentPos > 0 && yy_currentPos < yy_buffer.length - 1 &&
					yy_buffer[yy_currentPos - 1] == '<' && 
					(yy_buffer[yy_currentPos] == '?' || (yy_buffer[yy_currentPos] == '%' && ProjectOptions.isSupportingAspTags(project)))) {
				fLastInternalBlockStart = yy_markedPos = yy_currentPos - 1;
				yy_currentPos = yy_markedPos + 1;
				int resumeState = yystate();
				yybegin(ST_BLOCK_TAG_INTERNAL_SCAN);
				if(yy_markedPos == yy_startRead) {
					String jspContext = primGetNextToken();
					yybegin(resumeState);
					return jspContext;
				}
				return searchContext;
			}
			
			// 2) yy_currentPos - jspstarter.length : There's not searchStringLength of input available; check for a JSP 2 spots back in what we could read
			// ---
			// Look for a JSP beginning at the current position; this case wouldn't be handled by the preceding section
			// since it relies upon *having* closeTagStringLength amount of input to work as designed.  Must be sure we don't
			// spill over the end of the buffer while checking.
			else if(allowPHP && yy_startRead != fLastInternalBlockStart && yy_currentPos > 0 && yy_currentPos < yy_buffer.length - 1 &&
					yy_buffer[yy_currentPos - 1] == '<' && yy_buffer[yy_currentPos] == '?') {
				fLastInternalBlockStart = yy_markedPos = yy_currentPos - 1;
				yy_currentPos = yy_markedPos + 1;
				int resumeState = yystate();
				yybegin(ST_BLOCK_TAG_INTERNAL_SCAN);
				if(yy_markedPos == yy_startRead) {
					String jspContext = primGetNextToken();
					yybegin(resumeState);
					return jspContext;
				}
				return searchContext;
			}
			// 3) yy_currentPos..(yy_currentPos+jspStartlength-1) : Check at the start of the block one time
			// ---
			// Look for a JSP beginning immediately in the block area; this case wouldn't be handled by the preceding section
			// since it relies upon yy_currentPos equaling exactly the previous end +1 to work as designed.
			else if(allowPHP && yy_startRead != fLastInternalBlockStart && yy_startRead > 0 &&
					yy_startRead < yy_buffer.length - 1 && yy_buffer[yy_startRead] == '<' && yy_buffer[yy_startRead + 1] == '?') {
				fLastInternalBlockStart = yy_markedPos = yy_startRead;
				yy_currentPos = yy_markedPos + 1;
				int resumeState = yystate();
				yybegin(ST_BLOCK_TAG_INTERNAL_SCAN);
				if(yy_markedPos == yy_startRead) {
					String jspContext = primGetNextToken();
					yybegin(resumeState);
					return jspContext;
				}
				return searchContext;
			}

			// Check the characters in the target versus the last targetLength characters read from the buffer
			// and see if it matches
			if (n == YYEOF) {
				stillSearching = false;
			}
			else {
				same = true;
				// Ensure that we've not encountered a complete block (<%%>) that was *shorter* than the closeTagString and
				// thus found twice at current-targetLength [since the first scan would have come out this far anyway].
				// Check the characters in the target versus the last targetLength characters read from the buffer
				// and see if it matches
				
				// safety check for array accesses (yy_currentPos is the *last* character we can check against)
				if(yy_currentPos >= searchStringLength && yy_currentPos <= yy_buffer.length) {
					for(i = 0; i < searchStringLength; i++) {
						if(same && fIsCaseSensitiveBlocking)
							same = yy_buffer[i + yy_currentPos - searchStringLength] == searchString.charAt(i);
						else if(same && !fIsCaseSensitiveBlocking)
							same = Character.toLowerCase(yy_buffer[i + yy_currentPos - searchStringLength]) == Character.toLowerCase(searchString.charAt(i));
					}
				}
				// safety check failed; no match is possible right now
				else {
					same = false;
				}
			}
			if (same && requireTailSeparator && yy_currentPos < yy_buffer.length) {
				// Additional check for close tags to ensure that targetString="</script" doesn't match
				// "</scriptS"
				lastCheckChar = yy_buffer[yy_currentPos];
				// Succeed on "</script>" and "</script "
				if(lastCheckChar == '>' || Character.isWhitespace(lastCheckChar))
					stillSearching = false;
			}
			else {
				stillSearching = !same || (yy_currentPos < yy_startRead + searchStringLength);
			}
		}
	}
	if (n != YYEOF || same) {
		// We've stopped short of the end or definitely found a match
		yy_markedPos = yy_currentPos - searchStringLength;
		yy_currentPos = yy_markedPos + 1;
		// If the searchString occurs at the very beginning of what would have
		// been a Block, resume scanning normally immediately
		if (yy_markedPos == yy_startRead) {
			yybegin(immediateFallbackState);
			return primGetNextToken();
		}
	}
	else {
		// We ran through the rest of the input
		yy_markedPos = yy_currentPos;
		yy_currentPos++;
	}
	yybegin(exitState);
	// If the ending occurs at the very beginning of what would have
	// been a Block, resume scanning normally immediately
	if(yy_markedPos == yy_startRead)
		return primGetNextToken();
	return searchContext;
}

/**
 * Method doScanEndPhp
 * 
 * @see doScan(searchString, req...) 
 * this version can handle two strings as options to search string
 * it originally written to support ?> or %> close tags to php
 * The two strings must be on the same length
 *
 * @param isAsp - whether the asp %> close is premited
 * @param context - the context of the scanned region if non-zero length
 * @param exitState - the state to go to if the region was of non-zero length
 * @param abortState - the state to go to if the searchString was found immediately
 * @return String - the context found: the desired context on a non-zero length match, the abortContext on immediate success
 * @throws IOException
 */
private ITextRegion bufferedTextRegion = null;
private final String doScanEndPhp(boolean isAsp, String searchContext, int exitState, int immediateFallbackState) throws IOException {
	yypushback(1); // begin with the last char
	
	final AbstractPhpLexer phpLexer = getPhpLexer(); 
	bufferedTextRegion = new PhpScriptRegion(searchContext, yychar, project, phpLexer);

	// restore the locations / states
	reset(yy_reader, phpLexer.getZZBuffer(), phpLexer.getParamenters());
	
	yybegin(exitState);
	return searchContext;
}

/**
 * @param project
 * @param stream
 * @return a new lexer for the given project with the given stream initialized with current parameters
 */
private AbstractPhpLexer getPhpLexer() {
	final PHPVersion phpVersion = ProjectOptions.getPhpVersion(project);
	final AbstractPhpLexer lexer = PhpLexerFactory.createLexer(yy_reader, phpVersion);
	int[] currentParameters = getParamenters();
	try {
		// set initial lexer state - we use reflection here since we don't know the constant value of 
		// of this state in specific PHP version lexer 
		currentParameters[6] = lexer.getClass().getField("ST_PHP_IN_SCRIPTING").getInt(lexer);
	} catch (Exception e) {
		Logger.logException(e);
	}
	lexer.initialize(currentParameters[6]);
	lexer.reset(yy_reader, yy_buffer, currentParameters);
	lexer.setPatterns(project);

	lexer.setAspTags(ProjectOptions.isSupportingAspTags(project));
	return lexer;
}

// call the doScan without searching for PHP internal code
private final String doScan(String searchString, boolean requireTailSeparator, String searchContext, int exitState, int immediateFallbackState) throws IOException {
	return doScan(searchString, true, requireTailSeparator, searchContext, exitState, immediateFallbackState);	
}

	/* user method */
	private final void assembleEmbeddedTagSequence(String startType, String endTagName) {
		assembleEmbeddedContainer(startType, null, endTagName);
	}
	/* user method */
	private final void assembleEmbeddedContainer(String startType, String[] endTypes) {
		assembleEmbeddedContainer(startType, endTypes, null);
	}
	/* user method */
	private final void assembleEmbeddedContainer(String startType, String endType) {
		assembleEmbeddedContainer(startType, new String[]{endType}, null);
	}
	/**
	 *  user method 
	 * 
	 * Assembles an embedded container beginning with the given startType as
	 * the first ContextRegion within it and of the type fEmbeddedHint.  The
	 * endTypes[] array contains the context types that will cause a successful
	 * exit.  Use of the endTagName parameter alters this behavior to force an
	 * exit on an XML_TAG_CLOSE after seeing an XML_TAG_NAME whose significant
	 * text matches the endTagName String.  All contents in between are
	 * insignificant, and yes, this means comments are allowed inside.
	 **/
	private final void assembleEmbeddedContainer(String startType, String[] endTypes, String endTagName) {
		// the context of the region being added to the embedded container
		internalContext = startType;
		// keep track of where this container began; to provide relative indeces for the regions
		int containerStart = yychar;
		boolean notFinished = true;
		// keep track of where we seem to be so that the endTagName can be checked
		boolean isInEndTag = false;
		boolean isInFirstTag = true;
		// create the embedded container and setup its "type"
		if (fEmbeddedContainer == null) {
			fEmbeddedContainer = new ContextRegionContainer();
			fEmbeddedContainer.setType(fEmbeddedHint);
			fEmbeddedContainer.setStart(containerStart);
			// TODO: parent region needs to be set .... but not sure where to get it from 
			//		fEmbeddedContainer.setParent(parentRegion);
		}
		containerStart = fEmbeddedContainer.getStart();
		while (notFinished) {
			// add the region to the container
			if (internalContext != null && internalContext != PROXY_CONTEXT) {

				ITextRegion newToken;
				// if it is php content we extract the tokens
				if (internalContext == PHP_CONTENT) {
					newToken = bufferedTextRegion; 
					bufferedTextRegion.adjustStart(-containerStart);
				} else {
					newToken = fRegionFactory.createToken(internalContext, yychar - containerStart, yylength(), yylength());
				}
				fEmbeddedContainer.getRegions().add(newToken);
				fEmbeddedContainer.setLength(fEmbeddedContainer.getLength() + newToken.getLength() );
				fEmbeddedContainer.setTextLength(fEmbeddedContainer.getTextLength() + newToken.getLength());
				// DW, 4/16/2003 token regions no longer have parents
				//newToken.setParent(fEmbeddedContainer);
			}
			try {
				// longscan determines whether to attempt a blockTagScan within the embedded container
				boolean longscan = false;
				// save the tokenizer state in case of a block tag scan
				int previousState = yystate();
				String previousCurrentTagName = fCurrentTagName;
				int previousPostState = fEmbeddedPostState;
				String previousEmbeddedHint = fEmbeddedHint;
				// determine if a block tag scan is necessary
				if (internalContext == XML_TAG_NAME) {
					internalTagName = yytext();
					if(!isNestable(internalTagName)) {
						internalTagName = null;
						// snagged a tag name we shouldn't have
						fEmbeddedPostState = ST_ABORT_EMBEDDED;
						notFinished = false;
					}
				}
				else if (internalContext == XML_TAG_OPEN || internalContext == XML_END_TAG_OPEN) {
					internalTagName = null;
				}
				// do upkeep for endTagName usage; must be here since the next token could be the close
				if (internalContext == XML_END_TAG_OPEN) {
					isInEndTag = true;
				} else if (internalContext == XML_TAG_CLOSE) {
					isInFirstTag = isInEndTag = false;
				} else {
				 	ITextRegionList embeddedRegions = fEmbeddedContainer.getRegions();
					if (embeddedRegions.size() > 2 && (embeddedRegions.get(embeddedRegions.size()-1)).getType() == XML_TAG_CLOSE && (embeddedRegions.get(embeddedRegions.size() - 3)).getType() == XML_TAG_OPEN && internalTagName != null) {
						if (containsTagName(internalTagName)) {
							longscan = true;
							yybegin(ST_BLOCK_TAG_SCAN);
						}
					}
				}
				if (longscan)
					fCurrentTagName = internalTagName;
				// read the next region and context
				internalContext = primGetNextToken();
				if (longscan) {
					// Returning from a block tag scan requires restoring some state variables
					// as well as handling the block region and setting up for normal scanning
					// inside the embedded container

					ITextRegion newToken;
					// if it is php content we extract the tokens
					if (internalContext == PHP_CONTENT) {
						newToken = bufferedTextRegion; 
						bufferedTextRegion.adjustStart(-containerStart);
					} else {
						newToken = fRegionFactory.createToken(internalContext, yychar - containerStart, yylength(), yylength());
					}

					fEmbeddedContainer.getRegions().add(newToken);
					fEmbeddedContainer.setLength(fEmbeddedContainer.getLength() + newToken.getLength());
					fEmbeddedContainer.setTextLength(fEmbeddedContainer.getTextLength() + newToken.getLength());
					// DW, 4/16/2003 token regions no longer have parents
					// newToken.setParent(fEmbeddedContainer);
					longscan = false;
					fEmbeddedPostState = previousPostState;
					fEmbeddedHint = previousEmbeddedHint;
					fCurrentTagName = previousCurrentTagName;
					yybegin(previousState);
					internalContext = primGetNextToken();
				}
			} catch (IOException e) {
				// primGetNextToken() calls may throw an IOException
				// catch and do nothing since the isEOF check below
				// will properly exit if the input was too short
			} catch (Exception f) {
				// some other exception happened; never should
				Logger.logException(f);
			}
			boolean isEndingType = yystate() == ST_ABORT_EMBEDDED;
			if(!isEndingType) {
				// check for ending context
				if (endTagName == null) {
					for (int i = 0; i < endTypes.length; i++) {
						isEndingType = isEndingType || (internalContext == endTypes[i]);
					}
				}
				else {
					isEndingType = ((isInEndTag && internalContext == XML_TAG_CLOSE) || (isInFirstTag && internalContext == XML_EMPTY_TAG_CLOSE)) && internalTagName != null && internalTagName.equals(endTagName);
				}
			}
			ITextRegionList embeddedList = fEmbeddedContainer.getRegions();
			notFinished = notFinished && ((!isEndingType) && !isEOF() && (endTagName != null || internalContext != UNDEFINED) && !(internalContext == PROXY_CONTEXT && (embeddedList.get(embeddedList.size()-1)).getType() == UNDEFINED));
		}
		// finish adding the last context
		if (internalContext != null && internalContext != PROXY_CONTEXT) {
			ITextRegion newToken = fRegionFactory.createToken(internalContext, yychar - containerStart, yylength(), yylength());
			fEmbeddedContainer.getRegions().add(newToken);
			// DW, 4/16/2003 token regions no longer have parents
			//newToken.setParent(fEmbeddedContainer);
			fEmbeddedContainer.setLength(yychar - containerStart + yylength());
			fEmbeddedContainer.setTextLength(yychar - containerStart + yylength());
		}
		yybegin(fEmbeddedPostState);
	}

	/**
	 * user method
	 */
	private boolean isNestable(String tagName) {
		return true;
	}

/**
 * user method
 *
 * A generic lookahead-like operation
 */
private final String doBlockScan(String target, String targetContext, int immediateFallbackState) throws IOException {
	return doScan(target, false, targetContext, immediateFallbackState, immediateFallbackState);
}
/**
 * user method 
 * does a lookahead for the current tag name
 */
private final String doBlockTagScan() throws IOException {
        fIsCaseSensitiveBlocking = getBlockMarkerCaseSensitivity();
	return doScan("</" + fCurrentTagName, true, getBlockMarkerContext(fCurrentTagName), YYINITIAL, YYINITIAL);
}

private IProject project;

public void setProject(IProject project) {
	this.project = project;
}

public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
	this.yy_reader = reader;
	this.yy_buffer = buffer;
	this.yy_markedPos = parameters[0];
	this.yy_pushbackPos = parameters[1];
	this.yy_currentPos = parameters[2];
	this.yy_startRead = parameters[3];
	this.yy_endRead = parameters[4];
	this.yyline = parameters[5];  
	this.yychar = this.yy_startRead - this.yy_pushbackPos;
}

public int[] getParamenters(){
	return new int[]{yy_markedPos, yy_pushbackPos, yy_currentPos, yy_startRead, yy_endRead, yyline, yy_lexical_state};
}

/**
 * user method
 *
 * Converts the raw context String returned by the primGetNextToken()
 * method into a full ITextRegion by pulling in values for the
 * current offset within the scanning text.
 *
 * Returns null when EOF is encountered and attaches intermittently
 * discovered whitespace onto the end of useful regions.
 *
 * Note that this algorithm caches the token following the one being returned
 * so that whitespace can be collapsed.
 */
public final ITextRegion getNextToken() throws IOException {
	fEmbeddedContainer = null;
	// load the starting non-whitespace token (assume that it is so)
	if (fShouldLoadBuffered) {
		if (fBufferedEmbeddedContainer != null) {
			ITextRegion container = fBufferedEmbeddedContainer;
			fBufferedEmbeddedContainer = null;
			fShouldLoadBuffered = false;
			return container;
		}
		context = fBufferedContext;
		text = fBufferedText;
		start = fBufferedStart;
		textLength = length = fBufferedLength;
		fShouldLoadBuffered = false;
	}
	else {
		context = primGetNextToken();
		if (context == PROXY_CONTEXT) {
			return fEmbeddedContainer;
		} else if (context == XML_TAG_OPEN) {
			fIsBlockingEnabled = true;
		} else if (context == XML_END_TAG_OPEN) {
			fIsBlockingEnabled = false;
		}
		text = yytext();
		if (context == XML_TAG_NAME) {
			if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
				fCurrentTagName = text;
			else
				fCurrentTagName = null;
		}
		else if (context == XML_TAG_OPEN) {
			fIsBlockingEnabled = true;
		}
		else if (context == XML_END_TAG_OPEN) {
			fIsBlockingEnabled = false;
		}
		start = yychar;
		textLength = length = yylength();
		if (yy_atEOF) {
			fTokenCount++;
			return null;
		}
	}
	
	// store the next token
	f_context = primGetNextToken();
	if (f_context == PROXY_CONTEXT) {
		fBufferedEmbeddedContainer = fEmbeddedContainer;
		fShouldLoadBuffered = true;
	} else if (f_context == XML_TAG_NAME) {
		if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
			fCurrentTagName = yytext();
		else
			fCurrentTagName = null;
	} else if (f_context == XML_TAG_OPEN) {
		fIsBlockingEnabled = true;
	} else if (f_context == XML_END_TAG_OPEN) {
		fIsBlockingEnabled = false;
	}
	fBufferedContext = f_context;
	fBufferedText = yytext();
	if (fBufferedContext == XML_TAG_NAME) {
		if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
			fCurrentTagName = fBufferedText;
		else
			fCurrentTagName = null;
	}
	else if (fBufferedContext == XML_TAG_OPEN) {
		fIsBlockingEnabled = true;
	}
	else if (fBufferedContext == XML_END_TAG_OPEN) {
		fIsBlockingEnabled = false;
	}
	fBufferedStart = yychar;
	fBufferedLength = yylength();
	if (fBufferedContext == WHITE_SPACE) {
		fShouldLoadBuffered = false;
		length += fBufferedLength;
	}else {
		fShouldLoadBuffered = true;
	}
	if (context == null) {
		// EOF
		if (Debug.debugTokenizer) {
			System.out.println(getClass().getName() + " discovered " + fTokenCount + " tokens."); //$NON-NLS-2$//$NON-NLS-1$
		}
		return null;
	}
	fTokenCount++;

	// if it is php content we extract the tokens
	if (context == PHP_CONTENT) {
		return bufferedTextRegion; 
	} else {
		return fRegionFactory.createToken(context, start, textLength, length, null, fCurrentTagName);
	}
}

/* user method */
public PHPTokenizer(){
	super();
}
/* user method */
public PHPTokenizer(char[] charArray){
		this(new CharArrayReader(charArray));
}
/* user method */
public void reset(char[] charArray) {
	reset(new CharArrayReader(charArray), 0);
}
/* user method */
public void reset(char[] charArray, int newOffset) {
	reset(new CharArrayReader(charArray), newOffset);
}
/* user method */
public void reset(java.io.InputStream in) {
	reset(new java.io.InputStreamReader(in), 0);
}
/* user method */
public void reset(java.io.InputStream in, int newOffset) {
	reset(new java.io.InputStreamReader(in), newOffset);
}
/* user method */
public void reset(java.io.Reader in) {
	reset(in, 0);
}
/**
 * user method *
 *
 * Reset internal counters and vars to "newly created" values, in the hopes
 * that resetting a pre-existing tokenizer is faster than creating a new one.
 *
 * This method contains code blocks that were essentially duplicated from the
 * <em>generated</em> output of this specification before this method was
 * added.  Those code blocks were under the above copyright.
 */
public void reset(java.io.Reader in, int newOffset) {
	if (Debug.debugTokenizer) {
		System.out.println("resetting tokenizer");//$NON-NLS-1$
	}
	fOffset = newOffset;

	/* the input device */
	yy_reader = in;

	/* the current state of the DFA */
	yy_state = 0;

	/* the current lexical state */
	yy_lexical_state = YYINITIAL;

	/* this buffer contains the current text to be matched and is
	the source of the yytext() string */
	java.util.Arrays.fill(yy_buffer, (char)0);

	/* the textposition at the last accepting state */
	yy_markedPos = 0;

	/* the textposition at the last state to be included in yytext */
	yy_pushbackPos = 0;

	/* the current text position in the buffer */
	yy_currentPos = 0;

	/* startRead marks the beginning of the yytext() string in the buffer */
	yy_startRead = 0;

	/** 
	 * endRead marks the last character in the buffer, that has been read
	 * from input 
	 */
	yy_endRead = 0;

	/* number of newlines encountered up to the start of the matched text */
	yyline = 0;

	/* the number of characters up to the start of the matched text */
	yychar = 0;

	/* yy_atEOF == true <=> the scanner has returned a value for EOF */
	yy_atEOF = false;

	/* denotes if the user-EOF-code has already been executed */
	yy_eof_done = false;


	/* user vars: */
	fLastInternalBlockStart = -1;	

	fTokenCount = 0;
	
	fShouldLoadBuffered = false;
	fBufferedContext = null;
	fBufferedText = null;
	fBufferedStart = 1;
	fBufferedLength = 0;
	fStateStack = new IntStack();

	context = null;
	text = null;
	start = 0;
	textLength = 0;
	length = 0;
}

	/**
	 * user method
	 *
	 */
	public BlockTokenizer newInstance() {
		PHPTokenizer newInstance = new PHPTokenizer();
		// global tagmarkers can be shared; they have no state and 
		// are never destroyed (e.g. 'release')
		for(int i = 0; i < fBlockMarkers.size(); i++) {
			BlockMarker blockMarker = (BlockMarker) fBlockMarkers.get(i);
			if(blockMarker.isGlobal())
				newInstance.addBlockMarker(blockMarker);
		}
		return newInstance;
	}
/* user method */
private final String scanXMLCommentText() throws IOException {
	// Scan for '-->' and return the text up to that point as
	//   XML_COMMENT_TEXT unless the string occurs IMMEDIATELY, in which
	//  case change to the ST_XML_COMMENT_END state and return the next
	//  context as usual.
	return doScan("-->", true, false,  XML_COMMENT_TEXT, ST_XML_COMMENT_END, ST_XML_COMMENT_END);
}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPTokenizer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PHPTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the unpacked transition table
   */
  private static int [] yy_unpack(String packed) {
    int [] trans = new int[8415];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2572) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return trans;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1372) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (yy_currentPos < yy_endRead) return yy_buffer[yy_currentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (yy_atEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if ( numRead == -1 ) return YYEOF;

    yy_endRead+= numRead;

    return yy_buffer[yy_currentPos++];
  }

    
  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */
    yy_reader.close();
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }

  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }

  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning - from the SED JFlex skeleton
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    try {
      Logger.log(Logger.ERROR, YY_ERROR_MSG[errorCode]);
    }
    catch (ArrayIndexOutOfBoundsException e) {
      Logger.log(Logger.ERROR, YY_ERROR_MSG[YY_UNKNOWN_ERROR]);
    }
    // DO NOT EXIT the VM on an error
    // System.exit(1);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  void yypushback(int number) {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }

	/**
	 * user method - skeleton.sed
	 */
	protected final boolean containsTagName(char[] markerTagName, int offset, int tagnameLength) {
		for(int j = 0; j < fBlockMarkers.size(); j++) {
			BlockMarker marker = (BlockMarker)fBlockMarkers.get(j);
			if(marker.getTagName().length() == tagnameLength) {
				boolean matchesSoFar = true;
				for(int i = 0; i < tagnameLength && matchesSoFar; i++) {
					if(marker.isCaseSensitive()) {
						if(marker.getTagName().charAt(i) != markerTagName[i + offset])
							matchesSoFar = false;
					}
					else {
						if(Character.toLowerCase(marker.getTagName().charAt(i)) != Character.toLowerCase(markerTagName[i + offset]))
							matchesSoFar = false;
					}
				}
				if(matchesSoFar)
					return true;
			}
		}
		return false;
	}

	/**
	 * user method - skeleton.sed
	 *
	 * Return ALL of the regions scannable within the remaining text
	 * Note: for verification use
	 */
	public final List getRegions() {
		List tokens = new ArrayList();
		ITextRegion region = null;
		try {
			region = getNextToken();
			while(region != null) {
				if (region != null) {
					tokens.add(region);
				}
				region = getNextToken();
			}
		}
		catch (StackOverflowError e) {
			Logger.logException(getClass().getName()+": input could not be tokenized correctly at position " + getOffset(), e);//$NON-NLS-1$
			throw e;
		}
		catch (Exception e) {
			// Since this is convenience method and NOT the recommended 
			// way of getting tokens, many errors are simply hidden
			Logger.logException("Exception not handled retrieving regions: " + e.getLocalizedMessage(), e);//$NON-NLS-1$
		}
		return tokens;
	}
	/**
	 * user method - skeleton.sed
	 */
	private final void dump(String s) {
		if (Debug.debugTokenizer) {
			System.out.println(s + " (" + yychar + "-" + //$NON-NLS-2$//$NON-NLS-1$
				(yylength() + yychar) + "):\'" +//$NON-NLS-1$
					StringUtils.escape(yytext()) + "\'");//$NON-NLS-1$
		}
	}
	/* user method  - skeleton.sed */
	public final boolean isEOF() {
		return yy_atEOF;
	}
/* user method - skeleton.sed */
protected final boolean containsTagName(String markerTagName) {
	Iterator blocks = fBlockMarkers.iterator();
	while(blocks.hasNext()) {
		BlockMarker marker = (BlockMarker)blocks.next();
		if(marker.isCaseSensitive()) {
			if(marker.getTagName().equals(markerTagName))
				return true;
		}
		else {
			if(marker.getTagName().equalsIgnoreCase(markerTagName))
				return true;
		}
	}
	return false;
}

  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() {
    if (!yy_eof_done) {
      yy_eof_done = true;
    // do nothing, this is the downstream parser's job

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;


    while (true) {

      yychar+= yylength();

      boolean yy_counted = false;
      for (yy_currentPos = yy_startRead; yy_currentPos < yy_markedPos;
                                                      yy_currentPos++) {
        switch (yy_buffer[yy_currentPos]) {
        case '\r':
          yyline++;
          yy_counted = true;
          break;
        case '\n':
          if (yy_counted)
            yy_counted = false;
          else {
            yyline++;
          }
          break;
        default:
          yy_counted = false;
        }
      }

      if (yy_counted) {
        if ( yy_advance() == '\n' ) yyline--;
        if ( !yy_atEOF ) yy_currentPos--;
      }

      yy_action = -1;

      yy_currentPos = yy_startRead = yy_markedPos;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {
    
          yy_input = yy_advance();

          if ( yy_input == YYEOF ) break yy_forAction;

          int yy_next = yytrans[ yy_rowMap[yy_state] + yycmap[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = YY_ATTRIBUTE[yy_state];
          if ( (yy_attributes & 1) > 0 ) {
            yy_action = yy_state; 
            yy_markedPos = yy_currentPos; 
            if ( (yy_attributes & 8) > 0 ) break yy_forAction;
          }

        }
      }


      switch (yy_action) {    

        case 240: 
        case 241: 
        case 242: 
          { 
	if(Debug.debugTokenizer)
		dump("\nCDATA start");//$NON-NLS-1$
	fStateStack.push(yystate());
	yybegin(ST_CDATA_TEXT);
	return XML_CDATA_OPEN;
 }
        case 244: break;
        case 234: 
          { 
	if(Debug.debugTokenizer)
		dump("element");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION);
	return XML_ELEMENT_DECLARATION;
 }
        case 245: break;
        case 233: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION);
	return XML_ATTLIST_DECLARATION;
 }
        case 246: break;
        case 232: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_DECLARATION);
	return XML_DOCTYPE_DECLARATION;
 }
        case 247: break;
        case 228: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_PUBLIC);
	return XML_DOCTYPE_EXTERNAL_ID_PUBLIC;
 }
        case 248: break;
        case 227: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_SYSTEM;
 }
        case 249: break;
        case 202: 
          { 
	if(Debug.debugTokenizer)
		dump("\nCharRef");//$NON-NLS-1$
	return XML_CHAR_REFERENCE;
 }
        case 250: break;
        case 198: 
          { 
	if(Debug.debugTokenizer)
		dump("\ncomment start");//$NON-NLS-1$
	fEmbeddedHint = XML_COMMENT_TEXT;
	fEmbeddedPostState = ST_XML_COMMENT;
	yybegin(ST_XML_COMMENT);
	return XML_COMMENT_OPEN;
 }
        case 251: break;
        case 181: 
          { 
	if(Debug.debugTokenizer)
		dump("comment end");//$NON-NLS-1$
	fEmbeddedHint = UNDEFINED;
	yybegin(YYINITIAL);
	return XML_COMMENT_CLOSE;
 }
        case 252: break;
        case 180: 
          { 
	if(Debug.debugTokenizer)
		dump("CDATA end");//$NON-NLS-1$
	yybegin(fStateStack.pop());
	return XML_CDATA_CLOSE;
 }
        case 253: break;
        case 179: 
          { 
	if(Debug.debugTokenizer)
		dump("\nPEReference");//$NON-NLS-1$
	return XML_PE_REFERENCE;
 }
        case 254: break;
        case 176: 
          { 
	if(Debug.debugTokenizer)
		dump("\nEntityRef");//$NON-NLS-1$
	return XML_ENTITY_REFERENCE;
 }
        case 255: break;
        case 168: 
          { 
	// begin embedded region: " + fEmbeddedHint);//$NON-NLS-1$
	int incomingState = yystate();
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	// Php attribute value start - end tag
	yybegin(ST_XML_TAG_NAME);
	assembleEmbeddedContainer(XML_END_TAG_OPEN, new String[]{XML_TAG_CLOSE,XML_EMPTY_TAG_CLOSE});
	if(yystate() != ST_ABORT_EMBEDDED)
        yybegin(incomingState);
	return PROXY_CONTEXT;
 }
        case 256: break;
        case 166: 
          { 
	yybegin(fStateStack.pop());
	return PHP_CLOSE;
	
 }
        case 257: break;
        case 121: 
        case 135: 
        case 143: 
          { 
	return XML_DOCTYPE_INTERNAL_SUBSET;
 }
        case 258: break;
        case 112: 
          { 
	String tagName = yytext().substring(1);
	// pushback to just after the opening bracket
	yypushback(yylength() - 1);
	/*
	 * If this tag can not be nested or we're already searching for an
	 * attribute name, equals, or value, return immediately.
	 */
	if (!isNestable(tagName) || (!fStateStack.empty() && (fStateStack.peek() == ST_XML_ATTRIBUTE_NAME || fStateStack.peek() == ST_XML_EQUALS || fStateStack.peek() == ST_XML_ATTRIBUTE_VALUE))) {
		yybegin(ST_XML_TAG_NAME);
		return XML_TAG_OPEN;
	}
	if(Debug.debugTokenizer)
		dump("tag in place of attr value");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	fStateStack.push(yystate());
	// embedded container should be looking for the name (again) next
	yybegin(ST_XML_TAG_NAME);
	assembleEmbeddedTagSequence(XML_TAG_OPEN, tagName); // ?
	fStateStack.pop();
	yybegin(ST_XML_ATTRIBUTE_NAME);
	return PROXY_CONTEXT;
 }
        case 259: break;
        case 110: 
          { 
	String tagName = yytext().substring(1);
	// pushback to just after the opening bracket
	yypushback(yylength() - 1);
	/*
	 * If this tag can not be nested or we're already searching for an
	 * attribute name, equals, or value, return immediately.
	 */
	if (!isNestable(tagName) || (!fStateStack.empty() && (fStateStack.peek() == ST_XML_ATTRIBUTE_NAME || fStateStack.peek() == ST_XML_EQUALS || fStateStack.peek() == ST_XML_ATTRIBUTE_VALUE))) {
		yybegin(ST_XML_TAG_NAME);
		return XML_TAG_OPEN;
	}
	if(Debug.debugTokenizer)
		dump("tag in place of attr name");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	fStateStack.push(yystate());
	// embedded container should be looking for the name (again) next
	yybegin(ST_XML_TAG_NAME);
	assembleEmbeddedTagSequence(XML_TAG_OPEN, tagName); // ?
	fStateStack.pop();
	yybegin(ST_XML_EQUALS);
	return PROXY_CONTEXT;
 }
        case 260: break;
        case 51: 
          { 
	// begin embedded region: " + fEmbeddedHint
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_VALUE_SQUOTED;
	yybegin(ST_XML_ATTRIBUTE_VALUE_SQUOTED);
	fStateStack.push(yystate());
	// JSP attribute value start - complex single quoted
	assembleEmbeddedContainer(XML_TAG_ATTRIBUTE_VALUE_SQUOTE, XML_TAG_ATTRIBUTE_VALUE_SQUOTE);
	fStateStack.pop();
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
        yybegin(ST_XML_ATTRIBUTE_NAME);
	return PROXY_CONTEXT;
 }
        case 261: break;
        case 50: 
          { 
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_VALUE_DQUOTED;
	yybegin(ST_XML_ATTRIBUTE_VALUE_DQUOTED);
	fStateStack.push(yystate());
	assembleEmbeddedContainer(XML_TAG_ATTRIBUTE_VALUE_DQUOTE, XML_TAG_ATTRIBUTE_VALUE_DQUOTE);
	fStateStack.pop();
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_XML_ATTRIBUTE_NAME);
	return PROXY_CONTEXT;
 }
        case 262: break;
        case 47: 
        case 114: 
          { 
	// attr value
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
        yybegin(ST_XML_ATTRIBUTE_NAME);
        return XML_TAG_ATTRIBUTE_VALUE;
 }
        case 263: break;
        case 46: 
          { 
	// equals
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
        yybegin(ST_XML_ATTRIBUTE_VALUE);
        return XML_TAG_ATTRIBUTE_EQUALS;
 }
        case 264: break;
        case 45: 
          { 
	// attr name
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
        yybegin(ST_XML_EQUALS);
        return XML_TAG_ATTRIBUTE_NAME;
 }
        case 265: break;
        case 41: 
        case 42: 
          { 
	if(Debug.debugTokenizer)
		dump("tag name");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
        yybegin(ST_XML_ATTRIBUTE_NAME);
        return XML_TAG_NAME;
 }
        case 266: break;
        case 39: 
          { 
	// tag close
	fEmbeddedHint = UNDEFINED;
	if(isBlockMarker()) {
		fEmbeddedHint = getBlockMarkerContext();
		fEmbeddedPostState = ST_BLOCK_TAG_SCAN;
        	yybegin(ST_BLOCK_TAG_SCAN);
	}
	else
        	yybegin(YYINITIAL);
        return XML_TAG_CLOSE;
 }
        case 267: break;
        case 35: 
        case 36: 
          { 
	if(Debug.debugTokenizer)
		dump("comment content");//$NON-NLS-1$
	return scanXMLCommentText();
 }
        case 268: break;
        case 34: 
          { 
	if(Debug.debugTokenizer)
		dump("LINE FEED");//$NON-NLS-1$
	return WHITE_SPACE;
 }
        case 269: break;
        case 0: 
        case 25: 
        case 103: 
        case 105: 
        case 174: 
        case 175: 
        case 201: 
          { 
	if(Debug.debugTokenizer)
		dump("\nXML content");//$NON-NLS-1$
	return XML_CONTENT;
 }
        case 270: break;
        case 5: 
        case 38: 
          { 
	// inappropriate tag name
	if(!fStateStack.empty() && (fStateStack.peek()==ST_XML_ATTRIBUTE_VALUE_SQUOTED||fStateStack.peek()==ST_XML_ATTRIBUTE_VALUE_DQUOTED)) {
		yybegin(ST_ABORT_EMBEDDED);
		yypushback(yylength()-1);
		return XML_TAG_ATTRIBUTE_VALUE;
	}
	yybegin(YYINITIAL);
        return XML_CONTENT;
 }
        case 271: break;
        case 6: 
        case 7: 
        case 8: 
        case 9: 
        case 10: 
        case 11: 
        case 12: 
        case 13: 
        case 14: 
        case 15: 
        case 17: 
        case 44: 
          { 
	if(Debug.debugTokenizer)
		dump("white space");//$NON-NLS-1$
        return WHITE_SPACE;
 }
        case 272: break;
        case 16: 
        case 76: 
        case 77: 
        case 154: 
        case 193: 
        case 211: 
        case 221: 
        case 229: 
        case 235: 
        case 238: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl contentspec");//$NON-NLS-1$
	return XML_ELEMENT_DECL_CONTENT;
 }
        case 273: break;
        case 18: 
        case 83: 
        case 84: 
        case 165: 
        case 197: 
        case 213: 
        case 222: 
        case 230: 
        case 236: 
        case 239: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist contentspec");//$NON-NLS-1$
	return XML_ATTLIST_DECL_CONTENT;
 }
        case 274: break;
        case 26: 
        case 43: 
        case 48: 
        case 52: 
          { 
	if(Debug.debugTokenizer)
		dump("\nstart tag open");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_NAME;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
    yybegin(ST_XML_TAG_NAME);
    return XML_TAG_OPEN;
 }
        case 275: break;
        case 27: 
        case 28: 
        case 31: 
        case 32: 
        case 33: 
        case 37: 
        case 40: 
        case 49: 
        case 54: 
        case 55: 
        case 56: 
        case 57: 
        case 58: 
        case 60: 
        case 61: 
        case 63: 
        case 68: 
        case 73: 
        case 80: 
        case 94: 
        case 97: 
          { 
	if (Debug.debugTokenizer)
		System.out.println("!!!unexpected!!!: \"" + yytext() + "\":" + //$NON-NLS-2$//$NON-NLS-1$
			yychar + "-" + (yychar + yylength()));//$NON-NLS-1$
	return UNDEFINED;
 }
        case 276: break;
        case 29: 
        case 30: 
          { 
	if(Debug.debugTokenizer)
		dump("CDATA text");//$NON-NLS-1$
	String blockContext = doBlockScan("]]>", XML_CDATA_TEXT, ST_CDATA_END);//$NON-NLS-1$
	if(blockContext == XML_CDATA_TEXT)
		yybegin(ST_CDATA_END);
	return blockContext;
 }
        case 277: break;
        case 53: 
          { 
	if(Debug.debugTokenizer)
		dump("declaration end");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 278: break;
        case 59: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype type");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_EXTERNAL_ID);
	return XML_DOCTYPE_NAME;
 }
        case 279: break;
        case 62: 
        case 64: 
        case 65: 
        case 66: 
        case 127: 
        case 128: 
        case 131: 
        case 132: 
        case 188: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype public reference");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_PUBREF;
 }
        case 280: break;
        case 67: 
        case 69: 
        case 70: 
        case 71: 
        case 139: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype system reference");//$NON-NLS-1$
	yybegin(ST_XML_DECLARATION_CLOSE);
	return XML_DOCTYPE_EXTERNAL_ID_SYSREF;
 }
        case 281: break;
        case 72: 
        case 74: 
        case 75: 
        case 147: 
        case 148: 
        case 151: 
        case 152: 
        case 191: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl name");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION_CONTENT);
	return XML_ELEMENT_DECL_NAME;
 }
        case 282: break;
        case 78: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 283: break;
        case 79: 
        case 81: 
        case 82: 
        case 158: 
        case 159: 
        case 162: 
        case 163: 
        case 195: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist name");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION_CONTENT);
	return XML_ATTLIST_DECL_NAME;
 }
        case 284: break;
        case 85: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 285: break;
        case 88: 
        case 89: 
        case 90: 
          { 
	return doScanEndPhp(ProjectOptions.isSupportingAspTags(project), PHP_CONTENT, ST_PHP_CONTENT, ST_PHP_CONTENT);
 }
        case 286: break;
        case 91: 
        case 95: 
          { 
	return XML_TAG_ATTRIBUTE_VALUE;
 }
        case 287: break;
        case 92: 
          { 
	// begin embedded region: " + fEmbeddedHint
	int incomingState = yystate();
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	// tag inside of JSP attribute value start
	yybegin(ST_XML_TAG_NAME);
	assembleEmbeddedContainer(XML_TAG_OPEN, new String[]{XML_TAG_CLOSE,XML_EMPTY_TAG_CLOSE});
	if(yystate() != ST_ABORT_EMBEDDED)
        yybegin(incomingState);
	return PROXY_CONTEXT;
 }
        case 288: break;
        case 93: 
          { 
	return XML_TAG_ATTRIBUTE_VALUE_SQUOTE;
 }
        case 289: break;
        case 96: 
          { 
	return XML_TAG_ATTRIBUTE_VALUE_DQUOTE;
 }
        case 290: break;
        case 98: 
          { 
	// end tag open
	fEmbeddedHint = XML_TAG_NAME;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
        yybegin(ST_XML_TAG_NAME);
        return XML_END_TAG_OPEN;
 }
        case 291: break;
        case 99: 
        case 101: 
        case 172: 
          { 
    if (ProjectOptions.isSupportingAspTags(project) ||yytext().charAt(1) != '%') {
		//removeing trailing whitespaces for the php open
		String phpStart = yytext();
		int i = phpStart.length() - 1; 
		while(i >= 0 && Character.isWhitespace(phpStart.charAt(i--))){
			yypushback(1);
		}

		fStateStack.push(yystate());
		if(fStateStack.peek()==YYINITIAL) {
			// the simple case, just a regular scriptlet out in content
			yybegin(ST_PHP_CONTENT);
			return PHP_OPEN;
		}
		else {
			if(yystate() == ST_XML_ATTRIBUTE_VALUE_DQUOTED)
				fEmbeddedPostState = ST_XML_ATTRIBUTE_VALUE_DQUOTED;
			else if(yystate() == ST_XML_ATTRIBUTE_VALUE_SQUOTED)
				fEmbeddedPostState = ST_XML_ATTRIBUTE_VALUE_SQUOTED;
			else if(yystate() == ST_CDATA_TEXT) {
				fEmbeddedPostState = ST_CDATA_TEXT;
				fEmbeddedHint = XML_CDATA_TEXT;
			}
			yybegin(ST_PHP_CONTENT);
			assembleEmbeddedContainer(PHP_OPEN, PHP_CLOSE);
			if(yystate() == ST_BLOCK_TAG_INTERNAL_SCAN) {
				yybegin(ST_BLOCK_TAG_SCAN);
				return BLOCK_TEXT;
			}
			// required help for successive embedded regions
			if(yystate() == ST_XML_TAG_NAME) {
				fEmbeddedHint = XML_TAG_NAME;
				fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
			}
			else if((yystate() == ST_XML_ATTRIBUTE_NAME || yystate() == ST_XML_EQUALS)) {
				fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
				fEmbeddedPostState = ST_XML_EQUALS;
			}
			else if(yystate() == ST_XML_ATTRIBUTE_VALUE) {
				fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
				fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
			}
			return PROXY_CONTEXT;
		}
    }
    yypushback(1);
	yybegin(ST_XML_TAG_NAME);
	return XML_TAG_OPEN;
 }
        case 292: break;
        case 100: 
          { 
	fStateStack.push(yystate());
	if(Debug.debugTokenizer)
		dump("\ndeclaration start");//$NON-NLS-1$
        yybegin(ST_XML_DECLARATION);
	return XML_DECLARATION_OPEN;
 }
        case 293: break;
        case 109: 
          { 
        yybegin(YYINITIAL);
	fEmbeddedHint = UNDEFINED;
	// empty tag close
    return XML_EMPTY_TAG_CLOSE;
 }
        case 294: break;
        case 86: 
        case 87: 
          { 
		return doBlockTagScan();
	 }
        case 295: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              return null;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }    


}
