/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.jdbc;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCColumn;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCIndex;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableConstraintLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableIndexLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableSuperTableLoader;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.IncrementType;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.impl.TemporaryTableImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCTemporaryTable
extends TemporaryTableImpl
implements ICatalogObject {
    private static final long serialVersionUID = 8448936502194536715L;
    private Boolean columnsLoaded = Boolean.FALSE;
    private SoftReference columnLoaderRef;
    private Boolean pkLoaded = Boolean.FALSE;
    private Boolean ucsLoaded = Boolean.FALSE;
    private Boolean fksLoaded = Boolean.FALSE;
    private SoftReference constraintLoaderRef;
    private Boolean indexesLoaded = Boolean.FALSE;
    private SoftReference indexLoaderRef;
    private Boolean supertableLoaded = Boolean.FALSE;
    private SoftReference supertableLoaderRef;

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (this.columnsLoaded.booleanValue()) {
                this.columnsLoaded = Boolean.FALSE;
            }
        }
        bl = this.ucsLoaded;
        synchronized (bl) {
            if (this.ucsLoaded.booleanValue()) {
                this.pkLoaded = Boolean.FALSE;
                this.ucsLoaded = Boolean.FALSE;
            }
        }
        bl = this.fksLoaded;
        synchronized (bl) {
            if (this.fksLoaded.booleanValue()) {
                this.fksLoaded = Boolean.FALSE;
            }
        }
        bl = this.indexesLoaded;
        synchronized (bl) {
            if (this.indexesLoaded.booleanValue()) {
                this.indexesLoaded = Boolean.FALSE;
            }
        }
        bl = this.supertableLoaded;
        synchronized (bl) {
            if (this.supertableLoaded.booleanValue()) {
                this.supertableLoaded = Boolean.FALSE;
                this.setSupertable(null);
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getColumns() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (!this.columnsLoaded.booleanValue()) {
                this.loadColumns();
            }
        }
        return super.getColumns();
    }

    protected JDBCTableColumnLoader createColumnLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesPackage.eINSTANCE.getColumn().getInstanceClassName());
        if (loader != null) {
            JDBCTableColumnLoader tableColumnLoader = (JDBCTableColumnLoader)loader;
            tableColumnLoader.setCatalogObject(this);
            return tableColumnLoader;
        }
        return new JDBCTableColumnLoader(this);
    }

    protected final JDBCTableColumnLoader getColumnLoader() {
        if (this.columnLoaderRef == null || this.columnLoaderRef.get() == null) {
            this.columnLoaderRef = new SoftReference<JDBCTableColumnLoader>(this.createColumnLoader());
        }
        return (JDBCTableColumnLoader)this.columnLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumns() {
        boolean deliver = this.eDeliver();
        try {
            EList container = super.getColumns();
            ArrayList existingColumns = new ArrayList(container);
            this.eSetDeliver(false);
            container.clear();
            this.getColumnLoader().loadColumns((List)container, existingColumns);
            this.getColumnLoader().clearColumns(existingColumns);
            this.columnsLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryKey getPrimaryKey() {
        Boolean bl = this.ucsLoaded;
        synchronized (bl) {
            if (!this.pkLoaded.booleanValue()) {
                this.loadUniqueConstraints();
            }
        }
        return this.internalGetPrimaryKey((Collection)super.getConstraints());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUniqueConstraints() {
        Boolean bl = this.ucsLoaded;
        synchronized (bl) {
            if (!this.ucsLoaded.booleanValue()) {
                this.loadUniqueConstraints();
            }
        }
        return this.internalGetUniqueConstraints((Collection)super.getConstraints());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getForeignKeys() {
        Boolean bl = this.fksLoaded;
        synchronized (bl) {
            if (!this.fksLoaded.booleanValue()) {
                this.loadForeignKeys();
            }
        }
        return this.internalGetForeignKeys((Collection)super.getConstraints());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getConstraints() {
        Boolean bl = this.ucsLoaded;
        synchronized (bl) {
            if (!this.ucsLoaded.booleanValue()) {
                this.loadUniqueConstraints();
            }
        }
        bl = this.fksLoaded;
        synchronized (bl) {
            if (!this.fksLoaded.booleanValue()) {
                this.loadForeignKeys();
            }
        }
        return super.getConstraints();
    }

    protected JDBCTableConstraintLoader createConstraintLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLConstraintsPackage.eINSTANCE.getTableConstraint().getInstanceClassName());
        if (loader != null) {
            JDBCTableConstraintLoader tableConstraintLoader = (JDBCTableConstraintLoader)loader;
            tableConstraintLoader.setCatalogObject(this);
            return tableConstraintLoader;
        }
        return new JDBCTableConstraintLoader(this);
    }

    protected final JDBCTableConstraintLoader getConstraintLoader() {
        if (this.constraintLoaderRef == null || this.constraintLoaderRef.get() == null) {
            this.constraintLoaderRef = new SoftReference<JDBCTableConstraintLoader>(this.createConstraintLoader());
        }
        return (JDBCTableConstraintLoader)this.constraintLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUniqueConstraints() {
        boolean deliver = this.eDeliver();
        try {
            EList container = super.getConstraints();
            PrimaryKey existingPK = this.internalGetPrimaryKey((Collection)container);
            PrimaryKey pk = this.getConstraintLoader().loadPrimaryKey(existingPK);
            if (pk != null) {
                if (existingPK == null) {
                    container.add(0, pk);
                } else if (!pk.equals(existingPK)) {
                    container.set(container.indexOf(existingPK), pk);
                }
            } else if (existingPK != null) {
                container.remove(existingPK);
            }
            this.pkLoaded = Boolean.TRUE;
            List existingUCs = this.internalGetUniqueConstraints((Collection)container);
            container.removeAll(existingUCs);
            this.getConstraintLoader().loadUniqueConstraints(this.getPrimaryKey(), (List)container, existingUCs);
            this.ucsLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadForeignKeys() {
        boolean deliver = this.eDeliver();
        try {
            EList container = super.getConstraints();
            List existingFKs = this.internalGetForeignKeys((Collection)container);
            container.removeAll(existingFKs);
            this.getConstraintLoader().loadForeignKeys((List)container, existingFKs);
            this.fksLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getIndex() {
        Boolean bl = this.indexesLoaded;
        synchronized (bl) {
            if (!this.indexesLoaded.booleanValue()) {
                this.loadIndexes();
            }
        }
        return super.getIndex();
    }

    protected JDBCTableIndexLoader createIndexLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLConstraintsPackage.eINSTANCE.getIndex().getInstanceClassName());
        if (loader != null) {
            JDBCTableIndexLoader tableIndexLoader = (JDBCTableIndexLoader)loader;
            tableIndexLoader.setCatalogObject(this);
            return tableIndexLoader;
        }
        return new JDBCTableIndexLoader(this);
    }

    protected final JDBCTableIndexLoader getIndexLoader() {
        if (this.indexLoaderRef == null || this.indexLoaderRef.get() == null) {
            this.indexLoaderRef = new SoftReference<JDBCTableIndexLoader>(this.createIndexLoader());
        }
        return (JDBCTableIndexLoader)this.indexLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndexes() {
        boolean deliver = this.eDeliver();
        try {
            EList container = super.getIndex();
            ArrayList existingIndexes = new ArrayList(container);
            this.eSetDeliver(false);
            container.clear();
            this.getIndexLoader().loadIndexes((List)container, existingIndexes);
            this.getIndexLoader().clearIndexes(existingIndexes);
            this.indexesLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getSupertable() {
        Boolean bl = this.supertableLoaded;
        synchronized (bl) {
            if (!this.supertableLoaded.booleanValue()) {
                this.loadSupertable();
            }
        }
        return super.getSupertable();
    }

    protected JDBCTableSuperTableLoader createSupertableLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesPackage.eINSTANCE.getTable().getInstanceClassName());
        if (loader != null) {
            JDBCTableSuperTableLoader tableSuperTableLoader = (JDBCTableSuperTableLoader)loader;
            tableSuperTableLoader.setCatalogObject(this);
            return tableSuperTableLoader;
        }
        return new JDBCTableSuperTableLoader(this);
    }

    protected final JDBCTableSuperTableLoader getSupertableLoader() {
        if (this.supertableLoaderRef == null || this.supertableLoaderRef.get() == null) {
            this.supertableLoaderRef = new SoftReference<JDBCTableSuperTableLoader>(this.createSupertableLoader());
        }
        return (JDBCTableSuperTableLoader)this.supertableLoaderRef.get();
    }

    private void loadSupertable() {
        try {
            this.setSupertable(this.getSupertableLoader().loadSuperTable());
            this.supertableLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PrimaryKey internalGetPrimaryKey(Collection constraints) {
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            Constraint currentConstraint = (Constraint)it.next();
            if (!(currentConstraint instanceof PrimaryKey)) continue;
            return (PrimaryKey)currentConstraint;
        }
        return null;
    }

    private List internalGetUniqueConstraints(Collection constraints) {
        Vector<Constraint> uniqueConstraints = new Vector<Constraint>();
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            Constraint currentConstraint = (Constraint)it.next();
            if (!(currentConstraint instanceof UniqueConstraint)) continue;
            uniqueConstraints.add(currentConstraint);
        }
        return uniqueConstraints;
    }

    private List internalGetForeignKeys(Collection constraints) {
        Vector<Constraint> uniqueConstraints = new Vector<Constraint>();
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            Constraint currentConstraint = (Constraint)it.next();
            if (!(currentConstraint instanceof ForeignKey)) continue;
            uniqueConstraints.add(currentConstraint);
        }
        return uniqueConstraints;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 7: {
                this.getColumns();
                break;
            }
            case 17: {
                this.getConstraints();
                break;
            }
            case 13: {
                this.getIndex();
                break;
            }
            case 8: {
                this.getSupertable();
            }
        }
        return super.eIsSet(eFeature);
    }

    public static void loadColumns(Connection connection, EList columnList, Table table) throws SQLException {
        Schema schema = table.getSchema();
        Database database = schema.getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        Object[] list = columnList.toArray();
        columnList.clear();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet r = metaData.getColumns(null, schema.getName(), table.getName(), null);
            while (r.next()) {
                Object column;
                String columnName = r.getString(4);
                Object element = JDBCTemporaryTable.findElement(list, columnName, SQLTablesPackage.eINSTANCE.getColumn());
                if (element != null) {
                    column = (Column)element;
                    ((ICatalogObject)element).refresh();
                } else {
                    column = new JDBCColumn();
                    column.setName(columnName);
                }
                String remarks = r.getString(12);
                column.setDescription(remarks);
                String defaultValue = r.getString(13);
                column.setDefaultValue(defaultValue);
                String typeName = r.getString(6);
                PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                if (typeDefinition != null) {
                    EStructuralFeature feature;
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)new Integer(r.getInt(7)));
                    } else if (typeDefinition.isPrecisionSupported()) {
                        feature = type.eClass().getEStructuralFeature("precision");
                        type.eSet(feature, (Object)new Integer(r.getInt(10)));
                    }
                    if (typeDefinition.isScaleSupported()) {
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)new Integer(r.getInt(9)));
                    }
                    column.setContainedType((SQLDataType)type);
                } else {
                    System.out.println("Unresolved datatype: " + typeName);
                    Iterator it = databaseDefinition.getPredefinedDataTypes();
                    if (it.hasNext()) {
                        PredefinedDataTypeDefinition datatype = (PredefinedDataTypeDefinition)it.next();
                        PredefinedDataType type = databaseDefinition.getPredefinedDataType(datatype);
                        column.setContainedType((SQLDataType)type);
                    }
                }
                String nulls = r.getString(18);
                if (nulls.equals("YES")) {
                    column.setNullable(true);
                } else {
                    column.setNullable(false);
                }
                columnList.add(column);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadIndexes(Connection connection, EList indexList, Table table) throws SQLException {
        try {
            Schema schema = table.getSchema();
            Database database = schema.getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet r = metaData.getIndexInfo(null, schema.getName(), table.getName(), false, false);
            JDBCIndex index = null;
            String indexName = "";
            while (r.next()) {
                String column_name;
                String indName = r.getString(6);
                if (indName == null) continue;
                if (!indName.equals(indexName)) {
                    indexName = indName;
                    index = new JDBCIndex();
                    index.setName(indName);
                    String indSchema = r.getString(2);
                    index.setSchema(JDBCTemporaryTable.getSchema(table, indSchema));
                    boolean isUnqiue = !r.getBoolean(4);
                    index.setUnique(isUnqiue);
                    short type = r.getShort(7);
                    if (type == 1) {
                        index.setClustered(true);
                    }
                    indexList.add((Object)index);
                }
                if ((column_name = r.getString(9)) == null) continue;
                IndexMember member = (IndexMember)factory.create(SQLConstraintsPackage.eINSTANCE.getIndexMember());
                member.setColumn(JDBCTemporaryTable.getColumn(table, column_name));
                String order = r.getString(10);
                if (order != null) {
                    if (order.equals("A")) {
                        member.setIncrementType(IncrementType.ASC_LITERAL);
                    } else if (order.equals("D")) {
                        member.setIncrementType(IncrementType.DESC_LITERAL);
                    }
                }
                index.getMembers().add((Object)member);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        for (int i = 0; i < list.length; ++i) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (!sqlObject.getName().equals(name) || sqlObject.eClass() != metaclass) continue;
            object = list[i];
            break;
        }
        return object;
    }

    private static Schema getSchema(Table table, String schemaName) {
        Schema s = table.getSchema();
        if (s.getName().equals(schemaName)) {
            return s;
        }
        Database d = s.getDatabase();
        Iterator it = d.getSchemas().iterator();
        while (it.hasNext()) {
            s = (Schema)it.next();
            if (!s.getName().equals(schemaName)) continue;
            return s;
        }
        return null;
    }

    private static Column getColumn(Table table, String columnName) {
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column c = (Column)it.next();
            if (!c.getName().equals(columnName)) continue;
            return c;
        }
        return null;
    }

    private static class KeyColumnCollection {
        private Map keyMap = new TreeMap();
        private BaseTable table;

        public KeyColumnCollection(BaseTable table) {
            this.table = table;
        }

        public void add(int seq, String name) {
            Column column = this.getColumn(name);
            String key = "k" + seq;
            this.keyMap.put(key, column);
        }

        public Iterator iterator() {
            return this.keyMap.values().iterator();
        }

        private Column getColumn(String name) {
            Iterator it = this.table.getColumns().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                if (!column.getName().equals(name)) continue;
                return column;
            }
            return null;
        }
    }
}

