/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.DriversProvider;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeContentProvider;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeFilter;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeLabelProvider;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeSorter;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.EditDriverDialog;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.NewDriverDialog;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DriverDefinitionsDialog
extends TitleAreaDialog
implements IContextProvider {
    public static final String MEMENTO_ROOT = "Drivers Definitions Driver_Dialog_Root";
    public static final String MEMENTO_DIALOG_SIZE_HEIGHT = "Dialog_Size_Height";
    public static final String MEMENTO_DIALOG_SIZE_WIDTH = "Dialog_Size_Width";
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mEditButton;
    private Button mCopyButton;
    private TreeViewer mTreeViewer;
    private Label mErrorLabel;
    private DriverTreeFilter mViewerFilter;
    private boolean mDirty = false;
    private String mCategoryId;
    private String mInitialDriverName;
    private IPropertySet selectedPS = null;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public DriverDefinitionsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x860);
    }

    public DriverDefinitionsDialog(Shell parentShell, String category) {
        this(parentShell);
        if (CategoryDescriptor.getCategoryDescriptor((String)category) != null) {
            this.mViewerFilter = new DriverTreeFilter();
            this.mViewerFilter.setCategoryId(category);
            this.mCategoryId = category;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_DRIVER_DEFINITION_DIALOG", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        Composite area = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        Composite content = new Composite(area, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        content.setLayoutData((Object)data);
        content.setFont(font);
        this.mErrorLabel = new Label(content, 16448);
        data = new GridData(272);
        data.horizontalSpan = 2;
        data.heightHint = 35;
        this.mErrorLabel.setLayoutData((Object)data);
        this.mErrorLabel.setForeground(JFaceColors.getErrorText((Display)content.getDisplay()));
        this.mErrorLabel.setFont(font);
        this.mTreeViewer = new TreeViewer(content, 2048);
        data = new GridData(1808);
        this.mTreeViewer.getTree().setLayoutData((Object)data);
        this.mTreeViewer.getTree().setFont(font);
        this.mTreeViewer.setContentProvider((IContentProvider)new DriverTreeContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new DriverTreeLabelProvider(), (ILabelDecorator)new DriverTreeLabelProvider()));
        this.mTreeViewer.setSorter((ViewerSorter)new DriverTreeSorter());
        if (this.mViewerFilter != null) {
            this.mTreeViewer.addFilter((ViewerFilter)this.mViewerFilter);
        }
        this.mTreeViewer.setInput((Object)DriversProvider.getInstance());
        this.mTreeViewer.expandToLevel(3);
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DriverDefinitionsDialog.this.selectedPS = null;
                StructuredSelection selection = (StructuredSelection)DriverDefinitionsDialog.this.mTreeViewer.getSelection();
                if (selection.getFirstElement() instanceof CategoryDescriptor) {
                    DriverDefinitionsDialog.this.mAddButton.setEnabled(true);
                    DriverDefinitionsDialog.this.mRemoveButton.setEnabled(false);
                    DriverDefinitionsDialog.this.mEditButton.setEnabled(false);
                    DriverDefinitionsDialog.this.mErrorLabel.setText("");
                    DriverDefinitionsDialog.this.mErrorLabel.computeSize(-1, -1);
                } else if (selection.getFirstElement() instanceof IPropertySet) {
                    DriverDefinitionsDialog.this.mAddButton.setEnabled(false);
                    DriverDefinitionsDialog.this.mRemoveButton.setEnabled(true);
                    DriverDefinitionsDialog.this.mEditButton.setEnabled(true);
                    DriverDefinitionsDialog.this.selectedPS = (IPropertySet)selection.getFirstElement();
                    if (DriverDefinitionsDialog.this.selectedPS != null) {
                        DriverDefinitionsDialog.this.validate(DriverDefinitionsDialog.this.selectedPS);
                    }
                }
            }
        });
        Composite groupComponent = new Composite(content, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.mAddButton = new Button(groupComponent, 8);
        this.mAddButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.addDriver"));
        this.mAddButton.setLayoutData((Object)new GridData());
        this.mAddButton.setFont(font);
        this.setButtonLayoutData(this.mAddButton);
        this.mAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)DriverDefinitionsDialog.this.mTreeViewer.getSelection();
                if (selection.getFirstElement() instanceof CategoryDescriptor) {
                    DriverDefinitionsDialog.this.addDriver((ISelection)selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mEditButton = new Button(groupComponent, 8);
        this.mEditButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.editDriver"));
        this.mEditButton.setLayoutData((Object)new GridData());
        this.mEditButton.setFont(font);
        this.setButtonLayoutData(this.mEditButton);
        this.mEditButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)DriverDefinitionsDialog.this.mTreeViewer.getSelection();
                if (selection.getFirstElement() instanceof IPropertySet) {
                    DriverDefinitionsDialog.this.editDriver((ISelection)selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mRemoveButton = new Button(groupComponent, 8);
        this.mRemoveButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.removeDriver"));
        this.mRemoveButton.setLayoutData((Object)new GridData());
        this.mRemoveButton.setFont(font);
        this.setButtonLayoutData(this.mRemoveButton);
        this.mRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)DriverDefinitionsDialog.this.mTreeViewer.getSelection();
                if (selection.getFirstElement() instanceof IPropertySet) {
                    DriverDefinitionsDialog.this.removeDriver((ISelection)selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mCopyButton = new Button(groupComponent, 8);
        this.mCopyButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.copyDriver"));
        this.mCopyButton.setLayoutData((Object)new GridData());
        this.mCopyButton.setFont(font);
        this.setButtonLayoutData(this.mCopyButton);
        this.mCopyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)DriverDefinitionsDialog.this.mTreeViewer.getSelection();
                if (selection.getFirstElement() instanceof IPropertySet) {
                    DriverDefinitionsDialog.this.copyDriver((ISelection)selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setTitle(DriverMgmtMessages.getString((String)"DriverDefinitionsDialog.title"));
        this.setMessage(DriverMgmtMessages.getString((String)"DriverDefinitionsDialog.message"));
        IPropertySet pset = null;
        Object selection = null;
        if (this.mInitialDriverName != null) {
            DriverInstance di = DriverManager.getInstance().getDriverInstanceByName(this.mInitialDriverName);
            pset = di.getPropertySet();
        }
        selection = pset == null ? (this.mCategoryId == null ? (CategoryDescriptor.getRootCategories() == null || CategoryDescriptor.getRootCategories().length == 0 ? null : new StructuredSelection((Object)CategoryDescriptor.getRootCategories()[0])) : new StructuredSelection((Object)CategoryDescriptor.getCategoryDescriptor((String)this.mCategoryId))) : new StructuredSelection(pset);
        if (selection != null) {
            this.mTreeViewer.expandToLevel(selection.getFirstElement(), 1);
            this.mTreeViewer.setSelection((ISelection)selection, true);
        } else {
            this.mTreeViewer.expandToLevel(3);
        }
        return content;
    }

    private void validate(IPropertySet instance) {
        TemplateDescriptor template;
        String driverType = instance.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
        if (driverType != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
            DriverValidator validator = new DriverValidator(template, instance);
            String mErrorMessage = "";
            if (!validator.isValid()) {
                mErrorMessage = validator.getMessage();
            }
            this.mErrorLabel.setText(mErrorMessage);
            this.mErrorLabel.computeSize(-1, -1);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        IDialogSettings dSection;
        super.configureShell(newShell);
        newShell.setText(DriverMgmtMessages.getString((String)"DriverDefinitionsDialog.windowTitle"));
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null && (dSection = dset.getSection(MEMENTO_ROOT)) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT).trim().length() > 0) {
            int height = dSection.getInt(MEMENTO_DIALOG_SIZE_HEIGHT);
            int width = dSection.getInt(MEMENTO_DIALOG_SIZE_WIDTH);
            Point newsize = new Point(height, width);
            newShell.setSize(newsize);
        }
    }

    private void saveState() {
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null) {
            IDialogSettings dSection = dset.getSection(MEMENTO_ROOT);
            if (dSection == null) {
                dSection = dset.addNewSection(MEMENTO_ROOT);
            }
            if (dSection != null) {
                Point size = this.getShell().getSize();
                dSection.put(MEMENTO_DIALOG_SIZE_HEIGHT, size.x);
                dSection.put(MEMENTO_DIALOG_SIZE_WIDTH, size.y);
            }
        }
    }

    protected void okPressed() {
        if (this.mDirty) {
            this.saveChanges();
        }
        this.saveState();
        super.okPressed();
    }

    private void saveChanges() {
        this.mDirty = false;
    }

    public IPropertySet getSelectedDefinition() {
        return this.selectedPS;
    }

    private CategoryDescriptor getCategoryFromPropertySet(IPropertySet instance) {
        String driverType;
        TemplateDescriptor descriptor;
        if (instance != null && instance.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType") != null && (descriptor = TemplateDescriptor.getDriverTemplateDescriptor((String)(driverType = instance.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")))) != null) {
            CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)descriptor.getParentCategory());
            return category;
        }
        return null;
    }

    public void setInitialDriverName(String driverName) {
        this.mInitialDriverName = driverName;
    }

    public String getInitialDriverName() {
        return this.mInitialDriverName;
    }

    private IPropertySet duplicatePropertySet(IPropertySet pset) {
        PropertySetImpl newPset = new PropertySetImpl(pset.getName(), pset.getID());
        if (pset.getBaseProperties().size() > 0) {
            Properties newProps = new Properties();
            newPset.setBaseProperties(newProps);
            newPset.getBaseProperties().putAll((Map<?, ?>)pset.getBaseProperties());
        }
        return newPset;
    }

    private void copyPropertySet(IPropertySet fromPset, IPropertySet topset) {
        topset.setID(fromPset.getID());
        topset.setName(fromPset.getName());
        if (topset.getBaseProperties().size() > 0) {
            topset.getBaseProperties().putAll((Map<?, ?>)fromPset.getBaseProperties());
        }
    }

    private void addDriver(ISelection selection) {
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof CategoryDescriptor) {
            CategoryDescriptor descriptor = (CategoryDescriptor)sselection.getFirstElement();
            NewDriverDialog dlg = null;
            dlg = this.mCategoryId != null ? new NewDriverDialog(this.getShell(), descriptor.getId()) : new NewDriverDialog(this.getShell());
            if (dlg.open() == 0) {
                EditDriverDialog editdlg;
                int rtn_code;
                IPropertySet instance = dlg.getNewDriverInstance();
                this.mDirty = true;
                if (dlg.getEditImmediately() && (rtn_code = (editdlg = new EditDriverDialog(this.getShell(), instance)).open()) != 0) {
                    instance = editdlg.getInitialPropertySet();
                }
                DriverManager.getInstance().addDriverInstance(instance);
                this.mTreeViewer.setInput((Object)DriversProvider.getInstance());
                this.mTreeViewer.refresh();
                this.mTreeViewer.expandToLevel((Object)descriptor, 1);
                this.mTreeViewer.reveal((Object)descriptor);
            }
        }
    }

    private void editDriver(ISelection selection) {
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet) {
            IPropertySet instance = (IPropertySet)sselection.getFirstElement();
            IPropertySet copy = this.duplicatePropertySet(instance);
            EditDriverDialog dlg = new EditDriverDialog(this.getShell(), copy);
            if (dlg.open() == 0) {
                this.copyPropertySet(copy, instance);
                DriverManager.getInstance().removeDriverInstance(instance.getID());
                System.gc();
                DriverManager.getInstance().addDriverInstance(instance);
                this.mDirty = true;
                this.mTreeViewer.refresh();
                this.validate(instance);
            }
        }
    }

    private void removeDriver(ISelection selection) {
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet) {
            IPropertySet instance = (IPropertySet)sselection.getFirstElement();
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)DriverMgmtMessages.getString((String)"DriverPreferences.title.removeMessage"), (String)DriverMgmtMessages.format((String)"DriverPreferences.text.removeMessage", (Object[])new String[]{instance.getName()}))) {
                DriverManager.getInstance().removeDriverInstance(instance.getID());
                CategoryDescriptor category = this.getCategoryFromPropertySet(instance);
                this.mTreeViewer.refresh((Object)category);
                this.mDirty = true;
                this.mErrorLabel.setText("");
            }
        }
    }

    private void copyDriver(ISelection selection) {
        IPropertySet instance;
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet && (instance = (IPropertySet)sselection.getFirstElement()) != null) {
            IPropertySet cloned = (IPropertySet)((PropertySetImpl)instance).clone();
            String copyPrefix = DriverMgmtMessages.getString((String)"PropertySetImpl.copy_prefix");
            String copyIdSuffix = DriverMgmtMessages.getString((String)"PropertySetImpl.copy_id_suffix");
            String name = copyPrefix + instance.getName();
            String id = instance.getID() + copyIdSuffix;
            cloned.setID(id);
            cloned.setName(name);
            DriverManager.getInstance().addDriverInstance(cloned);
            this.mTreeViewer.refresh();
            this.mTreeViewer.setSelection((ISelection)new StructuredSelection((Object)cloned));
        }
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

