/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.actions;

import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.datatools.enablement.sybase.asa.actions.JDBCHelper;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MultiASADialog
extends TitleAreaDialog {
    private Button mCheckButton;
    private CheckboxTableViewer mList;
    private Button mSelectAll;
    private Button mDeselectAll;
    public Properties mCacheProps = null;
    private IConnectionProfile mProfile = null;
    private String[] mDBNames = null;

    public MultiASADialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setProfile(IConnectionProfile profile) {
        this.mProfile = profile;
    }

    public IConnectionProfile getProfile() {
        return this.mProfile;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(JDBCASAProfileMessages.getString("MultiASADialog.dialog.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData();
        GridLayout gl = new GridLayout(2, true);
        content.setLayout((Layout)gl);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.mCheckButton = new Button(content, 8);
        GridData pingData = new GridData();
        pingData.horizontalSpan = 2;
        pingData.horizontalAlignment = 1;
        this.mCheckButton.setLayoutData((Object)pingData);
        this.mCheckButton.setText(JDBCASAProfileMessages.getString("MultiASAWizardPage.checkButton.label"));
        this.mCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Connection conn = JDBCHelper.getConnectionForProfile(MultiASADialog.this.getShell(), MultiASADialog.this.mProfile);
                if (conn != null) {
                    String[] dbs = JDBCHelper.getDBNamesFromASA(conn);
                    MultiASADialog.this.mList.setInput((Object)dbs);
                    MultiASADialog.this.mList.getTable().setEnabled(true);
                    if (dbs == null) {
                        MultiASADialog.this.updateOKButton(false);
                        MultiASADialog.this.mList.getTable().setEnabled(false);
                    } else if (dbs.length == 1) {
                        List<Object> list = Arrays.asList(MultiASADialog.this.mList.getCheckedElements());
                        MultiASADialog.this.mDBNames = list.toArray(new String[list.size()]);
                        MultiASADialog.this.setErrorMessage(JDBCASAProfileMessages.getString("MultiASAWizardPage.OnlyOneDBMessage"));
                        MultiASADialog.this.updateOKButton(false);
                        MultiASADialog.this.mList.getTable().setEnabled(false);
                    } else {
                        MultiASADialog.this.setErrorMessage(null);
                        MultiASADialog.this.updateOKButton(true);
                        MultiASADialog.this.mList.getTable().setEnabled(true);
                    }
                    String dbName = (String)MultiASADialog.this.mProfile.getProperties(MultiASADialog.this.mProfile.getProviderId()).get("org.eclipse.datatools.enablement.sybase.dbName");
                    if (dbName != null) {
                        int i = 0;
                        while (i < dbs.length) {
                            if (dbName.equals(dbs[i])) {
                                MultiASADialog.this.mList.setChecked((Object)dbName, true);
                            }
                            ++i;
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label label = new Label(content, 0);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        label.setLayoutData((Object)labelData);
        label.setText(JDBCASAProfileMessages.getString("MultiASAWizardPage.Label.ChooseDbs"));
        this.mList = CheckboxTableViewer.newCheckList((Composite)content, (int)2050);
        GridData listData = new GridData(4, 4, true, true);
        listData.horizontalSpan = 2;
        this.mList.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private String[] mDatabases = null;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof String[]) {
                    this.mDatabases = (String[])newInput;
                }
            }

            public Object[] getElements(Object inputElement) {
                return this.mDatabases;
            }
        });
        this.mList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mList.getTable().setLayoutData((Object)listData);
        this.mList.getTable().setEnabled(false);
        this.mList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                List<Object> list = Arrays.asList(MultiASADialog.this.mList.getCheckedElements());
                MultiASADialog.this.mDBNames = list.toArray(new String[list.size()]);
            }
        });
        this.mSelectAll = new Button(content, 8);
        this.mSelectAll.setText(JDBCASAProfileMessages.getString("MultiASAWizardPage.selectAllButton.label"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.mSelectAll.setLayoutData((Object)gridData);
        this.mSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MultiASADialog.this.selectAll();
            }
        });
        this.mDeselectAll = new Button(content, 8);
        this.mDeselectAll.setText(JDBCASAProfileMessages.getString("MultiASAWizardPage.deselectAllButton.label"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.mDeselectAll.setLayoutData((Object)gridData);
        this.mDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MultiASADialog.this.unselectAll();
            }
        });
        this.setTitle(JDBCASAProfileMessages.getString("MultiASADialog.dialog.message.title"));
        this.setMessage(JDBCASAProfileMessages.getString("MultiASADialog.dialog.message"));
        return content;
    }

    private void selectAll() {
        Object[] names = (String[])this.mList.getInput();
        this.mList.setCheckedElements(names);
        List<Object> list = Arrays.asList(this.mList.getCheckedElements());
        this.mDBNames = list.toArray(new String[list.size()]);
    }

    private void unselectAll() {
        String[] names = (String[])this.mList.getInput();
        int i = 0;
        while (i < names.length) {
            this.mList.setChecked((Object)names[i], false);
            ++i;
        }
        List<Object> list = Arrays.asList(this.mList.getCheckedElements());
        this.mDBNames = list.toArray(new String[list.size()]);
    }

    public void clearList() {
        this.mList.setInput((Object)new String[0]);
        this.mList.getTable().setEnabled(false);
        this.mCacheProps.clear();
        this.mCacheProps = null;
    }

    public String[] getDBNames() {
        return this.mDBNames;
    }

    public void updateOKButton(boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }
}

