/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.ui;

import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.db.generic.GenericDBPlugin;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.datatools.enablement.sybase.ui.JDBCProfileTabs;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

public class JDBCASAProfileTabs
extends JDBCProfileTabs {
    protected Text mHostText;
    protected Text mPortText;
    protected Text mDatabaseText;
    protected Button mSaveDBPWDCheckbox;
    private boolean _isPropertyPage = false;

    public void setIsPropertyPage(boolean flag) {
        this._isPropertyPage = flag;
    }

    public boolean isPropertyPage() {
        return this._isPropertyPage;
    }

    protected void createConnectionTab(TabFolder parent) {
        this.connTabComposite = new Composite((Composite)parent, 0);
        GridLayout layout = new GridLayout(2, false);
        this.connTabComposite.setLayout((Layout)layout);
        this.combo.setLabelText(JDBCASAProfileMessages.getString("JDBCPropertyWizardPage.driverCombo.label"));
        this.combo.setCategory(this.getCategory());
        this.combo.setNullDriverIsValid(false);
        this.combo.createContents(this.connTabComposite);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        }
        this.mHostText = (Text)this.createLabelTextPair(this.connTabComposite, JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.hostName.label"), (Control)this.mHostText, 2048, 768);
        this.mHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCASAProfileTabs.this.fireChangedEvent((Object)JDBCASAProfileTabs.this);
            }
        });
        this.mPortText = (Text)this.createLabelTextPair(this.connTabComposite, JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.portNumber.label"), (Control)this.mPortText, 2048, 768);
        this.mPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCASAProfileTabs.this.fireChangedEvent((Object)JDBCASAProfileTabs.this);
            }
        });
        this.mDatabaseText = (Text)this.createLabelTextPair(this.connTabComposite, JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.databaseName.label"), (Control)this.mPortText, 2048, 768);
        this.mDatabaseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCASAProfileTabs.this.fireChangedEvent((Object)JDBCASAProfileTabs.this);
            }
        });
        this.mDBUIDText = (Text)this.createLabelTextPair(this.connTabComposite, JDBCASAProfileMessages.getString("JDBCPropertyWizardPage.userName.label"), (Control)this.mDBUIDText, 2048, 768);
        this.mDBUIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCASAProfileTabs.this.fireChangedEvent((Object)JDBCASAProfileTabs.this);
            }
        });
        this.mDBPWDText = (Text)this.createLabelTextPair(this.connTabComposite, JDBCASAProfileMessages.getString("JDBCPropertyWizardPage.password.label"), (Control)this.mDBPWDText, 2048, 768);
        this.mDBPWDText.setEchoChar('*');
        this.mDBPWDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCASAProfileTabs.this.fireChangedEvent((Object)JDBCASAProfileTabs.this);
            }
        });
        this.mSaveDBPWDCheckbox = new Button(this.connTabComposite, 32);
        this.mSaveDBPWDCheckbox.setText(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.persistpassword.label"));
        this.mSaveDBPWDCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.comboListener = new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                JDBCASAProfileTabs.this.driverStateChanged();
            }
        };
        this.combo.addChangeListener(this.comboListener);
    }

    protected String getCategory() {
        return "org.eclipse.datatools.enablement.sybase.asa.category";
    }

    protected void createOtherTab(TabFolder parent) {
        this.otherTabComposite = new Composite((Composite)parent, 0);
        GridLayout layout = new GridLayout(2, false);
        this.otherTabComposite.setLayout((Layout)layout);
        this.mDBConnProps = new DelimitedStringList(this.otherTabComposite, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.mDBConnProps.setLayoutData((Object)gdata);
        this.mDBConnProps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                JDBCASAProfileTabs.this.setErrorMessage(null);
                if (JDBCASAProfileTabs.this.mDBConnProps.getWarning() != null) {
                    JDBCASAProfileTabs.this.setErrorMessage(JDBCASAProfileTabs.this.mDBConnProps.getWarning());
                }
            }
        });
    }

    public String[] getCommonConnProperties() {
        return JDBCASAProfileMessages.getString("JDBCASAProfileTabs.otherPropertiesTab.commonOptions").split(",");
    }

    protected Properties collectProperties() {
        Properties props = super.collectProperties();
        String host = "";
        String port = "";
        String dbName = "";
        String xaConnectClass = "";
        if (this.combo.getSelectedDriverInstance() != null) {
            DriverInstance instance = this.combo.getSelectedDriverInstance();
            xaConnectClass = instance.getNamedProperty("xaConnectClass");
        }
        if (this.mPortText.getText() != null) {
            port = this.mPortText.getText();
        }
        if (this.mHostText.getText() != null) {
            host = this.mHostText.getText();
        }
        if (this.mDatabaseText.getText() != null) {
            dbName = this.mDatabaseText.getText();
        }
        String driverURL = this.getURL();
        props.setProperty("org.eclipse.datatools.connectivity.db.URL", driverURL);
        props.setProperty("org.eclipse.datatools.enablement.sybase.host", host);
        props.setProperty("org.eclipse.datatools.enablement.sybase.port", port);
        props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", dbName);
        if (xaConnectClass != null && xaConnectClass.trim().length() > 0) {
            props.setProperty("org.eclipse.datatools.enablement.sybase.xaConnectClass", xaConnectClass);
        }
        props.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.mSaveDBPWDCheckbox.getSelection()));
        return props;
    }

    protected void initControls() {
        IConnectionProfile profile = this.getConnectionProfile();
        String providerId = this.getProviderID();
        if (profile != null) {
            providerId = profile.getProviderId();
        }
        if (providerId != null) {
            this.combo.setFilter(this.getFilter());
            this.combo.refreshCombo();
        }
        if (this.isPropertyPage()) {
            super.setResetPwdFromDriver(false);
        }
        super.initControls();
        if (profile != null && this.mHostText != null && this.mPortText != null) {
            String dbName;
            String port;
            String host = profile.getBaseProperties().getProperty("org.eclipse.datatools.enablement.sybase.host");
            if (host != null) {
                this.mHostText.setText(host);
            }
            if ((port = profile.getBaseProperties().getProperty("org.eclipse.datatools.enablement.sybase.port")) != null) {
                this.mPortText.setText(port);
            }
            if ((dbName = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName")) != null) {
                this.mDatabaseText.setText(dbName);
            }
            this.mSaveDBPWDCheckbox.setSelection(Boolean.valueOf(profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.savePWD", Boolean.FALSE.toString())).booleanValue());
        }
        super.setResetPwdFromDriver(true);
    }

    protected String getFilter() {
        return "templateID = org.eclipse.datatools.enablement.sybase.asa.drivertemplate";
    }

    protected void driverStateChanged() {
        super.driverStateChanged();
        if (this.mHostText != null && this.mPortText != null) {
            String olddbname;
            String dbname;
            String oldport;
            String port;
            String oldHost;
            String host = this.getNamedPropertyFromDriverInstance("host");
            if (host == null || host.trim().length() == 0) {
                host = "";
            }
            if ((oldHost = this.mHostText.getText()) == null || oldHost.trim().length() == 0) {
                oldHost = "";
            }
            if (oldHost.length() == 0) {
                this.mHostText.setText(host);
            }
            if ((port = this.getNamedPropertyFromDriverInstance("port")) == null || port.trim().length() == 0) {
                port = "";
            }
            if ((oldport = this.mPortText.getText()) == null || oldport.trim().length() == 0) {
                oldport = "";
            }
            if (oldport.length() == 0) {
                this.mPortText.setText(port);
            }
            if ((dbname = this.getNamedPropertyFromDriverInstance("Database Name")) == null || dbname.trim().length() == 0) {
                dbname = "";
            }
            if ((olddbname = this.mDatabaseText.getText()) == null || olddbname.trim().length() == 0) {
                olddbname = "";
            }
            if (olddbname.length() == 0) {
                this.mDatabaseText.setText(dbname);
            }
        }
    }

    public boolean isValid() {
        boolean isDriverOK;
        boolean isUIDOK = this.mDBUIDText != null && this.mDBUIDText.getText().trim().length() > 0;
        boolean isHostOK = this.mHostText != null && this.mHostText.getText().trim().length() > 0;
        boolean isPortOK = this.mPortText != null && this.mPortText.getText().trim().length() > 0;
        boolean isPortValid = true;
        if (isPortOK) {
            try {
                Integer.valueOf(this.mPortText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                isPortValid = false;
            }
        }
        boolean bl = isDriverOK = this.combo.getErrorMessage() == null;
        if (isUIDOK && isDriverOK && isHostOK && isPortOK && isPortValid) {
            return true;
        }
        if (!isDriverOK) {
            this.setErrorMessage(this.combo.getErrorMessage());
        } else if (!isUIDOK) {
            this.setErrorMessage(JDBCASAProfileMessages.getString("JDBCProfileTabs.errors.requiredUID"));
        } else if (!isHostOK) {
            this.setErrorMessage(JDBCASAProfileMessages.getString("JDBCASAProfileTabs.errors.requiredHost"));
        } else if (!isPortOK) {
            this.setErrorMessage(JDBCASAProfileMessages.getString("JDBCASAProfileTabs.errors.requiredPort"));
        } else if (!isPortValid) {
            this.setErrorMessage(JDBCASAProfileMessages.getString("JDBCASAProfileTabs.errors.requiredPortValidNumber"));
        }
        return false;
    }

    public void dispose() {
        this.combo.removeChangeListener(this.comboListener);
        super.dispose();
    }

    public String getHostName() {
        return this.mHostText.getText();
    }

    public String getPortName() {
        return this.mPortText.getText();
    }

    public String getDBName() {
        return this.mDatabaseText.getText();
    }

    public String getURL() {
        String host = "";
        String port = "";
        String dbName = "";
        if (this.mPortText.getText() != null) {
            port = this.mPortText.getText();
        }
        if (this.mHostText.getText() != null) {
            host = this.mHostText.getText();
        }
        if (this.mDatabaseText.getText() != null) {
            dbName = this.mDatabaseText.getText();
        }
        String driverURL = JDBCASAPlugin.makeDriverURL(host, port, dbName);
        return driverURL;
    }

    public boolean getSaveDBPWD() {
        return this.mSaveDBPWDCheckbox.getSelection();
    }
}

