/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaModel;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaCoreFactory;
import org.eclipse.jpt.core.internal.JpaModel;
import org.eclipse.jpt.core.internal.JpaProject;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class JpaModelManager {
    private static JpaModelManager INSTANCE;
    JpaModel model = JpaCoreFactory.eINSTANCE.createJpaModel();
    private IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private IElementChangedListener elementChangeListener = new ElementChangeListener();
    private Preferences.IPropertyChangeListener preferencesListener = new PreferencesListener();

    public static final JpaModelManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new JpaModelManager();
        }
        return INSTANCE;
    }

    private JpaModelManager() {
    }

    public void startup() {
        try {
            this.buildWorkspace();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
            JavaCore.addElementChangedListener((IElementChangedListener)this.elementChangeListener);
            JptCorePlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(this.preferencesListener);
        }
        catch (RuntimeException re) {
            JptCorePlugin.log(re);
            this.shutdown();
        }
    }

    public void shutdown() {
        JptCorePlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this.preferencesListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.elementChangeListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.model.dispose();
    }

    private void buildWorkspace() {
        WorkspaceBuildJob workspaceBuildJob = new WorkspaceBuildJob();
        workspaceBuildJob.schedule(5000L);
    }

    public IJpaModel getJpaModel() {
        return this.model;
    }

    public IJpaModel getFilledJpaModel() throws CoreException {
        this.model.fill();
        return this.model;
    }

    public synchronized IJpaProject getJpaProject(IProject project) {
        if (project == null) {
            return null;
        }
        return this.model.getJpaProject(project);
    }

    public synchronized IJpaProject getFilledJpaProject(IProject project) throws CoreException {
        JpaProject jpaProject = (JpaProject)this.getJpaProject(project);
        if (jpaProject != null) {
            jpaProject.fill();
        }
        return jpaProject;
    }

    public synchronized void fillJpaProject(IProject project) throws CoreException {
        JpaProject jpaProject = (JpaProject)this.getJpaProject(project);
        if (jpaProject != null) {
            jpaProject.fill();
        }
    }

    public synchronized IJpaProject createJpaProject(IProject project) throws CoreException {
        if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jpt.jpa")) {
            JpaProject jpaProject = JpaCoreFactory.eINSTANCE.createJpaProject();
            jpaProject.setProject(project);
            this.model.getProjects().add((Object)jpaProject);
            return jpaProject;
        }
        return null;
    }

    public synchronized IJpaProject createFilledJpaProject(IProject project) throws CoreException {
        JpaProject jpaProject = (JpaProject)this.createJpaProject(project);
        if (jpaProject != null) {
            jpaProject.fill();
        }
        return jpaProject;
    }

    public void disposeJpaProject(IJpaProject jpaProject) {
        this.model.disposeProject((JpaProject)jpaProject);
    }

    public synchronized IJpaFile getJpaFile(IFile file) {
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        JpaProject jpaProject = (JpaProject)this.getJpaProject(project);
        if (jpaProject == null) {
            return null;
        }
        return jpaProject.getJpaFile(file);
    }

    private static class ElementChangeListener
    implements IElementChangedListener {
        ThreadLocal<ElementChangeProcessor> elementChangeProcessors = new ThreadLocal();

        ElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.getElementChangeProcessor().elementChanged(event);
        }

        public ElementChangeProcessor getElementChangeProcessor() {
            ElementChangeProcessor processor = this.elementChangeProcessors.get();
            if (processor == null) {
                processor = new ElementChangeProcessor();
                this.elementChangeProcessors.set(processor);
            }
            return processor;
        }
    }

    private static class ElementChangeProcessor {
        ElementChangeProcessor() {
        }

        public void elementChanged(ElementChangedEvent event) {
            JpaModelManager.instance().model.handleEvent(event);
        }
    }

    private static class PreferencesListener
    implements Preferences.IPropertyChangeListener {
        PreferencesListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty() == "defaultJpaLib") {
                try {
                    JavaCore.setClasspathVariable((String)"DEFAULT_JPA_LIB", (IPath)new Path((String)event.getNewValue()), null);
                }
                catch (JavaModelException jme) {
                    JptCorePlugin.log(jme);
                }
            }
        }
    }

    private static class ResourceChangeListener
    implements IResourceChangeListener {
        ThreadLocal<ResourceChangeProcessor> resourceChangeProcessors = new ThreadLocal();

        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            this.getResourceChangeProcessor().resourceChanged(event);
        }

        public ResourceChangeProcessor getResourceChangeProcessor() {
            ResourceChangeProcessor processor = this.resourceChangeProcessors.get();
            if (processor == null) {
                processor = new ResourceChangeProcessor();
                this.resourceChangeProcessors.set(processor);
            }
            return processor;
        }
    }

    private static class ResourceChangeProcessor {
        private JpaModel model;

        ResourceChangeProcessor() {
            this.model = JpaModelManager.instance().model;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getSource() instanceof IWorkspace) {
                IResource resource = event.getResource();
                IResourceDelta delta = event.getDelta();
                switch (event.getType()) {
                    case 4: {
                        try {
                            if (resource.getType() == 4 && FacetedProjectFramework.hasProjectFacet((IProject)((IProject)resource), (String)"jpt.jpa")) {
                                this.projectBeingDeleted((IProject)resource);
                            }
                        }
                        catch (CoreException coreException) {}
                        return;
                    }
                    case 1: {
                        if (this.isApplicable(delta)) {
                            this.checkForProjectsBeingAddedOrRemoved(delta);
                            this.checkForFilesBeingAddedOrRemoved(delta);
                        }
                        return;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }

        private void checkForFilesBeingAddedOrRemoved(IResourceDelta delta) {
            IResource resource = delta.getResource();
            boolean processChildren = false;
            switch (resource.getType()) {
                case 8: {
                    processChildren = true;
                    break;
                }
                case 4: {
                    IProject project = (IProject)resource;
                    try {
                        JpaProject jpaProject;
                        if (!FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jpt.jpa") || (jpaProject = (JpaProject)this.model.getJpaProject(project)) == null) break;
                        jpaProject.synchInternalResources(delta);
                        break;
                    }
                    catch (CoreException coreException) {}
                }
            }
            if (processChildren) {
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.checkForFilesBeingAddedOrRemoved(children[i]);
                    ++i;
                }
            }
        }

        private void checkForProjectsBeingAddedOrRemoved(IResourceDelta delta) {
            IResource resource = delta.getResource();
            boolean processChildren = false;
            block1 : switch (resource.getType()) {
                case 8: {
                    processChildren = true;
                    break;
                }
                case 4: {
                    IProject project = (IProject)resource;
                    JpaProject jpaProject = (JpaProject)this.model.getJpaProject(project);
                    switch (delta.getKind()) {
                        case 2: {
                            break block1;
                        }
                        case 1: 
                        case 4: {
                            if ((delta.getFlags() & 0x4000) != 0) {
                                if (project.isOpen()) {
                                    if (jpaProject == null) {
                                        try {
                                            JpaModelManager.instance().createFilledJpaProject(project);
                                        }
                                        catch (CoreException ce) {
                                            JptCorePlugin.log(ce);
                                        }
                                    }
                                } else if (jpaProject != null) {
                                    this.model.disposeProject(jpaProject);
                                    break block1;
                                }
                            } else {
                                delta.getFlags();
                            }
                        }
                    }
                }
            }
            if (processChildren) {
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.checkForProjectsBeingAddedOrRemoved(children[i]);
                    ++i;
                }
            }
        }

        private void projectBeingDeleted(IProject project) {
            JpaProject jpaProject = (JpaProject)this.model.getJpaProject(project);
            this.model.disposeProject(jpaProject);
        }

        private boolean isApplicable(IResourceDelta rootDelta) {
            if (rootDelta != null) {
                class FoundRelevantDeltaException
                extends RuntimeException {
                    private static final long serialVersionUID = 7137113252936111022L;

                    FoundRelevantDeltaException() {
                    }
                }
                try {
                    rootDelta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            switch (delta.getKind()) {
                                case 1: 
                                case 2: {
                                    throw new FoundRelevantDeltaException();
                                }
                                case 4: {
                                    if (delta.getAffectedChildren().length != 0 || (delta.getFlags() & 0xFFFCFFFF) == 0) break;
                                    throw new FoundRelevantDeltaException();
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (FoundRelevantDeltaException foundRelevantDeltaException) {
                    return true;
                }
                catch (CoreException coreException) {}
            }
            return false;
        }
    }

    private class WorkspaceBuildJob
    extends Job {
        WorkspaceBuildJob() {
            super("Initializing JPA Model ...");
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            try {
                workspace.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progress) throws CoreException {
                        ((WorkspaceBuildJob)WorkspaceBuildJob.this).JpaModelManager.this.model.fill();
                    }
                }, monitor);
            }
            catch (CoreException ce) {
                return ce.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

