/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.JpaFile;
import org.eclipse.jpt.core.internal.content.java.JavaEObject;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.java.JpaJavaFactory;
import org.eclipse.jpt.core.internal.content.java.JpaJavaPackage;
import org.eclipse.jpt.core.internal.jdtutility.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.jdtutility.AttributeAnnotationTools;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaCompilationUnit
extends JavaEObject
implements IJpaRootContentNode {
    protected EList<JavaPersistentType> types;
    private ICompilationUnit compilationUnit;

    protected JpaCompilationUnit() {
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaPackage.Literals.JPA_COMPILATION_UNIT;
    }

    @Override
    public IJpaFile getJpaFile() {
        if (this.eContainerFeatureID != 0) {
            return null;
        }
        return (IJpaFile)this.eContainer();
    }

    public EList<JavaPersistentType> getTypes() {
        if (this.types == null) {
            this.types = new EObjectContainmentEList(JavaPersistentType.class, (InternalEObject)this, 1);
        }
        return this.types;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.eBasicSetContainer(otherEnd, 0, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.eBasicSetContainer(null, 0, msgs);
            }
            case 1: {
                return ((InternalEList)this.getTypes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 0: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, JpaFile.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getJpaFile();
            }
            case 1: {
                return this.getTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getJpaFile() != null;
            }
            case 1: {
                return this.types != null && !this.types.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IJpaContentNode.class) {
            return -1;
        }
        if (baseClass == IJpaRootContentNode.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IJpaContentNode.class) {
            return -1;
        }
        if (baseClass == IJpaRootContentNode.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public ITextRange fullTextRange() {
        return new ASTNodeTextRange((ASTNode)this.astRoot());
    }

    @Override
    public ITextRange validationTextRange() {
        return this.selectionTextRange();
    }

    @Override
    public ITextRange selectionTextRange() {
        return null;
    }

    @Override
    public Object getId() {
        return "org.eclipse.jpt.core.java.compilationUnit";
    }

    @Override
    public IJpaRootContentNode getRoot() {
        return this;
    }

    public void setFile(IFile file) {
        this.compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        try {
            this.compilationUnit.open(null);
        }
        catch (JavaModelException javaModelException) {}
        this.synchronizePersistentTypes();
    }

    public JavaPersistentType addJavaPersistentType(IType primaryType, CompilationUnit astRoot) {
        return this.addJavaPersistentType(this.createJavaPersistentType(), primaryType, astRoot);
    }

    public JavaPersistentType createJavaPersistentType() {
        return JpaJavaFactory.eINSTANCE.createJavaPersistentType();
    }

    private JavaPersistentType addJavaPersistentType(JavaPersistentType javaPersistentType, IType primaryType, CompilationUnit astRoot) {
        this.getTypes().add((Object)javaPersistentType);
        javaPersistentType.setJdtType(primaryType, astRoot);
        return javaPersistentType;
    }

    @Override
    public IJpaContentNode getContentNode(int offset) {
        for (JavaPersistentType javaType : this.getTypes()) {
            if (!javaType.includes(offset)) continue;
            IJpaContentNode contentNode = javaType.contentNodeAt(offset);
            if (contentNode != null) {
                return contentNode;
            }
            return javaType;
        }
        return this;
    }

    @Override
    public void handleJavaElementChangedEvent(ElementChangedEvent event) {
        this.synchWithJavaDelta(event.getDelta());
    }

    private void synchWithJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.synchChildrenWithJavaDelta(delta);
                break;
            }
            case 5: {
                this.synchCompilationUnitWithJavaDelta(delta);
                break;
            }
        }
    }

    private void synchChildrenWithJavaDelta(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.synchWithJavaDelta(child);
            ++n2;
        }
    }

    private void synchCompilationUnitWithJavaDelta(IJavaElementDelta delta) {
        if ((delta.getFlags() & 0x10000) != 0) {
            return;
        }
        if (delta.getElement().equals(this.compilationUnit)) {
            this.synchronizePersistentTypes();
        }
    }

    private void synchronizePersistentTypes() {
        IType[] iTypes;
        CompilationUnit astRoot = this.astRoot();
        ArrayList<JavaPersistentType> persistentTypesToRemove = new ArrayList<JavaPersistentType>((Collection<JavaPersistentType>)this.getTypes());
        IType[] iTypeArray = iTypes = this.compilationUnitTypes();
        int n = iTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType iType = iTypeArray[n2];
            JavaPersistentType persistentType = this.persistentTypeFor(iType);
            if (persistentType == null && AttributeAnnotationTools.typeIsPersistable(iType)) {
                persistentType = this.addJavaPersistentType(iType, astRoot);
            }
            if (persistentType != null) {
                persistentTypesToRemove.remove(persistentType);
                if (AttributeAnnotationTools.typeIsPersistable(iType)) {
                    persistentType.updateFromJava(astRoot);
                } else {
                    this.getTypes().remove((Object)persistentType);
                }
            }
            ++n2;
        }
        this.getTypes().removeAll(persistentTypesToRemove);
    }

    private JavaPersistentType persistentTypeFor(IType iType) {
        for (JavaPersistentType persistentType : this.getTypes()) {
            if (!persistentType.isFor(iType)) continue;
            return persistentType;
        }
        return null;
    }

    private IType[] compilationUnitTypes() {
        try {
            return this.compilationUnit.getTypes();
        }
        catch (JavaModelException javaModelException) {
            return new IType[0];
        }
    }

    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter) {
        CompilationUnit astRoot = this.astRoot();
        for (JavaPersistentType persistentType : this.getTypes()) {
            Iterator<String> values = persistentType.candidateValuesFor(pos, filter, astRoot);
            if (values == null) continue;
            return values;
        }
        return EmptyIterator.instance();
    }

    public CompilationUnit astRoot() {
        return JDTTools.createASTRoot(this.compilationUnit);
    }

    @Override
    public void dispose() {
    }
}

