/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JoinColumnContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableContext
extends BaseContext {
    private IJoinTable table;
    private Collection<JoinColumnContext> joinColumnContexts;
    private Collection<JoinColumnContext> inverseJoinColumnContexts;
    private boolean doContinue;

    public JoinTableContext(IContext parentContext, IJoinTable table) {
        super(parentContext);
        this.table = table;
        this.joinColumnContexts = this.buildJoinColumnContexts();
        this.inverseJoinColumnContexts = this.buildInverseJoinColumnContexts();
    }

    @Override
    protected void initialize() {
    }

    protected Collection<JoinColumnContext> buildJoinColumnContexts() {
        ArrayList<JoinColumnContext> contexts = new ArrayList<JoinColumnContext>();
        for (IJoinColumn joinColumn : this.table.getJoinColumns()) {
            contexts.add(new JoinColumnContext((IContext)this, joinColumn));
        }
        return contexts;
    }

    protected Collection<JoinColumnContext> buildInverseJoinColumnContexts() {
        ArrayList<JoinColumnContext> contexts = new ArrayList<JoinColumnContext>();
        for (IJoinColumn joinColumn : this.table.getInverseJoinColumns()) {
            contexts.add(new JoinColumnContext((IContext)this, joinColumn));
        }
        return contexts;
    }

    public IJoinTable getTable() {
        return this.table;
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        this.table.refreshDefaults(defaultsContext);
        DefaultsContext joinColumnsDefaultsContext = this.wrapDefaultsContextForJoinColumn(defaultsContext);
        for (JoinColumnContext context : this.joinColumnContexts) {
            context.refreshDefaults(joinColumnsDefaultsContext);
        }
        DefaultsContext inverseJoinColumnsDefaultsContext = this.wrapDefaultsContextForInverseJoinColumn(defaultsContext);
        for (JoinColumnContext context : this.inverseJoinColumnContexts) {
            context.refreshDefaults(inverseJoinColumnsDefaultsContext);
        }
    }

    protected DefaultsContext wrapDefaultsContextForJoinColumn(final DefaultsContext defaultsContext) {
        return new DefaultsContext(){

            public Object getDefault(String key) {
                if (key.equals("joinColumn.table")) {
                    return JoinTableContext.this.getTable().getName();
                }
                return defaultsContext.getDefault(key);
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return defaultsContext.persistentType(fullyQualifiedTypeName);
            }
        };
    }

    protected DefaultsContext wrapDefaultsContextForInverseJoinColumn(final DefaultsContext defaultsContext) {
        return new DefaultsContext(){

            public Object getDefault(String key) {
                if (key.equals("joinColumn.table")) {
                    return JoinTableContext.this.getTable().getName();
                }
                return defaultsContext.getDefault(key);
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return defaultsContext.persistentType(fullyQualifiedTypeName);
            }
        };
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addTableMessages(messages);
        if (this.doContinue) {
            for (JoinColumnContext context : this.joinColumnContexts) {
                context.addToMessages(messages);
            }
            for (JoinColumnContext context : this.inverseJoinColumnContexts) {
                context.addToMessages(messages);
            }
        }
    }

    protected void addTableMessages(List<IMessage> messages) {
        this.doContinue = this.table.isConnected();
        String schema = this.table.getSchema();
        XmlRelationshipMapping mapping = (XmlRelationshipMapping)this.table.relationshipMapping();
        if (this.doContinue && !this.table.hasResolvedSchema()) {
            if (mapping.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{mapping.getPersistentAttribute().getName(), schema, this.table.getName()}, this.table, this.table.schemaTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.table.getName()}, this.table, this.table.schemaTextRange()));
            }
            this.doContinue = false;
        }
        if (this.doContinue && !this.table.isResolved()) {
            if (mapping.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME", new String[]{mapping.getPersistentAttribute().getName(), this.table.getName()}, this.table, this.table.nameTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_NAME", new String[]{this.table.getName()}, this.table, this.table.nameTextRange()));
            }
        }
    }
}

