/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.project.facet.AbstractJSFFacetInstallDelegate;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils11;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JSFJ2EEFacetInstallDelegate
extends AbstractJSFFacetInstallDelegate {
    protected void createConfigFile(final IProject project, final IProjectFacetVersion fv, IDataModel config, IProgressMonitor monitor) {
        final IPath configPath = this.resolveConfigPath(project, config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
        try {
            if (!configPath.toFile().exists()) {
                IWorkspaceRunnable op = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor_inner) throws CoreException {
                        JSFUtils11.createConfigFile(fv.getVersionString(), configPath);
                        project.refreshLocal(2, monitor_inner);
                    }
                };
                op.run(monitor);
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occured while creating faces-config.xml");
        }
    }

    protected void createServletAndModifyWebXML(IProject project, IDataModel config, IProgressMonitor monitor) {
        WebArtifactEdit webEdit = null;
        try {
            webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
            WebApp webApp = webEdit.getWebApp();
            Servlet servlet = JSFUtils11.findJSFServlet(webApp);
            if (servlet != null) {
                JSFUtils11.removeURLMappings(webApp, servlet);
            }
            servlet = JSFUtils11.createOrUpdateServletRef(webApp, config, servlet);
            List listOfMappings = this.getServletMappings(config);
            JSFUtils11.setUpURLMappings(webApp, listOfMappings, servlet);
            this.setupContextParams(webApp, config);
        }
        finally {
            if (webEdit != null) {
                webEdit.saveIfNecessary(monitor);
                webEdit.dispose();
            }
        }
    }

    private void setupContextParams(WebApp webApp, IDataModel config) {
        if (webApp.getVersionID() == 23) {
            JSFUtils11.setupConfigFileContextParamForV2_3(webApp, config);
        } else {
            JSFUtils11.setupConfigFileContextParamForV2_4(webApp, config);
        }
    }
}

