/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DBUnitDataExtractor {
    private DataSource dataSource;
    private String dataSetName = "dbunit-dataset.xml";
    private List queryList;
    private List tableList;
    private Map dbUnitProperties;
    private Map dbUnitFeatures;
    private String schema;
    private static final Pattern TABLE_MATCH_PATTERN = Pattern.compile(".*\\s+from\\s+(\\w+(\\.\\w+)?).*", 2);

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setDataSetName(String name) {
        this.dataSetName = name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extract(boolean closeWhenDone) throws Exception {
        block18: {
            Connection conn = null;
            try {
                conn = this.dataSource.getConnection();
                this.log("Beginning extraction from '" + conn.toString() + "'.");
                DatabaseConnection connection = null;
                connection = this.schema != null ? new DatabaseConnection(conn, this.schema) : new DatabaseConnection(conn);
                this.configConnection(connection);
                DatabaseConfig config = connection.getConfig();
                DatabaseMetaData metadata = conn.getMetaData();
                try {
                    metadata.getPrimaryKeys(null, null, null);
                }
                catch (SQLException sQLException) {
                    config.setProperty("http://www.dbunit.org/properties/primaryKeyFilter", (Object)new MyPrimaryKeyFilter());
                }
                catch (Exception exception) {}
                if (this.tableList != null || this.queryList != null) {
                    QueryDataSet partialDataSet = new QueryDataSet((IDatabaseConnection)connection);
                    this.addTables(partialDataSet);
                    this.addQueries(partialDataSet);
                    Path dsPath = new Path(this.dataSetName);
                    IFile dsFile = Activator.getFile(dsPath.toPortableString());
                    String hardPath = null;
                    if (dsFile != null) {
                        hardPath = dsFile.getLocation().makeAbsolute().toOSString();
                    } else {
                        IContainer dsFolder = Activator.getParentFolder(dsPath.toPortableString());
                        IPath newPath = dsFolder.getLocation().append(dsPath.lastSegment());
                        hardPath = newPath.makeAbsolute().toOSString();
                    }
                    File file = new File(hardPath);
                    if (file != null && !file.exists()) {
                        boolean flag = file.createNewFile();
                        this.log("New file created ( " + flag + " ): " + file.getAbsolutePath());
                    }
                    try {
                        FlatXmlDataSet.write((IDataSet)partialDataSet, (OutputStream)new FileOutputStream(file));
                        if (dsFile == null) {
                            dsFile = Activator.getFile(file.getAbsolutePath());
                        }
                        if (dsFile != null) {
                            dsFile.refreshLocal(1, null);
                        }
                    }
                    catch (DataSetException dse) {
                        Activator.log(dse);
                        MessageDialog.openError((Shell)new Shell(), (String)DbUnitMessages.DbUnitDataExtractor_DataSetGenerationError, (String)DbUnitMessages.DbUnitDataExtractor_DataSetGenerationError_Message);
                    }
                } else {
                    IDataSet fullDataSet = connection.createDataSet();
                    FlatXmlDataSet.write((IDataSet)fullDataSet, (OutputStream)new FileOutputStream(this.dataSetName));
                }
                Object var12_17 = null;
                if (!closeWhenDone || conn == null) break block18;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (closeWhenDone && conn != null) {
                    conn.close();
                }
                throw throwable;
            }
            conn.close();
        }
        this.log("Completed extraction to '" + this.dataSetName + "'.");
    }

    public void extract() throws Exception {
        this.extract(true);
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    public void setTableList(List list) {
        this.tableList = list;
    }

    public void setQueryList(List list) {
        this.queryList = list;
    }

    public void setDbUnitFeatures(Map dbUnitFeatures) {
        this.dbUnitFeatures = dbUnitFeatures;
    }

    public void setDbUnitProperties(Map dbUnitProperties) {
        this.dbUnitProperties = dbUnitProperties;
    }

    private void configConnection(DatabaseConnection conn) {
        String name;
        Map.Entry entry;
        Iterator k;
        DatabaseConfig config = conn.getConfig();
        if (this.dbUnitProperties != null) {
            k = this.dbUnitProperties.entrySet().iterator();
            while (k.hasNext()) {
                entry = k.next();
                name = (String)entry.getKey();
                Object value = entry.getValue();
                config.setProperty(name, value);
            }
        }
        if (this.dbUnitFeatures != null) {
            k = this.dbUnitFeatures.entrySet().iterator();
            while (k.hasNext()) {
                entry = k.next();
                name = (String)entry.getKey();
                boolean value = Boolean.valueOf((String)entry.getValue());
                config.setFeature(name, value);
            }
        }
    }

    private void addTables(QueryDataSet dataSet) {
        if (this.tableList == null) {
            return;
        }
        Iterator k = this.tableList.iterator();
        while (k.hasNext()) {
            String table = (String)k.next();
            dataSet.addTable(table);
        }
    }

    private void addQueries(QueryDataSet dataSet) {
        if (this.queryList == null) {
            return;
        }
        Iterator k = this.queryList.iterator();
        while (k.hasNext()) {
            String query = (String)k.next();
            Matcher m = TABLE_MATCH_PATTERN.matcher(query);
            if (!m.matches()) {
                this.log("Unable to parse query. Ignoring '" + query + "'.");
                continue;
            }
            String table = m.group(1);
            if (this.tableList != null && this.tableList.contains(table)) {
                this.log("Table '" + table + "' already added. Ignoring '" + query + "'.");
                continue;
            }
            dataSet.addTable(table, query);
        }
    }

    class MyPrimaryKeyFilter
    implements IColumnFilter {
        MyPrimaryKeyFilter() {
        }

        public boolean accept(String arg0, Column arg1) {
            return false;
        }
    }
}

